/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.model.impl;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.HelperContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.tuscany.sdo.SDOFactory;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.impl.FactoryBase;
import org.apache.tuscany.sdo.model.BaseDataGraphType;
import org.apache.tuscany.sdo.model.DataGraphType;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.ModelsType;
import org.apache.tuscany.sdo.model.Property;
import org.apache.tuscany.sdo.model.TextType;
import org.apache.tuscany.sdo.model.Type;
import org.apache.tuscany.sdo.model.Types;
import org.apache.tuscany.sdo.model.XSDType;
import org.apache.tuscany.sdo.model.impl.DataGraphTypeImpl;
import org.apache.tuscany.sdo.model.impl.ModelsTypeImpl;
import org.apache.tuscany.sdo.model.impl.PropertyImpl;
import org.apache.tuscany.sdo.model.impl.TypeImpl;
import org.apache.tuscany.sdo.model.impl.TypesImpl;
import org.apache.tuscany.sdo.model.impl.XSDTypeImpl;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;

public class ModelFactoryImpl
extends FactoryBase
implements ModelFactory {
    public static final String NAMESPACE_URI = "commonj.sdo";
    public static final String NAMESPACE_PREFIX = "sdo";
    public static final String PATTERN_VERSION = "1.2";
    public static final int BASE_DATA_GRAPH_TYPE = 1;
    public static final int DATA_GRAPH_TYPE = 2;
    public static final int DATA_OBJECT = 3;
    public static final int MODELS_TYPE = 4;
    public static final int PROPERTY = 5;
    public static final int TEXT_TYPE = 6;
    public static final int TYPE = 7;
    public static final int TYPES = 8;
    public static final int XSD_TYPE = 9;
    public static final int BOOLEAN = 10;
    public static final int BOOLEAN_OBJECT = 11;
    public static final int BYTE = 12;
    public static final int BYTE_OBJECT = 13;
    public static final int BYTES = 14;
    public static final int CHANGE_SUMMARY_TYPE = 15;
    public static final int CHARACTER = 16;
    public static final int CHARACTER_OBJECT = 17;
    public static final int DATE = 18;
    public static final int DATE_TIME = 19;
    public static final int DAY = 20;
    public static final int DECIMAL = 21;
    public static final int DOUBLE = 22;
    public static final int DOUBLE_OBJECT = 23;
    public static final int DURATION = 24;
    public static final int FLOAT = 25;
    public static final int FLOAT_OBJECT = 26;
    public static final int INT = 27;
    public static final int INTEGER = 28;
    public static final int INT_OBJECT = 29;
    public static final int LONG = 30;
    public static final int LONG_OBJECT = 31;
    public static final int MONTH = 32;
    public static final int MONTH_DAY = 33;
    public static final int OBJECT = 34;
    public static final int SHORT = 35;
    public static final int SHORT_OBJECT = 36;
    public static final int STRING = 37;
    public static final int STRINGS = 38;
    public static final int TIME = 39;
    public static final int URI = 40;
    public static final int YEAR = 41;
    public static final int YEAR_MONTH = 42;
    public static final int YEAR_MONTH_DAY = 43;
    protected commonj.sdo.Type baseDataGraphTypeType = null;
    protected commonj.sdo.Type dataGraphTypeType = null;
    protected commonj.sdo.Type dataObjectType = null;
    protected commonj.sdo.Type modelsTypeType = null;
    protected commonj.sdo.Type propertyType = null;
    protected commonj.sdo.Type textTypeType = null;
    protected commonj.sdo.Type typeType = null;
    protected commonj.sdo.Type typesType = null;
    protected commonj.sdo.Type xsdTypeType = null;
    protected commonj.sdo.Type boolean_Type = null;
    protected commonj.sdo.Type booleanObjectType = null;
    protected commonj.sdo.Type byte_Type = null;
    protected commonj.sdo.Type byteObjectType = null;
    protected commonj.sdo.Type bytesType = null;
    protected commonj.sdo.Type changeSummaryTypeType = null;
    protected commonj.sdo.Type characterType = null;
    protected commonj.sdo.Type characterObjectType = null;
    protected commonj.sdo.Type dateType = null;
    protected commonj.sdo.Type dateTimeType = null;
    protected commonj.sdo.Type dayType = null;
    protected commonj.sdo.Type decimalType = null;
    protected commonj.sdo.Type double_Type = null;
    protected commonj.sdo.Type doubleObjectType = null;
    protected commonj.sdo.Type durationType = null;
    protected commonj.sdo.Type float_Type = null;
    protected commonj.sdo.Type floatObjectType = null;
    protected commonj.sdo.Type int_Type = null;
    protected commonj.sdo.Type integerType = null;
    protected commonj.sdo.Type intObjectType = null;
    protected commonj.sdo.Type long_Type = null;
    protected commonj.sdo.Type longObjectType = null;
    protected commonj.sdo.Type monthType = null;
    protected commonj.sdo.Type monthDayType = null;
    protected commonj.sdo.Type objectType = null;
    protected commonj.sdo.Type short_Type = null;
    protected commonj.sdo.Type shortObjectType = null;
    protected commonj.sdo.Type stringType = null;
    protected commonj.sdo.Type stringsType = null;
    protected commonj.sdo.Type timeType = null;
    protected commonj.sdo.Type uriType = null;
    protected commonj.sdo.Type yearType = null;
    protected commonj.sdo.Type yearMonthType = null;
    protected commonj.sdo.Type yearMonthDayType = null;
    private static ModelFactoryImpl instance = null;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    public ModelFactoryImpl() {
        super(NAMESPACE_URI, NAMESPACE_PREFIX, "org.apache.tuscany.sdo.model");
    }

    public void register(HelperContext scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Scope can not be null");
        }
        TypeHelperImpl th = (TypeHelperImpl)scope.getTypeHelper();
        th.getExtendedMetaData().putPackage(NAMESPACE_URI, (EPackage)this);
    }

    public DataObject create(int typeNumber) {
        switch (typeNumber) {
            case 2: {
                return (DataObject)this.createDataGraphType();
            }
            case 4: {
                return (DataObject)this.createModelsType();
            }
            case 5: {
                return (DataObject)this.createProperty();
            }
            case 7: {
                return (DataObject)this.createType();
            }
            case 8: {
                return (DataObject)this.createTypes();
            }
            case 9: {
                return (DataObject)this.createXSDType();
            }
            case 3: {
                return SDOFactory.eINSTANCE.createAnyTypeDataObject();
            }
        }
        return super.create(typeNumber);
    }

    public Object createFromString(int typeNumber, String initialValue) {
        switch (typeNumber) {
            case 10: {
                return this.createBooleanFromString(initialValue);
            }
            case 11: {
                return this.createBooleanObjectFromString(initialValue);
            }
            case 12: {
                return this.createByteFromString(initialValue);
            }
            case 13: {
                return this.createByteObjectFromString(initialValue);
            }
            case 14: {
                return this.createBytesFromString(initialValue);
            }
            case 15: {
                return this.createChangeSummaryTypeFromString(initialValue);
            }
            case 16: {
                return this.createCharacterFromString(initialValue);
            }
            case 17: {
                return this.createCharacterObjectFromString(initialValue);
            }
            case 18: {
                return this.createDateFromString(initialValue);
            }
            case 19: {
                return this.createDateTimeFromString(initialValue);
            }
            case 20: {
                return this.createDayFromString(initialValue);
            }
            case 21: {
                return this.createDecimalFromString(initialValue);
            }
            case 22: {
                return this.createDoubleFromString(initialValue);
            }
            case 23: {
                return this.createDoubleObjectFromString(initialValue);
            }
            case 24: {
                return this.createDurationFromString(initialValue);
            }
            case 25: {
                return this.createFloatFromString(initialValue);
            }
            case 26: {
                return this.createFloatObjectFromString(initialValue);
            }
            case 27: {
                return this.createIntFromString(initialValue);
            }
            case 28: {
                return this.createIntegerFromString(initialValue);
            }
            case 29: {
                return this.createIntObjectFromString(initialValue);
            }
            case 30: {
                return this.createLongFromString(initialValue);
            }
            case 31: {
                return this.createLongObjectFromString(initialValue);
            }
            case 32: {
                return this.createMonthFromString(initialValue);
            }
            case 33: {
                return this.createMonthDayFromString(initialValue);
            }
            case 34: {
                return this.createObjectFromString(initialValue);
            }
            case 35: {
                return this.createShortFromString(initialValue);
            }
            case 36: {
                return this.createShortObjectFromString(initialValue);
            }
            case 37: {
                return this.createStringFromString(initialValue);
            }
            case 38: {
                return this.createStringsFromString(initialValue);
            }
            case 39: {
                return this.createTimeFromString(initialValue);
            }
            case 40: {
                return this.createURIFromString(initialValue);
            }
            case 41: {
                return this.createYearFromString(initialValue);
            }
            case 42: {
                return this.createYearMonthFromString(initialValue);
            }
            case 43: {
                return this.createYearMonthDayFromString(initialValue);
            }
        }
        throw new IllegalArgumentException("The type number '" + typeNumber + "' is not a valid datatype");
    }

    public String convertToString(int typeNumber, Object instanceValue) {
        switch (typeNumber) {
            case 10: {
                return this.convertBooleanToString(instanceValue);
            }
            case 11: {
                return this.convertBooleanObjectToString(instanceValue);
            }
            case 12: {
                return this.convertByteToString(instanceValue);
            }
            case 13: {
                return this.convertByteObjectToString(instanceValue);
            }
            case 14: {
                return this.convertBytesToString(instanceValue);
            }
            case 15: {
                return this.convertChangeSummaryTypeToString(instanceValue);
            }
            case 16: {
                return this.convertCharacterToString(instanceValue);
            }
            case 17: {
                return this.convertCharacterObjectToString(instanceValue);
            }
            case 18: {
                return this.convertDateToString(instanceValue);
            }
            case 19: {
                return this.convertDateTimeToString(instanceValue);
            }
            case 20: {
                return this.convertDayToString(instanceValue);
            }
            case 21: {
                return this.convertDecimalToString(instanceValue);
            }
            case 22: {
                return this.convertDoubleToString(instanceValue);
            }
            case 23: {
                return this.convertDoubleObjectToString(instanceValue);
            }
            case 24: {
                return this.convertDurationToString(instanceValue);
            }
            case 25: {
                return this.convertFloatToString(instanceValue);
            }
            case 26: {
                return this.convertFloatObjectToString(instanceValue);
            }
            case 27: {
                return this.convertIntToString(instanceValue);
            }
            case 28: {
                return this.convertIntegerToString(instanceValue);
            }
            case 29: {
                return this.convertIntObjectToString(instanceValue);
            }
            case 30: {
                return this.convertLongToString(instanceValue);
            }
            case 31: {
                return this.convertLongObjectToString(instanceValue);
            }
            case 32: {
                return this.convertMonthToString(instanceValue);
            }
            case 33: {
                return this.convertMonthDayToString(instanceValue);
            }
            case 34: {
                return this.convertObjectToString(instanceValue);
            }
            case 35: {
                return this.convertShortToString(instanceValue);
            }
            case 36: {
                return this.convertShortObjectToString(instanceValue);
            }
            case 37: {
                return this.convertStringToString(instanceValue);
            }
            case 38: {
                return this.convertStringsToString(instanceValue);
            }
            case 39: {
                return this.convertTimeToString(instanceValue);
            }
            case 40: {
                return this.convertURIToString(instanceValue);
            }
            case 41: {
                return this.convertYearToString(instanceValue);
            }
            case 42: {
                return this.convertYearMonthToString(instanceValue);
            }
            case 43: {
                return this.convertYearMonthDayToString(instanceValue);
            }
        }
        throw new IllegalArgumentException("The type number '" + typeNumber + "' is not a valid datatype");
    }

    public DataGraphType createDataGraphType() {
        DataGraphTypeImpl dataGraphType = new DataGraphTypeImpl();
        return dataGraphType;
    }

    public ModelsType createModelsType() {
        ModelsTypeImpl modelsType = new ModelsTypeImpl();
        return modelsType;
    }

    public Property createProperty() {
        PropertyImpl property = new PropertyImpl();
        return property;
    }

    public Type createType() {
        TypeImpl type = new TypeImpl();
        return type;
    }

    public Types createTypes() {
        TypesImpl types = new TypesImpl();
        return types;
    }

    public XSDType createXSDType() {
        XSDTypeImpl xsdType = new XSDTypeImpl();
        return xsdType;
    }

    public commonj.sdo.Type getBaseDataGraphType() {
        return this.baseDataGraphTypeType;
    }

    public commonj.sdo.Type getDataGraphType() {
        return this.dataGraphTypeType;
    }

    public commonj.sdo.Type getDataObject() {
        return this.dataObjectType;
    }

    public commonj.sdo.Type getModelsType() {
        return this.modelsTypeType;
    }

    public commonj.sdo.Type getProperty() {
        return this.propertyType;
    }

    public commonj.sdo.Type getTextType() {
        return this.textTypeType;
    }

    public commonj.sdo.Type getType() {
        return this.typeType;
    }

    public commonj.sdo.Type getTypes() {
        return this.typesType;
    }

    public commonj.sdo.Type getXSDType() {
        return this.xsdTypeType;
    }

    public commonj.sdo.Type getBoolean() {
        return this.boolean_Type;
    }

    public commonj.sdo.Type getBooleanObject() {
        return this.booleanObjectType;
    }

    public commonj.sdo.Type getByte() {
        return this.byte_Type;
    }

    public commonj.sdo.Type getByteObject() {
        return this.byteObjectType;
    }

    public commonj.sdo.Type getBytes() {
        return this.bytesType;
    }

    public commonj.sdo.Type getChangeSummaryType() {
        return this.changeSummaryTypeType;
    }

    public commonj.sdo.Type getCharacter() {
        return this.characterType;
    }

    public commonj.sdo.Type getCharacterObject() {
        return this.characterObjectType;
    }

    public commonj.sdo.Type getDate() {
        return this.dateType;
    }

    public commonj.sdo.Type getDateTime() {
        return this.dateTimeType;
    }

    public commonj.sdo.Type getDay() {
        return this.dayType;
    }

    public commonj.sdo.Type getDecimal() {
        return this.decimalType;
    }

    public commonj.sdo.Type getDouble() {
        return this.double_Type;
    }

    public commonj.sdo.Type getDoubleObject() {
        return this.doubleObjectType;
    }

    public commonj.sdo.Type getDuration() {
        return this.durationType;
    }

    public commonj.sdo.Type getFloat() {
        return this.float_Type;
    }

    public commonj.sdo.Type getFloatObject() {
        return this.floatObjectType;
    }

    public commonj.sdo.Type getInt() {
        return this.int_Type;
    }

    public commonj.sdo.Type getInteger() {
        return this.integerType;
    }

    public commonj.sdo.Type getIntObject() {
        return this.intObjectType;
    }

    public commonj.sdo.Type getLong() {
        return this.long_Type;
    }

    public commonj.sdo.Type getLongObject() {
        return this.longObjectType;
    }

    public commonj.sdo.Type getMonth() {
        return this.monthType;
    }

    public commonj.sdo.Type getMonthDay() {
        return this.monthDayType;
    }

    public commonj.sdo.Type getObject() {
        return this.objectType;
    }

    public commonj.sdo.Type getShort() {
        return this.short_Type;
    }

    public commonj.sdo.Type getShortObject() {
        return this.shortObjectType;
    }

    public commonj.sdo.Type getString() {
        return this.stringType;
    }

    public commonj.sdo.Type getStrings() {
        return this.stringsType;
    }

    public commonj.sdo.Type getTime() {
        return this.timeType;
    }

    public commonj.sdo.Type getURI() {
        return this.uriType;
    }

    public commonj.sdo.Type getYear() {
        return this.yearType;
    }

    public commonj.sdo.Type getYearMonth() {
        return this.yearMonthType;
    }

    public commonj.sdo.Type getYearMonthDay() {
        return this.yearMonthDayType;
    }

    public static ModelFactoryImpl init() {
        if (instance != null) {
            return instance;
        }
        instance = new ModelFactoryImpl();
        instance.createMetaData();
        instance.initializeMetaData();
        return instance;
    }

    public void createMetaData() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.baseDataGraphTypeType = this.createType(false, 1);
        this.createProperty(false, this.baseDataGraphTypeType, 0);
        this.createProperty(false, this.baseDataGraphTypeType, 1);
        this.createProperty(true, this.baseDataGraphTypeType, 2);
        this.createProperty(true, this.baseDataGraphTypeType, 3);
        this.dataGraphTypeType = this.createType(false, 2);
        this.createProperty(true, this.dataGraphTypeType, 4);
        this.dataObjectType = this.createType(false, 3);
        this.modelsTypeType = this.createType(false, 4);
        this.createProperty(true, this.modelsTypeType, 0);
        this.propertyType = this.createType(false, 5);
        this.createProperty(true, this.propertyType, 0);
        this.createProperty(true, this.propertyType, 1);
        this.createProperty(true, this.propertyType, 2);
        this.createProperty(true, this.propertyType, 3);
        this.createProperty(true, this.propertyType, 4);
        this.createProperty(true, this.propertyType, 5);
        this.createProperty(true, this.propertyType, 6);
        this.createProperty(false, this.propertyType, 7);
        this.createProperty(false, this.propertyType, 8);
        this.createProperty(true, this.propertyType, 9);
        this.createProperty(true, this.propertyType, 10);
        this.textTypeType = this.createType(false, 6);
        this.createProperty(true, this.textTypeType, 0);
        this.typeType = this.createType(false, 7);
        this.createProperty(false, this.typeType, 0);
        this.createProperty(false, this.typeType, 1);
        this.createProperty(true, this.typeType, 2);
        this.createProperty(true, this.typeType, 3);
        this.createProperty(true, this.typeType, 4);
        this.createProperty(true, this.typeType, 5);
        this.createProperty(true, this.typeType, 6);
        this.createProperty(true, this.typeType, 7);
        this.createProperty(true, this.typeType, 8);
        this.createProperty(true, this.typeType, 9);
        this.createProperty(true, this.typeType, 10);
        this.typesType = this.createType(false, 8);
        this.createProperty(false, this.typesType, 0);
        this.xsdTypeType = this.createType(false, 9);
        this.createProperty(true, this.xsdTypeType, 0);
        this.boolean_Type = this.createType(true, 10);
        this.booleanObjectType = this.createType(true, 11);
        this.byte_Type = this.createType(true, 12);
        this.byteObjectType = this.createType(true, 13);
        this.bytesType = this.createType(true, 14);
        this.changeSummaryTypeType = this.createType(true, 15);
        this.characterType = this.createType(true, 16);
        this.characterObjectType = this.createType(true, 17);
        this.dateType = this.createType(true, 18);
        this.dateTimeType = this.createType(true, 19);
        this.dayType = this.createType(true, 20);
        this.decimalType = this.createType(true, 21);
        this.double_Type = this.createType(true, 22);
        this.doubleObjectType = this.createType(true, 23);
        this.durationType = this.createType(true, 24);
        this.float_Type = this.createType(true, 25);
        this.floatObjectType = this.createType(true, 26);
        this.int_Type = this.createType(true, 27);
        this.integerType = this.createType(true, 28);
        this.intObjectType = this.createType(true, 29);
        this.long_Type = this.createType(true, 30);
        this.longObjectType = this.createType(true, 31);
        this.monthType = this.createType(true, 32);
        this.monthDayType = this.createType(true, 33);
        this.objectType = this.createType(true, 34);
        this.short_Type = this.createType(true, 35);
        this.shortObjectType = this.createType(true, 36);
        this.stringType = this.createType(true, 37);
        this.stringsType = this.createType(true, 38);
        this.timeType = this.createType(true, 39);
        this.uriType = this.createType(true, 40);
        this.yearType = this.createType(true, 41);
        this.yearMonthType = this.createType(true, 42);
        this.yearMonthDayType = this.createType(true, 43);
    }

    public void initializeMetaData() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        commonj.sdo.Property property = null;
        this.addSuperType(this.dataGraphTypeType, this.getBaseDataGraphType());
        this.initializeType(this.baseDataGraphTypeType, BaseDataGraphType.class, "BaseDataGraphType", true);
        property = this.getLocalProperty(this.baseDataGraphTypeType, 0);
        this.initializeProperty(property, this.getModelsType(), "models", null, 0, 1, BaseDataGraphType.class, false, true, false, true, null);
        property = this.getLocalProperty(this.baseDataGraphTypeType, 1);
        this.initializeProperty(property, this.getXSDType(), "xsd", null, 0, 1, BaseDataGraphType.class, false, true, false, true, null);
        property = this.getLocalProperty(this.baseDataGraphTypeType, 2);
        this.initializeProperty(property, this.getChangeSummaryType(), "changeSummary", null, 0, 1, BaseDataGraphType.class, false, true, false);
        property = this.getLocalProperty(this.baseDataGraphTypeType, 3);
        this.initializeProperty(property, this.getSequence(), "anyAttribute", null, 0, -1, BaseDataGraphType.class, false, false, false);
        this.initializeType(this.dataGraphTypeType, DataGraphType.class, "DataGraphType", false);
        property = this.getLocalProperty(this.dataGraphTypeType, 0);
        this.initializeProperty(property, this.getSequence(), "any", null, 0, 1, DataGraphType.class, false, false, false);
        this.initializeType(this.dataObjectType, DataObject.class, "DataObject", true);
        this.initializeType(this.modelsTypeType, ModelsType.class, "ModelsType", false);
        property = this.getLocalProperty(this.modelsTypeType, 0);
        this.initializeProperty(property, this.getSequence(), "any", null, 0, -1, ModelsType.class, false, false, false);
        this.initializeType(this.propertyType, Property.class, "Property", false);
        property = this.getLocalProperty(this.propertyType, 0);
        this.initializeProperty(property, this.getString(), "aliasName", null, 0, -1, Property.class, false, false, false);
        property = this.getLocalProperty(this.propertyType, 1);
        this.initializeProperty(property, this.getSequence(), "any", null, 0, -1, Property.class, false, false, false);
        property = this.getLocalProperty(this.propertyType, 2);
        this.initializeProperty(property, this.getString(), "name", null, 0, 1, Property.class, false, true, false);
        property = this.getLocalProperty(this.propertyType, 3);
        this.initializeProperty(property, this.getBoolean(), "many", null, 0, 1, Property.class, false, true, false);
        property = this.getLocalProperty(this.propertyType, 4);
        this.initializeProperty(property, this.getBoolean(), "containment", null, 0, 1, Property.class, false, true, false);
        property = this.getLocalProperty(this.propertyType, 5);
        this.initializeProperty(property, this.getString(), "default", null, 0, 1, Property.class, false, true, false);
        property = this.getLocalProperty(this.propertyType, 6);
        this.initializeProperty(property, this.getBoolean(), "readOnly", null, 0, 1, Property.class, false, true, false);
        property = this.getLocalProperty(this.propertyType, 7);
        this.initializeProperty(property, this.getType(), "type", null, 0, 1, Property.class, false, true, false, false, null);
        this.setInstanceProperty(property, "commonj.sdo/xml", "propertyType", "sdo:Type");
        property = this.getLocalProperty(this.propertyType, 8);
        this.initializeProperty(property, this.getProperty(), "opposite", null, 0, 1, Property.class, false, true, false, false, null);
        this.setInstanceProperty(property, "commonj.sdo/xml", "propertyType", "sdo:Property");
        property = this.getLocalProperty(this.propertyType, 9);
        this.initializeProperty(property, this.getBoolean(), "nullable", null, 0, 1, Property.class, false, true, false);
        property = this.getLocalProperty(this.propertyType, 10);
        this.initializeProperty(property, this.getSequence(), "anyAttribute", null, 0, -1, Property.class, false, false, false);
        this.initializeType(this.textTypeType, TextType.class, "TextType", true);
        property = this.getLocalProperty(this.textTypeType, 0);
        this.initializeProperty(property, this.getString(), "text", null, 0, -1, TextType.class, false, false, false);
        this.initializeType(this.typeType, Type.class, "Type", false);
        property = this.getLocalProperty(this.typeType, 0);
        this.initializeProperty(property, this.getType(), "baseType", null, 0, -1, Type.class, false, false, false, false, null);
        this.setInstanceProperty(property, "commonj.sdo/xml", "propertyType", "sdo:Type");
        property = this.getLocalProperty(this.typeType, 1);
        this.initializeProperty(property, this.getProperty(), "property", null, 0, -1, Type.class, false, false, false, true, null);
        property = this.getLocalProperty(this.typeType, 2);
        this.initializeProperty(property, this.getString(), "aliasName", null, 0, -1, Type.class, false, false, false);
        property = this.getLocalProperty(this.typeType, 3);
        this.initializeProperty(property, this.getSequence(), "any", null, 0, -1, Type.class, false, false, false);
        property = this.getLocalProperty(this.typeType, 4);
        this.initializeProperty(property, this.getString(), "name", null, 0, 1, Type.class, false, true, false);
        this.setInstanceProperty(property, "commonj.sdo/xml", "dataType", "sdo:String");
        property = this.getLocalProperty(this.typeType, 5);
        this.initializeProperty(property, this.getURI(), "uri", null, 0, 1, Type.class, false, true, false);
        property = this.getLocalProperty(this.typeType, 6);
        this.initializeProperty(property, this.getBoolean(), "dataType", null, 0, 1, Type.class, false, true, false);
        property = this.getLocalProperty(this.typeType, 7);
        this.initializeProperty(property, this.getBoolean(), "open", null, 0, 1, Type.class, false, true, false);
        property = this.getLocalProperty(this.typeType, 8);
        this.initializeProperty(property, this.getBoolean(), "sequenced", null, 0, 1, Type.class, false, true, false);
        property = this.getLocalProperty(this.typeType, 9);
        this.initializeProperty(property, this.getBoolean(), "abstract", null, 0, 1, Type.class, false, true, false);
        property = this.getLocalProperty(this.typeType, 10);
        this.initializeProperty(property, this.getSequence(), "anyAttribute", null, 0, -1, Type.class, false, false, false);
        this.initializeType(this.typesType, Types.class, "Types", false);
        property = this.getLocalProperty(this.typesType, 0);
        this.initializeProperty(property, this.getType(), "type", null, 0, -1, Types.class, false, false, false, true, null);
        this.initializeType(this.xsdTypeType, XSDType.class, "XSDType", false);
        property = this.getLocalProperty(this.xsdTypeType, 0);
        this.initializeProperty(property, this.getSequence(), "any", null, 0, -1, XSDType.class, false, false, false);
        this.initializeType(this.boolean_Type, Boolean.TYPE, "Boolean", true, false);
        this.setInstanceProperty(this.boolean_Type, "commonj.sdo/java", "instanceClass", "boolean");
        this.initializeType(this.booleanObjectType, Boolean.class, "BooleanObject", true, false);
        this.initializeType(this.byte_Type, Byte.TYPE, "Byte", true, false);
        this.setInstanceProperty(this.byte_Type, "commonj.sdo/java", "instanceClass", "byte");
        this.initializeType(this.byteObjectType, Byte.class, "ByteObject", true, false);
        this.initializeType(this.bytesType, [B.class, "Bytes", true, false);
        this.setInstanceProperty(this.bytesType, "commonj.sdo/java", "instanceClass", "byte[]");
        this.initializeType(this.changeSummaryTypeType, ChangeSummary.class, "ChangeSummaryType", true, false);
        this.setInstanceProperty(this.changeSummaryTypeType, "commonj.sdo/java", "instanceClass", "commonj.sdo.ChangeSummary");
        this.initializeType(this.characterType, Character.TYPE, "Character", true, false);
        this.setInstanceProperty(this.characterType, "commonj.sdo/java", "instanceClass", "char");
        this.initializeType(this.characterObjectType, Character.class, "CharacterObject", true, false);
        this.initializeType(this.dateType, Date.class, "Date", true, false);
        this.setInstanceProperty(this.dateType, "commonj.sdo/java", "instanceClass", "java.util.Date");
        this.initializeType(this.dateTimeType, String.class, "DateTime", true, false);
        this.setInstanceProperty(this.dateTimeType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.dayType, String.class, "Day", true, false);
        this.setInstanceProperty(this.dayType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.decimalType, BigDecimal.class, "Decimal", true, false);
        this.setInstanceProperty(this.decimalType, "commonj.sdo/java", "instanceClass", "java.math.BigDecimal");
        this.initializeType(this.double_Type, Double.TYPE, "Double", true, false);
        this.setInstanceProperty(this.double_Type, "commonj.sdo/java", "instanceClass", "double");
        this.initializeType(this.doubleObjectType, Double.class, "DoubleObject", true, false);
        this.initializeType(this.durationType, String.class, "Duration", true, false);
        this.setInstanceProperty(this.durationType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.float_Type, Float.TYPE, "Float", true, false);
        this.setInstanceProperty(this.float_Type, "commonj.sdo/java", "instanceClass", "float");
        this.initializeType(this.floatObjectType, Float.class, "FloatObject", true, false);
        this.initializeType(this.int_Type, Integer.TYPE, "Int", true, false);
        this.setInstanceProperty(this.int_Type, "commonj.sdo/java", "instanceClass", "int");
        this.initializeType(this.integerType, BigInteger.class, "Integer", true, false);
        this.setInstanceProperty(this.integerType, "commonj.sdo/java", "instanceClass", "java.math.BigInteger");
        this.initializeType(this.intObjectType, Integer.class, "IntObject", true, false);
        this.initializeType(this.long_Type, Long.TYPE, "Long", true, false);
        this.setInstanceProperty(this.long_Type, "commonj.sdo/java", "instanceClass", "long");
        this.initializeType(this.longObjectType, Long.class, "LongObject", true, false);
        this.initializeType(this.monthType, String.class, "Month", true, false);
        this.setInstanceProperty(this.monthType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.monthDayType, String.class, "MonthDay", true, false);
        this.setInstanceProperty(this.monthDayType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.objectType, Object.class, "Object", true, false);
        this.setInstanceProperty(this.objectType, "commonj.sdo/java", "instanceClass", "java.lang.Object");
        this.initializeType(this.short_Type, Short.TYPE, "Short", true, false);
        this.setInstanceProperty(this.short_Type, "commonj.sdo/java", "instanceClass", "short");
        this.initializeType(this.shortObjectType, Short.class, "ShortObject", true, false);
        this.initializeType(this.stringType, String.class, "String", true, false);
        this.setInstanceProperty(this.stringType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.stringsType, List.class, "Strings", true, false);
        this.setInstanceProperty(this.stringsType, "commonj.sdo/java", "instanceClass", "java.util.List");
        this.initializeType(this.timeType, String.class, "Time", true, false);
        this.setInstanceProperty(this.timeType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.uriType, String.class, "URI", true, false);
        this.setInstanceProperty(this.uriType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.yearType, String.class, "Year", true, false);
        this.setInstanceProperty(this.yearType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.yearMonthType, String.class, "YearMonth", true, false);
        this.setInstanceProperty(this.yearMonthType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.initializeType(this.yearMonthDayType, String.class, "YearMonthDay", true, false);
        this.setInstanceProperty(this.yearMonthDayType, "commonj.sdo/java", "instanceClass", "java.lang.String");
        this.createXSDMetaData();
    }

    protected void createXSDMetaData() {
        super.initXSD();
        commonj.sdo.Property property = null;
        this.addXSDMapping(this.baseDataGraphTypeType, new String[]{"name", "BaseDataGraphType", "kind", "elementOnly"});
        this.addXSDMapping(this.getProperty(this.baseDataGraphTypeType, 0), new String[]{"kind", "element", "name", "models"});
        this.addXSDMapping(this.getProperty(this.baseDataGraphTypeType, 1), new String[]{"kind", "element", "name", "xsd"});
        this.addXSDMapping(this.getProperty(this.baseDataGraphTypeType, 2), new String[]{"kind", "element", "name", "changeSummary"});
        this.addXSDMapping(this.getProperty(this.baseDataGraphTypeType, 3), new String[]{"kind", "attributeWildcard", "wildcards", "##other", "name", ":3", "processing", "lax"});
        this.addXSDMapping(this.dataGraphTypeType, new String[]{"name", "DataGraphType", "kind", "elementOnly"});
        this.addXSDMapping(this.getProperty(this.dataGraphTypeType, 4), new String[]{"kind", "elementWildcard", "wildcards", "##other", "name", ":4", "processing", "lax"});
        this.addXSDMapping(this.dataObjectType, new String[]{"name", "DataObject", "kind", "empty"});
        property = this.createGlobalProperty("datagraph", this.getDataGraphType(), new String[]{"kind", "element", "name", "datagraph", "namespace", "##targetNamespace"});
        property = this.createGlobalProperty("dataObject", this.getDataObject(), new String[]{"kind", "element", "name", "dataObject", "namespace", "##targetNamespace"});
        property = this.createGlobalProperty("type", this.getType(), new String[]{"kind", "element", "name", "type", "namespace", "##targetNamespace"});
        property = this.createGlobalProperty("types", this.getTypes(), new String[]{"kind", "element", "name", "types", "namespace", "##targetNamespace"});
        property = this.createGlobalProperty("ref", this.getString(), new String[]{"kind", "attribute", "name", "ref", "namespace", "##targetNamespace"}, true);
        property = this.createGlobalProperty("unset", this.getString(), new String[]{"kind", "attribute", "name", "unset", "namespace", "##targetNamespace"}, true);
        this.addXSDMapping(this.modelsTypeType, new String[]{"name", "ModelsType", "kind", "elementOnly"});
        this.addXSDMapping(this.getProperty(this.modelsTypeType, 0), new String[]{"kind", "elementWildcard", "wildcards", "##other", "name", ":0", "processing", "lax"});
        this.addXSDMapping(this.propertyType, new String[]{"name", "Property", "kind", "elementOnly"});
        this.addXSDMapping(this.getProperty(this.propertyType, 0), new String[]{"kind", "element", "name", "aliasName", "namespace", "##targetNamespace"});
        this.addXSDMapping(this.getProperty(this.propertyType, 1), new String[]{"kind", "elementWildcard", "wildcards", "##other", "name", ":1", "processing", "lax"});
        this.addXSDMapping(this.getProperty(this.propertyType, 2), new String[]{"kind", "attribute", "name", "name"});
        this.addXSDMapping(this.getProperty(this.propertyType, 3), new String[]{"kind", "attribute", "name", "many"});
        this.addXSDMapping(this.getProperty(this.propertyType, 4), new String[]{"kind", "attribute", "name", "containment"});
        this.addXSDMapping(this.getProperty(this.propertyType, 5), new String[]{"kind", "attribute", "name", "default"});
        this.addXSDMapping(this.getProperty(this.propertyType, 6), new String[]{"kind", "attribute", "name", "readOnly"});
        this.addXSDMapping(this.getProperty(this.propertyType, 7), new String[]{"kind", "attribute", "name", "type"});
        this.addXSDMapping(this.getProperty(this.propertyType, 8), new String[]{"kind", "attribute", "name", "opposite"});
        this.addXSDMapping(this.getProperty(this.propertyType, 9), new String[]{"kind", "attribute", "name", "nullable"});
        this.addXSDMapping(this.getProperty(this.propertyType, 10), new String[]{"kind", "attributeWildcard", "wildcards", "##any", "name", ":10", "processing", "lax"});
        this.addXSDMapping(this.textTypeType, new String[]{"name", "TextType", "kind", "elementOnly"});
        this.addXSDMapping(this.getProperty(this.textTypeType, 0), new String[]{"kind", "element", "name", "text", "namespace", "##targetNamespace"});
        this.addXSDMapping(this.typeType, new String[]{"name", "Type", "kind", "elementOnly"});
        this.addXSDMapping(this.getProperty(this.typeType, 0), new String[]{"kind", "element", "name", "baseType", "namespace", "##targetNamespace"});
        this.addXSDMapping(this.getProperty(this.typeType, 1), new String[]{"kind", "element", "name", "property", "namespace", "##targetNamespace"});
        this.addXSDMapping(this.getProperty(this.typeType, 2), new String[]{"kind", "element", "name", "aliasName", "namespace", "##targetNamespace"});
        this.addXSDMapping(this.getProperty(this.typeType, 3), new String[]{"kind", "elementWildcard", "wildcards", "##other", "name", ":3", "processing", "lax"});
        this.addXSDMapping(this.getProperty(this.typeType, 4), new String[]{"kind", "attribute", "name", "name"});
        this.addXSDMapping(this.getProperty(this.typeType, 5), new String[]{"kind", "attribute", "name", "uri"});
        this.addXSDMapping(this.getProperty(this.typeType, 6), new String[]{"kind", "attribute", "name", "dataType"});
        this.addXSDMapping(this.getProperty(this.typeType, 7), new String[]{"kind", "attribute", "name", "open"});
        this.addXSDMapping(this.getProperty(this.typeType, 8), new String[]{"kind", "attribute", "name", "sequenced"});
        this.addXSDMapping(this.getProperty(this.typeType, 9), new String[]{"kind", "attribute", "name", "abstract"});
        this.addXSDMapping(this.getProperty(this.typeType, 10), new String[]{"kind", "attributeWildcard", "wildcards", "##any", "name", ":10", "processing", "lax"});
        this.addXSDMapping(this.typesType, new String[]{"name", "Types", "kind", "elementOnly"});
        this.addXSDMapping(this.getProperty(this.typesType, 0), new String[]{"kind", "element", "name", "type", "namespace", "##targetNamespace"});
        this.addXSDMapping(this.xsdTypeType, new String[]{"name", "XSDType", "kind", "elementOnly"});
        this.addXSDMapping(this.getProperty(this.xsdTypeType, 0), new String[]{"kind", "elementWildcard", "wildcards", "http://www.w3.org/2001/XMLSchema", "name", ":0", "processing", "lax"});
        this.addXSDMapping(this.boolean_Type, new String[]{"name", "Boolean"});
        this.addXSDMapping(this.booleanObjectType, new String[]{"name", "Boolean:Object", "baseType", "Boolean"});
        this.addXSDMapping(this.byte_Type, new String[]{"name", "Byte"});
        this.addXSDMapping(this.byteObjectType, new String[]{"name", "Byte:Object", "baseType", "Byte"});
        this.addXSDMapping(this.bytesType, new String[]{"name", "Bytes"});
        this.addXSDMapping(this.changeSummaryTypeType, new String[]{"name", "ChangeSummaryType"});
        this.addXSDMapping(this.characterType, new String[]{"name", "Character"});
        this.addXSDMapping(this.characterObjectType, new String[]{"name", "Character:Object", "baseType", "Character"});
        this.addXSDMapping(this.dateType, new String[]{"name", "Date"});
        this.addXSDMapping(this.dateTimeType, new String[]{"name", "DateTime"});
        this.addXSDMapping(this.dayType, new String[]{"name", "Day"});
        this.addXSDMapping(this.decimalType, new String[]{"name", "Decimal"});
        this.addXSDMapping(this.double_Type, new String[]{"name", "Double"});
        this.addXSDMapping(this.doubleObjectType, new String[]{"name", "Double:Object", "baseType", "Double"});
        this.addXSDMapping(this.durationType, new String[]{"name", "Duration"});
        this.addXSDMapping(this.float_Type, new String[]{"name", "Float"});
        this.addXSDMapping(this.floatObjectType, new String[]{"name", "Float:Object", "baseType", "Float"});
        this.addXSDMapping(this.int_Type, new String[]{"name", "Int"});
        this.addXSDMapping(this.integerType, new String[]{"name", "Integer"});
        this.addXSDMapping(this.intObjectType, new String[]{"name", "Int:Object", "baseType", "Int"});
        this.addXSDMapping(this.long_Type, new String[]{"name", "Long"});
        this.addXSDMapping(this.longObjectType, new String[]{"name", "Long:Object", "baseType", "Long"});
        this.addXSDMapping(this.monthType, new String[]{"name", "Month"});
        this.addXSDMapping(this.monthDayType, new String[]{"name", "MonthDay"});
        this.addXSDMapping(this.objectType, new String[]{"name", "Object"});
        this.addXSDMapping(this.short_Type, new String[]{"name", "Short"});
        this.addXSDMapping(this.shortObjectType, new String[]{"name", "Short:Object", "baseType", "Short"});
        this.addXSDMapping(this.stringType, new String[]{"name", "String"});
        this.addXSDMapping(this.stringsType, new String[]{"name", "Strings"});
        this.addXSDMapping(this.timeType, new String[]{"name", "Time"});
        this.addXSDMapping(this.uriType, new String[]{"name", "URI"});
        this.addXSDMapping(this.yearType, new String[]{"name", "Year"});
        this.addXSDMapping(this.yearMonthType, new String[]{"name", "YearMonth"});
        this.addXSDMapping(this.yearMonthDayType, new String[]{"name", "YearMonthDay"});
    }

    public Boolean createBooleanFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createBooleanObject(initialValue);
    }

    public String convertBooleanToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertBooleanObject((Boolean)instanceValue);
    }

    public Boolean createBooleanObjectFromString(String initialValue) {
        return this.createBooleanFromString(initialValue);
    }

    public String convertBooleanObjectToString(Object instanceValue) {
        return this.convertBooleanToString(instanceValue);
    }

    public Byte createByteFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createByteObject(initialValue);
    }

    public String convertByteToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertByteObject((Byte)instanceValue);
    }

    public Byte createByteObjectFromString(String initialValue) {
        return this.createByteFromString(initialValue);
    }

    public String convertByteObjectToString(Object instanceValue) {
        return this.convertByteToString(instanceValue);
    }

    public byte[] createBytesFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createHexBinary(initialValue);
    }

    public String convertBytesToString(Object instanceValue) {
        if (instanceValue instanceof byte[]) {
            return XMLTypeFactory.eINSTANCE.convertHexBinary((byte[])instanceValue);
        }
        return XMLTypeFactory.eINSTANCE.convertHexBinary(instanceValue.toString().getBytes());
    }

    public ChangeSummary createChangeSummaryTypeFromString(String initialValue) {
        return null;
    }

    public String convertChangeSummaryTypeToString(Object instanceValue) {
        return "change summary serialization goes here ...";
    }

    public Character createCharacterFromString(String initialValue) {
        return initialValue == null && initialValue.length() > 0 ? null : new Character(XMLTypeUtil.normalize((String)initialValue, (boolean)true).charAt(0));
    }

    public String convertCharacterToString(Object instanceValue) {
        return String.valueOf(((Character)instanceValue).charValue());
    }

    public Character createCharacterObjectFromString(String initialValue) {
        return this.createCharacterFromString(initialValue);
    }

    public String convertCharacterObjectToString(Object instanceValue) {
        return this.convertCharacterToString(instanceValue);
    }

    public Date createDateFromString(String initialValue) {
        return DataHelper.INSTANCE.toDate(initialValue);
    }

    public String convertDateToString(Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        return f.format((Date)instanceValue);
    }

    public String createDateTimeFromString(String initialValue) {
        return initialValue;
    }

    public String convertDateTimeToString(Object instanceValue) {
        return (String)instanceValue;
    }

    public String createDayFromString(String initialValue) {
        return initialValue;
    }

    public String convertDayToString(Object instanceValue) {
        return (String)instanceValue;
    }

    public BigDecimal createDecimalFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createDecimal(initialValue);
    }

    public String convertDecimalToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertDecimal((BigDecimal)instanceValue);
    }

    public Double createDoubleFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createDoubleObject(initialValue);
    }

    public String convertDoubleToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertDoubleObject((Double)instanceValue);
    }

    public Double createDoubleObjectFromString(String initialValue) {
        return this.createDoubleFromString(initialValue);
    }

    public String convertDoubleObjectToString(Object instanceValue) {
        return this.convertDoubleToString(instanceValue);
    }

    public String createDurationFromString(String initialValue) {
        return initialValue;
    }

    public String convertDurationToString(Object instanceValue) {
        return (String)instanceValue;
    }

    public Float createFloatFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createFloatObject(initialValue);
    }

    public String convertFloatToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertFloatObject((Float)instanceValue);
    }

    public Float createFloatObjectFromString(String initialValue) {
        return this.createFloatFromString(initialValue);
    }

    public String convertFloatObjectToString(Object instanceValue) {
        return this.convertFloatToString(instanceValue);
    }

    public Integer createIntFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createIntObject(initialValue);
    }

    public String convertIntToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertIntObject((Integer)instanceValue);
    }

    public BigInteger createIntegerFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createInteger(initialValue);
    }

    public String convertIntegerToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertInteger((BigInteger)instanceValue);
    }

    public Integer createIntObjectFromString(String initialValue) {
        return this.createIntFromString(initialValue);
    }

    public String convertIntObjectToString(Object instanceValue) {
        return this.convertIntToString(instanceValue);
    }

    public Long createLongFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createLongObject(initialValue);
    }

    public String convertLongToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertLongObject((Long)instanceValue);
    }

    public Long createLongObjectFromString(String initialValue) {
        return this.createLongFromString(initialValue);
    }

    public String convertLongObjectToString(Object instanceValue) {
        return this.convertLongToString(instanceValue);
    }

    public String createMonthFromString(String initialValue) {
        return initialValue;
    }

    public String convertMonthToString(Object instanceValue) {
        return (String)instanceValue;
    }

    public String createMonthDayFromString(String initialValue) {
        return initialValue;
    }

    public String convertMonthDayToString(Object instanceValue) {
        return (String)instanceValue;
    }

    public Object createObjectFromString(String initialValue) {
        return initialValue;
    }

    public String convertObjectToString(Object instanceValue) {
        return instanceValue != null ? instanceValue.toString() : null;
    }

    public Short createShortFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createShortObject(initialValue);
    }

    public String convertShortToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertShortObject((Short)instanceValue);
    }

    public Short createShortObjectFromString(String initialValue) {
        return this.createShortFromString(initialValue);
    }

    public String convertShortObjectToString(Object instanceValue) {
        return this.convertShortToString(instanceValue);
    }

    public String createStringFromString(String initialValue) {
        return initialValue;
    }

    public String convertStringToString(Object instanceValue) {
        return instanceValue != null ? instanceValue.toString() : null;
    }

    public List createStringsFromString(String initialValue) {
        return XMLTypeFactory.eINSTANCE.createENTITIES(initialValue);
    }

    public String convertStringsToString(Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertENTITIES((List)instanceValue);
    }

    public String createTimeFromString(String initialValue) {
        return initialValue;
    }

    public String convertTimeToString(Object instanceValue) {
        return (String)instanceValue;
    }

    public String createURIFromString(String initialValue) {
        return initialValue;
    }

    public String convertURIToString(Object instanceValue) {
        return instanceValue != null ? instanceValue.toString() : null;
    }

    public String createYearFromString(String initialValue) {
        return initialValue;
    }

    public String convertYearToString(Object instanceValue) {
        return (String)instanceValue;
    }

    public String createYearMonthFromString(String initialValue) {
        return initialValue;
    }

    public String convertYearMonthToString(Object instanceValue) {
        return (String)instanceValue;
    }

    public String createYearMonthDayFromString(String initialValue) {
        return initialValue;
    }

    public String convertYearMonthDayToString(Object instanceValue) {
        return (String)instanceValue;
    }
}

