/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.impl.HelperProvider;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.tuscany.sdo.SDOExtendedMetaData;
import org.apache.tuscany.sdo.SDOFactory;
import org.apache.tuscany.sdo.SDOPackage;
import org.apache.tuscany.sdo.api.SDOUtil;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.impl.ClassImpl;
import org.apache.tuscany.sdo.impl.DataGraphImpl;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.impl.ModelFactoryImpl;
import org.apache.tuscany.sdo.util.BasicSequence;
import org.apache.tuscany.sdo.util.DataGraphResourceFactoryImpl;
import org.apache.tuscany.sdo.util.resource.SDOURIConverterImpl;
import org.apache.tuscany.sdo.util.resource.SDOXMLResourceFactoryImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EDataTypeImpl;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.EMOFResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;

public final class DataObjectUtil {
    protected static Map registrations;
    protected static XMLParserPool globalXMLParserPool;

    public static void setString(DataObject dataObject, Property property, String value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setShort(DataObject dataObject, Property property, short value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setLong(DataObject dataObject, Property property, long value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setList(DataObject dataObject, Property property, List value) {
        dataObject.set(property, (Object)value);
    }

    public static void setInt(DataObject dataObject, Property property, int value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setFloat(DataObject dataObject, Property property, float value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setDouble(DataObject dataObject, Property property, double value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setDate(DataObject dataObject, Property property, Date value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setDataObject(DataObject dataObject, Property property, DataObject value) {
        dataObject.set(property, (Object)value);
    }

    public static void setChar(DataObject dataObject, Property property, char value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setBytes(DataObject dataObject, Property property, byte[] value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setByte(DataObject dataObject, Property property, byte value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setBoolean(DataObject dataObject, Property property, boolean value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setBigInteger(DataObject dataObject, Property property, BigInteger value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static void setBigDecimal(DataObject dataObject, Property property, BigDecimal value) {
        dataObject.set(property, DataObjectUtil.getSetValue(property, value));
    }

    public static String getString(DataObject dataObject, Property property) {
        return DataObjectUtil.getString(dataObject.get(property));
    }

    public static short getShort(DataObject dataObject, Property property) {
        return DataObjectUtil.getShort(dataObject.get(property));
    }

    public static Sequence getSequence(DataObject dataObject, Property property) {
        return (Sequence)dataObject.get(property);
    }

    public static long getLong(DataObject dataObject, Property property) {
        return DataObjectUtil.getLong(dataObject.get(property));
    }

    public static List getList(DataObject dataObject, Property property) {
        return (List)dataObject.get(property);
    }

    public static int getInt(DataObject dataObject, Property property) {
        return DataObjectUtil.getInt(dataObject.get(property));
    }

    public static float getFloat(DataObject dataObject, Property property) {
        return DataObjectUtil.getFloat(dataObject.get(property));
    }

    public static double getDouble(DataObject dataObject, Property property) {
        return DataObjectUtil.getDouble(dataObject.get(property));
    }

    public static Date getDate(DataObject dataObject, Property property) {
        return DataObjectUtil.getDate(dataObject.get(property));
    }

    public static DataObject getDataObject(DataObject dataObject, Property property) {
        return (DataObject)dataObject.get(property);
    }

    public static char getChar(DataObject dataObject, Property property) {
        return DataObjectUtil.getChar(dataObject.get(property));
    }

    public static byte[] getBytes(DataObject dataObject, Property property) {
        return DataObjectUtil.getBytes(dataObject.get(property));
    }

    public static byte getByte(DataObject dataObject, Property property) {
        return DataObjectUtil.getByte(dataObject.get(property));
    }

    public static boolean getBoolean(DataObject dataObject, Property property) {
        return DataObjectUtil.getBoolean(dataObject.get(property));
    }

    public static BigInteger getBigInteger(DataObject dataObject, Property property) {
        return DataObjectUtil.getBigInteger(dataObject.get(property));
    }

    public static BigDecimal getBigDecimal(DataObject dataObject, Property property) {
        return DataObjectUtil.getBigDecimal(dataObject.get(property));
    }

    public static void setString(DataObject dataObject, int propertyIndex, String value) {
        DataObjectUtil.setString(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setShort(DataObject dataObject, int propertyIndex, short value) {
        DataObjectUtil.setShort(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setLong(DataObject dataObject, int propertyIndex, long value) {
        DataObjectUtil.setLong(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setList(DataObject dataObject, int propertyIndex, List value) {
        DataObjectUtil.setList(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setInt(DataObject dataObject, int propertyIndex, int value) {
        DataObjectUtil.setInt(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setFloat(DataObject dataObject, int propertyIndex, float value) {
        DataObjectUtil.setFloat(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setDouble(DataObject dataObject, int propertyIndex, double value) {
        DataObjectUtil.setDouble(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setDate(DataObject dataObject, int propertyIndex, Date value) {
        DataObjectUtil.setDate(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setDataObject(DataObject dataObject, int propertyIndex, DataObject value) {
        dataObject.set(DataObjectUtil.getProperty(dataObject, propertyIndex), (Object)value);
    }

    public static void setChar(DataObject dataObject, int propertyIndex, char value) {
        DataObjectUtil.setChar(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setBytes(DataObject dataObject, int propertyIndex, byte[] value) {
        DataObjectUtil.setBytes(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setByte(DataObject dataObject, int propertyIndex, byte value) {
        DataObjectUtil.setByte(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setBoolean(DataObject dataObject, int propertyIndex, boolean value) {
        DataObjectUtil.setBoolean(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setBigInteger(DataObject dataObject, int propertyIndex, BigInteger value) {
        DataObjectUtil.setBigInteger(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static void setBigDecimal(DataObject dataObject, int propertyIndex, BigDecimal value) {
        DataObjectUtil.setBigDecimal(dataObject, DataObjectUtil.getProperty(dataObject, propertyIndex), value);
    }

    public static String getString(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getString(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static short getShort(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getShort(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static Sequence getSequence(DataObject dataObject, int propertyIndex) {
        return (Sequence)dataObject.get(propertyIndex);
    }

    public static long getLong(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getLong(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static List getList(DataObject dataObject, int propertyIndex) {
        return (List)dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex));
    }

    public static int getInt(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getInt(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static float getFloat(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getFloat(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static double getDouble(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getDouble(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static Date getDate(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getDate(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static DataObject getDataObject(DataObject dataObject, int propertyIndex) {
        return (DataObject)dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex));
    }

    public static char getChar(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getChar(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static byte[] getBytes(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getBytes(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static byte getByte(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getByte(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static boolean getBoolean(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getBoolean(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static BigInteger getBigInteger(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getBigInteger(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static BigDecimal getBigDecimal(DataObject dataObject, int propertyIndex) {
        return DataObjectUtil.getBigDecimal(dataObject.get(DataObjectUtil.getProperty(dataObject, propertyIndex)));
    }

    public static void detach(DataObject dataObject) {
        EcoreUtil.remove((EObject)((EObject)dataObject));
    }

    public static DataObject getRootObject(DataObject dataObject) {
        return (DataObject)EcoreUtil.getRootContainer((EObject)((EObject)dataObject));
    }

    public static boolean isInternalProperty(EStructuralFeature eStructuralFeature) {
        EClassifier eClassifier = eStructuralFeature.getEType();
        return !(eClassifier instanceof Type) && eClassifier != XMLTypePackage.Literals.BASE64_BINARY;
    }

    public static List getInstanceProperties(DataObject dataObject) {
        Type type = dataObject.getType();
        UniqueEList result = new UniqueEList((Collection)type.getProperties());
        ((ClassImpl)type).addOpenProperties((EObject)dataObject, (Collection)result);
        return result;
    }

    public static void delete(DataObject dataObject) {
        EObject eDataObject = (EObject)dataObject;
        EcoreUtil.remove((EObject)eDataObject);
        ArrayList contents = new ArrayList(eDataObject.eContents());
        int size = contents.size();
        for (int i = 0; i < size; ++i) {
            ((DataObject)contents.get(i)).delete();
        }
        EClass eClass = eDataObject.eClass();
        int size2 = eClass.getFeatureCount();
        for (int i = 0; i < size2; ++i) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (!eStructuralFeature.isChangeable() || eStructuralFeature.isDerived() || ((Property)eStructuralFeature).isReadOnly()) continue;
            eDataObject.eUnset(eStructuralFeature);
        }
    }

    public static DataObject createDataObject(DataObject dataObject, Property property, Type type) {
        if (!property.isContainment()) {
            throw new IllegalArgumentException("The property '" + property.getName() + "' of '" + property.getContainingType().getName() + "' isn't a containment");
        }
        DataObject result = DataObjectUtil.create(type);
        if (FeatureMapUtil.isMany((EObject)((EObject)dataObject), (EStructuralFeature)((EStructuralFeature)property))) {
            ((List)dataObject.get(property)).add(result);
        } else {
            dataObject.set(property, (Object)result);
        }
        return result;
    }

    public static DataObject createDataObject(DataObject dataObject, int propertyIndex, String namespaceURI, String typeName) {
        Property property = DataObjectUtil.getProperty(dataObject, propertyIndex);
        Type type = DataObjectUtil.getType(dataObject, namespaceURI, typeName);
        return DataObjectUtil.createDataObject(dataObject, property, type);
    }

    public static DataObject createDataObject(DataObject dataObject, String propertyName, String namespaceURI, String typeName) {
        Property property = DataObjectUtil.getInstanceProperty(dataObject, propertyName);
        if (property != null) {
            Type type = DataObjectUtil.getType(dataObject, namespaceURI, typeName);
            return DataObjectUtil.createDataObject(dataObject, property, type);
        }
        if (dataObject.getType().isOpen()) {
            HelperContext ctx = HelperProvider.getDefaultContext();
            Type propertyType = ctx.getTypeHelper().getType(namespaceURI, typeName);
            if (propertyType == null) {
                throw new IllegalStateException("type does not exist: uri=" + namespaceURI + ", name=" + typeName);
            }
            DataObject value = ctx.getDataFactory().create(propertyType);
            ArrayList<DataObject> list = new ArrayList<DataObject>(1);
            list.add(value);
            dataObject.setList(propertyName, list);
            return value;
        }
        throw new IllegalArgumentException("property '" + propertyName + "' does not exist");
    }

    public static DataObject createDataObject(DataObject dataObject, Property property) {
        Type type = property.getType();
        return DataObjectUtil.createDataObject(dataObject, property, type);
    }

    public static DataObject createDataObject(DataObject dataObject, int propertyIndex) {
        Property property = DataObjectUtil.getProperty(dataObject, propertyIndex);
        Type type = property.getType();
        return DataObjectUtil.createDataObject(dataObject, property, type);
    }

    public static DataObject createDataObject(DataObject dataObject, String propertyName) {
        Property property = DataObjectUtil.getInstanceProperty(dataObject, propertyName);
        if (property != null) {
            Type type = property.getType();
            return DataObjectUtil.createDataObject(dataObject, property, type);
        }
        return DataObjectUtil.createDataObject(dataObject, propertyName, "http://www.apache.org/tuscany/2005/SDO", "AnyTypeDataObject");
    }

    public static void setString(DataObject dataObject, String path, String value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setShort(DataObject dataObject, String path, short value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setLong(DataObject dataObject, String path, long value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setList(DataObject dataObject, String path, List value) {
        dataObject.set(path, (Object)value);
    }

    public static void setInt(DataObject dataObject, String path, int value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setFloat(DataObject dataObject, String path, float value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setDouble(DataObject dataObject, String path, double value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setDate(DataObject dataObject, String path, Date value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setDataObject(DataObject dataObject, String path, DataObject value) {
        dataObject.set(path, (Object)value);
    }

    public static void setChar(DataObject dataObject, String path, char value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setBytes(DataObject dataObject, String path, byte[] value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setByte(DataObject dataObject, String path, byte value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setBoolean(DataObject dataObject, String path, boolean value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setBigInteger(DataObject dataObject, String path, BigInteger value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static void setBigDecimal(DataObject dataObject, String path, BigDecimal value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, DataObjectUtil.getSetValue(property, value));
        } else {
            Accessor accessor = Accessor.create((EObject)dataObject, path);
            accessor.setAndRecyle(DataObjectUtil.getSetValue(accessor.getProperty(), value));
        }
    }

    public static DataGraph getDataGraph(DataObject dataObject) {
        ResourceSet resourceSet;
        Resource resource = ((EObject)dataObject).eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
            return (DataGraphImpl)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), (Object)DataGraph.class);
        }
        return null;
    }

    public static ChangeSummary getChangeSummary(DataObject dataObject) {
        DataGraph dataGraph = DataObjectUtil.getDataGraph(dataObject);
        if (dataGraph != null) {
            return dataGraph.getChangeSummary();
        }
        for (DataObject csDataObject = dataObject; csDataObject != null; csDataObject = csDataObject.getContainer()) {
            Property csp = ((ClassImpl)csDataObject.getType()).getChangeSummaryProperty();
            if (csp == null) continue;
            return (ChangeSummary)csDataObject.get(csp);
        }
        return null;
    }

    public static void unset(DataObject dataObject, String path) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.unset(property);
        } else {
            Accessor.create((EObject)dataObject, path).unsetAndRecyle();
        }
    }

    public static boolean isSet(DataObject dataObject, String path) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            return dataObject.isSet(property);
        }
        return Accessor.create((EObject)dataObject, path).isSetAndRecyle();
    }

    public static void set(DataObject dataObject, String path, Object value) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            dataObject.set(property, value);
        } else {
            Accessor.create((EObject)dataObject, path, value).setAndRecyle(value);
        }
    }

    public static Object get(DataObject dataObject, String path) {
        Property property = dataObject.getType().getProperty(path);
        if (property != null) {
            return dataObject.get(property);
        }
        return Accessor.create((EObject)dataObject, path).getAndRecyle();
    }

    public static BigDecimal getBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value == null) {
            return null;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to BigDecimal");
    }

    public static Object getSetValue(Property property, BigDecimal value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "java.math.BigDecimal") {
            return value;
        }
        if (name == "java.math.BigInteger") {
            return value.toBigInteger();
        }
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte(value.byteValue());
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value.doubleValue());
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value.floatValue());
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value.intValue());
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value.longValue());
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short(value.shortValue());
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return value;
    }

    public static BigInteger getBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            return new BigInteger((String)value);
        }
        if (value instanceof byte[]) {
            return new BigInteger((byte[])value);
        }
        if (value == null) {
            return null;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to BigInteger");
    }

    public static Object getSetValue(Property property, BigInteger value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "java.math.BigInteger") {
            return value;
        }
        if (name == "java.math.BigDecimal") {
            return new BigDecimal(value);
        }
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte(value.byteValue());
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value.doubleValue());
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value.floatValue());
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value.intValue());
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value.longValue());
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short(value.shortValue());
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        if (name == "byte[]") {
            return value.toByteArray();
        }
        return value;
    }

    public static boolean getBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value == null) {
            return false;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to boolean");
    }

    public static Object getSetValue(Property property, boolean value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Boolean" || name == "boolean") {
            return value ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static byte getByte(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        if (value == null) {
            return 0;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to byte");
    }

    public static Object getSetValue(Property property, byte value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte(value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short(value);
        }
        if (name == "java.math.BigDecimal") {
            return DataObjectUtil.getBigDecimal(new Byte(value));
        }
        if (name == "java.math.BigInteger") {
            return DataObjectUtil.getBigInteger(new Byte(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Byte(value);
    }

    public static byte[] getBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).toByteArray();
        }
        if (value instanceof String) {
            return XMLTypeFactory.eINSTANCE.createHexBinary((String)value);
        }
        if (value == null) {
            return null;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to byte array");
    }

    public static Object getSetValue(Property property, byte[] value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "byte[]") {
            return value;
        }
        if (name == "java.math.BigInteger") {
            return new BigInteger(value);
        }
        if (name == "java.lang.String") {
            return XMLTypeFactory.eINSTANCE.convertHexBinary(value);
        }
        return value;
    }

    public static char getChar(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            return ((String)value).charAt(0);
        }
        if (value == null) {
            return '\u0000';
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to char");
    }

    public static Object getSetValue(Property property, char value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Character" || name == "char") {
            return new Character(value);
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Character(value);
    }

    public static Date getDate(Object value) {
        if (value instanceof String) {
            return DataHelper.INSTANCE.toDate((String)value);
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value == null) {
            return null;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to Date");
    }

    public static Object getSetValue(Property property, Date value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "java.lang.String") {
            String typeName = DataObjectUtil.getDateTypeName((EDataType)eType);
            if ("DateTime".equals(typeName)) {
                return DataHelper.INSTANCE.toDateTime(value);
            }
            if ("Day".equals(typeName)) {
                return DataHelper.INSTANCE.toDay(value);
            }
            if ("Duration".equals(typeName)) {
                return DataHelper.INSTANCE.toDuration(value);
            }
            if ("Month".equals(typeName)) {
                return DataHelper.INSTANCE.toMonth(value);
            }
            if ("MonthDay".equals(typeName)) {
                return DataHelper.INSTANCE.toMonthDay(value);
            }
            if ("Time".equals(typeName)) {
                return DataHelper.INSTANCE.toTime(value);
            }
            if ("Year".equals(typeName)) {
                return DataHelper.INSTANCE.toYear(value);
            }
            if ("YearMonth".equals(typeName)) {
                return DataHelper.INSTANCE.toYearMonth(value);
            }
            if ("YearMonthDay".equals(typeName)) {
                return DataHelper.INSTANCE.toYearMonthDay(value);
            }
            if ("String".equals(typeName)) {
                return DataHelper.INSTANCE.toDateTime(value);
            }
            return value;
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value.getTime());
        }
        return value;
    }

    protected static String getDateTypeName(EDataType eDataType) {
        String name = eDataType.getName();
        if ("DateTime".equals(name) || "Day".equals(name) || "Duration".equals(name) || "Month".equals(name) || "MonthDay".equals(name) || "Time".equals(name) || "Year".equals(name) || "YearMonth".equals(name) || "YearMonthDay".equals(name) || "String".equals(name)) {
            return name;
        }
        EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
        if (baseType != null) {
            return DataObjectUtil.getDateTypeName(baseType);
        }
        List memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType);
        if (!memberTypes.isEmpty()) {
            int size = memberTypes.size();
            for (int i = 0; i < size; ++i) {
                EDataType memberType = (EDataType)memberTypes.get(i);
                String memberTypeName = DataObjectUtil.getDateTypeName(memberType);
                if (!"DateTime".equals(memberTypeName) && !"Day".equals(memberTypeName) && !"Duration".equals(memberTypeName) && !"Month".equals(memberTypeName) && !"MonthDay".equals(memberTypeName) && !"Time".equals(memberTypeName) && !"Year".equals(memberTypeName) && !"YearMonth".equals(memberTypeName) && !"YearMonthDay".equals(memberTypeName) && !"String".equals(memberTypeName)) continue;
                return memberTypeName;
            }
        }
        return "";
    }

    public static double getDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value == null) {
            return 0.0;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to double");
    }

    public static Object getSetValue(Property property, double value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer((int)value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long((long)value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short((short)value);
        }
        if (name == "java.math.BigDecimal") {
            return DataObjectUtil.getBigDecimal(new Double(value));
        }
        if (name == "java.math.BigInteger") {
            return DataObjectUtil.getBigInteger(new Double(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Double(value);
    }

    public static float getFloat(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        if (value == null) {
            return 0.0f;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to float");
    }

    public static Object getSetValue(Property property, float value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer((int)value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long((long)value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short((short)value);
        }
        if (name == "java.math.BigDecimal") {
            return DataObjectUtil.getBigDecimal(new Float(value));
        }
        if (name == "java.math.BigInteger") {
            return DataObjectUtil.getBigInteger(new Float(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Float(value);
    }

    public static int getInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value == null) {
            return 0;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to int");
    }

    public static Object getSetValue(Property property, int value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short((short)value);
        }
        if (name == "java.math.BigDecimal") {
            return DataObjectUtil.getBigDecimal(new Integer(value));
        }
        if (name == "java.math.BigInteger") {
            return DataObjectUtil.getBigInteger(new Integer(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Integer(value);
    }

    public static long getLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value == null) {
            return 0L;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to long");
    }

    public static Object getSetValue(Property property, long value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer((int)value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short((short)value);
        }
        if (name == "java.math.BigDecimal") {
            return DataObjectUtil.getBigDecimal(new Long(value));
        }
        if (name == "java.math.BigInteger") {
            return DataObjectUtil.getBigInteger(new Long(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        if (name == "java.util.Date") {
            return new Date(value);
        }
        return new Long(value);
    }

    public static short getShort(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        if (value == null) {
            return 0;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to short");
    }

    public static Object getSetValue(Property property, short value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short(value);
        }
        if (name == "java.math.BigDecimal") {
            return DataObjectUtil.getBigDecimal(new Short(value));
        }
        if (name == "java.math.BigInteger") {
            return DataObjectUtil.getBigInteger(new Short(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Short(value);
    }

    public static String getString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof Character) {
            return String.valueOf(value);
        }
        if (value instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'T'H':'mm':'ss.S'Z'");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            return sdf.format((Date)value);
        }
        if (value instanceof byte[]) {
            return XMLTypeFactory.eINSTANCE.convertHexBinary((byte[])value);
        }
        if (value == null) {
            return null;
        }
        throw new ClassCastException("The value of type '" + value.getClass().getName() + "' cannot be converted to String");
    }

    public static Object getSetValue(Property property, String value) {
        EStructuralFeature eStructuralFeature = (EStructuralFeature)property;
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "java.lang.String") {
            return value;
        }
        if (name == "java.lang.Byte" || name == "byte") {
            return Byte.valueOf(value);
        }
        if (name == "java.util.Date") {
            return DataHelper.INSTANCE.toDate(value);
        }
        if (name == "java.lang.Double" || name == "double" || name == "java.lang.Number") {
            return Double.valueOf(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return Integer.valueOf(value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return Long.valueOf(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return Short.valueOf(value);
        }
        if (name == "java.lang.Character" || name == "char") {
            return new Character(value.charAt(0));
        }
        if (name == "java.math.BigDecimal") {
            return DataObjectUtil.getBigDecimal(value);
        }
        if (name == "java.math.BigInteger") {
            return DataObjectUtil.getBigInteger(value);
        }
        if (name == "java.lang.Boolean" || name == "boolean") {
            return Boolean.valueOf(value);
        }
        if (name == "byte[]") {
            return XMLTypeFactory.eINSTANCE.createHexBinary(value);
        }
        return value;
    }

    public static EStructuralFeature getOpenFeature(EObject eObject, int featureID) {
        EClass eClass = eObject.eClass();
        int openFeatureCount = featureID - eClass.getFeatureCount();
        HashSet<EStructuralFeature> openFeatureSet = new HashSet<EStructuralFeature>();
        int count = eClass.getEAllStructuralFeatures().size();
        for (int i = 0; i < count; ++i) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isDerived() || !FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) continue;
            List features = (List)eObject.eGet(eStructuralFeature);
            int size = features.size();
            for (int j = 0; j < size; ++j) {
                FeatureMap.Entry entry = (FeatureMap.Entry)features.get(j);
                EStructuralFeature entryFeature = entry.getEStructuralFeature();
                if (!openFeatureSet.add(entryFeature) || --openFeatureCount >= 0) continue;
                return entryFeature;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static List getAliasNames(EStructuralFeature eStructuralFeature) {
        ArrayList list = SDOExtendedMetaData.INSTANCE.getAliasNames((EModelElement)eStructuralFeature);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public static List getAliasNames(EClassifier eClassifier) {
        ArrayList list = SDOExtendedMetaData.INSTANCE.getAliasNames((EModelElement)eClassifier);
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    protected static Property demandOpenProperty(Type type, String name, Object value, boolean isSequence) {
        Type propertyType;
        TypeHelper typeHelper = TypeHelper.INSTANCE;
        String uri = type.getURI() + "/" + type.getName();
        Property property = typeHelper.getOpenContentProperty(uri, name);
        if (property != null) {
            return property;
        }
        boolean isMany = isSequence;
        boolean isContainment = false;
        if (value instanceof DataObject) {
            DataObject dataObject = (DataObject)value;
            propertyType = dataObject.getType();
            isContainment = dataObject.getContainer() == null;
        } else if (value instanceof List && !((List)value).isEmpty()) {
            Object listValue = ((List)value).get(0);
            propertyType = listValue instanceof DataObject ? ((DataObject)listValue).getType() : typeHelper.getType(listValue.getClass());
            isMany = true;
        } else {
            propertyType = typeHelper.getType(value.getClass());
        }
        if (propertyType == null) {
            propertyType = ((ModelFactoryImpl)ModelFactory.INSTANCE).getObject();
        }
        Property newProperty = SDOUtil.createOpenContentProperty((HelperContext)HelperProvider.getDefaultContext(), (String)uri, (String)name, (Type)propertyType);
        if (isMany) {
            SDOUtil.setMany((Property)newProperty, (boolean)isMany);
        }
        if (isContainment) {
            SDOUtil.setContainment((Property)newProperty, (boolean)isContainment);
        }
        return newProperty;
    }

    public static Type getType(DataObject dataObject, String namespaceURI, String typeName) {
        DataGraph dataGraph = dataObject.getDataGraph();
        if (dataGraph != null) {
            return dataGraph.getType(namespaceURI, typeName);
        }
        return TypeHelper.INSTANCE.getType(namespaceURI, typeName);
    }

    public static Property getInstanceProperty(DataObject dataObject, String propertyName) {
        ClassImpl type = (ClassImpl)dataObject.getType();
        Property property = type.getProperty(propertyName);
        if (property == null) {
            property = type.getOpenProperty((EObject)dataObject, propertyName);
        }
        return property;
    }

    public static Property getProperty(DataObject dataObject, int propertyIndex) {
        List typeProperties = dataObject.getType().getProperties();
        try {
            Property property = propertyIndex < typeProperties.size() ? (Property)typeProperties.get(propertyIndex) : (Property)dataObject.getInstanceProperties().get(propertyIndex);
            return property;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    public static Property getContainmentProperty(Property property) {
        if (property.isContainment()) {
            return property;
        }
        throw new IllegalArgumentException("The property '" + property.getName() + "' of '" + property.getContainingType().getName() + "' isn't a containment");
    }

    public static DataObject create(Type type) {
        if (type instanceof EClass && !type.isAbstract()) {
            EClass eClass = (EClass)type;
            try {
                return (DataObject)EcoreUtil.create((EClass)eClass);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        DataObjectUtil.configureResourceSet((ResourceSet)result);
        return result;
    }

    protected static Map getRegistrations() {
        if (registrations == null) {
            HashMap<String, Resource.Factory> result = new HashMap<String, Resource.Factory>();
            Resource.Factory factory = Resource.Factory.Registry.INSTANCE.getFactory(URI.createURI((String)"*.datagraph"));
            result.put("datagraph", (Resource.Factory)(factory instanceof DataGraphResourceFactoryImpl ? factory : new DataGraphResourceFactoryImpl()));
            factory = Resource.Factory.Registry.INSTANCE.getFactory(URI.createURI((String)"*.ecore"));
            result.put("ecore", (Resource.Factory)(factory instanceof EcoreResourceFactoryImpl ? factory : new EcoreResourceFactoryImpl()));
            factory = Resource.Factory.Registry.INSTANCE.getFactory(URI.createURI((String)"*.emof"));
            result.put("emof", (Resource.Factory)(factory instanceof EMOFResourceFactoryImpl ? factory : new EMOFResourceFactoryImpl()));
            factory = Resource.Factory.Registry.INSTANCE.getFactory(URI.createURI((String)"*.xsd"));
            result.put("xsd", (Resource.Factory)(factory instanceof XSDResourceFactoryImpl ? factory : new XSDResourceFactoryImpl()));
            factory = Resource.Factory.Registry.INSTANCE.getFactory(URI.createURI((String)"*.wsdl"));
            result.put("wsdl", (Resource.Factory)(factory instanceof XSDResourceFactoryImpl ? factory : new XSDResourceFactoryImpl()));
            factory = Resource.Factory.Registry.INSTANCE.getFactory(URI.createURI((String)"*.*"));
            result.put("*", (Resource.Factory)(factory instanceof SDOXMLResourceFactoryImpl ? factory : new SDOXMLResourceFactoryImpl()));
            registrations = result;
        }
        return registrations;
    }

    protected static void configureResourceSet(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().putAll(DataObjectUtil.getRegistrations());
        resourceSet.setPackageRegistry((EPackage.Registry)new EPackageRegistryImpl(HelperContextImpl.getBuiltInModelRegistry()));
        resourceSet.setURIConverter((URIConverter)new SDOURIConverterImpl());
    }

    public static EClass createDocumentRoot() {
        EClass documentRootEClass = (EClass)SDOFactory.eINSTANCE.createClass();
        documentRootEClass.setName("DocumentRoot");
        ExtendedMetaData.INSTANCE.setName((EClassifier)documentRootEClass, "");
        ExtendedMetaData.INSTANCE.setContentKind(documentRootEClass, 3);
        EAttribute mixed = (EAttribute)SDOFactory.eINSTANCE.createAttribute();
        mixed.setName("mixed");
        mixed.setEType((EClassifier)EcorePackage.eINSTANCE.getEFeatureMapEntry());
        mixed.setUpperBound(-1);
        ExtendedMetaData.INSTANCE.setName((EStructuralFeature)mixed, ":mixed");
        ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)mixed, 5);
        documentRootEClass.getEStructuralFeatures().add((Object)mixed);
        EReference xmlnsPrefixMap = (EReference)SDOFactory.eINSTANCE.createReference();
        xmlnsPrefixMap.setName("xMLNSPrefixMap");
        xmlnsPrefixMap.setEType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry());
        xmlnsPrefixMap.setUpperBound(-1);
        xmlnsPrefixMap.setContainment(true);
        xmlnsPrefixMap.setTransient(true);
        ExtendedMetaData.INSTANCE.setName((EStructuralFeature)xmlnsPrefixMap, "xmlns:prefix");
        ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)xmlnsPrefixMap, 2);
        documentRootEClass.getEStructuralFeatures().add((Object)xmlnsPrefixMap);
        EReference xsiSchemaLocation = (EReference)SDOFactory.eINSTANCE.createReference();
        xsiSchemaLocation.setName("xSISchemaLocation");
        xsiSchemaLocation.setEType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry());
        xsiSchemaLocation.setUpperBound(-1);
        xsiSchemaLocation.setContainment(true);
        xsiSchemaLocation.setTransient(true);
        ExtendedMetaData.INSTANCE.setName((EStructuralFeature)xsiSchemaLocation, "xsi:schemaLocation");
        ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)xsiSchemaLocation, 2);
        documentRootEClass.getEStructuralFeatures().add((Object)xsiSchemaLocation);
        return documentRootEClass;
    }

    public static String getXPath(DataObject dataObject) {
        return SDOUtil.getXPath((DataObject)dataObject);
    }

    public static void configureXMLResource(XMLResource resource, ExtendedMetaData extendedMetaData) {
        XMLOptionsImpl xmlOptions = new XMLOptionsImpl();
        xmlOptions.setProcessAnyXML(true);
        resource.getDefaultLoadOptions().put("XML_OPTIONS", xmlOptions);
        resource.getDefaultSaveOptions().put("EXTENDED_META_DATA", extendedMetaData);
        resource.getDefaultLoadOptions().put("EXTENDED_META_DATA", extendedMetaData);
        resource.getDefaultLoadOptions().put("USE_PARSER_POOL", globalXMLParserPool);
        resource.getDefaultLoadOptions().put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        resource.getDefaultSaveOptions().put("CONFIGURATION_CACHE", Boolean.TRUE);
        resource.getDefaultLoadOptions().put("CONFIGURATION_CACHE", Boolean.TRUE);
        resource.getDefaultLoadOptions().put("ANY_TYPE", SDOPackage.eINSTANCE.getAnyTypeDataObject());
        resource.getDefaultSaveOptions().put("ANY_TYPE", SDOPackage.eINSTANCE.getAnyTypeDataObject());
        resource.getDefaultLoadOptions().put("ANY_SIMPLE_TYPE", SDOPackage.eINSTANCE.getSimpleAnyTypeDataObject());
        resource.getDefaultSaveOptions().put("ANY_SIMPLE_TYPE", SDOPackage.eINSTANCE.getSimpleAnyTypeDataObject());
    }

    public static void initRuntime() {
    }

    public static List getMetaObjectInstanceProperties(EModelElement metaObject) {
        HelperContext hc = HelperProvider.getDefaultContext();
        UniqueEList result = new UniqueEList();
        EList annotations = metaObject.getEAnnotations();
        int size = annotations.size();
        for (int i = 0; i < size; ++i) {
            EAnnotation annotation = (EAnnotation)annotations.get(i);
            String propertyURI = annotation.getSource();
            Iterator iter = annotation.getDetails().iterator();
            while (iter.hasNext()) {
                EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)iter.next();
                String propertyName = entry.getTypedKey();
                Property globalProperty = DataObjectUtil.getGlobalProperty(hc, propertyURI, propertyName);
                if (globalProperty == null) continue;
                result.add(globalProperty);
            }
        }
        return result;
    }

    public static Object getMetaObjectInstanceProperty(EModelElement metaObject, Property property) {
        if (metaObject instanceof EDataTypeImpl) {
            if (property.getName().equals("enumeration")) {
                List enumVals = ((EDataTypeImpl)metaObject).getExtendedMetaData().getEnumerationFacet();
                return enumVals;
            }
            if (property.getName().equals("pattern")) {
                List patternVals = ((EDataTypeImpl)metaObject).getExtendedMetaData().getPatternFacet();
                return patternVals;
            }
        }
        String value = EcoreUtil.getAnnotation((EModelElement)metaObject, (String)property.getContainingType().getURI(), (String)property.getName());
        return SDOUtil.createFromString((Type)property.getType(), (String)value);
    }

    protected static Property getGlobalProperty(HelperContext hc, String uri, String name) {
        Object property;
        if ("http:///org/eclipse/emf/ecore/util/ExtendedMetaData".equals(uri)) {
            property = "minExclusive".equals(name) || "minInclusive".equals(name) || "maxExclusive".equals(name) || "maxInclusive".equals(name) || "totalDigits".equals(name) || "fractionDigits".equals(name) || "length".equals(name) || "minLength".equals(name) || "maxLength".equals(name) || "enumeration".equals(name) || "whiteSpace".equals(name) || "pattern".equals(name) ? SDOUtil.createOpenContentProperty((HelperContext)hc, (String)uri, (String)name, (Type)((ModelFactoryImpl)ModelFactory.INSTANCE).getString()) : null;
        } else {
            property = hc.getTypeHelper().getOpenContentProperty(uri, name);
            if (property == null) {
                property = SDOUtil.createOpenContentProperty((HelperContext)hc, (String)uri, (String)name, (Type)((ModelFactoryImpl)ModelFactory.INSTANCE).getString());
            }
        }
        return property;
    }

    protected static Class loadClass(final ClassLoader classLoader, final String className) {
        Class returnClass = null;
        try {
            returnClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return classLoader.loadClass(className);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        return returnClass;
    }

    public static Class getImplementationClass(Class instanceClass, boolean concrete) {
        if (instanceClass.isInterface()) {
            String sdoTypeImplClassName = instanceClass.getName();
            int index = sdoTypeImplClassName.lastIndexOf(46);
            sdoTypeImplClassName = index == -1 ? "impl." + sdoTypeImplClassName + "Impl" : sdoTypeImplClassName.substring(0, index) + ".impl" + sdoTypeImplClassName.substring(index) + "Impl";
            if (concrete) {
                sdoTypeImplClassName = sdoTypeImplClassName + "$ConcreteBase";
            }
            return DataObjectUtil.loadClass(instanceClass.getClassLoader(), sdoTypeImplClassName);
        }
        return instanceClass;
    }

    static {
        globalXMLParserPool = new XMLParserPoolImpl();
    }

    public static final class Accessor {
        static final Pool pool = new Pool();
        protected static final int NO_INDEX = -1;
        protected EObject eObject;
        protected Object value;
        protected EStructuralFeature feature;
        protected int index;
        RuntimeException runtimeException;

        public static Accessor create(EObject eObject, String path) {
            return Accessor.create(eObject, path, null);
        }

        public static Accessor create(EObject eObject, String path, Object value) {
            Accessor result = pool.get();
            result.init(eObject, path, value);
            return result;
        }

        protected Accessor() {
        }

        protected void init(EObject eObject, String path, Object value) {
            this.eObject = eObject;
            this.value = value;
            this.runtimeException = null;
            this.process(path);
        }

        public Object get() {
            if (this.feature == null) {
                return this.eObject;
            }
            Object value = this.eObject.eGet(this.feature, true);
            if (this.index >= 0) {
                if ((value = ((List)value).get(this.index)) instanceof FeatureMap.Entry) {
                    value = ((FeatureMap.Entry)value).getValue();
                }
            } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)this.feature)) {
                value = new BasicSequence((FeatureMap.Internal)value);
            }
            return value;
        }

        public Object getAndRecyle() {
            Object result = this.get();
            pool.recycle(this);
            return result;
        }

        protected final void assertSuccessfulProcess() {
            if (this.runtimeException != null) {
                throw this.runtimeException;
            }
        }

        public void set(Object newValue) {
            this.assertSuccessfulProcess();
            if (this.index >= 0) {
                List list = (List)this.eObject.eGet(this.feature, true);
                list.set(this.index, newValue);
            } else {
                this.eObject.eSet(this.feature, newValue);
            }
        }

        public void setAndRecyle(Object newValue) {
            this.set(newValue);
            pool.recycle(this);
        }

        public boolean isSet() {
            return this.feature != null && this.eObject.eIsSet(this.feature);
        }

        public boolean isSetAndRecyle() {
            boolean result = this.isSet();
            pool.recycle(this);
            return result;
        }

        public void unset() {
            this.assertSuccessfulProcess();
            this.eObject.eUnset(this.feature);
        }

        public void unsetAndRecyle() {
            this.unset();
            pool.recycle(this);
        }

        public void recycle() {
            pool.recycle(this);
        }

        public EObject getEObject() {
            return this.eObject;
        }

        protected void setEObject(EObject eObject) {
            this.eObject = eObject;
            this.feature = null;
            this.index = -1;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.feature;
        }

        public Property getProperty() {
            this.assertSuccessfulProcess();
            return (Property)this.feature;
        }

        protected void setFeatureName(String name) {
            if (name != null) {
                this.feature = (EStructuralFeature)((DataObject)this.eObject).getInstanceProperty(name);
                if (this.feature == null) {
                    int index = name.lastIndexOf(46);
                    if (index == -1) {
                        Type type = (Type)this.eObject.eClass();
                        if (this.value != null && type.isOpen()) {
                            this.feature = (EStructuralFeature)DataObjectUtil.demandOpenProperty(type, name, this.value, false);
                            this.index = -1;
                            return;
                        }
                        this.runtimeException = new IllegalArgumentException("Class '" + this.eObject.eClass().getName() + "' does not have a feature named '" + name + '\'');
                    } else {
                        int propertyNameEnd = index++;
                        try {
                            index = Integer.parseInt(name.substring(index));
                            String propertyName = name.substring(0, propertyNameEnd);
                            this.feature = (EStructuralFeature)((DataObject)this.eObject).getInstanceProperty(propertyName);
                            if (this.feature != null) {
                                this.setIndex(index);
                                return;
                            }
                            this.runtimeException = new IllegalArgumentException("Class '" + this.eObject.eClass().getName() + "' does not have a feature named '" + name + "' or '" + propertyName + '\'');
                        }
                        catch (NumberFormatException eNumberFormat) {
                            this.runtimeException = eNumberFormat;
                        }
                    }
                    this.setEObject(null);
                }
            } else {
                this.feature = null;
            }
            this.index = -1;
        }

        protected int getIndex() {
            return this.index;
        }

        protected void setIndex(int index) {
            if (index < 0) {
                this.runtimeException = new IndexOutOfBoundsException("Index value is too low");
                this.setEObject(null);
                return;
            }
            if (!FeatureMapUtil.isMany((EObject)this.eObject, (EStructuralFeature)this.feature)) {
                this.runtimeException = new IndexOutOfBoundsException("Index applies only to multi-valued features");
                this.setEObject(null);
                return;
            }
            int size = ((List)this.eObject.eGet(this.feature)).size();
            if (index >= size) {
                this.runtimeException = new IndexOutOfBoundsException("Index value should have been less than " + size);
                this.setEObject(null);
            }
            this.index = index;
        }

        protected void process(String pathString) {
            TokenList tokens = new TokenList(pathString.toCharArray());
            int size = tokens.size();
            int x = 0;
            if ("/".equals(tokens.peek(0))) {
                this.setEObject(EcoreUtil.getRootContainer((EObject)this.eObject));
                ++x;
            }
            while (x < size) {
                String token = tokens.peek(x);
                char c = token.charAt(0);
                if ('/' == c) {
                    this.setEObject((EObject)this.get());
                    if (this.eObject == null) {
                        break;
                    }
                } else if ("..".equals(token)) {
                    this.setEObject(this.eObject.eContainer());
                    if (this.eObject == null) {
                        break;
                    }
                } else if ('[' == c) {
                    token = tokens.peek(++x);
                    char following = tokens.peek(x + 1).charAt(0);
                    if ('=' != following) {
                        try {
                            this.setIndex(Integer.parseInt(token) - 1);
                        }
                        catch (NumberFormatException eNumberFormat) {
                            this.runtimeException = eNumberFormat;
                            this.setEObject(null);
                            break;
                        }
                        if (this.runtimeException != null) break;
                        ++x;
                    } else {
                        String attributeValue;
                        ++x;
                        if ("\"".equals(attributeValue = tokens.peek(++x))) {
                            ++x;
                            attributeValue = tokens.peek(++x);
                        }
                        ++x;
                        int index = Accessor.matchingIndex((List)this.get(), token, attributeValue);
                        if (index < 0) {
                            this.setEObject(null);
                            break;
                        }
                        this.setIndex(index);
                    }
                } else if ('@' != c) {
                    this.setFeatureName(token);
                    if (this.eObject == null) break;
                }
                ++x;
            }
        }

        protected static int matchingIndex(List dataObjects, String attributeName, String attributeValue) {
            int size = dataObjects.size();
            for (int i = 0; i < size; ++i) {
                String testString;
                Object test;
                DataObject dataObject = (DataObject)dataObjects.get(i);
                Property property = DataObjectUtil.getInstanceProperty(dataObject, attributeName);
                if (property == null || (test = dataObject.get(property)) == null || !attributeValue.equals(testString = EcoreUtil.convertToString((EDataType)((EDataType)property.getType()), (Object)test))) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("Accessor (object:");
            result.append(this.eObject == null ? "null" : this.eObject.toString());
            result.append(", feature:");
            result.append(this.feature == null ? "null" : this.feature.getName());
            result.append(", index:");
            result.append(this.index);
            result.append(")");
            return result.toString();
        }

        protected static class TokenList
        extends BasicEList {
            public TokenList(char[] path) {
                super(4);
                int pathLength = path.length;
                StringBuffer token = new StringBuffer();
                char c = '\u0000';
                char stringConstant = '\u0000';
                block9: for (int pos = 0; pos < pathLength; ++pos) {
                    char cNext;
                    char cPrev = c;
                    c = path[pos];
                    char c2 = cNext = pos < pathLength - 1 ? path[pos + 1] : (char)'\u0000';
                    if (stringConstant != '\u0000') {
                        if (c == stringConstant) {
                            this.endToken(token, true);
                            stringConstant = '\u0000';
                            continue;
                        }
                        token.append(c);
                        continue;
                    }
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (cPrev != ' ') {
                                this.endToken(token, false);
                            }
                            c = ' ';
                            continue block9;
                        }
                        case '\"': 
                        case '\'': {
                            this.endToken(token, false);
                            stringConstant = c;
                            continue block9;
                        }
                        case '/': 
                        case ':': {
                            if (cPrev != c) {
                                this.endToken(token, false);
                            }
                            token.append(c);
                            if (cNext == c) continue block9;
                            this.endToken(token, false);
                            continue block9;
                        }
                        case '.': {
                            if (cNext == '.') {
                                this.endToken(token, false);
                            }
                            token.append(c);
                            if (cPrev != '.') continue block9;
                            this.endToken(token, false);
                            continue block9;
                        }
                        case '(': 
                        case ')': 
                        case '*': 
                        case '@': 
                        case '[': 
                        case ']': 
                        case '|': {
                            this.endToken(token, false);
                            this.add(String.valueOf(c));
                            continue block9;
                        }
                        case '!': {
                            this.endToken(token, false);
                            token.append(c);
                            continue block9;
                        }
                        case '=': {
                            this.endToken(token, false);
                            this.add(String.valueOf(c));
                            continue block9;
                        }
                        default: {
                            token.append(c);
                        }
                    }
                }
                this.endToken(token, false);
            }

            public String peek() {
                return this.size > 0 ? (String)this.data[0] : " ";
            }

            public String peek(int index) {
                return index < this.size ? (String)this.data[index] : " ";
            }

            public TokenList pop() {
                this.remove(0);
                return this;
            }

            public TokenList pop(int count) {
                while (count-- > 0) {
                    this.remove(count);
                }
                return this;
            }

            protected void endToken(StringBuffer token, boolean includeEmpty) {
                if (includeEmpty || token.length() > 0) {
                    this.add(token.toString());
                }
                token.setLength(0);
            }

            protected boolean canContainNull() {
                return false;
            }

            protected Object[] newData(int capacity) {
                return new String[capacity];
            }
        }

        protected static class Pool
        extends BasicEList {
            protected Accessor[] accessors;

            public Pool() {
                super(10);
            }

            protected Object[] newData(int capacity) {
                this.accessors = new Accessor[capacity];
                return this.accessors;
            }

            public synchronized Accessor get() {
                if (this.size > 0) {
                    return this.accessors[--this.size];
                }
                return new Accessor();
            }

            public synchronized void recycle(Accessor accessor) {
                int minimumCapacity = this.size + 1;
                if (minimumCapacity > this.data.length) {
                    this.grow(minimumCapacity);
                }
                this.accessors[this.size++] = accessor;
            }
        }
    }
}

