/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StAX2SAXAdapter {
    private final boolean namespacePrefixes;

    public StAX2SAXAdapter(boolean namespacePrefixes) {
        this.namespacePrefixes = namespacePrefixes;
    }

    public void parse(XMLStreamReader reader, ContentHandler handler) throws XMLStreamException, SAXException {
        handler.setDocumentLocator(new LocatorAdaptor(reader.getLocation()));
        int level = 0;
        int event = reader.getEventType();
        while (true) {
            switch (event) {
                case 7: {
                    ++level;
                    handler.startDocument();
                    break;
                }
                case 1: {
                    ++level;
                    this.handleStartElement(reader, handler);
                    break;
                }
                case 3: {
                    handler.processingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 4: {
                    handler.characters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                    break;
                }
                case 2: {
                    StAX2SAXAdapter.handleEndElement(reader, handler);
                    if (--level != 1) break;
                    return;
                }
                case 8: {
                    handler.endDocument();
                    return;
                }
            }
            event = reader.next();
        }
    }

    private void handleStartElement(XMLStreamReader reader, ContentHandler handler) throws SAXException {
        String prefix;
        int nsCount = reader.getNamespaceCount();
        for (int i = 0; i < nsCount; ++i) {
            prefix = reader.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            handler.startPrefixMapping(prefix, reader.getNamespaceURI(i));
        }
        QName qname = reader.getName();
        prefix = qname.getPrefix();
        String rawname = prefix == null || prefix.length() == 0 ? qname.getLocalPart() : prefix + ':' + qname.getLocalPart();
        Attributes attrs = this.getAttributes(reader);
        handler.startElement(qname.getNamespaceURI(), qname.getLocalPart(), rawname, attrs);
    }

    private static void handleEndElement(XMLStreamReader reader, ContentHandler handler) throws SAXException {
        QName qname = reader.getName();
        handler.endElement(qname.getNamespaceURI(), qname.getLocalPart(), qname.toString());
        int nsCount = reader.getNamespaceCount();
        for (int i = nsCount - 1; i >= 0; --i) {
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            handler.endPrefixMapping(prefix);
        }
    }

    private Attributes getAttributes(XMLStreamReader reader) {
        int i;
        AttributesImpl attrs = new AttributesImpl();
        if (this.namespacePrefixes) {
            for (i = 0; i < reader.getNamespaceCount(); ++i) {
                String prefix = reader.getNamespacePrefix(i);
                String uri = reader.getNamespaceURI(i);
                attrs.addAttribute(null, prefix, "xmlns:" + prefix, "CDATA", uri);
            }
        }
        for (i = 0; i < reader.getAttributeCount(); ++i) {
            String uri = reader.getAttributeNamespace(i);
            if (uri == null) {
                uri = "";
            }
            String localName = reader.getAttributeLocalName(i);
            String prefix = reader.getAttributePrefix(i);
            String qname = prefix == null || prefix.length() == 0 ? localName : prefix + ':' + localName;
            String type = reader.getAttributeType(i);
            String value = reader.getAttributeValue(i);
            attrs.addAttribute(uri, localName, qname, type, value);
        }
        return attrs;
    }

    private static class LocatorAdaptor
    implements Locator {
        private final Location location;

        private LocatorAdaptor(Location location) {
            this.location = location;
        }

        public int getColumnNumber() {
            return this.location == null ? 0 : this.location.getColumnNumber();
        }

        public int getLineNumber() {
            return this.location == null ? 0 : this.location.getLineNumber();
        }

        public String getPublicId() {
            return this.location == null ? "" : this.location.getPublicId();
        }

        public String getSystemId() {
            return this.location == null ? "" : this.location.getSystemId();
        }
    }
}

