/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util.resource;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.XSDHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sdo.SDOPackage;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.impl.ChangeSummaryImpl;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.impl.ModelFactoryImpl;
import org.apache.tuscany.sdo.util.resource.DataObjectXMLStreamReader;
import org.apache.tuscany.sdo.util.resource.XMLDocumentStreamReader;
import org.apache.tuscany.sdo.util.resource.XMLStreamSerializer;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class ChangeSummaryStreamSerializer {
    private XMLStreamWriter writer;
    private int nsPrefixSuffix;
    XSDHelper xsdHelper;
    private String lineBreak;
    private String indent;
    private String margin;
    private int nest;
    private Map options;
    private static final String STRING_OPTION = "String option";
    protected static final String CREATE_ATTRIBUTE = "create";
    protected static final String DELETE_ATTRIBUTE = "delete";
    protected static final String LOGGING_ATTRIBUTE = "logging";
    protected static final String REF_ATTRIBUTE = "ref";
    protected static final String UNSET = "unset";
    private DataObject dataObject;
    private String pathRootObject;
    private DataObject rootObject;
    protected String rootElementNS;
    String rootElementName;
    ExtendedMetaData extendedMetaData;
    private StringBuffer pathDeleted;
    private Collection modifiedDataObjects;
    private int lengthDeleted;
    private String changeSummaryElementNS;
    private String changeSummaryElementName;
    private ChangeSummary changeSummary;
    public static final Object ChangeSummary_TYPE = ((ModelFactoryImpl)ModelFactory.INSTANCE).getChangeSummaryType();
    Collection deletedDataObjects;
    protected static final Object CHANGE_SUMMARY = SDOPackage.eINSTANCE.getChangeSummary();
    public static final String OPTION_RootObject_PATH = "RootObject path";
    public static final String OPTION_OPTIMIZE_LIST = "optimize sequence/list/array";
    public static final String OPTION_ROOT_ELEMENT = "Root Element";

    private String writeNamespace(String prefix, String nameSpace) throws XMLStreamException {
        this.writer.writeNamespace(prefix, nameSpace);
        this.writer.setPrefix(prefix, nameSpace);
        return prefix;
    }

    private String prefix(String nameSpace, String preference) throws XMLStreamException {
        Object automaticNsPrefix;
        if (preference != null) {
            String bound = this.writer.getNamespaceContext().getNamespaceURI(preference);
            if (bound == null) {
                String prefix = this.writer.getPrefix(nameSpace);
                return prefix == null ? this.writeNamespace(preference, nameSpace) : prefix;
            }
            if (bound.equals(nameSpace)) {
                return preference;
            }
        }
        if ((automaticNsPrefix = this.writer.getProperty("javax.xml.stream.isRepairingNamespaces")) != null && automaticNsPrefix.getClass() == Boolean.class && ((Boolean)automaticNsPrefix).booleanValue()) {
            return null;
        }
        String prefix = this.writer.getPrefix(nameSpace);
        if (prefix != null) {
            return prefix;
        }
        NamespaceContext nameSpaces = this.writer.getNamespaceContext();
        while (nameSpaces.getNamespaceURI(prefix = "CS" + this.nsPrefixSuffix++) != null) {
        }
        return this.writeNamespace(prefix, nameSpace);
    }

    void writeGlobalAttribute(String prefix, String nameSpace, String name, String value) throws XMLStreamException {
        if ((prefix = this.prefix(nameSpace, prefix)) == null) {
            this.writer.writeAttribute(nameSpace, name, value);
        } else {
            this.writer.writeAttribute(prefix, nameSpace, name, value);
        }
    }

    protected final void writeAttribute(Property property, String value) throws XMLStreamException {
        String name = this.xsdHelper.getLocalName(property);
        String nameSpace = this.xsdHelper.getNamespaceURI(property);
        if (nameSpace == null) {
            this.writer.writeAttribute(name, value);
        } else {
            this.writeGlobalAttribute(null, nameSpace, name, value);
        }
    }

    private void breakLine() throws XMLStreamException {
        this.writer.writeCharacters(this.lineBreak);
        if (this.margin != null) {
            this.writer.writeCharacters(this.margin);
        }
        if (this.indent != null) {
            for (int count = this.nest; count != 0; --count) {
                this.writer.writeCharacters(this.indent);
            }
        }
    }

    void startElement() throws XMLStreamException {
        if (this.options == null) {
            return;
        }
        if (this.lineBreak == STRING_OPTION) {
            this.lineBreak = (String)this.options.get("LineBreak");
        }
        if (this.lineBreak == null) {
            return;
        }
        if (this.margin == STRING_OPTION) {
            this.margin = (String)this.options.get("margin");
        }
        if (this.indent == STRING_OPTION) {
            this.indent = (String)this.options.get("indent");
        }
        this.breakLine();
    }

    void writeStartElement(String prefix, String nameSpace, String name) throws XMLStreamException {
        this.startElement();
        if (nameSpace == null) {
            this.writer.writeStartElement(name);
        } else if ((prefix = this.prefix(nameSpace, prefix)) == null) {
            this.writer.writeStartElement(nameSpace, name);
        } else {
            this.writer.writeStartElement(prefix, name, nameSpace);
        }
    }

    void writeStartElement(Property property) throws XMLStreamException {
        ++this.nest;
        this.writeStartElement(null, this.xsdHelper.getNamespaceURI(property), this.xsdHelper.getLocalName(property));
    }

    private StringBuffer step(String nameSpace, String name, StringBuffer path) throws XMLStreamException {
        if (nameSpace != null && (nameSpace = this.writer.getPrefix(nameSpace)) != null && nameSpace.length() != 0) {
            return path.append(nameSpace).append(':').append(name);
        }
        return path.append(name);
    }

    private StringBuffer step(Property containmentProperty, StringBuffer path) throws XMLStreamException {
        return this.step(this.xsdHelper.getNamespaceURI(containmentProperty), this.xsdHelper.getLocalName(containmentProperty), path);
    }

    private StringBuffer step(Property containmentProperty) throws XMLStreamException {
        return this.step(containmentProperty, new StringBuffer());
    }

    private StringBuffer step(Object container) throws XMLStreamException {
        Property containmentProperty = this.dataObject.getContainmentProperty();
        StringBuffer step = this.step(containmentProperty);
        if (containmentProperty.isMany() || ((EObject)this.dataObject).eContainingFeature() != containmentProperty) {
            step.append('[').append(((DataObject)container).getList(containmentProperty).indexOf(this.dataObject) + 1).append(']');
        }
        return step;
    }

    private EObject container(EObject object) {
        EObject container = object.eContainer();
        if (!(container instanceof DataObject)) {
            return null;
        }
        String name = this.extendedMetaData.getName((EClassifier)container.eClass());
        return name != null && name.length() == 0 ? null : container;
    }

    private String path() throws XMLStreamException {
        if (this.pathRootObject == STRING_OPTION) {
            String string = this.pathRootObject = this.options == null ? null : (String)this.options.get(OPTION_RootObject_PATH);
        }
        if (this.pathRootObject != null && this.dataObject == this.rootObject) {
            return null;
        }
        EObject container = this.container((EObject)this.dataObject);
        if (container == null) {
            return null;
        }
        StringBuffer step = this.step(container);
        while (true) {
            String path = step.toString();
            this.dataObject = (DataObject)container;
            if (this.pathRootObject != null && container == this.rootObject) {
                return path;
            }
            if ((container = this.container(container)) == null) {
                return path;
            }
            step = this.step(container).append('/').append(path);
        }
    }

    protected final String rootElementName() {
        if (this.rootElementNS != null) {
            return this.rootElementName;
        }
        QName rootElement = (QName)this.options.get(OPTION_ROOT_ELEMENT);
        if (rootElement != null) {
            this.rootElementNS = rootElement.getNamespaceURI();
            this.rootElementName = rootElement.getLocalPart();
            return this.rootElementName;
        }
        EStructuralFeature element = ((EObject)this.rootObject).eContainingFeature();
        if (element == null) {
            this.rootElementNS = "";
            this.rootElementName = "descendant-or-self::node()";
            return "descendant-or-self::node()";
        }
        this.rootElementNS = this.extendedMetaData.getNamespace(element);
        if (this.rootElementNS == null) {
            this.rootElementNS = "";
        }
        this.rootElementName = this.extendedMetaData.getName(element);
        return this.rootElementName;
    }

    String ref() throws XMLStreamException {
        String id = EcoreUtil.getID((EObject)((EObject)this.dataObject));
        if (id != null) {
            return id;
        }
        id = this.path();
        if (this.pathRootObject == null) {
            return id == null ? "#/" + this.rootElementName() : "#//" + id;
        }
        return id == null ? this.pathRootObject : this.pathRootObject + id;
    }

    void writeRef(String ref) throws XMLStreamException {
        this.writer.writeAttribute("commonj.sdo", REF_ATTRIBUTE, ref);
    }

    void writeRef() throws XMLStreamException {
        this.writeRef(this.ref());
    }

    void writeEndElement(String lineBreak) throws XMLStreamException {
        if (lineBreak != null) {
            this.breakLine();
        }
        this.writer.writeEndElement();
        --this.nest;
    }

    protected boolean skipDeletedModification(DataObject modifiedDataObject) {
        return this.changeSummary.isDeleted(modifiedDataObject);
    }

    String refDeleted() throws XMLStreamException {
        EStructuralFeature f;
        String id = EcoreUtil.getID((EObject)((EObject)this.dataObject));
        if (id != null) {
            return id;
        }
        id = this.path();
        DataObject deletedDataObject = this.dataObject;
        if (this.lengthDeleted == -1) {
            String path;
            String string = path = this.pathRootObject == null ? "#//" : this.pathRootObject;
            if (this.pathDeleted == null) {
                this.pathDeleted = new StringBuffer(path);
            } else {
                this.pathDeleted.replace(0, this.pathDeleted.length(), path);
            }
            this.dataObject = this.rootObject;
            path = this.path();
            if (path != null) {
                this.pathDeleted.append(path).append('/');
            }
            this.step(this.changeSummaryElementNS, this.changeSummaryElementName, this.pathDeleted).append('/');
            this.lengthDeleted = this.pathDeleted.length();
        } else {
            this.pathDeleted.delete(this.lengthDeleted, this.pathDeleted.length());
        }
        this.dataObject = this.changeSummary.getOldContainer(deletedDataObject);
        Property containmentProperty = this.dataObject.getContainmentProperty();
        String name = containmentProperty == null ? this.rootElementName() : this.xsdHelper.getLocalName(containmentProperty);
        int index = 1;
        Iterator iterator = this.modifiedDataObjects.iterator();
        while (iterator.hasNext()) {
            DataObject modifiedDataObject = (DataObject)iterator.next();
            if (this.skipDeletedModification(modifiedDataObject)) continue;
            if (modifiedDataObject == this.dataObject) break;
            Property property = modifiedDataObject.getContainmentProperty();
            if (property != containmentProperty && !name.equals(property == null ? this.rootElementName() : this.xsdHelper.getLocalName(property))) continue;
            ++index;
        }
        this.pathDeleted.append(name).append('[').append(index).append("]/");
        containmentProperty = this.changeSummary.getOldContainmentProperty(deletedDataObject);
        this.step(containmentProperty, this.pathDeleted);
        if (containmentProperty.isMany() || (f = this.extendedMetaData.getAffiliation(((EObject)this.dataObject).eClass(), (EStructuralFeature)containmentProperty)) != null && f != containmentProperty) {
            this.pathDeleted.append('[').append(((List)this.changeSummary.getOldValue(this.dataObject, containmentProperty).getValue()).indexOf(deletedDataObject) + 1).append(']');
        }
        if (id != null) {
            this.pathDeleted.append('/').append(id);
        }
        return this.pathDeleted.toString();
    }

    static String convertToString(Property property, Object value) {
        return EcoreUtil.convertToString((EDataType)((EDataType)property.getType()), (Object)value);
    }

    void writeRefDeleted() throws XMLStreamException {
        this.writeRef(this.refDeleted());
    }

    protected final void writeDeletedObject(Property property) throws XMLStreamException {
        ++this.nest;
        this.startElement();
        --this.nest;
        DataObject oldDataObject = ((ChangeSummaryImpl)this.changeSummary).getOldDataObject(this.dataObject);
        DataObjectXMLStreamReader reader = new DataObjectXMLStreamReader(property, oldDataObject, null, this.xsdHelper);
        new XMLStreamSerializer().serialize(new XMLDocumentStreamReader(reader), this.writer);
    }

    protected final void writeElement(Object value, Property property) throws XMLStreamException {
        if (value == null) {
            this.writeStartElement(property);
            this.writeGlobalAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
            this.writeEndElement(null);
        } else if (value instanceof DataObject) {
            this.dataObject = (DataObject)value;
            if (!this.changeSummary.isDeleted(this.dataObject)) {
                this.writeStartElement(property);
                this.writeRef();
                this.writeEndElement(null);
            } else if (property.isContainment() && this.deletedDataObjects.contains(this.dataObject)) {
                this.writeDeletedObject(property);
            } else {
                this.writeStartElement(property);
                this.writeRefDeleted();
                this.writeEndElement(null);
            }
        } else {
            Type type = property.getType();
            if (type == ChangeSummary_TYPE) {
                return;
            }
            this.writeStartElement(property);
            this.writer.writeCharacters(EcoreUtil.convertToString((EDataType)((EDataType)type), (Object)value));
            this.writeEndElement(null);
        }
    }

    protected final void writeElement(Object value) throws XMLStreamException {
        FeatureMap.Entry entry = (FeatureMap.Entry)value;
        this.writeElement(entry.getValue(), (Property)entry.getEStructuralFeature());
    }

    protected static List optimize(List values, Object featureChange, int size) {
        int fromIndex = size;
        int toIndex = 0;
        Iterator changes = ((FeatureChange)featureChange).getListChanges().iterator();
        while (changes.hasNext()) {
            ListChange change = (ListChange)changes.next();
            ChangeKind kind = change.getKind();
            if (kind == ChangeKind.MOVE_LITERAL) {
                return values;
            }
            int index = change.getIndex();
            if (kind == ChangeKind.ADD_LITERAL) {
                if (index == 0) {
                    fromIndex = 0;
                    if (toIndex == 0) {
                        toIndex = 1;
                    }
                } else {
                    int to = index--;
                    if (index < fromIndex) {
                        fromIndex = index;
                    }
                    if (++to > toIndex) {
                        toIndex = to;
                    } else if (to < toIndex) {
                        ++toIndex;
                    }
                }
                ++size;
                continue;
            }
            --size;
            if (index < fromIndex) {
                fromIndex = index;
            }
            if (index < toIndex) {
                --toIndex;
                continue;
            }
            if (index <= toIndex || index == size) continue;
            toIndex = index;
        }
        return values.subList(fromIndex, toIndex);
    }

    public final void saveChangeSummary(ChangeSummary changeSummary, QName changeSummaryElement, XMLStreamWriter writer, Map options) throws XMLStreamException {
        Iterator iterator;
        EClass type;
        Property declaration;
        if (changeSummary.isLogging()) {
            ((ChangeSummaryImpl)changeSummary).summarize();
        }
        ChangeDescription changeDescription = (ChangeDescription)changeSummary;
        Iterator createdDataObjects = changeDescription.getObjectsToDetach().iterator();
        this.deletedDataObjects = changeDescription.getObjectsToAttach();
        EMap objectChanges = changeDescription.getObjectChanges();
        this.modifiedDataObjects = objectChanges.keySet();
        this.nsPrefixSuffix = 0;
        this.writer = writer;
        this.options = options;
        this.lineBreak = "";
        this.pathRootObject = STRING_OPTION;
        this.margin = STRING_OPTION;
        this.indent = STRING_OPTION;
        this.nest = 0;
        this.changeSummaryElementNS = changeSummaryElement.getNamespaceURI();
        this.changeSummaryElementName = changeSummaryElement.getLocalPart();
        this.writeStartElement(changeSummaryElement.getPrefix(), this.changeSummaryElementNS, this.changeSummaryElementName);
        this.lineBreak = STRING_OPTION;
        this.rootObject = changeSummary.getRootObject();
        this.extendedMetaData = (ExtendedMetaData)options.get("EXTENDED_META_DATA");
        if (this.extendedMetaData == null) {
            this.extendedMetaData = ExtendedMetaData.INSTANCE;
            this.xsdHelper = XSDHelper.INSTANCE;
        } else {
            this.xsdHelper = new HelperContextImpl(this.extendedMetaData, false).getXSDHelper();
        }
        Property property = declaration = this.changeSummaryElementNS == null ? this.rootObject.getType().getProperty(this.changeSummaryElementName) : this.xsdHelper.getGlobalProperty(this.changeSummaryElementNS, this.changeSummaryElementName, true);
        if (declaration != null && (type = changeDescription.eClass()) != declaration.getType() && type != CHANGE_SUMMARY) {
            this.writeGlobalAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", this.prefix(this.extendedMetaData.getNamespace((EClassifier)type), null) + ':' + this.extendedMetaData.getName((EClassifier)type));
        }
        this.rootElementNS = null;
        this.changeSummary = changeSummary;
        if (createdDataObjects.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            while (true) {
                this.dataObject = (DataObject)createdDataObjects.next();
                buffer.append(this.ref());
                if (!createdDataObjects.hasNext()) break;
                buffer.append(' ');
            }
            writer.writeAttribute(CREATE_ATTRIBUTE, buffer.toString());
        }
        if ((iterator = this.deletedDataObjects.iterator()).hasNext()) {
            this.lengthDeleted = -1;
            StringBuffer buffer = null;
            do {
                this.dataObject = (DataObject)iterator.next();
                if (this.skipDeletedModification(changeSummary.getOldContainer(this.dataObject))) continue;
                if (buffer == null) {
                    buffer = new StringBuffer();
                } else {
                    buffer.append(' ');
                }
                buffer.append(this.refDeleted());
            } while (iterator.hasNext());
            writer.writeAttribute(DELETE_ATTRIBUTE, buffer.toString());
        }
        writer.writeAttribute(LOGGING_ATTRIBUTE, changeSummary.isLogging() ? "true" : "false");
        iterator = this.modifiedDataObjects.iterator();
        if (iterator.hasNext()) {
            Object option;
            boolean optimizeList = options == null ? false : ((option = options.get(OPTION_OPTIMIZE_LIST)) == null ? false : (Boolean)option);
            this.prefix("commonj.sdo", "sdo");
            do {
                DataObject dataObject;
                if (this.skipDeletedModification(dataObject = (DataObject)iterator.next())) continue;
                Property containmentProperty = dataObject.getContainmentProperty();
                if (containmentProperty == null) {
                    ++this.nest;
                    this.startElement();
                    this.rootElementName();
                    writer.writeStartElement(this.rootElementNS, this.rootElementName);
                } else {
                    this.writeStartElement(containmentProperty);
                }
                this.dataObject = dataObject;
                this.writeRef();
                String lineBreak = null;
                Collection oldValues = (Collection)objectChanges.get((Object)dataObject);
                Iterator settings = oldValues.iterator();
                if (settings.hasNext()) {
                    Property property2;
                    ChangeSummary.Setting oldValue;
                    do {
                        if ((oldValue = (ChangeSummary.Setting)settings.next()).isSet()) continue;
                        StringBuffer unset = this.step(oldValue.getProperty());
                        while (settings.hasNext()) {
                            oldValue = (ChangeSummary.Setting)settings.next();
                            if (oldValue.isSet()) continue;
                            this.step(oldValue.getProperty(), unset.append(' '));
                        }
                        writer.writeAttribute("commonj.sdo", UNSET, unset.toString());
                        break;
                    } while (settings.hasNext());
                    settings = oldValues.iterator();
                    while (settings.hasNext()) {
                        oldValue = (ChangeSummary.Setting)settings.next();
                        property2 = oldValue.getProperty();
                        if (!oldValue.isSet() || !this.xsdHelper.isAttribute(property2)) continue;
                        this.writeAttribute(property2, ChangeSummaryStreamSerializer.convertToString(property2, oldValue.getValue()));
                    }
                    settings = oldValues.iterator();
                    while (settings.hasNext()) {
                        Object value;
                        oldValue = (ChangeSummary.Setting)settings.next();
                        property2 = oldValue.getProperty();
                        if (this.xsdHelper.isAttribute(property2)) continue;
                        if (property2.isMany()) {
                            Iterator values;
                            value = oldValue.getValue();
                            List list = (List)value;
                            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)((EStructuralFeature)property2))) {
                                if (optimizeList) {
                                    list = ChangeSummaryStreamSerializer.optimize(list, oldValue, dataObject.getSequence(property2).size());
                                }
                                if (!(values = list.iterator()).hasNext()) continue;
                                do {
                                    this.writeElement(values.next());
                                } while (values.hasNext());
                            } else {
                                if (optimizeList) {
                                    list = ChangeSummaryStreamSerializer.optimize(list, oldValue, dataObject.getList(property2).size());
                                }
                                if (!(values = list.iterator()).hasNext()) continue;
                                do {
                                    this.writeElement(values.next(), property2);
                                } while (values.hasNext());
                            }
                            lineBreak = this.lineBreak;
                            continue;
                        }
                        if (!oldValue.isSet()) continue;
                        value = oldValue.getValue();
                        if (value instanceof FeatureMap.Entry) {
                            this.writeElement(value);
                        } else {
                            this.writeElement(value, property2);
                        }
                        lineBreak = this.lineBreak;
                    }
                }
                this.writeEndElement(lineBreak);
            } while (iterator.hasNext());
            this.writeEndElement(this.lineBreak);
        } else {
            this.writeEndElement(null);
        }
        writer.flush();
    }
}

