/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class RecordedEventXMLStreamReader
implements XMLStreamReader {
    Event event;
    final List events;
    final int size;
    protected StringBuffer buffer;
    protected int next;

    protected static String prefix(String qName, String nameSpace) {
        int delimiter = qName.indexOf(58);
        if (delimiter != -1) {
            return qName.substring(0, delimiter);
        }
        if (nameSpace.length() != 0) {
            return "";
        }
        return null;
    }

    protected RecordedEventXMLStreamReader(Tag tag) {
        this.event = tag;
        tag.type = 1;
        this.events = tag.events;
        this.size = this.events.size();
    }

    public int getAttributeCount() {
        switch (this.getEventType()) {
            case 1: {
                AttributeList attributes = ((StartElement)this.event).attributes;
                return attributes == null ? 0 : attributes.getLength();
            }
            case 10: {
                return ((AttributeEvent)this.event).attributes;
            }
        }
        throw new IllegalStateException("Neither START_ELEMENT nor ATTRIBUTE");
    }

    protected final AttributeList attributes() {
        if (this.getEventType() == 1) {
            return ((StartElement)this.event).attributes;
        }
        throw new IllegalStateException("Neither START_ELEMENT nor ATTRIBUTE");
    }

    public String getAttributeLocalName(int index) {
        return this.attributes().getLocalName(index);
    }

    static Attribute attribute(AttributeList attributes, int index) {
        return (Attribute)attributes.attributes.get(index);
    }

    public QName getAttributeName(int index) {
        return this.getEventType() == 10 ? ((AttributeEvent)this.event).name : RecordedEventXMLStreamReader.attribute((AttributeList)this.attributes(), (int)index).qName;
    }

    public String getAttributeNamespace(int index) {
        return this.getEventType() == 10 ? ((AttributeEvent)this.event).nameSpace : this.attributes().getURI(index);
    }

    public String getAttributePrefix(int index) {
        return this.getEventType() == 10 ? ((AttributeEvent)this.event).prefix : RecordedEventXMLStreamReader.attribute((AttributeList)this.attributes(), (int)index).prefix;
    }

    public String getAttributeType(int index) {
        return this.getEventType() == 10 ? ((Reference)this.event).target : this.attributes().getType(index);
    }

    public String getAttributeValue(int index) {
        return this.getEventType() == 10 ? ((ValueEvent)this.event).value : this.attributes().getValue(index);
    }

    public boolean isAttributeSpecified(int index) {
        if (this.getEventType() == 10) {
            return ((AttributeEvent)this.event).specified;
        }
        AttributeList attributes = this.attributes();
        return RecordedEventXMLStreamReader.attribute((AttributeList)attributes, (int)index).specified;
    }

    public String getAttributeValue(String nameSpace, String name) {
        if (this.getEventType() == 10) {
            AttributeEvent attribute = (AttributeEvent)this.event;
            return !attribute.name.getLocalPart().equals(name) ? null : (nameSpace == null ? (attribute.nameSpace == null ? attribute.value : null) : (nameSpace.equals(attribute.nameSpace) ? attribute.value : null));
        }
        AttributeList attributes = this.attributes();
        return attributes == null ? null : attributes.getValue(nameSpace == null ? "" : nameSpace, name);
    }

    public String getElementText() {
        if (this.buffer != null) {
            this.buffer.delete(0, this.buffer.length());
        }
        while (true) {
            switch (this.next()) {
                case 2: {
                    return this.buffer == null ? null : this.buffer.toString();
                }
                default: {
                    if (this.buffer == null) {
                        this.buffer = new StringBuffer();
                    }
                    this.buffer.append(this.getText());
                }
                case 3: 
                case 5: 
            }
        }
    }

    public final int getEventType() {
        return this.event.type;
    }

    public String getLocalName() {
        if (this.getEventType() == 9) {
            return ((Reference)this.event).target;
        }
        if (this.event instanceof EndElement) {
            return ((EndElement)this.event).name.getLocalPart();
        }
        throw new IllegalStateException("Neither START_ELEMENT, END_ELEMENT nor ENTITY_REFERENCE");
    }

    public final Location getLocation() {
        return this.event.location;
    }

    public QName getName() {
        if (this.hasName()) {
            return ((EndElement)this.event).name;
        }
        throw new IllegalStateException("Neither START_ELEMENT nor END_ELEMENT");
    }

    public final NamespaceContext getNamespaceContext() {
        return this.event.nameSpaceContext;
    }

    public int getNamespaceCount() {
        if (this.getEventType() == 13) {
            return ((NameSpaceEvent)this.event).nameSpaces;
        }
        if (!(this.event instanceof EndElement)) {
            throw new IllegalStateException("Neither START_ELEMENT, END_ELEMENT nor NAMESPACE");
        }
        List nameSpaces = ((EndElement)this.event).nameSpaces;
        return nameSpaces == null ? 0 : nameSpaces.size();
    }

    protected final NameSpace getNameSpace(int index) {
        if (this.event instanceof EndElement) {
            return (NameSpace)((EndElement)this.event).nameSpaces.get(index);
        }
        throw new IllegalStateException("Neither START_ELEMENT, END_ELEMENT nor NAMESPACE");
    }

    public String getNamespacePrefix(int index) {
        return this.getEventType() == 13 ? ((Reference)this.event).target : this.getNameSpace((int)index).prefix;
    }

    public final String getNamespaceURI() {
        switch (this.getEventType()) {
            case 10: {
                return ((AttributeEvent)this.event).nameSpace;
            }
            case 13: {
                return ((ValueEvent)this.event).value;
            }
        }
        return this.event instanceof EndElement ? ((EndElement)this.event).nameSpace : null;
    }

    public String getNamespaceURI(String prefix) {
        return this.getNamespaceContext().getNamespaceURI(prefix);
    }

    public String getNamespaceURI(int index) {
        return this.getEventType() == 13 ? ((ValueEvent)this.event).value : this.getNameSpace((int)index).uri;
    }

    public String getPIData() {
        return this.getEventType() == 3 ? ((ValueEvent)this.event).value : null;
    }

    public String getPITarget() {
        return this.getEventType() == 3 ? ((Reference)this.event).target : null;
    }

    public String getPrefix() {
        switch (this.getEventType()) {
            case 10: {
                return ((AttributeEvent)this.event).prefix;
            }
            case 13: {
                return ((Reference)this.event).target;
            }
        }
        return this.event instanceof EndElement ? ((EndElement)this.event).prefix : null;
    }

    public final String getText() {
        if (this.hasText()) {
            return ((ValueEvent)this.event).value;
        }
        throw new IllegalStateException("Neither CHARACTERS, CDATA, COMMENT, SPACE, ENTITY_REFERENCE nor DTD");
    }

    public final char[] getTextCharacters() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 12: {
                return ((ValueEvent)this.event).value.toCharArray();
            }
        }
        throw new IllegalStateException("Neither CHARACTERS, CDATA, COMMENT nor SPACE");
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) {
        char[] source = this.getTextCharacters();
        if (sourceStart > source.length) {
            throw new IndexOutOfBoundsException("source start > source length");
        }
        int sourceLen = source.length - sourceStart;
        if (length > sourceLen) {
            length = sourceLen;
        }
        System.arraycopy(source, sourceStart, target, targetStart, length);
        return sourceLen;
    }

    public int getTextLength() {
        return this.getTextCharacters().length;
    }

    public int getTextStart() {
        return 0;
    }

    public final boolean hasName() {
        return this.event instanceof EndElement;
    }

    public final boolean hasNext() {
        return this.next != this.size;
    }

    public final boolean hasText() {
        switch (this.getEventType()) {
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean isCharacters() {
        switch (this.getEventType()) {
            case 4: 
            case 6: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    protected final boolean areWhiteSpace() {
        String text = this.getText();
        int index = text.length();
        while (index != 0) {
            if (Character.isWhitespace(text.charAt(--index))) continue;
            return false;
        }
        return true;
    }

    public boolean isWhiteSpace() {
        switch (this.getEventType()) {
            case 4: 
            case 12: {
                return this.areWhiteSpace();
            }
            case 6: {
                return true;
            }
        }
        return false;
    }

    public final int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.event = (Event)this.events.get(this.next++);
        return this.event.type;
    }

    protected final void throwXMLStreamException(String message) throws XMLStreamException {
        throw new XMLStreamException(message, this.getLocation());
    }

    public int nextTag() throws XMLStreamException {
        block5: while (true) {
            int type = this.next();
            switch (type) {
                case 4: 
                case 12: {
                    if (!this.areWhiteSpace()) break;
                }
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 1: 
                case 2: {
                    return type;
                }
            }
            this.throwXMLStreamException("expected start or end tag");
        }
    }

    public void require(int type, String nameSpace, String name) throws XMLStreamException {
        if (this.getEventType() != type) {
            this.throwXMLStreamException("type not matched");
        }
        if (nameSpace != null && !nameSpace.equals(this.getNamespaceURI())) {
            this.throwXMLStreamException("Name Space not matched");
        }
        if (name != null && !(this.getEventType() != 10 ? this.event instanceof EndElement && name.equals(((EndElement)this.event).name.getLocalPart()) : name.equals(((AttributeEvent)this.event).name.getLocalPart()))) {
            this.throwXMLStreamException("name not matched");
        }
    }

    public static class Tag
    extends StartElement {
        public List events;
        protected int nest;

        public Tag(XMLStreamReader reader) {
            super(reader);
            this.initialize(reader);
        }

        protected final void events() {
            this.events = new ArrayList();
        }

        public Tag(String nameSpace, String local, String prefix, Attributes attributes, Locator locator, NamespaceContext context, List bindings) {
            super(nameSpace, local, prefix, attributes, locator, bindings, context);
            this.events();
        }

        public static void bind(String prefix, String nameSpace, Collection nameSpaces) {
            nameSpaces.add(new NameSpace(prefix, nameSpace));
        }

        public final void start(String nameSpace, String local, String qName, Attributes attributes, Locator locator, List bindings) {
            Event event;
            int index = this.events.size();
            block4: while (true) {
                if (index == 0) {
                    event = this;
                    break;
                }
                event = (Event)this.events.get(--index);
                if (event.type != 2) break;
                int nest = 0;
                while (true) {
                    switch (((Event)this.events.get((int)(--index))).type) {
                        case 1: {
                            if (nest == 0) continue block4;
                            --nest;
                            break;
                        }
                        case 2: {
                            ++nest;
                        }
                    }
                }
                break;
            }
            StartElement start = new StartElement(nameSpace, local, RecordedEventXMLStreamReader.prefix(qName, nameSpace), attributes, locator, bindings, event.nameSpaceContext);
            start.type = 1;
            this.events.add(start);
            ++this.nest;
        }

        protected final void add(Event event) {
            int index = this.events.size();
            event.nameSpaceContext = index == 0 ? this.nameSpaceContext : ((Event)this.events.get((int)(--index))).nameSpaceContext;
            this.events.add(event);
        }

        public final void text(int type, String value, Locator locator) {
            ValueEvent event = new ValueEvent(value);
            event.type = type;
            event.location(locator);
            this.add(event);
        }

        public final boolean end(String nameSpace, String local, String qName, Locator locator) {
            EndElement end = new EndElement(nameSpace, local, RecordedEventXMLStreamReader.prefix(qName, nameSpace), locator);
            end.type = 2;
            this.add(end);
            if (this.nest == 0) {
                return true;
            }
            --this.nest;
            return false;
        }

        public final XMLStreamReader play(final XMLResource resource) {
            return new RecordedEventXMLStreamReader(this){

                public void close() {
                }

                public String getCharacterEncodingScheme() {
                    return null;
                }

                public String getEncoding() {
                    return resource.getEncoding();
                }

                public Object getProperty(String property) {
                    return null;
                }

                public String getVersion() {
                    return resource.getXMLVersion();
                }

                public boolean isStandalone() {
                    return false;
                }

                public boolean standaloneSet() {
                    return false;
                }
            };
        }

        protected final void add(Event event, int type, XMLStreamReader reader) {
            event.type = type;
            event.initialize(reader);
            this.events.add(event);
        }

        public final boolean record(XMLStreamReader reader) throws XMLStreamException {
            this.events();
            int nest = 0;
            block10: while (reader.hasNext()) {
                Event event;
                int type = reader.next();
                switch (type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 12: {
                        event = new ValueEvent(reader.getText());
                        break;
                    }
                    case 9: {
                        event = new Reference(reader.getLocalName(), reader.getText());
                        break;
                    }
                    case 3: {
                        event = new Reference(reader.getPITarget(), reader.getPIData());
                        break;
                    }
                    case 10: {
                        event = new AttributeEvent(reader);
                        break;
                    }
                    case 13: {
                        event = new NameSpaceEvent(reader);
                        break;
                    }
                    case 1: {
                        ++nest;
                        event = new StartElement(reader);
                        break;
                    }
                    case 2: {
                        this.add(new EndElement(reader), type, reader);
                        if (nest == 0) {
                            return false;
                        }
                        --nest;
                        continue block10;
                    }
                    case 8: {
                        return true;
                    }
                    default: {
                        event = new Event();
                    }
                }
                this.add(event, type, reader);
            }
            return true;
        }

        public final XMLStreamReader play(final XMLStreamReader reader) {
            return new RecordedEventXMLStreamReader(this){

                public void close() throws XMLStreamException {
                    reader.close();
                }

                public String getCharacterEncodingScheme() {
                    return reader.getCharacterEncodingScheme();
                }

                public String getEncoding() {
                    return reader.getEncoding();
                }

                public Object getProperty(String property) {
                    return reader.getProperty(property);
                }

                public String getVersion() {
                    return reader.getVersion();
                }

                public boolean isStandalone() {
                    return reader.isStandalone();
                }

                public boolean standaloneSet() {
                    return reader.standaloneSet();
                }
            };
        }
    }

    protected static class StartElement
    extends EndElement {
        final AttributeList attributes;

        protected StartElement(XMLStreamReader reader) {
            super(reader);
            int count = reader.getAttributeCount();
            if (count == 0) {
                this.attributes = null;
            } else {
                this.attributes = new AttributeList(count);
                int index = 0;
                do {
                    Attribute attribute = new Attribute(reader.getAttributeType(index), reader.getAttributeValue(index), reader.getAttributeName(index), reader.getAttributePrefix(index), reader.getAttributeNamespace(index));
                    attribute.specified = reader.isAttributeSpecified(index);
                    this.attributes.attributes.add(attribute);
                } while (++index != count);
            }
        }

        protected StartElement(String nameSpace, String local, String prefix, Attributes attributeArray, Locator locator, List bindings, final NamespaceContext context) {
            super(nameSpace, local, prefix, locator);
            this.nameSpaces = bindings;
            this.nameSpaceContext = bindings == null || bindings.isEmpty() ? context : new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    int index = StartElement.this.nameSpaces.size();
                    while (index != 0) {
                        NameSpace binding = (NameSpace)StartElement.this.nameSpaces.get(--index);
                        if (!binding.prefix.equals(prefix)) continue;
                        return binding.uri;
                    }
                    return context.getNamespaceURI(prefix);
                }

                public String getPrefix(String namespaceURI) {
                    int index = StartElement.this.nameSpaces.size();
                    while (index != 0) {
                        NameSpace binding = (NameSpace)StartElement.this.nameSpaces.get(--index);
                        if (!binding.uri.equals(namespaceURI)) continue;
                        return binding.prefix;
                    }
                    return context.getPrefix(namespaceURI);
                }

                public Iterator getPrefixes(final String namespaceURI) {
                    final Iterator<String> iterator = context.getPrefixes(namespaceURI);
                    return new Iterator(){
                        Iterator bindings;
                        NameSpace binding;
                        protected NameSpace nameSpace;
                        {
                            this.bindings = (this).StartElement.this.nameSpaces.iterator();
                        }

                        protected final boolean prefix() {
                            while (this.bindings.hasNext()) {
                                this.binding = (NameSpace)this.bindings.next();
                                if (!this.binding.uri.equals(namespaceURI)) continue;
                                return true;
                            }
                            this.bindings = null;
                            return false;
                        }

                        public boolean hasNext() {
                            return this.bindings != null && this.prefix() || iterator.hasNext();
                        }

                        public Object next() {
                            if (this.bindings == null || this.binding == null && !this.prefix()) {
                                return iterator.next();
                            }
                            this.nameSpace = this.binding;
                            this.binding = null;
                            return this.nameSpace.prefix;
                        }

                        public void remove() {
                            if (this.bindings == null) {
                                iterator.remove();
                            } else {
                                (this).StartElement.this.nameSpaces.remove(this.nameSpace);
                            }
                        }
                    };
                }
            };
            int count = attributeArray.getLength();
            if (count == 0) {
                this.attributes = null;
            } else {
                this.attributes = new AttributeList(count);
                int index = 0;
                do {
                    QName name;
                    nameSpace = attributeArray.getURI(index);
                    local = attributeArray.getLocalName(index);
                    prefix = RecordedEventXMLStreamReader.prefix(attributeArray.getQName(index), nameSpace);
                    if (prefix == null) {
                        name = new QName(nameSpace, local, "");
                        nameSpace = null;
                    } else {
                        name = new QName(nameSpace, local, prefix);
                    }
                    this.attributes.attributes.add(new Attribute(attributeArray.getType(index), attributeArray.getValue(index), name, prefix, nameSpace));
                } while (++index != count);
            }
        }
    }

    static final class AttributeList {
        final List attributes;

        protected AttributeList(int size) {
            this.attributes = new ArrayList(size);
        }

        public final int getIndex(String uri, String localName) {
            int index = this.getLength();
            while (index != 0) {
                if (!this.getLocalName(--index).equals(localName) || !uri.equals(this.getURI(index))) continue;
                return index;
            }
            return -1;
        }

        public final int getLength() {
            return this.attributes.size();
        }

        protected final Attribute attribute(int index) {
            return (Attribute)this.attributes.get(index);
        }

        public final String getLocalName(int index) {
            return this.attribute((int)index).qName.getLocalPart();
        }

        public final String getType(int index) {
            return this.attribute((int)index).type;
        }

        public final String getURI(int index) {
            return this.attribute((int)index).uri;
        }

        public final String getValue(int index) {
            return this.attribute((int)index).value;
        }

        public final String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            return index == -1 ? null : this.getValue(index);
        }
    }

    static final class Attribute
    extends NameSpace {
        final String type;
        final String value;
        final QName qName;
        boolean specified;

        protected Attribute(String t, String v, QName name, String prefix, String nameSpace) {
            super(prefix, nameSpace);
            this.type = t;
            this.value = v;
            this.qName = name;
        }
    }

    static class NameSpace {
        final String prefix;
        final String uri;

        protected NameSpace(String p, String nameSpace) {
            this.prefix = p;
            this.uri = nameSpace;
        }
    }

    static class EndElement
    extends Event {
        List nameSpaces;
        public final QName name;
        public final String nameSpace;
        final String prefix;

        protected EndElement(XMLStreamReader reader) {
            this.name = reader.getName();
            this.nameSpace = reader.getNamespaceURI();
            this.prefix = reader.getPrefix();
            int count = reader.getNamespaceCount();
            if (count == 0) {
                return;
            }
            this.nameSpaces = new ArrayList(count);
            int index = 0;
            do {
                Tag.bind(reader.getNamespacePrefix(index), reader.getNamespaceURI(index), this.nameSpaces);
            } while (++index != count);
        }

        protected EndElement(String uri, String local, String p, Locator locator) {
            if (p == null) {
                this.name = new QName(uri, local, "");
                this.nameSpace = null;
            } else {
                this.name = new QName(uri, local, p);
                this.nameSpace = uri;
            }
            this.prefix = p;
            this.location(locator);
        }
    }

    protected static final class NameSpaceEvent
    extends Reference {
        int nameSpaces;

        protected NameSpaceEvent(XMLStreamReader reader) {
            super(reader.getNamespacePrefix(0), reader.getNamespaceURI(0));
            this.nameSpaces = reader.getNamespaceCount();
        }
    }

    protected static final class AttributeEvent
    extends Reference {
        final QName name;
        final String nameSpace;
        final String prefix;
        int attributes;
        final boolean specified;

        protected AttributeEvent(XMLStreamReader reader) {
            super(reader.getAttributeType(0), reader.getAttributeValue(0));
            this.attributes = reader.getAttributeCount();
            this.name = reader.getAttributeName(0);
            this.nameSpace = reader.getAttributeNamespace(0);
            this.prefix = reader.getAttributePrefix(0);
            this.specified = reader.isAttributeSpecified(0);
        }
    }

    protected static class Reference
    extends ValueEvent {
        final String target;

        protected Reference(String name, String data) {
            super(data);
            this.target = name;
        }
    }

    static class ValueEvent
    extends Event {
        final String value;

        protected ValueEvent(String v) {
            this.value = v;
        }
    }

    private static class Event {
        int type;
        public NamespaceContext nameSpaceContext;
        Location location;

        private Event() {
        }

        protected final void initialize(XMLStreamReader reader) {
            this.nameSpaceContext = reader.getNamespaceContext();
            this.location = reader.getLocation();
        }

        protected final void location(final Locator locator) {
            this.location = new Location(){

                public int getCharacterOffset() {
                    return -1;
                }

                public int getColumnNumber() {
                    return locator.getColumnNumber();
                }

                public int getLineNumber() {
                    return locator.getLineNumber();
                }

                public String getPublicId() {
                    return locator.getPublicId();
                }

                public String getSystemId() {
                    return locator.getSystemId();
                }
            };
        }
    }
}

