/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util.resource;

import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamSerializer
implements XMLStreamConstants {
    private static int namespaceSuffix = 0;
    public static final String NAMESPACE_PREFIX = "ns";
    private int depth = 0;
    private String lineBreak;
    private String indent;
    private String margin = null;
    private int nest;
    private int oldNest;
    private Map options;
    private static final String STRING_OPTION = "String option";

    public void serialize(XMLStreamReader node, XMLStreamWriter writer) throws XMLStreamException {
        this.serializeNode(node, writer);
    }

    public void serialize(XMLStreamReader node, XMLStreamWriter writer, Map options) throws XMLStreamException {
        this.options = options;
        this.serializeNode(node, writer);
    }

    protected void serializeNode(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        while (reader.hasNext()) {
            int event = reader.next();
            if (event == 1) {
                if (this.options == null) {
                    this.serializeElement(reader, writer);
                } else {
                    this.serializeElementWithOptions(reader, writer);
                }
                ++this.depth;
            } else if (event == 10) {
                this.serializeAttributes(reader, writer);
            } else if (event == 4) {
                this.serializeText(reader, writer);
            } else if (event == 5) {
                this.serializeComment(reader, writer);
            } else if (event == 12) {
                this.serializeCData(reader, writer);
            } else if (event == 2) {
                if (this.options == null) {
                    this.serializeEndElement(writer);
                } else {
                    this.serializeEndElementWithOptions(writer);
                }
                --this.depth;
            } else if (event == 7) {
                ++this.depth;
            } else if (event == 8) {
                if (this.depth != 0) {
                    --this.depth;
                }
                try {
                    if (this.options == null) {
                        this.serializeEndElement(writer);
                    } else {
                        this.serializeEndElementWithOptions(writer);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.depth != 0) continue;
            break;
        }
    }

    protected void serializeElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        String prefix = reader.getPrefix();
        String nameSpaceName = reader.getNamespaceURI();
        if (nameSpaceName != null) {
            String writer_prefix = writer.getPrefix(nameSpaceName);
            if (writer_prefix != null) {
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
            } else if (prefix != null) {
                writer.writeStartElement(prefix, reader.getLocalName(), nameSpaceName);
                writer.writeNamespace(prefix, nameSpaceName);
                writer.setPrefix(prefix, nameSpaceName);
            } else {
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
                writer.writeDefaultNamespace(nameSpaceName);
                writer.setDefaultNamespace(nameSpaceName);
            }
        } else {
            writer.writeStartElement(reader.getLocalName());
        }
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            if (namespacePrefix != null && namespacePrefix.length() == 0) continue;
            this.serializeNamespace(namespacePrefix, reader.getNamespaceURI(i), writer);
        }
        this.serializeAttributes(reader, writer);
    }

    protected void serializeElementWithOptions(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        ++this.nest;
        boolean brk = false;
        if (this.oldNest != this.nest) {
            if (this.oldNest < this.nest) {
                brk = true;
            }
            this.oldNest = this.nest;
        }
        this.startElement(writer);
        String prefix = reader.getPrefix();
        String nameSpaceName = reader.getNamespaceURI();
        if (nameSpaceName != null) {
            String writer_prefix = writer.getPrefix(nameSpaceName);
            if (writer_prefix != null) {
                if (brk && this.nest != 1) {
                    this.breakLine(writer, true, true);
                } else {
                    this.breakLine(writer, false, true);
                }
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
            } else if (prefix != null) {
                if (brk && this.nest == 1) {
                    this.breakLine(writer, false, true);
                }
                writer.writeStartElement(prefix, reader.getLocalName(), nameSpaceName);
                writer.writeNamespace(prefix, nameSpaceName);
                writer.setPrefix(prefix, nameSpaceName);
            } else {
                if (brk && this.nest == 1) {
                    this.breakLine(writer, false, true);
                }
                writer.writeStartElement(nameSpaceName, reader.getLocalName());
                writer.writeDefaultNamespace(nameSpaceName);
                writer.setDefaultNamespace(nameSpaceName);
                if (brk && this.nest == 1) {
                    this.breakLine(writer, false, true);
                }
            }
        } else {
            writer.writeStartElement(reader.getLocalName());
        }
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            if (namespacePrefix != null && namespacePrefix.length() == 0) continue;
            this.serializeNamespace(namespacePrefix, reader.getNamespaceURI(i), writer);
        }
        this.serializeAttributes(reader, writer);
    }

    protected void serializeEndElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
    }

    protected void serializeEndElementWithOptions(XMLStreamWriter writer) throws XMLStreamException {
        --this.nest;
        if (this.oldNest > this.nest + 1) {
            ++this.nest;
            this.breakLine(writer, false, true);
            writer.writeEndElement();
            this.breakLine(writer, true, false);
            --this.nest;
        } else {
            writer.writeEndElement();
            this.breakLine(writer, true, false);
        }
    }

    protected void serializeText(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(reader.getText());
    }

    protected void serializeCData(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCData(reader.getText());
    }

    protected void serializeComment(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeComment(reader.getText());
    }

    protected void serializeAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String prefix = null;
        String namespaceName = null;
        String writerPrefix = null;
        for (int i = 0; i < count; ++i) {
            prefix = reader.getAttributePrefix(i);
            namespaceName = reader.getAttributeNamespace(i);
            if (namespaceName != null) {
                writerPrefix = writer.getNamespaceContext().getPrefix(namespaceName);
            }
            if (!"".equals(namespaceName)) {
                if (writerPrefix != null && (prefix == null || prefix.equals(""))) {
                    writer.writeAttribute(writerPrefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                if (prefix != null && !"".equals(prefix) && !prefix.equals(writerPrefix)) {
                    writer.writeNamespace(prefix, namespaceName);
                    writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                if (prefix == null || prefix.equals("")) {
                    prefix = this.generateUniquePrefix(writer.getNamespaceContext());
                    writer.writeNamespace(prefix, namespaceName);
                    writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    continue;
                }
                writer.writeAttribute(prefix, namespaceName, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    private String generateUniquePrefix(NamespaceContext nsCtxt) {
        String prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        while (nsCtxt.getNamespaceURI(prefix) != null) {
            prefix = NAMESPACE_PREFIX + namespaceSuffix++;
        }
        return prefix;
    }

    private void serializeNamespace(String prefix, String URI2, XMLStreamWriter writer) throws XMLStreamException {
        String prefix1 = writer.getPrefix(URI2);
        if (prefix1 == null) {
            writer.writeNamespace(prefix, URI2);
            writer.setPrefix(prefix, URI2);
        }
    }

    private void breakLine(XMLStreamWriter writer, boolean breakLine, boolean others) throws XMLStreamException {
        if (this.options == null || this.lineBreak == null && this.indent == null && this.margin == null) {
            return;
        }
        if (breakLine) {
            writer.writeCharacters(this.lineBreak);
        }
        if (this.margin != null && others) {
            writer.writeCharacters(this.margin);
        }
        if (this.indent != null && others) {
            for (int count = this.nest; count != 1; --count) {
                writer.writeCharacters(this.indent);
            }
        }
    }

    void startElement(XMLStreamWriter writer) throws XMLStreamException {
        if (this.options == null) {
            return;
        }
        this.lineBreak = (String)this.options.get("LineBreak");
        if (this.lineBreak == null) {
            return;
        }
        this.margin = (String)this.options.get("margin");
        this.indent = (String)this.options.get("indent");
    }
}

