/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.injection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.injection.IFieldValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundFieldValueFactory
implements IFieldValueFactory {
    private final List<IFieldValueFactory> delegates = new ArrayList<IFieldValueFactory>();

    public CompoundFieldValueFactory(IFieldValueFactory[] factories) {
        if (factories == null) {
            throw new IllegalArgumentException("argument [factories] cannot be null");
        }
        this.delegates.addAll(Arrays.asList(factories));
    }

    public CompoundFieldValueFactory(List<IFieldValueFactory> factories) {
        if (factories == null) {
            throw new IllegalArgumentException("argument [factories] cannot be null");
        }
        this.delegates.addAll(factories);
    }

    public CompoundFieldValueFactory(IFieldValueFactory f1, IFieldValueFactory f2) {
        if (f1 == null) {
            throw new IllegalArgumentException("argument [f1] cannot be null");
        }
        if (f2 == null) {
            throw new IllegalArgumentException("argument [f2] cannot be null");
        }
        this.delegates.add(f1);
        this.delegates.add(f2);
    }

    public void addFactory(IFieldValueFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("argument [factory] cannot be null");
        }
        this.delegates.add(factory);
    }

    @Override
    public Object getFieldValue(Field field, Object fieldOwner) {
        for (IFieldValueFactory factory : this.delegates) {
            Object object = factory.getFieldValue(field, fieldOwner);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public boolean supportsField(Field field) {
        for (IFieldValueFactory factory : this.delegates) {
            if (!factory.supportsField(field)) continue;
            return true;
        }
        return false;
    }
}

