/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.time;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.time.ITimeFrameSource;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.time.TimeFrame;

public final class TimeMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<ITimeFrameSource, Object> sources = new ConcurrentHashMap<ITimeFrameSource, Object>();

    public Object get() {
        return this.get(Time.now());
    }

    public Object get(Time time) {
        for (ITimeFrameSource source : this.sources.keySet()) {
            TimeFrame current = source.getTimeFrame();
            if (!current.contains(time)) continue;
            return this.sources.get(current);
        }
        return null;
    }

    public void put(ITimeFrameSource source, Object o) {
        TimeFrame timeframe = source.getTimeFrame();
        for (ITimeFrameSource tfs : this.sources.keySet()) {
            TimeFrame current = tfs.getTimeFrame();
            if (!timeframe.overlaps(current)) continue;
            throw new IllegalArgumentException("Timeframe " + timeframe + " overlaps timeframe " + current);
        }
        this.sources.put(source, o);
    }
}

