/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.v2c;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.impl.DateEditor;
import org.apache.xbean.spring.context.impl.FileEditor;
import org.apache.xbean.spring.context.impl.MappingMetaData;
import org.apache.xbean.spring.context.impl.NamedConstructorArgs;
import org.apache.xbean.spring.context.impl.NamespaceHelper;
import org.apache.xbean.spring.context.impl.ObjectNameEditor;
import org.apache.xbean.spring.context.impl.URIEditor;
import org.apache.xbean.spring.context.v2c.PropertyEditorFactory;
import org.apache.xbean.spring.context.v2c.XBeanQNameHelper;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XBeanNamespaceHandler
implements NamespaceHandler {
    public static final String SPRING_SCHEMA = "http://xbean.apache.org/schemas/spring/1.0";
    public static final String SPRING_SCHEMA_COMPAT = "http://xbean.org/schemas/spring/1.0";
    private static final Log log = LogFactory.getLog(XBeanNamespaceHandler.class);
    private static final String QNAME_ELEMENT = "qname";
    private static final String DESCRIPTION_ELEMENT = "description";
    protected static final String[] RESERVED_ELEMENT_NAMES = new String[]{"beans", "description", "import", "alias", "bean", "constructor-arg", "property", "lookup-method", "replaced-method", "arg-type", "ref", "idref", "value", "null", "list", "set", "map", "entry", "key", "props", "prop", "qname"};
    protected static final String[] RESERVED_BEAN_ATTRIBUTE_NAMES = new String[]{"id", "name", "class", "parent", "depends-on", "factory-method", "factory-bean", "dependency-check", "autowire", "init-method", "destroy-method", "abstract", "singleton", "lazy-init"};
    private static final String JAVA_PACKAGE_PREFIX = "java://";
    private static final String BEAN_REFERENCE_PREFIX = "#";
    private static final String NULL_REFERENCE = "#null";
    private Set reservedElementNames = new HashSet<String>(Arrays.asList(RESERVED_ELEMENT_NAMES));
    private Set reservedBeanAttributeNames = new HashSet<String>(Arrays.asList(RESERVED_BEAN_ATTRIBUTE_NAMES));
    protected final NamedConstructorArgs namedConstructorArgs = new NamedConstructorArgs();
    private ParserContext parserContext;
    private XBeanQNameHelper qnameHelper;

    public void init() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parserContext = parserContext;
        this.qnameHelper = new XBeanQNameHelper(parserContext.getReaderContext());
        BeanDefinitionHolder holder = this.parseBeanFromExtensionElement(element);
        if (element.getParentNode() == element.getOwnerDocument() || element.getParentNode().getParentNode() == element.getOwnerDocument()) {
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition(holder);
            parserContext.getReaderContext().fireComponentRegistered((ComponentDefinition)componentDefinition);
        }
        return holder.getBeanDefinition();
    }

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        if (node instanceof Attr && "xmlns".equals(node.getLocalName())) {
            return definition;
        }
        throw new IllegalArgumentException("Cannot locate BeanDefinitionDecorator for " + (node instanceof Element ? "element" : "attribute") + " [" + node.getLocalName() + "].");
    }

    public static void configure(AbstractApplicationContext context, XmlBeanDefinitionReader reader) {
        reader.setNamespaceAware(true);
        reader.setValidationMode(3);
    }

    public static void registerCustomEditors(DefaultListableBeanFactory beanFactory) {
        PropertyEditorRegistrar registrar = new PropertyEditorRegistrar(){

            public void registerCustomEditors(PropertyEditorRegistry registry) {
                registry.registerCustomEditor(File.class, (PropertyEditor)new FileEditor());
                registry.registerCustomEditor(URI.class, (PropertyEditor)new URIEditor());
                registry.registerCustomEditor(Date.class, (PropertyEditor)new DateEditor());
                registry.registerCustomEditor(ObjectName.class, (PropertyEditor)new ObjectNameEditor());
            }
        };
        beanFactory.addPropertyEditorRegistrar(registrar);
    }

    protected BeanDefinitionHolder parseBeanFromExtensionElement(Element element, String parentClass, String property) {
        String className;
        String localName;
        String uri = element.getNamespaceURI();
        MappingMetaData metadata = this.findNamespaceProperties(uri, localName = this.getLocalName(element));
        if (metadata != null && (className = this.getPropertyDescriptor(parentClass, property).getPropertyType().getName()) != null) {
            return this.parseBeanFromExtensionElement(element, metadata, className);
        }
        return null;
    }

    private BeanDefinitionHolder parseBeanFromExtensionElement(Element element, MappingMetaData metadata, String className) {
        Element original = this.cloneElement(element);
        element.setAttributeNS(null, "class", className);
        this.addSpringAttributeValues(className, element);
        BeanDefinitionHolder definition = this.parserContext.getDelegate().parseBeanDefinitionElement(element, null);
        this.addAttributeProperties(definition, metadata, className, original);
        this.addContentProperty(definition, metadata, element);
        this.addNestedPropertyElements(definition, metadata, className, element);
        this.qnameHelper.coerceNamespaceAwarePropertyValues(definition.getBeanDefinition(), element);
        this.declareLifecycleMethods(definition, metadata, element);
        this.resolveBeanClass((AbstractBeanDefinition)definition.getBeanDefinition(), definition.getBeanName());
        this.namedConstructorArgs.processParameters(definition, metadata);
        return definition;
    }

    protected Class resolveBeanClass(AbstractBeanDefinition bd, String beanName) {
        if (bd.hasBeanClass()) {
            return bd.getBeanClass();
        }
        try {
            ClassLoader cl;
            ResourceLoader rl = this.parserContext.getReaderContext().getResourceLoader();
            ClassLoader classLoader = cl = rl != null ? rl.getClassLoader() : null;
            if (cl == null) {
                cl = this.parserContext.getReaderContext().getReader().getBeanClassLoader();
            }
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            return bd.resolveBeanClass(cl);
        }
        catch (ClassNotFoundException ex) {
            throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Bean class [" + bd.getBeanClassName() + "] not found", (Throwable)ex);
        }
        catch (NoClassDefFoundError err) {
            throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Class that bean class [" + bd.getBeanClassName() + "] depends on not found", (Throwable)err);
        }
    }

    protected BeanDefinitionHolder parseBeanFromExtensionElement(Element element) {
        String localName;
        String uri = element.getNamespaceURI();
        MappingMetaData metadata = this.findNamespaceProperties(uri, localName = this.getLocalName(element));
        if (metadata != null) {
            String className = metadata.getClassName(localName);
            if (className != null) {
                return this.parseBeanFromExtensionElement(element, metadata, className);
            }
            throw new BeanDefinitionStoreException("Unrecognized xbean element mapping: " + localName + " in namespace " + uri);
        }
        if (uri == null) {
            throw new BeanDefinitionStoreException("Unrecognized Spring element: " + localName);
        }
        throw new BeanDefinitionStoreException("Unrecognized xbean namespace mapping: " + uri);
    }

    protected void addSpringAttributeValues(String className, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String uri = attribute.getNamespaceURI();
            String localName = attribute.getLocalName();
            if (uri == null || !uri.equals(SPRING_SCHEMA) && !uri.equals(SPRING_SCHEMA_COMPAT)) continue;
            element.setAttributeNS(null, localName, attribute.getNodeValue());
        }
    }

    protected Element cloneElement(Element element) {
        Element answer = element.getOwnerDocument().createElementNS(element.getNamespaceURI(), element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String uri = attribute.getNamespaceURI();
            answer.setAttributeNS(uri, attribute.getName(), attribute.getNodeValue());
        }
        return answer;
    }

    protected void addAttributeProperties(BeanDefinitionHolder definition, MappingMetaData metadata, String className, Element element) {
        PropertyDescriptor descriptor;
        boolean addProperty;
        String localName;
        String uri;
        Attr attribute;
        int i;
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (i = 0; i < size; ++i) {
            attribute = (Attr)attributes.item(i);
            uri = attribute.getNamespaceURI();
            localName = attribute.getLocalName();
            if (localName == null || localName.equals("xmlns") || localName.startsWith("xmlns:") || !this.isEmpty(uri) || localName.equals("class")) continue;
            addProperty = true;
            if (this.reservedBeanAttributeNames.contains(localName)) {
                descriptor = this.getPropertyDescriptor(className, localName);
                boolean bl = addProperty = descriptor != null;
            }
            if (!addProperty) continue;
            this.addAttributeProperty(definition, metadata, element, attribute);
        }
        size = attributes.getLength();
        for (i = 0; i < size; ++i) {
            attribute = (Attr)attributes.item(i);
            uri = attribute.getNamespaceURI();
            localName = attribute.getLocalName();
            if (localName == null || localName.equals("xmlns") || localName.startsWith("xmlns:") || this.isEmpty(uri) || !uri.equals(element.getNamespaceURI())) continue;
            addProperty = true;
            if (this.reservedBeanAttributeNames.contains(localName)) {
                descriptor = this.getPropertyDescriptor(className, localName);
                boolean bl = addProperty = descriptor != null;
            }
            if (!addProperty) continue;
            this.addAttributeProperty(definition, metadata, element, attribute);
        }
    }

    protected void addContentProperty(BeanDefinitionHolder definition, MappingMetaData metadata, Element element) {
        String name = metadata.getContentProperty(this.getLocalName(element));
        if (name != null) {
            String value = this.getElementText(element);
            this.addProperty(definition, metadata, element, name, value);
        } else {
            StringBuffer buffer = new StringBuffer();
            NodeList childNodes = element.getChildNodes();
            int size = childNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Text)) continue;
                buffer.append(((Text)node).getData());
            }
            ByteArrayInputStream in = new ByteArrayInputStream(buffer.toString().getBytes());
            Properties properties = new Properties();
            try {
                properties.load(in);
            }
            catch (IOException e) {
                return;
            }
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propertyName = (String)enumeration.nextElement();
                String propertyEditor = metadata.getPropertyEditor(this.getLocalName(element), propertyName);
                Object value = this.getValue(properties.getProperty(propertyName), propertyEditor);
                definition.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, value);
            }
        }
    }

    protected void addAttributeProperty(BeanDefinitionHolder definition, MappingMetaData metadata, Element element, Attr attribute) {
        String localName = attribute.getLocalName();
        String value = attribute.getValue();
        this.addProperty(definition, metadata, element, localName, value);
    }

    protected void addProperty(BeanDefinitionHolder definition, MappingMetaData metadata, Element element, String localName, String value) {
        String propertyName = metadata.getPropertyName(this.getLocalName(element), localName);
        String propertyEditor = metadata.getPropertyEditor(this.getLocalName(element), propertyName);
        if (propertyName != null) {
            definition.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, this.getValue(value, propertyEditor));
        }
    }

    protected Object getValue(String value, String propertyEditor) {
        if (value == null) {
            return null;
        }
        if (NULL_REFERENCE.equals(value)) {
            return null;
        }
        if (value.startsWith(BEAN_REFERENCE_PREFIX) && !(value = value.substring(BEAN_REFERENCE_PREFIX.length())).startsWith(BEAN_REFERENCE_PREFIX)) {
            return new RuntimeBeanReference(value);
        }
        if (propertyEditor != null) {
            PropertyEditor p = this.createPropertyEditor(propertyEditor);
            RootBeanDefinition def = new RootBeanDefinition();
            def.setBeanClass(PropertyEditorFactory.class);
            def.getPropertyValues().addPropertyValue("propertyEditor", (Object)p);
            def.getPropertyValues().addPropertyValue("value", (Object)value);
            return def;
        }
        return value;
    }

    protected PropertyEditor createPropertyEditor(String propertyEditor) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = XBeanNamespaceHandler.class.getClassLoader();
        }
        try {
            return (PropertyEditor)cl.loadClass(propertyEditor).newInstance();
        }
        catch (Throwable e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Could not load property editor: " + propertyEditor).initCause(e);
        }
    }

    protected String getLocalName(Element element) {
        String localName = element.getLocalName();
        if (localName == null) {
            localName = element.getNodeName();
        }
        return localName;
    }

    protected void addNestedPropertyElements(BeanDefinitionHolder definition, MappingMetaData metadata, String className, Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String uri = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if (this.isDefaultNamespace(uri) && this.reservedElementNames.contains(localName)) continue;
            Object value = null;
            String propertyName = metadata.getNestedListProperty(this.getLocalName(element), localName);
            if (propertyName != null) {
                value = this.parseListElement(childElement, propertyName);
            } else {
                propertyName = metadata.getFlatCollectionProperty(this.getLocalName(element), localName);
                if (propertyName != null) {
                    Collection l;
                    BeanDefinition def = this.parserContext.getDelegate().parseCustomElement(childElement);
                    PropertyValue pv = definition.getBeanDefinition().getPropertyValues().getPropertyValue(propertyName);
                    if (pv != null) {
                        l = (Collection)pv.getValue();
                        l.add(def);
                        continue;
                    }
                    l = new ManagedList();
                    l.add(def);
                    value = l;
                } else {
                    propertyName = metadata.getNestedProperty(this.getLocalName(element), localName);
                    if (propertyName != null) {
                        value = this.parseChildExtensionBean(childElement);
                    }
                }
            }
            if (propertyName == null && metadata.isFlatProperty(this.getLocalName(element), localName)) {
                value = this.parseBeanFromExtensionElement(childElement, className, localName);
                propertyName = localName;
            }
            if (propertyName == null) {
                value = this.tryParseNestedPropertyViaIntrospection(metadata, className, childElement);
                propertyName = localName;
            }
            if (value != null) {
                definition.getBeanDefinition().getPropertyValues().addPropertyValue(propertyName, value);
                continue;
            }
            String text = this.getElementText(childElement);
            if (text == null) continue;
            this.addProperty(definition, metadata, element, localName, text);
        }
    }

    protected Object tryParseNestedPropertyViaIntrospection(MappingMetaData metadata, String className, Element element) {
        String localName = this.getLocalName(element);
        PropertyDescriptor descriptor = this.getPropertyDescriptor(className, localName);
        if (descriptor != null) {
            return this.parseNestedPropertyViaIntrospection(metadata, element, descriptor.getName(), descriptor.getPropertyType());
        }
        return this.parseNestedPropertyViaIntrospection(metadata, element, localName, Object.class);
    }

    protected PropertyDescriptor getPropertyDescriptor(String className, String localName) {
        BeanInfo beanInfo = this.qnameHelper.getBeanInfo(className);
        if (beanInfo != null) {
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                if (!name.equals(localName)) continue;
                return descriptor;
            }
        }
        return null;
    }

    private Object parseNestedPropertyViaIntrospection(MappingMetaData metadata, Element element, String propertyName, Class propertyType) {
        if (this.isMap(propertyType)) {
            return this.parseCustomMapElement(metadata, element, propertyName);
        }
        if (this.isCollection(propertyType)) {
            return this.parseListElement(element, propertyName);
        }
        return this.parseChildExtensionBean(element);
    }

    protected Object parseListElement(Element element, String name) {
        return this.parserContext.getDelegate().parseListElement(element, null);
    }

    protected Object parseCustomMapElement(MappingMetaData metadata, Element element, String name) {
        ManagedMap map = new ManagedMap();
        Element parent = (Element)element.getParentNode();
        String entryName = metadata.getMapEntryName(this.getLocalName(parent), name);
        String keyName = metadata.getMapKeyName(this.getLocalName(parent), name);
        String dups = metadata.getMapDupsMode(this.getLocalName(parent), name);
        boolean flat = metadata.isFlatMap(this.getLocalName(parent), name);
        String defaultKey = metadata.getMapDefaultKey(this.getLocalName(parent), name);
        if (entryName == null) {
            entryName = "property";
        }
        if (keyName == null) {
            keyName = "key";
        }
        if (dups == null) {
            dups = "replace";
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Object keyValue;
            String key;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String localName = childElement.getLocalName();
            String uri = childElement.getNamespaceURI();
            if (localName == null || localName.equals("xmlns") || localName.startsWith("xmlns:")) continue;
            if (!flat && !this.isEmpty(uri) && localName.equals(entryName)) {
                Object value;
                key = childElement.getAttribute(keyName);
                if (key == null || key.length() == 0) {
                    key = defaultKey;
                }
                if (key == null) {
                    throw new RuntimeException("No key defined for map " + entryName);
                }
                keyValue = this.getValue(key, null);
                Element valueElement = this.getFirstChildElement(childElement);
                if (valueElement != null) {
                    String valueElUri = valueElement.getNamespaceURI();
                    String valueElLocalName = valueElement.getLocalName();
                    value = valueElUri == null || valueElUri.equals(SPRING_SCHEMA) || valueElUri.equals(SPRING_SCHEMA_COMPAT) || valueElUri.equals("http://www.springframework.org/schema/beans") ? ("bean".equals(valueElLocalName) ? this.parserContext.getDelegate().parseBeanDefinitionElement(valueElement, null) : this.parserContext.getDelegate().parsePropertySubElement(valueElement, null)) : this.parserContext.getDelegate().parseCustomElement(valueElement);
                } else {
                    value = this.getElementText(childElement);
                }
                this.addValueToMap((Map)map, keyValue, value, dups);
                continue;
            }
            if (!flat || this.isEmpty(uri)) continue;
            key = childElement.getAttribute(keyName);
            if (key == null || key.length() == 0) {
                key = defaultKey;
            }
            if (key == null) {
                throw new RuntimeException("No key defined for map entry " + entryName);
            }
            keyValue = this.getValue(key, null);
            childElement.removeAttribute(keyName);
            BeanDefinitionHolder bdh = this.parseBeanFromExtensionElement(childElement);
            this.addValueToMap((Map)map, keyValue, bdh, dups);
        }
        return map;
    }

    protected void addValueToMap(Map map, Object keyValue, Object value, String dups) {
        if (map.containsKey(keyValue)) {
            if (!"discard".equalsIgnoreCase(dups)) {
                if ("replace".equalsIgnoreCase(dups)) {
                    map.put(keyValue, value);
                } else if ("allow".equalsIgnoreCase(dups)) {
                    ManagedList l = new ManagedList();
                    l.add(map.get(keyValue));
                    l.add(value);
                    map.put(keyValue, l);
                } else if ("always".equalsIgnoreCase(dups)) {
                    List l = (List)map.get(keyValue);
                    l.add(value);
                }
            }
        } else if ("always".equalsIgnoreCase(dups)) {
            List l = (List)map.get(keyValue);
            if (l == null) {
                l = new ManagedList();
                map.put(keyValue, l);
            }
            l.add(value);
        } else {
            map.put(keyValue, value);
        }
    }

    protected Element getFirstChildElement(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    protected boolean isMap(Class type) {
        return Map.class.isAssignableFrom(type);
    }

    protected boolean isCollection(Class type) {
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    protected Object parseChildExtensionBean(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String uri = childElement.getNamespaceURI();
            String localName = childElement.getLocalName();
            if (uri == null || uri.equals(SPRING_SCHEMA) || uri.equals(SPRING_SCHEMA_COMPAT) || uri.equals("http://www.springframework.org/schema/beans")) {
                if ("bean".equals(localName)) {
                    return this.parserContext.getDelegate().parseBeanDefinitionElement(childElement, null);
                }
                return this.parserContext.getDelegate().parsePropertySubElement(childElement, null);
            }
            BeanDefinition value = this.parserContext.getDelegate().parseCustomElement(childElement);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected MappingMetaData findNamespaceProperties(String namespaceURI, String localName) {
        if (namespaceURI != null && namespaceURI.startsWith(JAVA_PACKAGE_PREFIX)) {
            String packageName = namespaceURI.substring(JAVA_PACKAGE_PREFIX.length());
            return new MappingMetaData(packageName);
        }
        String uri = NamespaceHelper.createDiscoveryPathName(namespaceURI, localName);
        InputStream in = this.loadResource(uri);
        if (in == null && namespaceURI != null && namespaceURI.length() > 0 && (in = this.loadResource(uri = NamespaceHelper.createDiscoveryPathName(namespaceURI))) == null) {
            uri = NamespaceHelper.createDiscoveryOldPathName(namespaceURI);
            in = this.loadResource(uri);
        }
        if (in != null) {
            try {
                Properties properties = new Properties();
                properties.load(in);
                return new MappingMetaData(properties);
            }
            catch (IOException e) {
                log.warn((Object)("Failed to load resource from uri: " + uri), (Throwable)e);
            }
        }
        return null;
    }

    protected InputStream loadResource(String uri) {
        InputStream in;
        if (System.getProperty("xbean.dir") != null) {
            File f = new File(System.getProperty("xbean.dir") + uri);
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if ((in = Thread.currentThread().getContextClassLoader().getResourceAsStream(uri)) == null) {
            ClassLoader cl = this.parserContext.getReaderContext().getReader().getBeanClassLoader();
            if (cl != null) {
                in = cl.getResourceAsStream(uri);
            }
            if (in == null && (in = this.getClass().getClassLoader().getResourceAsStream(uri)) == null) {
                log.debug((Object)("Could not find resource: " + uri));
            }
        }
        return in;
    }

    protected boolean isEmpty(String uri) {
        return uri == null || uri.length() == 0;
    }

    protected boolean isDefaultNamespace(String namespaceUri) {
        return !StringUtils.hasLength((String)namespaceUri) || "http://www.springframework.org/schema/beans".equals(namespaceUri) || SPRING_SCHEMA.equals(namespaceUri) || SPRING_SCHEMA_COMPAT.equals(namespaceUri);
    }

    protected void declareLifecycleMethods(BeanDefinitionHolder definitionHolder, MappingMetaData metaData, Element element) {
        BeanDefinition definition = definitionHolder.getBeanDefinition();
        if (definition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)definition;
            if (beanDefinition.getInitMethodName() == null) {
                beanDefinition.setInitMethodName(metaData.getInitMethodName(this.getLocalName(element)));
            }
            if (beanDefinition.getDestroyMethodName() == null) {
                beanDefinition.setDestroyMethodName(metaData.getDestroyMethodName(this.getLocalName(element)));
            }
            if (beanDefinition.getFactoryMethodName() == null) {
                beanDefinition.setFactoryMethodName(metaData.getFactoryMethodName(this.getLocalName(element)));
            }
        }
    }

    protected String getElementText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }
}

