/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.util.CompareUtil;

public class CondLengthProperty
extends Property
implements CompoundDatatype {
    private static final PropertyCache<CondLengthProperty> CACHE = new PropertyCache();
    private Property length;
    private EnumProperty conditionality;
    private boolean isCached;
    private int hash = -1;

    public void setComponent(int cmpId, Property cmpnValue, boolean bIsDefault) {
        if (this.isCached) {
            throw new IllegalStateException("CondLengthProperty.setComponent() called on a cached value!");
        }
        if (cmpId == 2048) {
            this.length = cmpnValue;
        } else if (cmpId == 1024) {
            this.conditionality = (EnumProperty)cmpnValue;
        }
    }

    public Property getComponent(int cmpId) {
        if (cmpId == 2048) {
            return this.length;
        }
        if (cmpId == 1024) {
            return this.conditionality;
        }
        return null;
    }

    public Property getConditionality() {
        return this.conditionality;
    }

    public Property getLengthComponent() {
        return this.length;
    }

    public boolean isDiscard() {
        return this.conditionality.getEnum() == 32;
    }

    public int getLengthValue() {
        return this.length.getLength().getValue();
    }

    public int getLengthValue(PercentBaseContext context) {
        return this.length.getLength().getValue(context);
    }

    public String toString() {
        return "CondLength[" + this.length.getObject().toString() + ", " + (this.isDiscard() ? this.conditionality.toString().toLowerCase() : this.conditionality.toString()) + "]";
    }

    public CondLengthProperty getCondLength() {
        if (this.length.getLength().isAbsolute()) {
            CondLengthProperty clp = CACHE.fetch(this);
            if (clp == this) {
                this.isCached = true;
            }
            return clp;
        }
        return this;
    }

    public Length getLength() {
        return this.length.getLength();
    }

    public Object getObject() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CondLengthProperty) {
            CondLengthProperty clp = (CondLengthProperty)obj;
            return CompareUtil.equal(this.length, clp.length) && CompareUtil.equal(this.conditionality, clp.conditionality);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == -1) {
            int hash = 17;
            hash = 37 * hash + (this.length == null ? 0 : this.length.hashCode());
            this.hash = hash = 37 * hash + (this.conditionality == null ? 0 : this.conditionality.hashCode());
        }
        return this.hash;
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        public Property makeNewProperty() {
            return new CondLengthProperty();
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
            if (p instanceof KeepProperty) {
                return p;
            }
            return super.convertProperty(p, propertyList, fo);
        }
    }
}

