/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class TimesBold
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Times-Bold";
    private static final String fullName = "Times Bold";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 676;
    private static final int xHeight = 461;
    private static final int ascender = 676;
    private static final int descender = -205;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public TimesBold() {
        this(false);
    }

    public TimesBold(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncodingName() {
        return encoding;
    }

    public URI getFontURI() {
        return fontFileURI;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size) {
        return size * 676;
    }

    public int getCapHeight(int size) {
        return size * 676;
    }

    public int getDescender(int size) {
        return size * -205;
    }

    public int getXHeight(int size) {
        return size * 461;
    }

    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i, int size) {
        return size * width[i];
    }

    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + fontName.toLowerCase());
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        TimesBold.width[65] = 722;
        TimesBold.boundingBoxes[65] = new Rectangle(9, 0, 680, 690);
        TimesBold.width[198] = 1000;
        TimesBold.boundingBoxes[198] = new Rectangle(4, 0, 947, 676);
        TimesBold.width[193] = 722;
        TimesBold.boundingBoxes[193] = new Rectangle(9, 0, 680, 923);
        TimesBold.width[194] = 722;
        TimesBold.boundingBoxes[194] = new Rectangle(9, 0, 680, 914);
        TimesBold.width[196] = 722;
        TimesBold.boundingBoxes[196] = new Rectangle(9, 0, 680, 877);
        TimesBold.width[192] = 722;
        TimesBold.boundingBoxes[192] = new Rectangle(9, 0, 680, 923);
        TimesBold.width[197] = 722;
        TimesBold.boundingBoxes[197] = new Rectangle(9, 0, 680, 935);
        TimesBold.width[195] = 722;
        TimesBold.boundingBoxes[195] = new Rectangle(9, 0, 680, 884);
        TimesBold.width[66] = 667;
        TimesBold.boundingBoxes[66] = new Rectangle(16, 0, 603, 676);
        TimesBold.width[67] = 722;
        TimesBold.boundingBoxes[67] = new Rectangle(49, -19, 638, 710);
        TimesBold.width[199] = 722;
        TimesBold.boundingBoxes[199] = new Rectangle(49, -218, 638, 909);
        TimesBold.width[68] = 722;
        TimesBold.boundingBoxes[68] = new Rectangle(14, 0, 676, 676);
        TimesBold.width[69] = 667;
        TimesBold.boundingBoxes[69] = new Rectangle(16, 0, 625, 676);
        TimesBold.width[201] = 667;
        TimesBold.boundingBoxes[201] = new Rectangle(16, 0, 625, 923);
        TimesBold.width[202] = 667;
        TimesBold.boundingBoxes[202] = new Rectangle(16, 0, 625, 914);
        TimesBold.width[203] = 667;
        TimesBold.boundingBoxes[203] = new Rectangle(16, 0, 625, 877);
        TimesBold.width[200] = 667;
        TimesBold.boundingBoxes[200] = new Rectangle(16, 0, 625, 923);
        TimesBold.width[208] = 722;
        TimesBold.boundingBoxes[208] = new Rectangle(6, 0, 684, 676);
        TimesBold.width[128] = 500;
        TimesBold.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        TimesBold.width[70] = 611;
        TimesBold.boundingBoxes[70] = new Rectangle(16, 0, 567, 676);
        TimesBold.width[71] = 778;
        TimesBold.boundingBoxes[71] = new Rectangle(37, -19, 718, 710);
        TimesBold.width[72] = 778;
        TimesBold.boundingBoxes[72] = new Rectangle(21, 0, 738, 676);
        TimesBold.width[73] = 389;
        TimesBold.boundingBoxes[73] = new Rectangle(20, 0, 350, 676);
        TimesBold.width[205] = 389;
        TimesBold.boundingBoxes[205] = new Rectangle(20, 0, 350, 923);
        TimesBold.width[206] = 389;
        TimesBold.boundingBoxes[206] = new Rectangle(20, 0, 350, 914);
        TimesBold.width[207] = 389;
        TimesBold.boundingBoxes[207] = new Rectangle(20, 0, 350, 877);
        TimesBold.width[204] = 389;
        TimesBold.boundingBoxes[204] = new Rectangle(20, 0, 350, 923);
        TimesBold.width[74] = 500;
        TimesBold.boundingBoxes[74] = new Rectangle(3, -96, 476, 772);
        TimesBold.width[75] = 778;
        TimesBold.boundingBoxes[75] = new Rectangle(30, 0, 739, 676);
        TimesBold.width[76] = 667;
        TimesBold.boundingBoxes[76] = new Rectangle(19, 0, 619, 676);
        TimesBold.width[77] = 944;
        TimesBold.boundingBoxes[77] = new Rectangle(14, 0, 907, 676);
        TimesBold.width[78] = 722;
        TimesBold.boundingBoxes[78] = new Rectangle(16, -18, 685, 694);
        TimesBold.width[209] = 722;
        TimesBold.boundingBoxes[209] = new Rectangle(16, -18, 685, 902);
        TimesBold.width[79] = 778;
        TimesBold.boundingBoxes[79] = new Rectangle(35, -19, 708, 710);
        TimesBold.width[140] = 1000;
        TimesBold.boundingBoxes[140] = new Rectangle(22, -5, 959, 689);
        TimesBold.width[211] = 778;
        TimesBold.boundingBoxes[211] = new Rectangle(35, -19, 708, 942);
        TimesBold.width[212] = 778;
        TimesBold.boundingBoxes[212] = new Rectangle(35, -19, 708, 933);
        TimesBold.width[214] = 778;
        TimesBold.boundingBoxes[214] = new Rectangle(35, -19, 708, 896);
        TimesBold.width[210] = 778;
        TimesBold.boundingBoxes[210] = new Rectangle(35, -19, 708, 942);
        TimesBold.width[216] = 778;
        TimesBold.boundingBoxes[216] = new Rectangle(35, -74, 708, 811);
        TimesBold.width[213] = 778;
        TimesBold.boundingBoxes[213] = new Rectangle(35, -19, 708, 903);
        TimesBold.width[80] = 611;
        TimesBold.boundingBoxes[80] = new Rectangle(16, 0, 584, 676);
        TimesBold.width[81] = 778;
        TimesBold.boundingBoxes[81] = new Rectangle(35, -176, 708, 867);
        TimesBold.width[82] = 722;
        TimesBold.boundingBoxes[82] = new Rectangle(26, 0, 689, 676);
        TimesBold.width[83] = 556;
        TimesBold.boundingBoxes[83] = new Rectangle(35, -19, 478, 711);
        TimesBold.width[138] = 556;
        TimesBold.boundingBoxes[138] = new Rectangle(35, -19, 478, 933);
        TimesBold.width[84] = 667;
        TimesBold.boundingBoxes[84] = new Rectangle(31, 0, 605, 676);
        TimesBold.width[222] = 611;
        TimesBold.boundingBoxes[222] = new Rectangle(16, 0, 584, 676);
        TimesBold.width[85] = 722;
        TimesBold.boundingBoxes[85] = new Rectangle(16, -19, 685, 695);
        TimesBold.width[218] = 722;
        TimesBold.boundingBoxes[218] = new Rectangle(16, -19, 685, 942);
        TimesBold.width[219] = 722;
        TimesBold.boundingBoxes[219] = new Rectangle(16, -19, 685, 933);
        TimesBold.width[220] = 722;
        TimesBold.boundingBoxes[220] = new Rectangle(16, -19, 685, 896);
        TimesBold.width[217] = 722;
        TimesBold.boundingBoxes[217] = new Rectangle(16, -19, 685, 942);
        TimesBold.width[86] = 722;
        TimesBold.boundingBoxes[86] = new Rectangle(16, -18, 685, 694);
        TimesBold.width[87] = 1000;
        TimesBold.boundingBoxes[87] = new Rectangle(19, -15, 962, 691);
        TimesBold.width[88] = 722;
        TimesBold.boundingBoxes[88] = new Rectangle(16, 0, 683, 676);
        TimesBold.width[89] = 722;
        TimesBold.boundingBoxes[89] = new Rectangle(15, 0, 684, 676);
        TimesBold.width[221] = 722;
        TimesBold.boundingBoxes[221] = new Rectangle(15, 0, 684, 923);
        TimesBold.width[159] = 722;
        TimesBold.boundingBoxes[159] = new Rectangle(15, 0, 684, 877);
        TimesBold.width[90] = 667;
        TimesBold.boundingBoxes[90] = new Rectangle(28, 0, 606, 676);
        TimesBold.width[142] = 667;
        TimesBold.boundingBoxes[142] = new Rectangle(28, 0, 606, 914);
        TimesBold.width[97] = 500;
        TimesBold.boundingBoxes[97] = new Rectangle(25, -14, 463, 487);
        TimesBold.width[225] = 500;
        TimesBold.boundingBoxes[225] = new Rectangle(25, -14, 463, 727);
        TimesBold.width[226] = 500;
        TimesBold.boundingBoxes[226] = new Rectangle(25, -14, 463, 718);
        TimesBold.width[180] = 333;
        TimesBold.boundingBoxes[180] = new Rectangle(86, 528, 238, 185);
        TimesBold.width[228] = 500;
        TimesBold.boundingBoxes[228] = new Rectangle(25, -14, 463, 681);
        TimesBold.width[230] = 722;
        TimesBold.boundingBoxes[230] = new Rectangle(33, -14, 660, 487);
        TimesBold.width[224] = 500;
        TimesBold.boundingBoxes[224] = new Rectangle(25, -14, 463, 727);
        TimesBold.width[38] = 833;
        TimesBold.boundingBoxes[38] = new Rectangle(62, -16, 725, 707);
        TimesBold.width[229] = 500;
        TimesBold.boundingBoxes[229] = new Rectangle(25, -14, 463, 754);
        TimesBold.width[94] = 581;
        TimesBold.boundingBoxes[94] = new Rectangle(73, 311, 436, 365);
        TimesBold.width[126] = 520;
        TimesBold.boundingBoxes[126] = new Rectangle(29, 173, 462, 160);
        TimesBold.width[42] = 500;
        TimesBold.boundingBoxes[42] = new Rectangle(56, 255, 391, 436);
        TimesBold.width[64] = 930;
        TimesBold.boundingBoxes[64] = new Rectangle(108, -19, 714, 710);
        TimesBold.width[227] = 500;
        TimesBold.boundingBoxes[227] = new Rectangle(25, -14, 463, 688);
        TimesBold.width[98] = 556;
        TimesBold.boundingBoxes[98] = new Rectangle(17, -14, 504, 690);
        TimesBold.width[92] = 278;
        TimesBold.boundingBoxes[92] = new Rectangle(-25, -19, 328, 710);
        TimesBold.width[124] = 220;
        TimesBold.boundingBoxes[124] = new Rectangle(66, -218, 88, 1000);
        TimesBold.width[123] = 394;
        TimesBold.boundingBoxes[123] = new Rectangle(22, -175, 318, 873);
        TimesBold.width[125] = 394;
        TimesBold.boundingBoxes[125] = new Rectangle(54, -175, 318, 873);
        TimesBold.width[91] = 333;
        TimesBold.boundingBoxes[91] = new Rectangle(67, -149, 234, 827);
        TimesBold.width[93] = 333;
        TimesBold.boundingBoxes[93] = new Rectangle(32, -149, 234, 827);
        TimesBold.width[166] = 220;
        TimesBold.boundingBoxes[166] = new Rectangle(66, -143, 88, 850);
        TimesBold.width[149] = 350;
        TimesBold.boundingBoxes[149] = new Rectangle(35, 198, 280, 280);
        TimesBold.width[99] = 444;
        TimesBold.boundingBoxes[99] = new Rectangle(25, -14, 405, 487);
        TimesBold.width[231] = 444;
        TimesBold.boundingBoxes[231] = new Rectangle(25, -218, 405, 691);
        TimesBold.width[184] = 333;
        TimesBold.boundingBoxes[184] = new Rectangle(68, -218, 226, 218);
        TimesBold.width[162] = 500;
        TimesBold.boundingBoxes[162] = new Rectangle(53, -140, 405, 728);
        TimesBold.width[136] = 333;
        TimesBold.boundingBoxes[136] = new Rectangle(-2, 528, 337, 176);
        TimesBold.width[58] = 333;
        TimesBold.boundingBoxes[58] = new Rectangle(82, -13, 169, 485);
        TimesBold.width[44] = 250;
        TimesBold.boundingBoxes[44] = new Rectangle(39, -180, 184, 335);
        TimesBold.width[169] = 747;
        TimesBold.boundingBoxes[169] = new Rectangle(26, -19, 695, 710);
        TimesBold.width[164] = 500;
        TimesBold.boundingBoxes[164] = new Rectangle(-26, 61, 552, 552);
        TimesBold.width[100] = 556;
        TimesBold.boundingBoxes[100] = new Rectangle(25, -14, 509, 690);
        TimesBold.width[134] = 500;
        TimesBold.boundingBoxes[134] = new Rectangle(47, -134, 406, 825);
        TimesBold.width[135] = 500;
        TimesBold.boundingBoxes[135] = new Rectangle(45, -132, 411, 823);
        TimesBold.width[176] = 400;
        TimesBold.boundingBoxes[176] = new Rectangle(57, 402, 286, 286);
        TimesBold.width[168] = 333;
        TimesBold.boundingBoxes[168] = new Rectangle(-2, 537, 337, 130);
        TimesBold.width[247] = 570;
        TimesBold.boundingBoxes[247] = new Rectangle(33, -31, 504, 568);
        TimesBold.width[36] = 500;
        TimesBold.boundingBoxes[36] = new Rectangle(29, -99, 443, 849);
        TimesBold.width[101] = 444;
        TimesBold.boundingBoxes[101] = new Rectangle(25, -14, 401, 487);
        TimesBold.width[233] = 444;
        TimesBold.boundingBoxes[233] = new Rectangle(25, -14, 401, 727);
        TimesBold.width[234] = 444;
        TimesBold.boundingBoxes[234] = new Rectangle(25, -14, 401, 718);
        TimesBold.width[235] = 444;
        TimesBold.boundingBoxes[235] = new Rectangle(25, -14, 401, 681);
        TimesBold.width[232] = 444;
        TimesBold.boundingBoxes[232] = new Rectangle(25, -14, 401, 727);
        TimesBold.width[56] = 500;
        TimesBold.boundingBoxes[56] = new Rectangle(28, -13, 444, 701);
        TimesBold.width[133] = 1000;
        TimesBold.boundingBoxes[133] = new Rectangle(82, -13, 835, 169);
        TimesBold.width[151] = 1000;
        TimesBold.boundingBoxes[151] = new Rectangle(0, 181, 1000, 90);
        TimesBold.width[150] = 500;
        TimesBold.boundingBoxes[150] = new Rectangle(0, 181, 500, 90);
        TimesBold.width[61] = 570;
        TimesBold.boundingBoxes[61] = new Rectangle(33, 107, 504, 292);
        TimesBold.width[240] = 500;
        TimesBold.boundingBoxes[240] = new Rectangle(25, -14, 451, 705);
        TimesBold.width[33] = 333;
        TimesBold.boundingBoxes[33] = new Rectangle(81, -13, 170, 704);
        TimesBold.width[161] = 333;
        TimesBold.boundingBoxes[161] = new Rectangle(82, -203, 170, 704);
        TimesBold.width[102] = 333;
        TimesBold.boundingBoxes[102] = new Rectangle(14, 0, 375, 691);
        TimesBold.width[53] = 500;
        TimesBold.boundingBoxes[53] = new Rectangle(22, -8, 448, 684);
        TimesBold.width[131] = 500;
        TimesBold.boundingBoxes[131] = new Rectangle(0, -155, 498, 861);
        TimesBold.width[52] = 500;
        TimesBold.boundingBoxes[52] = new Rectangle(19, 0, 456, 688);
        TimesBold.width[103] = 500;
        TimesBold.boundingBoxes[103] = new Rectangle(28, -206, 455, 679);
        TimesBold.width[223] = 556;
        TimesBold.boundingBoxes[223] = new Rectangle(19, -12, 498, 703);
        TimesBold.width[96] = 333;
        TimesBold.boundingBoxes[96] = new Rectangle(8, 528, 238, 185);
        TimesBold.width[62] = 570;
        TimesBold.boundingBoxes[62] = new Rectangle(31, -8, 508, 522);
        TimesBold.width[171] = 500;
        TimesBold.boundingBoxes[171] = new Rectangle(23, 36, 450, 379);
        TimesBold.width[187] = 500;
        TimesBold.boundingBoxes[187] = new Rectangle(27, 36, 450, 379);
        TimesBold.width[139] = 333;
        TimesBold.boundingBoxes[139] = new Rectangle(51, 36, 254, 379);
        TimesBold.width[155] = 333;
        TimesBold.boundingBoxes[155] = new Rectangle(28, 36, 254, 379);
        TimesBold.width[104] = 556;
        TimesBold.boundingBoxes[104] = new Rectangle(16, 0, 518, 676);
        TimesBold.width[45] = 333;
        TimesBold.boundingBoxes[45] = new Rectangle(44, 171, 243, 116);
        TimesBold.width[105] = 278;
        TimesBold.boundingBoxes[105] = new Rectangle(16, 0, 239, 691);
        TimesBold.width[237] = 278;
        TimesBold.boundingBoxes[237] = new Rectangle(16, 0, 273, 713);
        TimesBold.width[238] = 278;
        TimesBold.boundingBoxes[238] = new Rectangle(-37, 0, 337, 704);
        TimesBold.width[239] = 278;
        TimesBold.boundingBoxes[239] = new Rectangle(-37, 0, 337, 667);
        TimesBold.width[236] = 278;
        TimesBold.boundingBoxes[236] = new Rectangle(-27, 0, 282, 713);
        TimesBold.width[106] = 333;
        TimesBold.boundingBoxes[106] = new Rectangle(-57, -203, 320, 894);
        TimesBold.width[107] = 556;
        TimesBold.boundingBoxes[107] = new Rectangle(22, 0, 521, 676);
        TimesBold.width[108] = 278;
        TimesBold.boundingBoxes[108] = new Rectangle(16, 0, 239, 676);
        TimesBold.width[60] = 570;
        TimesBold.boundingBoxes[60] = new Rectangle(31, -8, 508, 522);
        TimesBold.width[172] = 570;
        TimesBold.boundingBoxes[172] = new Rectangle(33, 108, 504, 291);
        TimesBold.width[109] = 833;
        TimesBold.boundingBoxes[109] = new Rectangle(16, 0, 798, 473);
        TimesBold.width[175] = 333;
        TimesBold.boundingBoxes[175] = new Rectangle(1, 565, 330, 72);
        TimesBold.width[181] = 556;
        TimesBold.boundingBoxes[181] = new Rectangle(33, -206, 503, 667);
        TimesBold.width[215] = 570;
        TimesBold.boundingBoxes[215] = new Rectangle(48, 16, 474, 474);
        TimesBold.width[110] = 556;
        TimesBold.boundingBoxes[110] = new Rectangle(21, 0, 518, 473);
        TimesBold.width[57] = 500;
        TimesBold.boundingBoxes[57] = new Rectangle(26, -13, 447, 701);
        TimesBold.width[241] = 556;
        TimesBold.boundingBoxes[241] = new Rectangle(21, 0, 518, 674);
        TimesBold.width[35] = 500;
        TimesBold.boundingBoxes[35] = new Rectangle(4, 0, 492, 700);
        TimesBold.width[111] = 500;
        TimesBold.boundingBoxes[111] = new Rectangle(25, -14, 451, 487);
        TimesBold.width[243] = 500;
        TimesBold.boundingBoxes[243] = new Rectangle(25, -14, 451, 727);
        TimesBold.width[244] = 500;
        TimesBold.boundingBoxes[244] = new Rectangle(25, -14, 451, 718);
        TimesBold.width[246] = 500;
        TimesBold.boundingBoxes[246] = new Rectangle(25, -14, 451, 681);
        TimesBold.width[156] = 722;
        TimesBold.boundingBoxes[156] = new Rectangle(22, -14, 674, 487);
        TimesBold.width[242] = 500;
        TimesBold.boundingBoxes[242] = new Rectangle(25, -14, 451, 727);
        TimesBold.width[49] = 500;
        TimesBold.boundingBoxes[49] = new Rectangle(65, 0, 377, 688);
        TimesBold.width[189] = 750;
        TimesBold.boundingBoxes[189] = new Rectangle(-7, -12, 782, 700);
        TimesBold.width[188] = 750;
        TimesBold.boundingBoxes[188] = new Rectangle(28, -12, 715, 700);
        TimesBold.width[185] = 300;
        TimesBold.boundingBoxes[185] = new Rectangle(28, 275, 245, 413);
        TimesBold.width[170] = 300;
        TimesBold.boundingBoxes[170] = new Rectangle(-1, 397, 302, 291);
        TimesBold.width[186] = 330;
        TimesBold.boundingBoxes[186] = new Rectangle(18, 397, 294, 291);
        TimesBold.width[248] = 500;
        TimesBold.boundingBoxes[248] = new Rectangle(25, -92, 451, 641);
        TimesBold.width[245] = 500;
        TimesBold.boundingBoxes[245] = new Rectangle(25, -14, 451, 688);
        TimesBold.width[112] = 556;
        TimesBold.boundingBoxes[112] = new Rectangle(19, -205, 505, 678);
        TimesBold.width[182] = 540;
        TimesBold.boundingBoxes[182] = new Rectangle(0, -186, 519, 862);
        TimesBold.width[40] = 333;
        TimesBold.boundingBoxes[40] = new Rectangle(46, -168, 260, 862);
        TimesBold.width[41] = 333;
        TimesBold.boundingBoxes[41] = new Rectangle(27, -168, 260, 862);
        TimesBold.width[37] = 1000;
        TimesBold.boundingBoxes[37] = new Rectangle(124, -14, 753, 706);
        TimesBold.width[46] = 250;
        TimesBold.boundingBoxes[46] = new Rectangle(41, -13, 169, 169);
        TimesBold.width[183] = 250;
        TimesBold.boundingBoxes[183] = new Rectangle(41, 248, 169, 169);
        TimesBold.width[137] = 1000;
        TimesBold.boundingBoxes[137] = new Rectangle(7, -29, 988, 735);
        TimesBold.width[43] = 570;
        TimesBold.boundingBoxes[43] = new Rectangle(33, 0, 504, 506);
        TimesBold.width[177] = 570;
        TimesBold.boundingBoxes[177] = new Rectangle(33, 0, 504, 506);
        TimesBold.width[113] = 556;
        TimesBold.boundingBoxes[113] = new Rectangle(34, -205, 502, 678);
        TimesBold.width[63] = 500;
        TimesBold.boundingBoxes[63] = new Rectangle(57, -13, 388, 702);
        TimesBold.width[191] = 500;
        TimesBold.boundingBoxes[191] = new Rectangle(55, -201, 388, 702);
        TimesBold.width[34] = 555;
        TimesBold.boundingBoxes[34] = new Rectangle(83, 404, 389, 287);
        TimesBold.width[132] = 500;
        TimesBold.boundingBoxes[132] = new Rectangle(14, -180, 454, 335);
        TimesBold.width[147] = 500;
        TimesBold.boundingBoxes[147] = new Rectangle(32, 356, 454, 335);
        TimesBold.width[148] = 500;
        TimesBold.boundingBoxes[148] = new Rectangle(14, 356, 454, 335);
        TimesBold.width[145] = 333;
        TimesBold.boundingBoxes[145] = new Rectangle(70, 356, 184, 335);
        TimesBold.width[146] = 333;
        TimesBold.boundingBoxes[146] = new Rectangle(79, 356, 184, 335);
        TimesBold.width[130] = 333;
        TimesBold.boundingBoxes[130] = new Rectangle(79, -180, 184, 335);
        TimesBold.width[39] = 278;
        TimesBold.boundingBoxes[39] = new Rectangle(75, 404, 129, 287);
        TimesBold.width[114] = 444;
        TimesBold.boundingBoxes[114] = new Rectangle(29, 0, 405, 473);
        TimesBold.width[174] = 747;
        TimesBold.boundingBoxes[174] = new Rectangle(26, -19, 695, 710);
        TimesBold.width[115] = 389;
        TimesBold.boundingBoxes[115] = new Rectangle(25, -14, 336, 487);
        TimesBold.width[154] = 389;
        TimesBold.boundingBoxes[154] = new Rectangle(25, -14, 338, 718);
        TimesBold.width[167] = 500;
        TimesBold.boundingBoxes[167] = new Rectangle(57, -132, 386, 823);
        TimesBold.width[59] = 333;
        TimesBold.boundingBoxes[59] = new Rectangle(82, -180, 184, 652);
        TimesBold.width[55] = 500;
        TimesBold.boundingBoxes[55] = new Rectangle(17, 0, 460, 676);
        TimesBold.width[54] = 500;
        TimesBold.boundingBoxes[54] = new Rectangle(28, -13, 447, 701);
        TimesBold.width[47] = 278;
        TimesBold.boundingBoxes[47] = new Rectangle(-24, -19, 326, 710);
        TimesBold.width[32] = 250;
        TimesBold.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        TimesBold.width[163] = 500;
        TimesBold.boundingBoxes[163] = new Rectangle(21, -14, 456, 698);
        TimesBold.width[116] = 333;
        TimesBold.boundingBoxes[116] = new Rectangle(20, -12, 312, 642);
        TimesBold.width[254] = 556;
        TimesBold.boundingBoxes[254] = new Rectangle(19, -205, 505, 881);
        TimesBold.width[51] = 500;
        TimesBold.boundingBoxes[51] = new Rectangle(16, -14, 452, 702);
        TimesBold.width[190] = 750;
        TimesBold.boundingBoxes[190] = new Rectangle(23, -12, 710, 700);
        TimesBold.width[179] = 300;
        TimesBold.boundingBoxes[179] = new Rectangle(3, 268, 294, 420);
        TimesBold.width[152] = 333;
        TimesBold.boundingBoxes[152] = new Rectangle(-16, 547, 365, 127);
        TimesBold.width[153] = 1000;
        TimesBold.boundingBoxes[153] = new Rectangle(24, 271, 953, 405);
        TimesBold.width[50] = 500;
        TimesBold.boundingBoxes[50] = new Rectangle(17, 0, 461, 688);
        TimesBold.width[178] = 300;
        TimesBold.boundingBoxes[178] = new Rectangle(0, 275, 300, 413);
        TimesBold.width[117] = 556;
        TimesBold.boundingBoxes[117] = new Rectangle(16, -14, 521, 475);
        TimesBold.width[250] = 556;
        TimesBold.boundingBoxes[250] = new Rectangle(16, -14, 521, 727);
        TimesBold.width[251] = 556;
        TimesBold.boundingBoxes[251] = new Rectangle(16, -14, 521, 718);
        TimesBold.width[252] = 556;
        TimesBold.boundingBoxes[252] = new Rectangle(16, -14, 521, 681);
        TimesBold.width[249] = 556;
        TimesBold.boundingBoxes[249] = new Rectangle(16, -14, 521, 727);
        TimesBold.width[95] = 500;
        TimesBold.boundingBoxes[95] = new Rectangle(0, -125, 500, 50);
        TimesBold.width[118] = 500;
        TimesBold.boundingBoxes[118] = new Rectangle(21, -14, 464, 475);
        TimesBold.width[119] = 722;
        TimesBold.boundingBoxes[119] = new Rectangle(23, -14, 684, 475);
        TimesBold.width[120] = 500;
        TimesBold.boundingBoxes[120] = new Rectangle(12, 0, 472, 461);
        TimesBold.width[121] = 500;
        TimesBold.boundingBoxes[121] = new Rectangle(16, -205, 464, 666);
        TimesBold.width[253] = 500;
        TimesBold.boundingBoxes[253] = new Rectangle(16, -205, 464, 918);
        TimesBold.width[255] = 500;
        TimesBold.boundingBoxes[255] = new Rectangle(16, -205, 464, 872);
        TimesBold.width[165] = 500;
        TimesBold.boundingBoxes[165] = new Rectangle(-64, 0, 611, 676);
        TimesBold.width[122] = 444;
        TimesBold.boundingBoxes[122] = new Rectangle(21, 0, 399, 461);
        TimesBold.width[158] = 444;
        TimesBold.boundingBoxes[158] = new Rectangle(21, 0, 399, 704);
        TimesBold.width[48] = 500;
        TimesBold.boundingBoxes[48] = new Rectangle(24, -13, 452, 701);
        kerning = new HashMap();
        Integer first = new Integer(79);
        Map<Integer, Integer> pairs = (HashMap<Integer, Integer>)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap<Integer, Integer>();
            kerning.put(first, pairs);
        }
        Integer second = new Integer(65);
        pairs.put(second, new Integer(-40));
        second = new Integer(87);
        pairs.put(second, new Integer(-50));
        second = new Integer(89);
        pairs.put(second, new Integer(-50));
        second = new Integer(84);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        second = new Integer(88);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(107);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        first = new Integer(112);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        first = new Integer(80);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(97);
        pairs.put(second, new Integer(-10));
        second = new Integer(65);
        pairs.put(second, new Integer(-74));
        second = new Integer(46);
        pairs.put(second, new Integer(-110));
        second = new Integer(101);
        pairs.put(second, new Integer(-20));
        second = new Integer(44);
        pairs.put(second, new Integer(-92));
        first = new Integer(86);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-100));
        second = new Integer(79);
        pairs.put(second, new Integer(-45));
        second = new Integer(58);
        pairs.put(second, new Integer(-92));
        second = new Integer(71);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-129));
        second = new Integer(59);
        pairs.put(second, new Integer(-92));
        second = new Integer(45);
        pairs.put(second, new Integer(-74));
        second = new Integer(105);
        pairs.put(second, new Integer(-37));
        second = new Integer(65);
        pairs.put(second, new Integer(-135));
        second = new Integer(97);
        pairs.put(second, new Integer(-92));
        second = new Integer(117);
        pairs.put(second, new Integer(-92));
        second = new Integer(46);
        pairs.put(second, new Integer(-145));
        second = new Integer(101);
        pairs.put(second, new Integer(-100));
        first = new Integer(118);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-10));
        second = new Integer(97);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(-70));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-55));
        first = new Integer(32);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-55));
        second = new Integer(87);
        pairs.put(second, new Integer(-30));
        second = new Integer(147);
        pairs.put(second, new Integer(0));
        second = new Integer(89);
        pairs.put(second, new Integer(-55));
        second = new Integer(84);
        pairs.put(second, new Integer(-30));
        second = new Integer(145);
        pairs.put(second, new Integer(0));
        second = new Integer(86);
        pairs.put(second, new Integer(-45));
        first = new Integer(97);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        second = new Integer(116);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(0));
        second = new Integer(98);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(-25));
        first = new Integer(70);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-25));
        second = new Integer(105);
        pairs.put(second, new Integer(0));
        second = new Integer(114);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(-25));
        second = new Integer(65);
        pairs.put(second, new Integer(-90));
        second = new Integer(46);
        pairs.put(second, new Integer(-110));
        second = new Integer(101);
        pairs.put(second, new Integer(-25));
        second = new Integer(44);
        pairs.put(second, new Integer(-92));
        first = new Integer(85);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-60));
        second = new Integer(46);
        pairs.put(second, new Integer(-50));
        second = new Integer(44);
        pairs.put(second, new Integer(-50));
        first = new Integer(100);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(100);
        pairs.put(second, new Integer(0));
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(83);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(122);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        first = new Integer(68);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-35));
        second = new Integer(87);
        pairs.put(second, new Integer(-40));
        second = new Integer(89);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(-20));
        second = new Integer(86);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(146);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(100);
        pairs.put(second, new Integer(-20));
        second = new Integer(32);
        pairs.put(second, new Integer(-74));
        second = new Integer(146);
        pairs.put(second, new Integer(-63));
        second = new Integer(114);
        pairs.put(second, new Integer(-20));
        second = new Integer(116);
        pairs.put(second, new Integer(0));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(115);
        pairs.put(second, new Integer(-37));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(58);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(0));
        first = new Integer(119);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-10));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-70));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-55));
        first = new Integer(75);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-25));
        second = new Integer(79);
        pairs.put(second, new Integer(-30));
        second = new Integer(117);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-45));
        second = new Integer(101);
        pairs.put(second, new Integer(-25));
        first = new Integer(82);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-30));
        second = new Integer(87);
        pairs.put(second, new Integer(-35));
        second = new Integer(85);
        pairs.put(second, new Integer(-30));
        second = new Integer(89);
        pairs.put(second, new Integer(-35));
        second = new Integer(84);
        pairs.put(second, new Integer(-40));
        second = new Integer(86);
        pairs.put(second, new Integer(-55));
        first = new Integer(145);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-10));
        second = new Integer(145);
        pairs.put(second, new Integer(-63));
        first = new Integer(103);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(0));
        second = new Integer(105);
        pairs.put(second, new Integer(0));
        second = new Integer(114);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-15));
        second = new Integer(103);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(66);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-30));
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(98);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(98);
        pairs.put(second, new Integer(-10));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(81);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(-20));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(44);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-45));
        second = new Integer(32);
        pairs.put(second, new Integer(0));
        second = new Integer(146);
        pairs.put(second, new Integer(-55));
        first = new Integer(102);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(50));
        second = new Integer(111);
        pairs.put(second, new Integer(-25));
        second = new Integer(105);
        pairs.put(second, new Integer(-25));
        second = new Integer(146);
        pairs.put(second, new Integer(55));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(102);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-15));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-15));
        first = new Integer(84);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-92));
        second = new Integer(79);
        pairs.put(second, new Integer(-18));
        second = new Integer(119);
        pairs.put(second, new Integer(-74));
        second = new Integer(58);
        pairs.put(second, new Integer(-74));
        second = new Integer(114);
        pairs.put(second, new Integer(-74));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-74));
        second = new Integer(59);
        pairs.put(second, new Integer(-74));
        second = new Integer(45);
        pairs.put(second, new Integer(-92));
        second = new Integer(105);
        pairs.put(second, new Integer(-18));
        second = new Integer(65);
        pairs.put(second, new Integer(-90));
        second = new Integer(97);
        pairs.put(second, new Integer(-92));
        second = new Integer(117);
        pairs.put(second, new Integer(-92));
        second = new Integer(121);
        pairs.put(second, new Integer(-74));
        second = new Integer(46);
        pairs.put(second, new Integer(-90));
        second = new Integer(101);
        pairs.put(second, new Integer(-92));
        first = new Integer(121);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-25));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-70));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-55));
        first = new Integer(120);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(101);
        pairs.put(second, new Integer(0));
        first = new Integer(101);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(112);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(0));
        second = new Integer(98);
        pairs.put(second, new Integer(0));
        second = new Integer(120);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(99);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(107);
        pairs.put(second, new Integer(0));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(87);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-75));
        second = new Integer(79);
        pairs.put(second, new Integer(-10));
        second = new Integer(58);
        pairs.put(second, new Integer(-55));
        second = new Integer(104);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(-92));
        second = new Integer(59);
        pairs.put(second, new Integer(-55));
        second = new Integer(45);
        pairs.put(second, new Integer(-37));
        second = new Integer(105);
        pairs.put(second, new Integer(-18));
        second = new Integer(65);
        pairs.put(second, new Integer(-120));
        second = new Integer(97);
        pairs.put(second, new Integer(-65));
        second = new Integer(117);
        pairs.put(second, new Integer(-50));
        second = new Integer(121);
        pairs.put(second, new Integer(-60));
        second = new Integer(46);
        pairs.put(second, new Integer(-92));
        second = new Integer(101);
        pairs.put(second, new Integer(-65));
        first = new Integer(104);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        first = new Integer(71);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(105);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(118);
        pairs.put(second, new Integer(-10));
        first = new Integer(65);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-45));
        second = new Integer(146);
        pairs.put(second, new Integer(-74));
        second = new Integer(119);
        pairs.put(second, new Integer(-90));
        second = new Integer(87);
        pairs.put(second, new Integer(-130));
        second = new Integer(67);
        pairs.put(second, new Integer(-55));
        second = new Integer(112);
        pairs.put(second, new Integer(-25));
        second = new Integer(81);
        pairs.put(second, new Integer(-45));
        second = new Integer(71);
        pairs.put(second, new Integer(-55));
        second = new Integer(86);
        pairs.put(second, new Integer(-145));
        second = new Integer(118);
        pairs.put(second, new Integer(-100));
        second = new Integer(148);
        pairs.put(second, new Integer(0));
        second = new Integer(85);
        pairs.put(second, new Integer(-50));
        second = new Integer(117);
        pairs.put(second, new Integer(-50));
        second = new Integer(89);
        pairs.put(second, new Integer(-100));
        second = new Integer(121);
        pairs.put(second, new Integer(-74));
        second = new Integer(84);
        pairs.put(second, new Integer(-95));
        first = new Integer(147);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-10));
        second = new Integer(145);
        pairs.put(second, new Integer(0));
        first = new Integer(78);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(0));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(115);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        first = new Integer(111);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(103);
        pairs.put(second, new Integer(0));
        second = new Integer(120);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(-10));
        first = new Integer(114);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-18));
        second = new Integer(100);
        pairs.put(second, new Integer(0));
        second = new Integer(107);
        pairs.put(second, new Integer(0));
        second = new Integer(114);
        pairs.put(second, new Integer(0));
        second = new Integer(99);
        pairs.put(second, new Integer(-18));
        second = new Integer(112);
        pairs.put(second, new Integer(-10));
        second = new Integer(103);
        pairs.put(second, new Integer(-10));
        second = new Integer(108);
        pairs.put(second, new Integer(0));
        second = new Integer(113);
        pairs.put(second, new Integer(-18));
        second = new Integer(118);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-92));
        second = new Integer(45);
        pairs.put(second, new Integer(-37));
        second = new Integer(105);
        pairs.put(second, new Integer(0));
        second = new Integer(109);
        pairs.put(second, new Integer(0));
        second = new Integer(97);
        pairs.put(second, new Integer(0));
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(116);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(46);
        pairs.put(second, new Integer(-100));
        second = new Integer(110);
        pairs.put(second, new Integer(-15));
        second = new Integer(115);
        pairs.put(second, new Integer(0));
        second = new Integer(101);
        pairs.put(second, new Integer(-18));
        first = new Integer(108);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        first = new Integer(76);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-20));
        second = new Integer(146);
        pairs.put(second, new Integer(-110));
        second = new Integer(87);
        pairs.put(second, new Integer(-92));
        second = new Integer(89);
        pairs.put(second, new Integer(-92));
        second = new Integer(121);
        pairs.put(second, new Integer(-55));
        second = new Integer(84);
        pairs.put(second, new Integer(-92));
        second = new Integer(86);
        pairs.put(second, new Integer(-92));
        first = new Integer(148);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(0));
        first = new Integer(109);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        first = new Integer(89);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-111));
        second = new Integer(45);
        pairs.put(second, new Integer(-92));
        second = new Integer(105);
        pairs.put(second, new Integer(-37));
        second = new Integer(79);
        pairs.put(second, new Integer(-35));
        second = new Integer(58);
        pairs.put(second, new Integer(-92));
        second = new Integer(97);
        pairs.put(second, new Integer(-85));
        second = new Integer(65);
        pairs.put(second, new Integer(-110));
        second = new Integer(117);
        pairs.put(second, new Integer(-92));
        second = new Integer(46);
        pairs.put(second, new Integer(-92));
        second = new Integer(101);
        pairs.put(second, new Integer(-111));
        second = new Integer(59);
        pairs.put(second, new Integer(-92));
        second = new Integer(44);
        pairs.put(second, new Integer(-92));
        first = new Integer(74);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-15));
        second = new Integer(97);
        pairs.put(second, new Integer(-15));
        second = new Integer(65);
        pairs.put(second, new Integer(-30));
        second = new Integer(117);
        pairs.put(second, new Integer(-15));
        second = new Integer(46);
        pairs.put(second, new Integer(-20));
        second = new Integer(101);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(0));
        first = new Integer(46);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-55));
        second = new Integer(146);
        pairs.put(second, new Integer(-55));
        first = new Integer(110);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(0));
        second = new Integer(121);
        pairs.put(second, new Integer(0));
        second = new Integer(118);
        pairs.put(second, new Integer(-40));
        familyNames = new HashSet();
        familyNames.add("Times");
    }
}

