/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.pagination.ColorProfile;
import org.apache.fop.fo.pagination.Declarations;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;

class RGBNamedColorFunction
extends FunctionBase {
    RGBNamedColorFunction() {
    }

    public int getRequiredArgsCount() {
        return 5;
    }

    public PercentBase getPercentBase() {
        return new RGBNamedPercentBase();
    }

    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        String colorProfileName = args[3].getString();
        String colorName = args[4].getString();
        Declarations decls = pInfo.getFO() != null ? pInfo.getFO().getRoot().getDeclarations() : null;
        ColorProfile cp = null;
        if (decls != null) {
            cp = decls.getColorProfile(colorProfileName);
        }
        if (cp == null) {
            PropertyException pe = new PropertyException("The " + colorProfileName + " color profile was not declared");
            pe.setPropertyInfo(pInfo);
            throw pe;
        }
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        red = args[0].getNumber().floatValue();
        green = args[1].getNumber().floatValue();
        blue = args[2].getNumber().floatValue();
        if (red < 0.0f || red > 255.0f || green < 0.0f || green > 255.0f || blue < 0.0f || blue > 255.0f) {
            throw new PropertyException("sRGB color values out of range. Arguments to rgb-named-color() must be [0..255] or [0%..100%]");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("fop-rgb-named-color(");
        sb.append(red / 255.0f);
        sb.append(',').append(green / 255.0f);
        sb.append(',').append(blue / 255.0f);
        sb.append(',').append(colorProfileName);
        sb.append(',').append(cp.getSrc());
        sb.append(", '").append(colorName).append('\'');
        sb.append(")");
        return ColorProperty.getInstance(pInfo.getUserAgent(), sb.toString());
    }

    private static final class RGBNamedPercentBase
    implements PercentBase {
        private RGBNamedPercentBase() {
        }

        public int getBaseLength(PercentBaseContext context) throws PropertyException {
            return 0;
        }

        public double getBaseValue() {
            return 255.0;
        }

        public int getDimension() {
            return 0;
        }
    }
}

