/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageProvider;
import org.apache.fop.traits.MinOptMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BalancingColumnBreakingAlgorithm
extends PageBreakingAlgorithm {
    private int columnCount;
    private List<Integer> idealBreaks;

    public BalancingColumnBreakingAlgorithm(LayoutManager topLevelLM, PageProvider pageProvider, PageBreakingAlgorithm.PageBreakingLayoutListener layoutListener, int alignment, int alignmentLast, MinOptMax footnoteSeparatorLength, boolean partOverflowRecovery, int columnCount) {
        super(topLevelLM, pageProvider, layoutListener, alignment, alignmentLast, footnoteSeparatorLength, partOverflowRecovery, false, false);
        this.columnCount = columnCount;
        this.considerTooShort = true;
    }

    @Override
    protected double computeDemerits(BreakingAlgorithm.KnuthNode activeNode, KnuthElement element, int fitnessClass, double r) {
        double demerits = Double.MAX_VALUE;
        if (this.idealBreaks == null) {
            this.idealBreaks = this.calculateIdealBreaks(activeNode.position);
        }
        LinkedList<Integer> curPossibility = this.getPossibilityTrail(activeNode);
        boolean notIdeal = false;
        int idealDemerit = this.columnCount + 1 - curPossibility.size();
        if (curPossibility.size() > this.idealBreaks.size()) {
            return demerits;
        }
        for (int breakPos = 0; breakPos < curPossibility.size(); ++breakPos) {
            if (curPossibility.get(breakPos) == 0 || curPossibility.get(breakPos).equals(this.idealBreaks.get(breakPos))) continue;
            notIdeal = true;
            break;
        }
        if (!notIdeal) {
            demerits = idealDemerit;
        }
        return demerits;
    }

    private List<Integer> calculateIdealBreaks(int startPos) {
        ArrayList<ColumnContent> previousPreviousBreaks = null;
        ArrayList<ColumnContent> previousBreaks = null;
        List<ColumnContent> breaks = new ArrayList<ColumnContent>();
        breaks.add(new ColumnContent(startPos, this.par.size() - 1));
        do {
            previousPreviousBreaks = previousBreaks;
            previousBreaks = breaks;
        } while (!((Object)(breaks = this.getInitialBreaks(startPos, this.getAverageColumnLength(breaks)))).equals(previousBreaks) && !((Object)breaks).equals(previousPreviousBreaks));
        breaks = this.sortElementsForBreaks(breaks);
        return this.getElementIdBreaks(breaks, startPos);
    }

    private int getAverageColumnLength(List<ColumnContent> columns) {
        int totalLength = 0;
        for (ColumnContent col : columns) {
            totalLength += this.calcContentLength(this.par, col.startIndex, col.endIndex);
        }
        return totalLength / this.columnCount;
    }

    private List<ColumnContent> getInitialBreaks(int startIndex, int averageColLength) {
        ArrayList<ColumnContent> initialColumns = new ArrayList<ColumnContent>();
        int colStartIndex = startIndex;
        int totalLength = 0;
        int idealBreakLength = averageColLength;
        int previousBreakLength = 0;
        int prevBreakIndex = startIndex;
        boolean prevIsBox = false;
        int colNumber = 1;
        for (int i = startIndex; i < this.par.size(); ++i) {
            KnuthElement element = (KnuthElement)this.par.get(i);
            if (this.isLegalBreak(i, prevIsBox)) {
                int breakLength = totalLength + (element instanceof KnuthPenalty ? element.getWidth() : 0);
                if (breakLength > idealBreakLength && colNumber < this.columnCount) {
                    int breakIndex;
                    if (breakLength - idealBreakLength > idealBreakLength - previousBreakLength) {
                        breakIndex = prevBreakIndex;
                        totalLength = previousBreakLength;
                    } else {
                        breakIndex = element instanceof KnuthPenalty ? i : i - 1;
                        totalLength = breakLength;
                    }
                    initialColumns.add(new ColumnContent(colStartIndex, breakIndex));
                    i = this.getNextStartIndex(breakIndex);
                    colStartIndex = i--;
                    ++colNumber;
                    idealBreakLength += averageColLength;
                    continue;
                }
                previousBreakLength = breakLength;
                prevBreakIndex = element instanceof KnuthPenalty ? i : i - 1;
                prevIsBox = false;
                continue;
            }
            totalLength += element instanceof KnuthPenalty ? 0 : element.getWidth();
            prevIsBox = element instanceof KnuthBox;
        }
        assert (initialColumns.size() == this.columnCount - 1);
        initialColumns.add(new ColumnContent(colStartIndex, this.par.size() - 1));
        return initialColumns;
    }

    private int getNextStartIndex(int breakIndex) {
        int startIndex = breakIndex;
        ListIterator iter = this.par.listIterator(breakIndex);
        while (iter.hasNext() && !(iter.next() instanceof KnuthBox)) {
            ++startIndex;
        }
        return startIndex;
    }

    private List<ColumnContent> sortElementsForBreaks(List<ColumnContent> breaks) {
        boolean changes;
        int fFactor = 4000;
        do {
            changes = false;
            ColumnContent curColumn = breaks.get(breaks.size() - 1);
            int curColLength = this.calcContentLength(this.par, curColumn.startIndex, curColumn.endIndex);
            for (int colIndex = breaks.size() - 1; colIndex > 0; --colIndex) {
                ColumnContent prevColumn = breaks.get(colIndex - 1);
                int prevColLength = this.calcContentLength(this.par, prevColumn.startIndex, prevColumn.endIndex);
                if (prevColLength < curColLength) {
                    int newBreakIndex = curColumn.startIndex;
                    boolean prevIsBox = true;
                    while (newBreakIndex <= curColumn.endIndex && !this.isLegalBreak(newBreakIndex, prevIsBox)) {
                        prevIsBox = this.par.get(++newBreakIndex) instanceof KnuthBox;
                    }
                    if (newBreakIndex < curColumn.endIndex) {
                        if (prevIsBox) {
                            --newBreakIndex;
                        }
                        int newStartIndex = this.getNextStartIndex(newBreakIndex);
                        int newPrevColLength = this.calcContentLength(this.par, prevColumn.startIndex, newBreakIndex);
                        if (newPrevColLength <= fFactor + curColLength) {
                            prevColumn = new ColumnContent(prevColumn.startIndex, newBreakIndex);
                            breaks.set(colIndex - 1, prevColumn);
                            breaks.set(colIndex, new ColumnContent(newStartIndex, curColumn.endIndex));
                            prevColLength = this.calcContentLength(this.par, prevColumn.startIndex, newBreakIndex);
                            changes = true;
                        }
                    }
                }
                curColLength = prevColLength;
                curColumn = prevColumn;
            }
        } while (changes);
        return breaks;
    }

    private boolean isLegalBreak(int index, boolean prevIsBox) {
        KnuthElement element = (KnuthElement)this.par.get(index);
        return element instanceof KnuthPenalty && element.getPenalty() < 1000 || prevIsBox && element instanceof KnuthGlue;
    }

    private int calcContentLength(KnuthSequence par, int startIndex, int endIndex) {
        return ElementListUtils.calcContentLength(par, startIndex, endIndex) + this.getPenaltyWidth(endIndex);
    }

    private int getPenaltyWidth(int index) {
        KnuthElement element = (KnuthElement)this.par.get(index);
        return element instanceof KnuthPenalty ? element.getWidth() : 0;
    }

    private List<Integer> getElementIdBreaks(List<ColumnContent> breaks, int startPos) {
        ArrayList<Integer> elementIdBreaks = new ArrayList<Integer>();
        elementIdBreaks.add(startPos);
        for (ColumnContent column : breaks) {
            if (breaks.get(breaks.size() - 1).equals(column)) continue;
            elementIdBreaks.add(column.endIndex);
        }
        return elementIdBreaks;
    }

    private LinkedList<Integer> getPossibilityTrail(BreakingAlgorithm.KnuthNode activeNode) {
        LinkedList<Integer> trail = new LinkedList<Integer>();
        BreakingAlgorithm.KnuthNode previous = activeNode;
        do {
            trail.addFirst(previous.position);
        } while ((previous = previous.previous) != null);
        return trail;
    }

    private static final class ColumnContent {
        public final int startIndex;
        public final int endIndex;

        ColumnContent(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public int hashCode() {
            return this.startIndex << 16 | this.endIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColumnContent)) {
                return false;
            }
            ColumnContent other = (ColumnContent)obj;
            return other.startIndex == this.startIndex && other.endIndex == this.endIndex;
        }

        public String toString() {
            return this.startIndex + "-" + this.endIndex;
        }
    }
}

