/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MethodType
implements Serializable {
    private static final long serialVersionUID = 292L;
    private final Class<?> rtype;
    private final Class<?>[] ptypes;
    static final int MAX_JVM_ARITY = 255;
    static final int MAX_MH_ARITY = 254;
    static final int MAX_MH_INVOKER_ARITY = 253;
    static final ConcurrentWeakInternSet<MethodType> internTable = new ConcurrentWeakInternSet();
    static final Class<?>[] NO_PTYPES = new Class[0];
    private static final MethodType[] objectOnlyTypes = new MethodType[20];
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];

    private MethodType(Class<?> rtype, Class<?>[] ptypes, boolean trusted) {
        this.rtype = rtype;
        this.ptypes = trusted ? ptypes : Arrays.copyOf(ptypes, ptypes.length);
    }

    private MethodType(Class<?>[] ptypes, Class<?> rtype) {
        this.rtype = rtype;
        this.ptypes = ptypes;
    }

    private static void checkRtype(Class<?> rtype) {
        Objects.requireNonNull(rtype);
    }

    public static MethodType methodType(Class<?> rtype, Class<?>[] ptypes) {
        return MethodType.makeImpl(rtype, ptypes, false);
    }

    public static MethodType methodType(Class<?> rtype, List<Class<?>> ptypes) {
        boolean notrust = false;
        return MethodType.makeImpl(rtype, MethodType.listToArray(ptypes), notrust);
    }

    private static Class<?>[] listToArray(List<Class<?>> ptypes) {
        return ptypes.toArray(NO_PTYPES);
    }

    public static MethodType methodType(Class<?> rtype, Class<?> ptype0, Class<?> ... ptypes) {
        Class[] ptypes1 = new Class[1 + ptypes.length];
        ptypes1[0] = ptype0;
        System.arraycopy(ptypes, 0, ptypes1, 1, ptypes.length);
        return MethodType.makeImpl(rtype, ptypes1, true);
    }

    public static MethodType methodType(Class<?> rtype) {
        return MethodType.makeImpl(rtype, NO_PTYPES, true);
    }

    public static MethodType methodType(Class<?> rtype, Class<?> ptype0) {
        return MethodType.makeImpl(rtype, new Class[]{ptype0}, true);
    }

    public static MethodType methodType(Class<?> rtype, MethodType ptypes) {
        return MethodType.makeImpl(rtype, ptypes.ptypes, true);
    }

    static MethodType makeImpl(Class<?> rtype, Class<?>[] ptypes, boolean trusted) {
        throw new IllegalStateException();
    }

    public static MethodType genericMethodType(int objectArgCount, boolean finalArray) {
        throw new IllegalStateException();
    }

    public static MethodType genericMethodType(int objectArgCount) {
        return MethodType.genericMethodType(objectArgCount, false);
    }

    public MethodType changeParameterType(int num, Class<?> nptype) {
        throw new IllegalStateException();
    }

    public MethodType insertParameterTypes(int num, Class<?> ... ptypesToInsert) {
        throw new IllegalStateException();
    }

    public MethodType appendParameterTypes(Class<?> ... ptypesToInsert) {
        return this.insertParameterTypes(this.parameterCount(), ptypesToInsert);
    }

    public MethodType insertParameterTypes(int num, List<Class<?>> ptypesToInsert) {
        return this.insertParameterTypes(num, MethodType.listToArray(ptypesToInsert));
    }

    public MethodType appendParameterTypes(List<Class<?>> ptypesToInsert) {
        return this.insertParameterTypes(this.parameterCount(), ptypesToInsert);
    }

    MethodType replaceParameterTypes(int start, int end, Class<?> ... ptypesToInsert) {
        throw new IllegalStateException();
    }

    public MethodType dropParameterTypes(int start, int end) {
        throw new IllegalStateException();
    }

    public MethodType changeReturnType(Class<?> nrtype) {
        throw new IllegalStateException();
    }

    public boolean hasPrimitives() {
        throw new IllegalStateException();
    }

    public boolean hasWrappers() {
        return this.unwrap() != this;
    }

    public MethodType erase() {
        throw new IllegalStateException();
    }

    MethodType basicType() {
        throw new IllegalStateException();
    }

    MethodType invokerType() {
        throw new IllegalStateException();
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.parameterCount());
    }

    public MethodType wrap() {
        return this.hasPrimitives() ? MethodType.wrapWithPrims(this) : this;
    }

    public MethodType unwrap() {
        MethodType noprims = !this.hasPrimitives() ? this : MethodType.wrapWithPrims(this);
        return MethodType.unwrapWithNoPrims(noprims);
    }

    private static MethodType wrapWithPrims(MethodType pt) {
        throw new IllegalStateException();
    }

    private static MethodType unwrapWithNoPrims(MethodType wt) {
        throw new IllegalStateException();
    }

    public Class<?> parameterType(int num) {
        return this.ptypes[num];
    }

    public int parameterCount() {
        return this.ptypes.length;
    }

    public Class<?> returnType() {
        return this.rtype;
    }

    public List<Class<?>> parameterList() {
        return Collections.unmodifiableList(Arrays.asList(this.ptypes));
    }

    Class<?> lastParameterType() {
        int len = this.ptypes.length;
        return len == 0 ? Void.TYPE : this.ptypes[len - 1];
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.ptypes.clone();
    }

    public boolean equals(Object x) {
        return this == x || x instanceof MethodType && this.equals((MethodType)x);
    }

    private boolean equals(MethodType that) {
        return this.rtype == that.rtype && Arrays.equals(this.ptypes, that.ptypes);
    }

    public int hashCode() {
        int hashCode = 31 + this.rtype.hashCode();
        for (Class<?> ptype : this.ptypes) {
            hashCode = 31 * hashCode + ptype.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.ptypes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.ptypes[i].getSimpleName());
        }
        sb.append(")");
        sb.append(this.rtype.getSimpleName());
        return sb.toString();
    }

    public static MethodType fromMethodDescriptorString(String descriptor, ClassLoader loader) throws IllegalArgumentException {
        throw new IllegalStateException();
    }

    public String toMethodDescriptorString() {
        throw new IllegalStateException();
    }

    private MethodType() {
        this.rtype = null;
        this.ptypes = null;
    }

    private Object readResolve() {
        return MethodType.methodType(this.rtype, this.ptypes);
    }

    private static class ConcurrentWeakInternSet<T> {
        private final ConcurrentMap<WeakEntry<T>, WeakEntry<T>> map = new ConcurrentHashMap<WeakEntry<T>, WeakEntry<T>>();
        private final ReferenceQueue<T> stale = new ReferenceQueue();

        public T get(T elem) {
            Object res;
            if (elem == null) {
                throw new NullPointerException();
            }
            this.expungeStaleElements();
            WeakEntry value = (WeakEntry)this.map.get(new WeakEntry<T>(elem));
            if (value != null && (res = value.get()) != null) {
                return res;
            }
            return null;
        }

        public T add(T elem) {
            WeakEntry<T> exist;
            T interned;
            if (elem == null) {
                throw new NullPointerException();
            }
            WeakEntry<T> e = new WeakEntry<T>(elem, this.stale);
            do {
                this.expungeStaleElements();
            } while ((interned = (exist = this.map.putIfAbsent(e, e)) == null ? elem : exist.get()) == null);
            return interned;
        }

        private void expungeStaleElements() {
            Reference<T> reference;
            while ((reference = this.stale.poll()) != null) {
                this.map.remove(reference);
            }
        }

        private static class WeakEntry<T>
        extends WeakReference<T> {
            public final int hashcode;

            public WeakEntry(T key, ReferenceQueue<T> queue) {
                super(key, queue);
                this.hashcode = key.hashCode();
            }

            public WeakEntry(T key) {
                super(key);
                this.hashcode = key.hashCode();
            }

            public boolean equals(Object obj) {
                if (obj instanceof WeakEntry) {
                    Object that = ((WeakEntry)obj).get();
                    Object mine = this.get();
                    return that == null || mine == null ? this == obj : mine.equals(that);
                }
                return false;
            }

            public int hashCode() {
                return this.hashcode;
            }
        }
    }
}

