/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class Charset
implements Comparable<Charset> {
    private static volatile String bugLevel = null;
    private static volatile Object[] cache1 = null;
    private static volatile Object[] cache2 = null;
    private static ThreadLocal<ThreadLocal> gate = new ThreadLocal();
    private static Object extendedProviderLock = new Object();
    private static boolean extendedProviderProbed = false;
    private static volatile Charset defaultCharset;
    private final String name;
    private final String[] aliases;
    private Set<String> aliasSet = null;

    private static void checkName(String s) {
        int n = s.length();
        if (n == 0) {
            throw new IllegalCharsetNameException(s);
        }
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' && i != 0 || c == '+' && i != 0 || c == ':' && i != 0 || c == '_' && i != 0 || c == '.' && i != 0) continue;
            throw new IllegalCharsetNameException(s);
        }
    }

    private static void cache(String charsetName, Charset cs) {
        cache2 = cache1;
        cache1 = new Object[]{charsetName, cs};
    }

    private static Iterator providers() {
        return Collections.emptyIterator();
    }

    private static Charset lookupViaProviders(String charsetName) {
        return null;
    }

    private static Charset lookupExtendedCharset(String charsetName) {
        return null;
    }

    private static Charset lookup(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("Null charset name");
        }
        Object[] a = cache1;
        if (cache1 != null && charsetName.equals(a[0])) {
            return (Charset)a[1];
        }
        return Charset.lookup2(charsetName);
    }

    private static Charset lookup2(String charsetName) {
        Object[] a = cache2;
        if (cache2 != null && charsetName.equals(a[0])) {
            cache2 = cache1;
            cache1 = a;
            return (Charset)a[1];
        }
        Charset.checkName(charsetName);
        return null;
    }

    public static boolean isSupported(String charsetName) {
        return Charset.lookup(charsetName) != null;
    }

    public static Charset forName(String charsetName) {
        Charset cs = Charset.lookup(charsetName);
        if (cs != null) {
            return cs;
        }
        throw new UnsupportedCharsetException(charsetName);
    }

    private static void put(Iterator<Charset> i, Map<String, Charset> m) {
        while (i.hasNext()) {
            Charset cs = i.next();
            if (m.containsKey(cs.name())) continue;
            m.put(cs.name(), cs);
        }
    }

    public static SortedMap<String, Charset> availableCharsets() {
        TreeMap<String, Charset> tm = new TreeMap<String, Charset>();
        tm.put("UTF-8", Charset.defaultCharset());
        return tm;
    }

    public static Charset defaultCharset() {
        if (defaultCharset == null) {
            defaultCharset = Charset.forName("UTF-8");
        }
        return defaultCharset;
    }

    protected Charset(String canonicalName, String[] aliases) {
        Charset.checkName(canonicalName);
        String[] as = aliases == null ? new String[]{} : aliases;
        for (int i = 0; i < as.length; ++i) {
            Charset.checkName(as[i]);
        }
        this.name = canonicalName;
        this.aliases = as;
    }

    public final String name() {
        return this.name;
    }

    public final Set<String> aliases() {
        if (this.aliasSet != null) {
            return this.aliasSet;
        }
        int n = this.aliases.length;
        HashSet<String> hs = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            hs.add(this.aliases[i]);
        }
        this.aliasSet = Collections.unmodifiableSet(hs);
        return this.aliasSet;
    }

    public String displayName() {
        return this.name;
    }

    public final boolean isRegistered() {
        return !this.name.startsWith("X-") && !this.name.startsWith("x-");
    }

    public String displayName(Locale locale) {
        return this.name;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    @Override
    public final int compareTo(Charset that) {
        return this.name().compareToIgnoreCase(that.name());
    }

    public final int hashCode() {
        return this.name().hashCode();
    }

    public final boolean equals(Object ob) {
        if (!(ob instanceof Charset)) {
            return false;
        }
        if (this == ob) {
            return true;
        }
        return this.name.equals(((Charset)ob).name());
    }

    public final String toString() {
        return this.name();
    }
}

