/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.util.Calendar;

class CalendarBuilder {
    private static final int UNSET = 0;
    private static final int COMPUTED = 1;
    private static final int MINIMUM_USER_STAMP = 2;
    private static final int MAX_FIELD = 18;
    public static final int WEEK_YEAR = 17;
    public static final int ISO_DAY_OF_WEEK = 1000;
    private final int[] field = new int[36];
    private int nextStamp = 2;
    private int maxFieldIndex = -1;

    CalendarBuilder() {
    }

    CalendarBuilder set(int index, int value) {
        if (index == 1000) {
            index = 7;
            value = CalendarBuilder.toCalendarDayOfWeek(value);
        }
        ++this.nextStamp;
        this.field[18 + index] = value;
        if (index > this.maxFieldIndex && index < 17) {
            this.maxFieldIndex = index;
        }
        return this;
    }

    CalendarBuilder addYear(int value) {
        this.field[19] = this.field[19] + value;
        this.field[35] = this.field[35] + value;
        return this;
    }

    boolean isSet(int index) {
        if (index == 1000) {
            index = 7;
        }
        return this.field[index] > 0;
    }

    Calendar establish(Calendar cal) {
        boolean weekDate;
        boolean bl = weekDate = this.isSet(17) && this.field[17] > this.field[1];
        if (weekDate && !cal.isWeekDateSupported()) {
            if (!this.isSet(1)) {
                this.set(1, this.field[35]);
            }
            weekDate = false;
        }
        cal.clear();
        block0: for (int stamp = 2; stamp < this.nextStamp; ++stamp) {
            for (int index = 0; index <= this.maxFieldIndex; ++index) {
                if (this.field[index] != stamp) continue;
                cal.set(index, this.field[18 + index]);
                continue block0;
            }
        }
        if (weekDate) {
            int dayOfWeek;
            int weekOfYear = this.isSet(3) ? this.field[21] : 1;
            int n = dayOfWeek = this.isSet(7) ? this.field[25] : cal.getFirstDayOfWeek();
            if (!CalendarBuilder.isValidDayOfWeek(dayOfWeek) && cal.isLenient()) {
                if (dayOfWeek >= 8) {
                    weekOfYear += --dayOfWeek / 7;
                    dayOfWeek = dayOfWeek % 7 + 1;
                } else {
                    while (dayOfWeek <= 0) {
                        dayOfWeek += 7;
                        --weekOfYear;
                    }
                }
                dayOfWeek = CalendarBuilder.toCalendarDayOfWeek(dayOfWeek);
            }
            cal.setWeekDate(this.field[35], weekOfYear, dayOfWeek);
        }
        return cal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CalendarBuilder:[");
        for (int i = 0; i < this.field.length; ++i) {
            if (!this.isSet(i)) continue;
            sb.append(i).append('=').append(this.field[18 + i]).append(',');
        }
        int lastIndex = sb.length() - 1;
        if (sb.charAt(lastIndex) == ',') {
            sb.setLength(lastIndex);
        }
        sb.append(']');
        return sb.toString();
    }

    static int toISODayOfWeek(int calendarDayOfWeek) {
        return calendarDayOfWeek == 1 ? 7 : calendarDayOfWeek - 1;
    }

    static int toCalendarDayOfWeek(int isoDayOfWeek) {
        if (!CalendarBuilder.isValidDayOfWeek(isoDayOfWeek)) {
            return isoDayOfWeek;
        }
        return isoDayOfWeek == 7 ? 1 : isoDayOfWeek + 1;
    }

    static boolean isValidDayOfWeek(int dayOfWeek) {
        return dayOfWeek > 0 && dayOfWeek <= 7;
    }
}

