/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.TaskQueue;
import java.util.TimerTask;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

class TimerThread
implements Runnable {
    boolean newTasksMayBeScheduled = true;
    private TaskQueue queue;

    TimerThread(TaskQueue queue) {
        this.queue = queue;
    }

    void notifyQueue(int delay) {
        if (delay < 1) {
            delay = 1;
        }
        TimerThread.setTimeout(delay, this);
    }

    @JavaScriptBody(args={"delay", "r"}, body="window.setTimeout(function() { r.run__V(); }, delay);")
    private static native void setTimeout(int var0, Runnable var1);

    @Override
    public void run() {
        this.mainLoop(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop(int inc) {
        for (int i = 0; i < 1; i += inc) {
            try {
                boolean taskFired;
                TimerTask task;
                TaskQueue taskQueue = this.queue;
                synchronized (taskQueue) {
                    long currentTime;
                    long executionTime;
                    if (!this.queue.isEmpty() || this.newTasksMayBeScheduled) {
                        // empty if block
                    }
                    if (this.queue.isEmpty()) {
                        break;
                    }
                    task = this.queue.getMin();
                    Object object = task.lock;
                    synchronized (object) {
                        if (task.state == 3) {
                            this.queue.removeMin();
                            continue;
                        }
                        executionTime = task.nextExecutionTime;
                        currentTime = System.currentTimeMillis();
                        taskFired = executionTime <= currentTime;
                        if (taskFired) {
                            if (task.period == 0L) {
                                this.queue.removeMin();
                                task.state = 2;
                            } else {
                                this.queue.rescheduleMin(task.period < 0L ? currentTime - task.period : executionTime + task.period);
                            }
                        }
                    }
                    if (!taskFired) {
                        this.notifyQueue((int)(executionTime - currentTime));
                        return;
                    }
                }
                if (!taskFired) continue;
                task.run();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

