/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicIntegerArray
implements Serializable {
    private static final long serialVersionUID = 2862133569453604235L;
    private final int[] array;

    public AtomicIntegerArray(int length) {
        this.array = new int[length];
    }

    public AtomicIntegerArray(int[] array) {
        this.array = (int[])array.clone();
    }

    public final int length() {
        return this.array.length;
    }

    public final int get(int i) {
        return this.array[i];
    }

    public final void set(int i, int newValue) {
        this.array[i] = newValue;
    }

    public final void lazySet(int i, int newValue) {
        this.array[i] = newValue;
    }

    public final int getAndSet(int i, int newValue) {
        int current = this.array[i];
        this.array[i] = newValue;
        return current;
    }

    public final boolean compareAndSet(int i, int expect, int update) {
        if (this.array[i] == expect) {
            this.array[i] = update;
            return true;
        }
        return false;
    }

    public final boolean weakCompareAndSet(int i, int expect, int update) {
        return this.compareAndSet(i, expect, update);
    }

    public final int getAndIncrement(int i) {
        return this.getAndAdd(i, 1);
    }

    public final int getAndDecrement(int i) {
        return this.getAndAdd(i, -1);
    }

    public final int getAndAdd(int i, int delta) {
        int v = this.array[i];
        int n = i;
        this.array[n] = this.array[n] + delta;
        return v;
    }

    public final int incrementAndGet(int i) {
        return this.addAndGet(i, 1);
    }

    public final int decrementAndGet(int i) {
        return this.addAndGet(i, -1);
    }

    public final int addAndGet(int i, int delta) {
        int n = i;
        this.array[n] = this.array[n] + delta;
        return this.array[i];
    }

    public String toString() {
        int iMax = this.array.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.get(i));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i;
        }
    }
}

