/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import org.apidesign.bck2brwsr.core.JavaScriptBody;

public abstract class AtomicReferenceFieldUpdater<T, V> {
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> tclass, Class<W> vclass, String fieldName) {
        return new Impl<U, W>(tclass, vclass, fieldName);
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract void lazySet(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T obj, V newValue) {
        V current;
        while (!this.compareAndSet(obj, current = this.get(obj), newValue)) {
        }
        return current;
    }

    private static class Impl<T, U>
    extends AtomicReferenceFieldUpdater<T, U> {
        private final Object fn;
        private Class<T> tclass;
        private Object cclass;

        Impl(Class<T> tclass, Class<U> vclass, Object fieldName) {
            if (!Impl.isFunction(fieldName)) {
                throw new SecurityException("Updater can be used only from own class!");
            }
            this.tclass = tclass;
            this.fn = fieldName;
        }

        @JavaScriptBody(args={"obj", "fn"}, body="return fn.call(obj);")
        private static native Object get(Object var0, Object var1);

        @JavaScriptBody(args={"obj", "fn", "v"}, body="fn.call(obj, v);")
        private static native void set(Object var0, Object var1, Object var2);

        @JavaScriptBody(args={"f"}, body="return typeof f === 'function';")
        private static native boolean isFunction(Object var0);

        private void fullCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
        }

        @Override
        public boolean compareAndSet(T obj, U expect, U update) {
            Object prev;
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            if ((prev = Impl.get(obj, this.fn)) == expect) {
                Impl.set(obj, this.fn, update);
                return true;
            }
            return false;
        }

        @Override
        public boolean weakCompareAndSet(T obj, U expect, U update) {
            return this.compareAndSet(obj, expect, update);
        }

        @Override
        public void set(T obj, U newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            Impl.set(obj, this.fn, newValue);
        }

        @Override
        public void lazySet(T obj, U newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            Impl.set(obj, this.fn, newValue);
        }

        @Override
        public final U get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return (U)Impl.get(obj, this.fn);
        }
    }
}

