/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apidesign.bck2brwsr.core.JavaScriptBody;

public class Logger {
    private static int offValue = Level.OFF.intValue();
    private static final Map<String, Logger> ALL = new HashMap<String, Logger>();
    private String name;
    private volatile int levelValue;
    private Level levelObject;
    public static final String GLOBAL_LOGGER_NAME = "global";
    @Deprecated
    public static final Logger global = new Logger("global");

    public static final Logger getGlobal() {
        return global;
    }

    protected Logger(String name, String resourceBundleName) {
        this.name = name;
        this.levelValue = Level.INFO.intValue();
    }

    private Logger(String name) {
        this.name = name;
        this.levelValue = Level.INFO.intValue();
    }

    private void checkAccess() throws SecurityException {
        throw new SecurityException();
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger(name, null);
    }

    public static Logger getLogger(String name, String resourceBundleName) {
        Logger l = ALL.get(name);
        if (l == null) {
            l = new Logger(name, resourceBundleName);
            ALL.put(name, l);
        }
        return l;
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    public static Logger getAnonymousLogger(String resourceBundleName) {
        return new Logger(null, resourceBundleName);
    }

    public String getResourceBundleName() {
        return null;
    }

    public void log(LogRecord record) {
        String method;
        if (record.getLevel().intValue() < this.levelValue) {
            return;
        }
        switch (record.getLevel().toString()) {
            case "INFO": {
                method = "info";
                break;
            }
            case "SEVERE": {
                method = "error";
                break;
            }
            case "WARNING": {
                method = "warn";
                break;
            }
            default: {
                method = "log";
            }
        }
        String msg = record.getMessage();
        Object[] params = record.getParameters();
        if (params != null && params.length != 0) {
            for (int i = 0; i < params.length; ++i) {
                msg = msg.replace("{" + i + "}", params[i] == null ? "null" : params[i].toString());
            }
        }
        Logger.consoleLog(method, record.getLoggerName(), msg);
    }

    @JavaScriptBody(args={"method", "logger", "msg"}, body="if (typeof console !== 'undefined') console[method]('[' + logger + ']: ' + msg);")
    private static native void consoleLog(String var0, String var1, String var2);

    private void doLog(LogRecord lr) {
        this.doLog(lr, lr.getResourceBundleName());
    }

    private void doLog(LogRecord lr, String bundleName) {
        lr.setLoggerName(this.name);
        this.log(lr);
    }

    public void log(Level level, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr, bundleName);
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", params);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        String msg = "ENTRY";
        if (params == null) {
            this.logp(Level.FINER, sourceClass, sourceMethod, msg);
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            msg = msg + " {" + i + "}";
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] params = new Object[]{result};
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", result);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (Level.FINER.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(Level.FINER, "THROW");
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void severe(String msg) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, msg);
    }

    public void setLevel(Level newLevel) throws SecurityException {
        this.levelValue = newLevel.intValue();
        this.levelObject = newLevel;
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.levelValue && this.levelValue != offValue;
    }

    public String getName() {
        return this.name;
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.checkAccess();
    }

    public boolean getUseParentHandlers() {
        return true;
    }

    public Logger getParent() {
        String n = this.getName();
        int at = n.length();
        int last;
        while ((last = n.lastIndexOf(46, at - 1)) != -1) {
            Logger p = ALL.get(n.substring(0, last));
            if (p != null) {
                return p;
            }
            at = last;
        }
        return Logger.getGlobal();
    }

    public void setParent(Logger parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.checkAccess();
    }
}

