/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.container.BlockingIOCometSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedWebSocketHandler.class);
    private final AtmosphereFramework framework;
    private boolean on;
    private WebSocketProcessor processor;
    private final ConcurrentHashMap<InputStream, WebSocket> webSockets = new ConcurrentHashMap();
    private String requestURI = "/";
    public static AtmosphereHandler ECHO_ATMOSPHEREHANDLER = new AbstractReflectorAtmosphereHandler(){

        @Override
        public void onRequest(AtmosphereResource resource) throws IOException {
            String body = IOUtils.readEntirelyAsString(resource).toString();
            if (!body.isEmpty()) {
                resource.getBroadcaster().broadcast(body);
            }
        }
    };

    public EmbeddedWebSocketHandler(AtmosphereFramework framework) {
        this.framework = framework;
        framework.setAsyncSupport(new BlockingIOCometSupport(framework.getAtmosphereConfig()){

            @Override
            public boolean supportWebSocket() {
                return true;
            }
        }).getAtmosphereConfig().startupHook(new AtmosphereConfig.StartupHook(){

            @Override
            public void started(AtmosphereFramework framework) {
                if (framework.getAtmosphereConfig().handlers().isEmpty()) {
                    framework.addAtmosphereHandler("/*", ECHO_ATMOSPHEREHANDLER);
                }
            }
        });
    }

    public EmbeddedWebSocketHandler on() {
        if (!this.on) {
            this.on = true;
            this.framework.init();
            this.processor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.framework);
        }
        logger.info("EmbeddedWebSocketHandler started");
        return this;
    }

    public EmbeddedWebSocketHandler off() {
        if (this.on) {
            this.framework.destroy();
        }
        return this;
    }

    public EmbeddedWebSocketHandler serve(InputStream inputStream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        String a = "";
        while (!a.equals("===quit")) {
            a = br.readLine();
            logger.info("Received WebSocket Message {}", (Object)a);
            this.processor.invokeWebSocketProtocol(this.webSocket(inputStream), a);
        }
        return this;
    }

    private WebSocket webSocket(InputStream inputStream) throws IOException {
        WebSocket webSocket = this.webSockets.get(inputStream);
        if (webSocket == null) {
            webSocket = new ArrayBaseWebSocket();
            this.webSockets.put(inputStream, webSocket);
            AtmosphereRequest request = AtmosphereRequestImpl.newInstance().header("Connection", "Upgrade").header("Upgrade", "websocket").pathInfo(this.requestURI);
            try {
                this.processor.open(webSocket, request, AtmosphereResponseImpl.newInstance(this.framework.getAtmosphereConfig(), request, webSocket));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return webSocket;
    }

    public EmbeddedWebSocketHandler requestURI(String requestURI) {
        this.requestURI = requestURI;
        return this;
    }

    public static void main(String ... args) throws IOException {
        new EmbeddedWebSocketHandler(new AtmosphereFramework()).on().serve(System.in);
    }

    private final class ArrayBaseWebSocket
    extends WebSocket {
        public ArrayBaseWebSocket() {
            super(EmbeddedWebSocketHandler.this.framework.getAtmosphereConfig());
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public WebSocket write(String s) throws IOException {
            System.out.println(s);
            return this;
        }

        @Override
        public WebSocket write(byte[] b, int offset, int length) throws IOException {
            System.out.println(new String(b, offset, length));
            return this;
        }

        @Override
        public void close() {
        }
    }
}

