/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.datasource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.avaje.datasource.ConfigPropertiesHelper;
import org.avaje.datasource.DataSourceAlert;
import org.avaje.datasource.DataSourcePoolListener;

public class DataSourceConfig {
    private String url;
    private String username;
    private String password;
    private String driver;
    private int minConnections = 2;
    private int maxConnections = 100;
    private int isolationLevel = 2;
    private boolean autoCommit;
    private String heartbeatSql;
    private int heartbeatFreqSecs = 30;
    private int heartbeatTimeoutSeconds = 3;
    private boolean captureStackTrace;
    private int maxStackTraceSize = 5;
    private int leakTimeMinutes = 30;
    private int maxInactiveTimeSecs = 720;
    private int maxAgeMinutes = 0;
    private int trimPoolFreqSecs = 59;
    private int pstmtCacheSize = 20;
    private int cstmtCacheSize = 20;
    private int waitTimeoutMillis = 1000;
    private String poolListener;
    private boolean offline;
    private Map<String, String> customProperties;
    private DataSourceAlert alert;
    private DataSourcePoolListener listener;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public DataSourceAlert getAlert() {
        return this.alert;
    }

    public void setAlert(DataSourceAlert alert) {
        this.alert = alert;
    }

    public DataSourcePoolListener getListener() {
        return this.listener;
    }

    public void setListener(DataSourcePoolListener listener) {
        this.listener = listener;
    }

    public String getHeartbeatSql() {
        return this.heartbeatSql;
    }

    public void setHeartbeatSql(String heartbeatSql) {
        this.heartbeatSql = heartbeatSql;
    }

    public int getHeartbeatFreqSecs() {
        return this.heartbeatFreqSecs;
    }

    public void setHeartbeatFreqSecs(int heartbeatFreqSecs) {
        this.heartbeatFreqSecs = heartbeatFreqSecs;
    }

    public int getHeartbeatTimeoutSeconds() {
        return this.heartbeatTimeoutSeconds;
    }

    public void setHeartbeatTimeoutSeconds(int heartbeatTimeoutSeconds) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
    }

    public boolean isCaptureStackTrace() {
        return this.captureStackTrace;
    }

    public void setCaptureStackTrace(boolean captureStackTrace) {
        this.captureStackTrace = captureStackTrace;
    }

    public int getMaxStackTraceSize() {
        return this.maxStackTraceSize;
    }

    public void setMaxStackTraceSize(int maxStackTraceSize) {
        this.maxStackTraceSize = maxStackTraceSize;
    }

    public int getLeakTimeMinutes() {
        return this.leakTimeMinutes;
    }

    public void setLeakTimeMinutes(int leakTimeMinutes) {
        this.leakTimeMinutes = leakTimeMinutes;
    }

    public int getPstmtCacheSize() {
        return this.pstmtCacheSize;
    }

    public void setPstmtCacheSize(int pstmtCacheSize) {
        this.pstmtCacheSize = pstmtCacheSize;
    }

    public int getCstmtCacheSize() {
        return this.cstmtCacheSize;
    }

    public void setCstmtCacheSize(int cstmtCacheSize) {
        this.cstmtCacheSize = cstmtCacheSize;
    }

    public int getWaitTimeoutMillis() {
        return this.waitTimeoutMillis;
    }

    public void setWaitTimeoutMillis(int waitTimeoutMillis) {
        this.waitTimeoutMillis = waitTimeoutMillis;
    }

    public int getMaxInactiveTimeSecs() {
        return this.maxInactiveTimeSecs;
    }

    public int getMaxAgeMinutes() {
        return this.maxAgeMinutes;
    }

    public void setMaxAgeMinutes(int maxAgeMinutes) {
        this.maxAgeMinutes = maxAgeMinutes;
    }

    public void setMaxInactiveTimeSecs(int maxInactiveTimeSecs) {
        this.maxInactiveTimeSecs = maxInactiveTimeSecs;
    }

    public int getTrimPoolFreqSecs() {
        return this.trimPoolFreqSecs;
    }

    public void setTrimPoolFreqSecs(int trimPoolFreqSecs) {
        this.trimPoolFreqSecs = trimPoolFreqSecs;
    }

    public String getPoolListener() {
        return this.poolListener;
    }

    public void setPoolListener(String poolListener) {
        this.poolListener = poolListener;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }

    public void loadSettings(Properties properties, String serverName) {
        ConfigPropertiesHelper dbProps = new ConfigPropertiesHelper("datasource", serverName, properties);
        this.loadSettings(dbProps);
    }

    private void loadSettings(ConfigPropertiesHelper properties) {
        this.username = properties.get("username", this.username);
        this.password = properties.get("password", this.password);
        this.driver = properties.get("driver", properties.get("databaseDriver", this.driver));
        this.url = properties.get("url", properties.get("databaseUrl", this.url));
        this.autoCommit = properties.getBoolean("autoCommit", this.autoCommit);
        this.captureStackTrace = properties.getBoolean("captureStackTrace", this.captureStackTrace);
        this.maxStackTraceSize = properties.getInt("maxStackTraceSize", this.maxStackTraceSize);
        this.leakTimeMinutes = properties.getInt("leakTimeMinutes", this.leakTimeMinutes);
        this.maxInactiveTimeSecs = properties.getInt("maxInactiveTimeSecs", this.maxInactiveTimeSecs);
        this.trimPoolFreqSecs = properties.getInt("trimPoolFreqSecs", this.trimPoolFreqSecs);
        this.maxAgeMinutes = properties.getInt("maxAgeMinutes", this.maxAgeMinutes);
        this.minConnections = properties.getInt("minConnections", this.minConnections);
        this.maxConnections = properties.getInt("maxConnections", this.maxConnections);
        this.pstmtCacheSize = properties.getInt("pstmtCacheSize", this.pstmtCacheSize);
        this.cstmtCacheSize = properties.getInt("cstmtCacheSize", this.cstmtCacheSize);
        this.waitTimeoutMillis = properties.getInt("waitTimeout", this.waitTimeoutMillis);
        this.heartbeatSql = properties.get("heartbeatSql", this.heartbeatSql);
        this.heartbeatTimeoutSeconds = properties.getInt("heartbeatTimeoutSeconds", this.heartbeatTimeoutSeconds);
        this.poolListener = properties.get("poolListener", this.poolListener);
        this.offline = properties.getBoolean("offline", this.offline);
        String isoLevel = properties.get("isolationLevel", this.getTransactionIsolationLevel(this.isolationLevel));
        this.isolationLevel = this.getTransactionIsolationLevel(isoLevel);
        String customProperties = properties.get("customProperties", null);
        if (customProperties != null && customProperties.length() > 0) {
            this.customProperties = this.parseCustom(customProperties);
        }
    }

    Map<String, String> parseCustom(String customProperties) {
        String[] pairs;
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>();
        for (String pair : pairs = customProperties.split(";")) {
            String[] split = pair.split("=");
            if (split.length != 2) continue;
            propertyMap.put(split[0], split[1]);
        }
        return propertyMap;
    }

    private String getTransactionIsolationLevel(int level) {
        switch (level) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "READ_COMMITTED";
            }
            case 1: {
                return "READ_UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw new RuntimeException("Transaction Isolation level [" + level + "] is not known.");
    }

    private int getTransactionIsolationLevel(String level) {
        if ((level = level.toUpperCase()).startsWith("TRANSACTION")) {
            level = level.substring("TRANSACTION".length());
        }
        if ("NONE".equalsIgnoreCase(level = level.replace("_", ""))) {
            return 0;
        }
        if ("READCOMMITTED".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("READUNCOMMITTED".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("REPEATABLEREAD".equalsIgnoreCase(level)) {
            return 4;
        }
        if ("SERIALIZABLE".equalsIgnoreCase(level)) {
            return 8;
        }
        throw new RuntimeException("Transaction Isolation level [" + level + "] is not known.");
    }
}

