/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.docker.swarm;

import com.hazelcast.instance.AddressPicker;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.SwarmDiscoveryUtil;

public class SwarmAddressPicker
implements AddressPicker {
    public static final String PROP_DOCKER_NETWORK_NAMES = "dockerNetworkNames";
    public static final String PROP_DOCKER_SERVICE_LABELS = "dockerServiceLabels";
    public static final String PROP_DOCKER_SERVICE_NAMES = "dockerServiceNames";
    public static final String PROP_HAZELCAST_PEER_PORT = "hazelcastPeerPort";
    public static final String PROP_SWARM_MGR_URI = "swarmMgrUri";
    public static final String PROP_SKIP_VERIFY_SSL = "skipVerifySsl";
    private SwarmDiscoveryUtil swarmDiscoveryUtil = null;

    public SwarmAddressPicker(ILogger iLogger) {
        String dockerNetworkNames = System.getProperty(PROP_DOCKER_NETWORK_NAMES);
        String dockerServiceLabels = System.getProperty(PROP_DOCKER_SERVICE_LABELS);
        String dockerServiceNames = System.getProperty(PROP_DOCKER_SERVICE_NAMES);
        Integer hazelcastPeerPort = Integer.valueOf(System.getProperty(PROP_HAZELCAST_PEER_PORT));
        String swarmMgrUri = System.getProperty(PROP_SWARM_MGR_URI);
        if (swarmMgrUri == null || swarmMgrUri.trim().isEmpty()) {
            swarmMgrUri = System.getenv("DOCKER_HOST");
        }
        Boolean skipVerifySsl = false;
        if (System.getProperty(PROP_SKIP_VERIFY_SSL) != null) {
            skipVerifySsl = Boolean.valueOf(System.getProperty(PROP_SKIP_VERIFY_SSL));
        }
        this.initialize(iLogger, dockerNetworkNames, dockerServiceLabels, dockerServiceNames, hazelcastPeerPort, swarmMgrUri, skipVerifySsl);
    }

    public SwarmAddressPicker(ILogger iLogger, String dockerNetworkNames, String dockerServiceLabels, String dockerServiceNames, Integer hazelcastPeerPort) {
        String swarmMgrUri = System.getenv("DOCKER_HOST");
        Boolean skipVerifySsl = false;
        this.initialize(iLogger, dockerNetworkNames, dockerServiceLabels, dockerServiceNames, hazelcastPeerPort, swarmMgrUri, skipVerifySsl);
    }

    private void initialize(ILogger iLogger, String dockerNetworkNames, String dockerServiceLabels, String dockerServiceNames, Integer hazelcastPeerPort, String swarmMgrUri, Boolean skipVerifySsl) {
        int port = hazelcastPeerPort != null ? hazelcastPeerPort : 5701;
        try {
            URI swarmMgr = null;
            if (swarmMgrUri == null || swarmMgrUri.trim().isEmpty()) {
                swarmMgr = new URI(System.getenv("DOCKER_HOST"));
            }
            this.swarmDiscoveryUtil = new SwarmDiscoveryUtil(dockerNetworkNames, dockerServiceLabels, dockerServiceNames, port, true, swarmMgr, skipVerifySsl);
        }
        catch (Exception e) {
            throw new RuntimeException("SwarmAddressPicker: Error constructing SwarmDiscoveryUtil: " + e.getMessage(), e);
        }
    }

    public void pickAddress() throws Exception {
    }

    public Address getBindAddress() {
        return this.swarmDiscoveryUtil.getMyAddress();
    }

    public Address getPublicAddress() {
        return this.swarmDiscoveryUtil.getMyAddress();
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.swarmDiscoveryUtil.getServerSocketChannel();
    }
}

