/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicePurpose;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.SavableDigestXof;
import org.bouncycastle.crypto.digests.Utils;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SHAKENativeDigest
implements SavableDigestXof {
    private final CryptoServicePurpose purpose;
    protected DigestRefWrapper nativeRef = null;
    private int bitLen;

    public SHAKENativeDigest(CryptoServicePurpose cryptoServicePurpose) {
        this(128, cryptoServicePurpose);
    }

    public SHAKENativeDigest(int n, CryptoServicePurpose cryptoServicePurpose) {
        if (!CryptoServicesRegistrar.hasEnabledService("SHA3")) {
            throw new IllegalStateException("no native SHAKE support");
        }
        this.purpose = cryptoServicePurpose;
        this.bitLen = n;
        this.nativeRef = new DigestRefWrapper(SHAKENativeDigest.makeNative(n));
        this.reset();
        CryptoServicesRegistrar.checkConstraints(this.cryptoServiceProperties());
    }

    public SHAKENativeDigest(int n) {
        this(n, CryptoServicePurpose.ANY);
    }

    public SHAKENativeDigest() {
        this(CryptoServicePurpose.ANY);
    }

    public SHAKENativeDigest(SHAKENativeDigest sHAKENativeDigest) {
        this(CryptoServicePurpose.ANY);
        byte[] byArray = sHAKENativeDigest.getEncodedState();
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    public SHAKENativeDigest(byte[] byArray, CryptoServicePurpose cryptoServicePurpose) {
        this(cryptoServicePurpose);
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    public SHAKENativeDigest(byte[] byArray) {
        this();
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    SHAKENativeDigest restoreState(byte[] byArray, int n) {
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return "SHAKE" + this.bitLen;
    }

    @Override
    public int getDigestSize() {
        return SHAKENativeDigest.getDigestSize(this.nativeRef.getReference());
    }

    @Override
    public void update(byte by) {
        SHAKENativeDigest.update(this.nativeRef.getReference(), by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        SHAKENativeDigest.update(this.nativeRef.getReference(), byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        int n2 = SHAKENativeDigest.doFinal(this.nativeRef.getReference(), byArray, n);
        return n2;
    }

    @Override
    public int doFinal(byte[] byArray, int n, int n2) {
        int n3 = SHAKENativeDigest.doFinal(this.nativeRef.getReference(), byArray, n, n2);
        return n3;
    }

    @Override
    public int doOutput(byte[] byArray, int n, int n2) {
        return SHAKENativeDigest.doOutput(this.nativeRef.getReference(), byArray, n, n2);
    }

    @Override
    public void reset() {
        SHAKENativeDigest.reset(this.nativeRef.getReference());
    }

    @Override
    public int getByteLength() {
        return SHAKENativeDigest.getByteLength(this.nativeRef.getReference());
    }

    @Override
    public Memoable copy() {
        return new SHAKENativeDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHAKENativeDigest sHAKENativeDigest = (SHAKENativeDigest)memoable;
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), sHAKENativeDigest.getEncodedState(), 0);
    }

    @Override
    public byte[] getEncodedState() {
        int n = SHAKENativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
        byte[] byArray = new byte[n];
        SHAKENativeDigest.encodeFullState(this.nativeRef.getReference(), byArray, 0);
        return byArray;
    }

    void restoreFullState(byte[] byArray, int n) {
        SHAKENativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
    }

    public String toString() {
        return "SHAKE[Native]()";
    }

    static native long makeNative(int var0);

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native int doOutput(long var0, byte[] var2, int var3, int var4);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, this.bitLen, this.purpose);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long l) {
            super(l, "SHAKE");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SHAKENativeDigest.destroy(l);
        }
    }
}

