/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("privateKeyInfoData array null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("privateKeyInfoData array empty");
        }
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        if (privateKeyInfo == null) {
            throw new IllegalArgumentException("keyInfo array null");
        }
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
            ASN1OctetString aSN1OctetString = PrivateKeyFactory.parseOctetString(privateKeyInfo.getPrivateKey(), 64);
            byte[] byArray = aSN1OctetString.getOctets();
            ASN1BitString aSN1BitString = privateKeyInfo.getPublicKeyData();
            if (aSN1BitString != null) {
                byte[] byArray2 = aSN1BitString.getOctets();
                return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length), byArray2);
            }
            return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length));
        }
        if (Utils.slhdsaParams.containsKey(aSN1ObjectIdentifier)) {
            SLHDSAParameters sLHDSAParameters = Utils.slhdsaParamsLookup(aSN1ObjectIdentifier);
            ASN1OctetString aSN1OctetString = PrivateKeyFactory.parseOctetString(privateKeyInfo.getPrivateKey(), sLHDSAParameters.getN() * 4);
            return new SLHDSAPrivateKeyParameters(sLHDSAParameters, aSN1OctetString.getOctets());
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_alg_ml_kem_512) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_alg_ml_kem_768) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_alg_ml_kem_1024)) {
            ASN1Primitive aSN1Primitive = PrivateKeyFactory.parsePrimitiveString(privateKeyInfo.getPrivateKey(), 64);
            MLKEMParameters mLKEMParameters = Utils.mlkemParamsLookup(aSN1ObjectIdentifier);
            MLKEMPublicKeyParameters mLKEMPublicKeyParameters = null;
            if (privateKeyInfo.getPublicKeyData() != null) {
                mLKEMPublicKeyParameters = PublicKeyFactory.MLKEMConverter.getPublicKeyParams(mLKEMParameters, privateKeyInfo.getPublicKeyData());
            }
            if (aSN1Primitive instanceof ASN1OctetString) {
                return new MLKEMPrivateKeyParameters(mLKEMParameters, ((ASN1OctetString)aSN1Primitive).getOctets(), mLKEMPublicKeyParameters);
            }
            if (aSN1Primitive instanceof ASN1Sequence) {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
                byte[] byArray = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets();
                byte[] byArray3 = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets();
                MLKEMPrivateKeyParameters mLKEMPrivateKeyParameters = new MLKEMPrivateKeyParameters(mLKEMParameters, byArray, mLKEMPublicKeyParameters);
                if (!Arrays.constantTimeAreEqual(mLKEMPrivateKeyParameters.getEncoded(), byArray3)) {
                    throw new IllegalArgumentException("inconsistent " + mLKEMParameters.getName() + " private key");
                }
                return mLKEMPrivateKeyParameters;
            }
            throw new IllegalArgumentException("invalid " + mLKEMParameters.getName() + " private key");
        }
        if (Utils.mldsaParams.containsKey(aSN1ObjectIdentifier)) {
            ASN1Primitive aSN1Primitive = PrivateKeyFactory.parsePrimitiveString(privateKeyInfo.getPrivateKey(), 32);
            MLDSAParameters mLDSAParameters = Utils.mldsaParamsLookup(aSN1ObjectIdentifier);
            MLDSAPublicKeyParameters mLDSAPublicKeyParameters = null;
            if (privateKeyInfo.getPublicKeyData() != null) {
                mLDSAPublicKeyParameters = PublicKeyFactory.MLDSAConverter.getPublicKeyParams(mLDSAParameters, privateKeyInfo.getPublicKeyData());
            }
            if (aSN1Primitive instanceof ASN1OctetString) {
                return new MLDSAPrivateKeyParameters(mLDSAParameters, ((ASN1OctetString)aSN1Primitive).getOctets(), mLDSAPublicKeyParameters);
            }
            if (aSN1Primitive instanceof ASN1Sequence) {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
                byte[] byArray = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets();
                byte[] byArray4 = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets();
                MLDSAPrivateKeyParameters mLDSAPrivateKeyParameters = new MLDSAPrivateKeyParameters(mLDSAParameters, byArray, mLDSAPublicKeyParameters);
                if (!Arrays.constantTimeAreEqual(mLDSAPrivateKeyParameters.getEncoded(), byArray4)) {
                    throw new IllegalArgumentException("inconsistent " + mLDSAParameters.getName() + " private key");
                }
                return mLDSAPrivateKeyParameters;
            }
            throw new IllegalArgumentException("invalid " + mLDSAParameters.getName() + " private key");
        }
        throw new RuntimeException("algorithm identifier in private key not recognised");
    }

    private static ASN1OctetString parseOctetString(ASN1OctetString aSN1OctetString, int n) throws IOException {
        byte[] byArray = aSN1OctetString.getOctets();
        if (byArray.length == n) {
            return aSN1OctetString;
        }
        ASN1OctetString aSN1OctetString2 = Utils.parseOctetData(byArray);
        if (aSN1OctetString2 != null) {
            return ASN1OctetString.getInstance(aSN1OctetString2);
        }
        return aSN1OctetString;
    }

    private static ASN1Primitive parsePrimitiveString(ASN1OctetString aSN1OctetString, int n) throws IOException {
        byte[] byArray = aSN1OctetString.getOctets();
        if (byArray.length == n) {
            return aSN1OctetString;
        }
        ASN1Primitive aSN1Primitive = Utils.parseData(byArray);
        if (aSN1Primitive instanceof ASN1OctetString) {
            return ASN1OctetString.getInstance(aSN1Primitive);
        }
        if (aSN1Primitive instanceof ASN1Sequence) {
            return ASN1Sequence.getInstance(aSN1Primitive);
        }
        return aSN1OctetString;
    }

    private static short[] convert(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i != sArray.length; ++i) {
            sArray[i] = Pack.littleEndianToShort(byArray, i * 2);
        }
        return sArray;
    }
}

