// Targeted by JavaCPP version 1.5.2: DO NOT EDIT THIS FILE

package org.bytedeco.hdf5;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.hdf5.global.hdf5.*;


/** \class EnumType
    \brief EnumType is a derivative of a DataType and operates on HDF5
    enum datatypes.
*/
//  Inheritance: DataType -> H5Object -> H5Location -> IdComponent
@Namespace("H5") @Properties(inherit = org.bytedeco.hdf5.presets.hdf5.class)
public class EnumType extends DataType {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public EnumType(Pointer p) { super(p); }

        // Creates an empty enumeration datatype based on a native signed
        // integer type, whose size is given by size.
        public EnumType(@Cast("size_t") long size) { super((Pointer)null); allocate(size); }
        private native void allocate(@Cast("size_t") long size);

        // Gets the enum datatype of the specified dataset
        public EnumType(@Const @ByRef DataSet dataset) { super((Pointer)null); allocate(dataset); }
        private native void allocate(@Const @ByRef DataSet dataset);  // H5Dget_type

        // Creates a new enum datatype based on an integer datatype
        public EnumType(@Const @ByRef IntType data_type) { super((Pointer)null); allocate(data_type); }
        private native void allocate(@Const @ByRef IntType data_type);  // H5Tenum_create

        // Constructors that open an enum datatype, given a location.
        public EnumType(@Const @ByRef H5Location loc, @Cast("const char*") BytePointer name) { super((Pointer)null); allocate(loc, name); }
        private native void allocate(@Const @ByRef H5Location loc, @Cast("const char*") BytePointer name);
        public EnumType(@Const @ByRef H5Location loc, String name) { super((Pointer)null); allocate(loc, name); }
        private native void allocate(@Const @ByRef H5Location loc, String name);

        // Returns an EnumType object via DataType* by decoding the
        // binary object description of this type.
        public native DataType decode();

        // Returns the number of members in this enumeration datatype.
        public native int getNmembers();

        // Returns the index of a member in this enumeration data type.
        public native int getMemberIndex(@Cast("const char*") BytePointer name);
        public native int getMemberIndex(String name);

        // Returns the value of an enumeration datatype member
        public native void getMemberValue(@Cast("unsigned") int memb_no, Pointer value);

        // Inserts a new member to this enumeration type.
        public native void insert(@Cast("const char*") BytePointer name, Pointer value);
        public native void insert(String name, Pointer value);

        // Returns the symbol name corresponding to a specified member
        // of this enumeration datatype.
        public native @StdString BytePointer nameOf(Pointer value, @Cast("size_t") long size);

        // Returns the value corresponding to a specified member of this
        // enumeration datatype.
        public native void valueOf(@Cast("const char*") BytePointer name, Pointer value);
        public native void valueOf(String name, Pointer value);

        /**\brief Returns this class name. */
        public native @StdString BytePointer fromClass();

        // Default constructor
        public EnumType() { super((Pointer)null); allocate(); }
        private native void allocate();

        // Creates an enumeration datatype using an existing id

        // Copy constructor: same as the original EnumType.
        public EnumType(@Const @ByRef EnumType original) { super((Pointer)null); allocate(original); }
        private native void allocate(@Const @ByRef EnumType original);

}
