/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k;

import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.KeyValueStore;
import org.cache2k.jmx.CacheInfoMXBean;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;

public interface Cache<K, V>
extends KeyValueStore<K, V>,
Closeable {
    public String getName();

    @Override
    public V get(K var1);

    public CacheEntry<K, V> getEntry(K var1);

    @Override
    public void prefetch(K var1);

    @Override
    public void prefetchAll(Iterable<? extends K> var1, CacheOperationCompletionListener var2);

    public V peek(K var1);

    public CacheEntry<K, V> peekEntry(K var1);

    public boolean containsKey(K var1);

    @Override
    public void put(K var1, V var2);

    public V computeIfAbsent(K var1, Callable<V> var2);

    public boolean putIfAbsent(K var1, V var2);

    public V peekAndReplace(K var1, V var2);

    public boolean replace(K var1, V var2);

    public boolean replaceIfEquals(K var1, V var2, V var3);

    public V peekAndRemove(K var1);

    public boolean containsAndRemove(K var1);

    @Override
    public void remove(K var1);

    public boolean removeIfEquals(K var1, V var2);

    @Override
    public void removeAll(Iterable<? extends K> var1);

    public V peekAndPut(K var1, V var2);

    public void expireAt(K var1, long var2);

    public void loadAll(Iterable<? extends K> var1, CacheOperationCompletionListener var2);

    public void reloadAll(Iterable<? extends K> var1, CacheOperationCompletionListener var2);

    public <R> R invoke(K var1, EntryProcessor<K, V, R> var2);

    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> var1, EntryProcessor<K, V, R> var2);

    @Override
    public Map<K, V> getAll(Iterable<? extends K> var1);

    public Map<K, V> peekAll(Iterable<? extends K> var1);

    @Override
    public void putAll(Map<? extends K, ? extends V> var1);

    public Iterable<K> keys();

    public Iterable<CacheEntry<K, V>> entries();

    public void removeAll();

    public void clear();

    public void clearAndClose();

    @Override
    public void close();

    public CacheManager getCacheManager();

    public boolean isClosed();

    public String toString();

    public <X> X requestInterface(Class<X> var1);

    public ConcurrentMap<K, V> asMap();

    public CacheInfoMXBean getStatistics();
}

