/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.expiry;

import org.cache2k.expiry.ExpiryTimeValues;

public class Expiry
implements ExpiryTimeValues {
    public static long toSharpTime(long millis) {
        if (millis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        if (millis < 0L) {
            return millis;
        }
        return -millis;
    }

    public static long earliestTime(long loadTime, long candidate1, long candidate2) {
        if (candidate1 >= loadTime && (candidate1 < candidate2 || candidate2 < loadTime)) {
            return candidate1;
        }
        if (candidate2 >= loadTime) {
            return candidate2;
        }
        return Long.MAX_VALUE;
    }

    public static long mixTimeSpanAndPointInTime(long loadTime, long refreshAfter, long pointInTime) {
        long refreshTime = loadTime + refreshAfter;
        if (refreshTime < 0L) {
            refreshTime = Long.MAX_VALUE;
        }
        if (pointInTime == Long.MAX_VALUE) {
            return refreshTime;
        }
        if (pointInTime > refreshTime) {
            return refreshTime;
        }
        long absPointInTime = Math.abs(pointInTime);
        if (absPointInTime <= refreshTime) {
            return pointInTime;
        }
        long pointInTimeMinusDelta = absPointInTime - refreshAfter;
        if (pointInTimeMinusDelta < refreshTime) {
            return pointInTimeMinusDelta;
        }
        return refreshTime;
    }
}

