/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.casbin.jcasbin.config.Config;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.Policy;
import org.casbin.jcasbin.util.Util;

public class Model
extends Policy {
    private static final Map<String, String> sectionNameMap = new HashMap<String, String>();
    protected int modCount;
    private int domainIndex = -1;
    private String defaultDomain = "";
    private String defaultSeparator = "::";

    public Model() {
        this.model = new HashMap();
    }

    public int getModCount() {
        return this.modCount;
    }

    private boolean loadAssertion(Model model, Config cfg, String sec, String key) {
        String value = cfg.getString(sectionNameMap.get(sec) + "::" + key);
        return model.addDef(sec, key, value);
    }

    public boolean addDef(String sec, String key, String value) {
        Assertion ast = new Assertion();
        ast.key = key;
        ast.value = value;
        ast.initPriorityIndex();
        if ("".equals(ast.value)) {
            return false;
        }
        if ("r".equals(sec) || "p".equals(sec)) {
            ast.tokens = Util.splitCommaDelimited(ast.value);
            for (int i = 0; i < ast.tokens.length; ++i) {
                ast.tokens[i] = key + "_" + ast.tokens[i];
                if (!"p_priority".equals(ast.tokens[i])) continue;
                ast.priorityIndex = i;
            }
        } else {
            ast.value = Util.removeComments(Util.escapeAssertion(ast.value));
        }
        if (!this.model.containsKey(sec)) {
            this.model.put(sec, new HashMap());
        }
        ((Map)this.model.get(sec)).put(key, ast);
        ++this.modCount;
        return true;
    }

    private String getKeySuffix(int i) {
        if (i == 1) {
            return "";
        }
        return Integer.toString(i);
    }

    private void loadSection(Model model, Config cfg, String sec) {
        int i = 1;
        while (this.loadAssertion(model, cfg, sec, sec + this.getKeySuffix(i))) {
            ++i;
        }
    }

    private void loadSections(Config cfg) {
        this.loadSection(this, cfg, "r");
        this.loadSection(this, cfg, "p");
        this.loadSection(this, cfg, "e");
        this.loadSection(this, cfg, "m");
        this.loadSection(this, cfg, "g");
    }

    public void loadModel(String path) {
        Config cfg = Config.newConfig(path);
        this.loadSections(cfg);
    }

    public void loadModelFromText(String text) {
        Config cfg = Config.newConfigFromText(text);
        this.loadSections(cfg);
    }

    private String saveSectionToText(String sec) {
        StringBuilder res = new StringBuilder("[" + sectionNameMap.get(sec) + "]\n");
        Map section = (Map)this.model.get(sec);
        if (section == null) {
            return "";
        }
        for (Map.Entry entry : section.entrySet()) {
            res.append(String.format("%s = %s\n", entry.getKey(), ((Assertion)entry.getValue()).value.replace("_", ".")));
        }
        return res.toString();
    }

    public String saveModelToText() {
        StringBuilder res = new StringBuilder();
        res.append(this.saveSectionToText("r"));
        res.append("\n");
        res.append(this.saveSectionToText("p"));
        res.append("\n");
        String g = this.saveSectionToText("g");
        g = g.replace(".", "_");
        res.append(g);
        if (!"".equals(g)) {
            res.append("\n");
        }
        res.append(this.saveSectionToText("e"));
        res.append("\n");
        res.append(this.saveSectionToText("m"));
        return res.toString();
    }

    public void printModel() {
        Util.logPrint("Model:");
        for (Map.Entry entry : this.model.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                Util.logPrintf("%s.%s: %s", (String)entry.getKey(), (String)entry2.getKey(), ((Assertion)entry2.getValue()).value);
            }
        }
    }

    public void sortPoliciesByPriority() {
        if (!this.model.containsKey("p")) {
            return;
        }
        for (Map.Entry entry : ((Map)this.model.get("p")).entrySet()) {
            Assertion assertion = (Assertion)entry.getValue();
            int priorityIndex = assertion.priorityIndex;
            if (priorityIndex < 0) continue;
            assertion.policy.sort(Comparator.comparingInt(p -> Integer.parseInt((String)p.get(priorityIndex))));
            for (int i = 0; i < assertion.policy.size(); ++i) {
                assertion.policyIndex.put(assertion.policy.get(i).toString(), i);
            }
        }
    }

    public void sortPoliciesBySubjectHieraichy() {
        if (this.model.get("e") == null || !"subjectPriority(p_eft) || deny".equals(((Assertion)((Map)this.model.get((Object)"e")).get((Object)"e")).value)) {
            return;
        }
        for (Map.Entry entry : ((Map)this.model.get("p")).entrySet()) {
            Map<String, Integer> subjectHierarchyMap = this.getSubjectHierarchyMap(((Assertion)((Map)this.model.get((Object)"g")).get((Object)"g")).policy);
            Assertion assertion = (Assertion)entry.getValue();
            this.domainIndex = -1;
            for (int i = 0; i < assertion.tokens.length; ++i) {
                if (!assertion.tokens[i].equals(assertion.key + "_dom")) continue;
                this.domainIndex = i;
                break;
            }
            Collections.sort(assertion.policy, (o1, o2) -> {
                String domain1 = this.domainIndex != -1 ? (String)o1.get(this.domainIndex) : this.defaultDomain;
                String domain2 = this.domainIndex != -1 ? (String)o2.get(this.domainIndex) : this.defaultDomain;
                int priority1 = (Integer)subjectHierarchyMap.get(this.getNameWithDomain(domain1, (String)o1.get(0)));
                int priority2 = (Integer)subjectHierarchyMap.get(this.getNameWithDomain(domain2, (String)o2.get(0)));
                return priority2 - priority1;
            });
        }
    }

    public Map<String, Integer> getSubjectHierarchyMap(List<List<String>> policies) {
        HashMap<String, Integer> subjectHierarchyMap = new HashMap<String, Integer>();
        HashMap<String, String> policyMap = new HashMap<String, String>();
        String domain = this.defaultDomain;
        for (List<String> policy : policies) {
            if (policy.size() != 2) {
                domain = (String)policy.get(2);
            }
            String child = this.getNameWithDomain(domain, (String)policy.get(0));
            String parent = this.getNameWithDomain(domain, (String)policy.get(1));
            policyMap.put(child, parent);
            if (!subjectHierarchyMap.containsKey(child)) {
                subjectHierarchyMap.put(child, 0);
            }
            if (!subjectHierarchyMap.containsKey(parent)) {
                subjectHierarchyMap.put(parent, 0);
            }
            subjectHierarchyMap.replace(child, 1);
        }
        ArrayList<String> set = new ArrayList<String>();
        for (String key : subjectHierarchyMap.keySet()) {
            if ((Integer)subjectHierarchyMap.get(key) == 0) continue;
            set.add(key);
        }
        while (!set.isEmpty()) {
            String child = (String)set.get(0);
            this.findHierarchy(policyMap, subjectHierarchyMap, set, child);
        }
        return subjectHierarchyMap;
    }

    private void findHierarchy(Map<String, String> policyMap, Map<String, Integer> subjectHierarchyMap, List<String> set, String child) {
        set.remove(child);
        String parent = policyMap.get(child);
        if (set.contains(parent)) {
            this.findHierarchy(policyMap, subjectHierarchyMap, set, parent);
        }
        subjectHierarchyMap.replace(child, subjectHierarchyMap.get(parent) + 10);
    }

    public String getNameWithDomain(String domain, String name) {
        return domain + this.defaultSeparator + name;
    }

    static {
        sectionNameMap.put("r", "request_definition");
        sectionNameMap.put("p", "policy_definition");
        sectionNameMap.put("g", "role_definition");
        sectionNameMap.put("e", "policy_effect");
        sectionNameMap.put("m", "matchers");
    }

    public static enum PolicyOperations {
        POLICY_ADD,
        POLICY_REMOVE;

    }
}

