/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.rbac;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.casbin.jcasbin.rbac.Role;
import org.casbin.jcasbin.rbac.RoleManager;
import org.casbin.jcasbin.util.SyncedLRUCache;
import org.casbin.jcasbin.util.Util;

public class DefaultRoleManager
implements RoleManager {
    private static final String DEFAULT_DOMAIN = "casbin::default";
    Map<String, Role> allRoles;
    private final int maxHierarchyLevel;
    private BiPredicate<String, String> matchingFunc;
    private SyncedLRUCache<String, Boolean> matchingFuncCache;

    public DefaultRoleManager(int maxHierarchyLevel) {
        this(maxHierarchyLevel, null, null);
    }

    public DefaultRoleManager(int maxHierarchyLevel, BiPredicate<String, String> matchingFunc, BiPredicate<String, String> domainMatchingFunc) {
        this.clear();
        this.maxHierarchyLevel = maxHierarchyLevel;
        this.matchingFunc = matchingFunc;
    }

    public void addMatchingFunc(String name, BiPredicate<String, String> matchingFunc) {
        this.matchingFunc = matchingFunc;
        this.rebuild();
    }

    public void addDomainMatchingFunc(String name, BiPredicate<String, String> domainMatchingFunc) {
    }

    private void rebuild() {
        HashMap<String, Role> roles = new HashMap<String, Role>(this.allRoles);
        this.clear();
        roles.values().forEach(user -> user.getAllRoles().keySet().forEach(roleName -> this.addLink(user.getName(), (String)roleName, DEFAULT_DOMAIN)));
    }

    private boolean match(String str, String pattern) {
        String cacheKey = String.join((CharSequence)"$$", str, pattern);
        Boolean matched = this.matchingFuncCache.get(cacheKey);
        if (matched == null) {
            matched = this.matchingFunc != null ? Boolean.valueOf(this.matchingFunc.test(str, pattern)) : Boolean.valueOf(str.equals(pattern));
            this.matchingFuncCache.put(cacheKey, matched);
        }
        return matched;
    }

    private Role getRole(String name) {
        Role role = this.allRoles.get(name);
        if (role == null) {
            role = new Role(name);
            this.allRoles.put(name, role);
            if (this.matchingFunc != null) {
                for (Map.Entry<String, Role> entry : this.allRoles.entrySet()) {
                    String name2 = entry.getKey();
                    Role role2 = entry.getValue();
                    if (!name.equals(name2) && this.match(name, name2)) {
                        role2.addMatch(role);
                    }
                    if (name.equals(name2) || !this.match(name2, name)) continue;
                    role.addMatch(role2);
                }
            }
        }
        return role;
    }

    private void removeRole(String name) {
        Role role = this.allRoles.get(name);
        if (role != null) {
            this.allRoles.remove(name);
            role.removeMatches();
        }
    }

    void copyFrom(DefaultRoleManager other) {
        other.allRoles.values().forEach(user -> user.roles.keySet().forEach(roleName -> this.addLink(user.getName(), (String)roleName, DEFAULT_DOMAIN)));
    }

    @Override
    public void clear() {
        this.matchingFuncCache = new SyncedLRUCache(100);
        this.allRoles = new HashMap<String, Role>();
    }

    @Override
    public void addLink(String name1, String name2, String ... domain) {
        Role user = this.getRole(name1);
        Role role = this.getRole(name2);
        user.addRole(role);
    }

    @Override
    public void deleteLink(String name1, String name2, String ... domain) {
        Role user = this.getRole(name1);
        Role role = this.getRole(name2);
        user.removeRole(role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasLink(String name1, String name2, String ... domain) {
        if (name1.equals(name2) || this.matchingFunc != null && this.matchingFunc.test(name1, name2)) {
            return true;
        }
        boolean userCreated = !this.allRoles.containsKey(name1);
        boolean roleCreated = !this.allRoles.containsKey(name2);
        Role user = this.getRole(name1);
        Role role = this.getRole(name2);
        try {
            boolean bl = this.hasLinkHelper(role.getName(), Collections.singletonMap(user.getName(), user), this.maxHierarchyLevel);
            return bl;
        }
        finally {
            if (userCreated) {
                this.removeRole(user.getName());
            }
            if (roleCreated) {
                this.removeRole(role.getName());
            }
        }
    }

    private boolean hasLinkHelper(String targetName, Map<String, Role> roles, int level) {
        if (level < 0 || roles.size() == 0) {
            return false;
        }
        HashMap<String, Role> nextRoles = new HashMap<String, Role>();
        for (Map.Entry<String, Role> entry : roles.entrySet()) {
            Role role = entry.getValue();
            if (targetName.equals(role.getName()) || this.matchingFunc != null && this.match(role.getName(), targetName)) {
                return true;
            }
            nextRoles.putAll(role.getAllRoles());
        }
        return this.hasLinkHelper(targetName, nextRoles, level - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRoles(String name, String ... domain) {
        boolean created = !this.allRoles.containsKey(name);
        Role user = this.getRole(name);
        try {
            List<String> list = user.getRoles();
            return list;
        }
        finally {
            if (created) {
                this.removeRole(user.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsers(String name, String ... domain) {
        boolean created = !this.allRoles.containsKey(name);
        Role role = this.getRole(name);
        try {
            List<String> list = role.getUsers();
            return list;
        }
        finally {
            if (created) {
                this.removeRole(role.getName());
            }
        }
    }

    public String toString() {
        ArrayList roles = new ArrayList();
        this.allRoles.values().forEach(role -> {
            if (!"".equals(role.toString())) {
                roles.add(role.toString());
            }
        });
        return String.join((CharSequence)"\n", roles);
    }

    @Override
    public void printRoles() {
        Util.logPrint(this.toString());
    }
}

