/*
 * Decompiled with CFR 0.152.
 */
package clojure.tools.nrepl;

import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Seqable;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Connection
implements Closeable {
    private static Var connect;
    private static Var urlConnect;
    private static Var createClient;
    private static Var clientSession;
    private static Var newSession;
    private static Var message;
    private static Var combineResponses;
    private static Var map;
    private static Var readString;
    private static Var stringifyKeys;
    public final Closeable transport;
    public final IFn client;
    public final String url;

    public static Var find(String ns, String name) {
        return Var.find((Symbol)Symbol.intern((String)ns, (String)name));
    }

    public Connection(String url) throws Exception {
        this(url, Long.MAX_VALUE);
    }

    public Connection(String url, long readTimeout) throws Exception {
        this.url = url;
        this.transport = (Closeable)urlConnect.invoke((Object)this.url);
        this.client = (IFn)createClient.invoke((Object)this.transport, (Object)readTimeout);
    }

    public void close() throws IOException {
        this.transport.close();
    }

    public Response send(String ... kvs) {
        try {
            PersistentHashMap msg = PersistentHashMap.createWithCheck((Object[])kvs);
            return new Response((ISeq)message.invoke((Object)this.client, (Object)msg));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Response sendSession(String session, String ... kvs) {
        try {
            PersistentHashMap msg = PersistentHashMap.createWithCheck((Object[])kvs);
            return new Response((ISeq)message.invoke(clientSession.invoke((Object)this.client, (Object)Keyword.intern((String)"session"), (Object)session), (Object)msg));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String newSession(String cloneSessionId) {
        try {
            if (cloneSessionId == null) {
                return (String)newSession.invoke((Object)this.client);
            }
            return (String)newSession.invoke((Object)this.client, (Object)Keyword.intern((String)"clone"), (Object)cloneSessionId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            RT.var((String)"clojure.core", (String)"require").invoke((Object)Symbol.intern((String)"clojure.tools.nrepl"));
            RT.var((String)"clojure.core", (String)"require").invoke((Object)Symbol.intern((String)"clojure.walk"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        connect = Connection.find("clojure.tools.nrepl", "connect");
        urlConnect = Connection.find("clojure.tools.nrepl", "url-connect");
        createClient = Connection.find("clojure.tools.nrepl", "client");
        clientSession = Connection.find("clojure.tools.nrepl", "client-session");
        newSession = Connection.find("clojure.tools.nrepl", "new-session");
        message = Connection.find("clojure.tools.nrepl", "message");
        combineResponses = Connection.find("clojure.tools.nrepl", "combine-responses");
        map = Connection.find("clojure.core", "map");
        readString = Connection.find("clojure.core", "read-string");
        stringifyKeys = Connection.find("clojure.walk", "stringify-keys");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Response
    implements Seqable {
        private ISeq responses;
        private Map<String, Object> response;

        private Response(ISeq responses) {
            this.responses = responses;
        }

        public synchronized Map<String, Object> combinedResponse() {
            try {
                if (this.response == null) {
                    this.response = (Map)stringifyKeys.invoke(combineResponses.invoke((Object)this.responses));
                    this.responses = null;
                }
                return this.response;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Set<String> statuses() {
            try {
                return (Set)this.combinedResponse().get("status");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<Object> values() {
            try {
                return (List)map.invoke((Object)readString, this.combinedResponse().get("value"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public ISeq seq() {
            return this.responses;
        }
    }
}

