/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.csharp;

import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.freemarker.FreemarkerJavaDoc;
import org.apache.commons.digester.RuleSet;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.config.WsdlInfo;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.jaxws.WebFault;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.ArtifactType;
import org.codehaus.enunciate.main.ClientLibraryArtifact;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.main.NamedFileArtifact;
import org.codehaus.enunciate.modules.FacetAware;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;
import org.codehaus.enunciate.modules.csharp.CSharpValidator;
import org.codehaus.enunciate.modules.csharp.ClientClassnameForMethod;
import org.codehaus.enunciate.modules.csharp.ListsAsArraysClientClassnameForMethod;
import org.codehaus.enunciate.modules.csharp.RequestDocumentQNameMethod;
import org.codehaus.enunciate.modules.csharp.ResponseDocumentQNameMethod;
import org.codehaus.enunciate.modules.csharp.config.CSharpRuleSet;
import org.codehaus.enunciate.modules.csharp.config.PackageNamespaceConversion;
import org.codehaus.enunciate.template.freemarker.AccessorOverridesAnotherMethod;
import org.codehaus.enunciate.template.freemarker.ClassnameForMethod;
import org.codehaus.enunciate.template.freemarker.ClientPackageForMethod;
import org.codehaus.enunciate.template.freemarker.FindRootElementMethod;
import org.codehaus.enunciate.template.freemarker.SimpleNameWithParamsMethod;
import org.codehaus.enunciate.util.TypeDeclarationComparator;

public class CSharpDeploymentModule
extends FreemarkerDeploymentModule
implements FacetAware {
    private boolean require = false;
    private boolean disableCompile = true;
    private String label = null;
    private String compileExecutable = null;
    private String compileCommand = "%s /target:library /out:%s /r:System.Web.Services /doc:%s %s";
    private final Map<String, String> packageToNamespaceConversions = new HashMap<String, String>();
    private String bundleFileName = null;
    private String DLLFileName = null;
    private String docXmlFileName = null;
    private String sourceFileName = null;
    private boolean singleFilePerClass = false;
    private Set<String> facetIncludes = new TreeSet<String>();
    private Set<String> facetExcludes = new TreeSet<String>();

    public String getName() {
        return "csharp";
    }

    public void init(Enunciate enunciate) throws EnunciateException {
        super.init(enunciate);
        if (!super.isDisabled()) {
            if (this.isDisableCompile()) {
                this.info("C# compilation is disabled, but the source code will still be generated.", new Object[0]);
                this.setCompileExecutable(null);
            } else {
                String compileExectuable = this.getCompileExecutable();
                if (compileExectuable == null) {
                    int exitCode;
                    int len;
                    byte[] buffer;
                    InputStream in;
                    Process process;
                    String osName = System.getProperty("os.name");
                    if (osName != null && osName.toUpperCase().contains("WINDOWS")) {
                        this.debug("Attempting to execute command \"csc /help\" for the current environment (%s).", new Object[]{osName});
                        try {
                            process = new ProcessBuilder("csc", "/help").redirectErrorStream(true).start();
                            in = process.getInputStream();
                            buffer = new byte[1024];
                            len = in.read(buffer);
                            while (len > 0) {
                                len = in.read(buffer);
                            }
                            exitCode = process.waitFor();
                            if (exitCode != 0) {
                                this.debug("Command \"csc /help\" failed with exit code " + exitCode + ".", new Object[0]);
                            } else {
                                compileExectuable = "csc";
                                this.debug("C# compile executable to be used: csc", new Object[0]);
                            }
                        }
                        catch (Throwable e) {
                            this.debug("Command \"csc /help\" failed (" + e.getMessage() + ").", new Object[0]);
                        }
                    }
                    if (compileExectuable == null) {
                        this.debug("Attempting to execute command \"gmcs /help\" for the current environment (%s).", new Object[]{osName});
                        try {
                            process = new ProcessBuilder("gmcs", "/help").redirectErrorStream(true).start();
                            in = process.getInputStream();
                            buffer = new byte[1024];
                            len = in.read(buffer);
                            while (len > 0) {
                                len = in.read(buffer);
                            }
                            exitCode = process.waitFor();
                            if (exitCode != 0) {
                                this.debug("Command \"gmcs /help\" failed with exit code " + exitCode + ".", new Object[0]);
                            } else {
                                compileExectuable = "gmcs";
                                this.debug("C# compile executable to be used: %s", new Object[]{compileExectuable});
                            }
                        }
                        catch (Throwable e) {
                            this.debug("Command \"gmcs /help\" failed (" + e.getMessage() + ").", new Object[0]);
                        }
                    }
                    if (compileExectuable == null && this.isRequire()) {
                        throw new EnunciateException("C# client code generation is required, but there was no valid compile executable found. Please supply one in the configuration file, or set it up on your system path.");
                    }
                    this.setCompileExecutable(compileExectuable);
                }
            }
        }
    }

    public void initModel(EnunciateFreemarkerModel model) {
        super.initModel(model);
        if (!this.isDisabled()) {
            String pckg;
            TreeSet<WebFault> allFaults = new TreeSet<WebFault>((Comparator<WebFault>)new TypeDeclarationComparator());
            for (WsdlInfo wsdlInfo : model.getNamespacesToWSDLs().values()) {
                for (EndpointInterface ei : wsdlInfo.getEndpointInterfaces()) {
                    pckg = ei.getPackage().getQualifiedName();
                    if (!this.packageToNamespaceConversions.containsKey(pckg)) {
                        this.packageToNamespaceConversions.put(pckg, this.packageToNamespace(pckg));
                    }
                    for (WebMethod webMethod : ei.getWebMethods()) {
                        for (WebFault webFault : webMethod.getWebFaults()) {
                            allFaults.add(webFault);
                        }
                    }
                }
            }
            for (WebFault webFault : allFaults) {
                String pckg2 = webFault.getPackage().getQualifiedName();
                if (this.packageToNamespaceConversions.containsKey(pckg2)) continue;
                this.packageToNamespaceConversions.put(pckg2, this.packageToNamespace(pckg2));
            }
            for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
                for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                    pckg = typeDefinition.getPackage().getQualifiedName();
                    if (this.packageToNamespaceConversions.containsKey(pckg)) continue;
                    this.packageToNamespaceConversions.put(pckg, this.packageToNamespace(pckg));
                }
            }
        }
    }

    protected String packageToNamespace(String pckg) {
        if (pckg == null) {
            return null;
        }
        StringBuilder ns = new StringBuilder();
        StringTokenizer toks = new StringTokenizer(pckg, ".");
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            ns.append(Character.toString(tok.charAt(0)).toUpperCase());
            if (tok.length() > 1) {
                ns.append(tok.substring(1));
            }
            if (!toks.hasMoreTokens()) continue;
            ns.append('.');
        }
        return ns.toString();
    }

    public void doFreemarkerGenerate() throws IOException, TemplateException {
        File genDir = this.getGenerateDir();
        if (!this.enunciate.isUpToDateWithSources(genDir)) {
            EnunciateFreemarkerModel model = this.getModel();
            ClientPackageForMethod namespaceFor = new ClientPackageForMethod(this.packageToNamespaceConversions);
            namespaceFor.setUseClientNameConversions(true);
            model.put("namespaceFor", (Object)namespaceFor);
            model.put("findRootElement", (Object)new FindRootElementMethod());
            model.put("requestDocumentQName", (Object)new RequestDocumentQNameMethod());
            model.put("responseDocumentQName", (Object)new ResponseDocumentQNameMethod());
            ClientClassnameForMethod classnameFor = new ClientClassnameForMethod(this.packageToNamespaceConversions);
            classnameFor.setUseClientNameConversions(true);
            model.put("classnameFor", (Object)classnameFor);
            model.put("listsAsArraysClassnameFor", (Object)new ListsAsArraysClientClassnameForMethod(this.packageToNamespaceConversions));
            model.put("simpleNameFor", (Object)new SimpleNameWithParamsMethod((ClassnameForMethod)classnameFor));
            model.put("csFileName", (Object)this.getSourceFileName());
            model.put("accessorOverridesAnother", (Object)new AccessorOverridesAnotherMethod());
            this.debug("Generating the C# client classes...", new Object[0]);
            URL apiTemplate = this.isSingleFilePerClass() ? this.getTemplateURL("api-multiple-files.fmt") : this.getTemplateURL("api.fmt");
            this.processTemplate(apiTemplate, model);
        } else {
            this.info("Skipping C# code generation because everything appears up-to-date.", new Object[0]);
        }
    }

    protected void doCompile() throws EnunciateException, IOException {
        File compileDir = this.getCompileDir();
        Enunciate enunciate = this.getEnunciate();
        String compileExecutable = this.getCompileExecutable();
        if (this.getCompileExecutable() != null) {
            if (!enunciate.isUpToDateWithSources(compileDir)) {
                int procCode;
                compileDir.mkdirs();
                String compileCommand = this.getCompileCommand();
                if (compileCommand == null) {
                    throw new IllegalStateException("Somehow the \"compile\" step was invoked on the C# module without a valid compile command.");
                }
                compileCommand = compileCommand.replace(' ', '\u0000');
                File dll = new File(compileDir, this.getDLLFileName());
                File docXml = new File(compileDir, this.getDocXmlFileName());
                File sourceFile = new File(this.getGenerateDir(), this.getSourceFileName());
                compileCommand = String.format(compileCommand, compileExecutable, dll.getAbsolutePath(), docXml.getAbsolutePath(), sourceFile.getAbsolutePath());
                StringTokenizer tokenizer = new StringTokenizer(compileCommand, "\u0000");
                ArrayList<String> command = new ArrayList<String>();
                while (tokenizer.hasMoreElements()) {
                    command.add((String)tokenizer.nextElement());
                }
                Process process = new ProcessBuilder(command).redirectErrorStream(true).directory(compileDir).start();
                BufferedReader procReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = procReader.readLine();
                while (line != null) {
                    this.info(line, new Object[0]);
                    line = procReader.readLine();
                }
                try {
                    procCode = process.waitFor();
                }
                catch (InterruptedException e1) {
                    throw new EnunciateException("Unexpected inturruption of the C# compile process.");
                }
                if (procCode != 0) {
                    throw new EnunciateException("C# compile failed.");
                }
                enunciate.addArtifact((Artifact)new FileArtifact(this.getName(), "csharp.assembly", dll));
                if (docXml.exists()) {
                    enunciate.addArtifact((Artifact)new FileArtifact(this.getName(), "csharp.docs.xml", docXml));
                }
            } else {
                this.info("Skipping C# compile because everything appears up-to-date.", new Object[0]);
            }
        } else {
            this.debug("Skipping C# compile because a compile executale was neither found nor provided.  The C# bundle will only include the sources.", new Object[0]);
        }
    }

    protected void doBuild() throws EnunciateException, IOException {
        File buildDir;
        Enunciate enunciate = this.getEnunciate();
        if (!enunciate.isUpToDateWithSources(buildDir = this.getBuildDir())) {
            File compileDir = this.getCompileDir();
            compileDir.mkdirs();
            enunciate.copyDir(this.getGenerateDir(), compileDir, new File[0]);
            buildDir.mkdirs();
            File bundle = new File(buildDir, this.getBundleFileName());
            enunciate.zip(bundle, new File[]{compileDir});
            ClientLibraryArtifact artifactBundle = new ClientLibraryArtifact(this.getName(), "csharp.client.library", ".NET Client Library");
            artifactBundle.setPlatform(".NET 2.0");
            StringBuilder builder = new StringBuilder("C# source code");
            boolean docsExist = new File(compileDir, this.getDocXmlFileName()).exists();
            boolean dllExists = new File(compileDir, this.getDLLFileName()).exists();
            if (docsExist && dllExists) {
                builder.append(", the assembly, and the XML docs");
            } else if (dllExists) {
                builder.append("and the assembly");
            }
            String description = this.readResource("library_description.fmt", builder.toString());
            artifactBundle.setDescription(description);
            NamedFileArtifact binariesJar = new NamedFileArtifact(this.getName(), "dotnet.client.bundle", bundle);
            binariesJar.setArtifactType(ArtifactType.binaries);
            binariesJar.setDescription(String.format("The %s for the .NET client library.", builder.toString()));
            binariesJar.setPublic(false);
            artifactBundle.addArtifact((FileArtifact)binariesJar);
            enunciate.addArtifact((Artifact)artifactBundle);
        }
    }

    protected String readResource(String resource, String contains) throws IOException, EnunciateException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("sample_service_method", this.getModelInternal().findExampleWebMethod());
        model.put("sample_resource", this.getModelInternal().findExampleResourceMethod());
        model.put("bundle_contains", contains);
        URL res = CSharpDeploymentModule.class.getResource(resource);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        try {
            this.processTemplate(res, model, out);
            out.flush();
            bytes.flush();
            return bytes.toString("utf-8");
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    protected String getBundleFileName() {
        if (this.bundleFileName != null) {
            return this.bundleFileName;
        }
        String label = this.getLabel();
        if (label == null) {
            label = this.getEnunciate().getConfig().getLabel();
        }
        return label + "-dotnet.zip";
    }

    public void setBundleFileName(String bundleFileName) {
        this.bundleFileName = bundleFileName;
    }

    protected String getDLLFileName() {
        if (this.DLLFileName != null) {
            return this.DLLFileName;
        }
        String label = this.getLabel();
        if (label == null) {
            label = this.getEnunciate().getConfig().getLabel();
        }
        return label + ".dll";
    }

    public void setDLLFileName(String DLLFileName) {
        this.DLLFileName = DLLFileName;
    }

    protected String getDocXmlFileName() {
        if (this.docXmlFileName != null) {
            return this.docXmlFileName;
        }
        String label = this.getLabel();
        if (label == null) {
            label = this.getEnunciate().getConfig().getLabel();
        }
        return label + "-docs.xml";
    }

    public void setDocXmlFileName(String docXmlFileName) {
        this.docXmlFileName = docXmlFileName;
    }

    protected String getSourceFileName() {
        if (this.sourceFileName != null) {
            return this.sourceFileName;
        }
        String label = this.getLabel();
        if (label == null) {
            label = this.getEnunciate().getConfig().getLabel();
        }
        return label + ".cs";
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    protected ObjectWrapper getObjectWrapper() {
        return new DefaultObjectWrapper(){

            public TemplateModel wrap(Object obj) throws TemplateModelException {
                if (obj instanceof JavaDoc) {
                    return new FreemarkerJavaDoc((JavaDoc)obj);
                }
                return super.wrap(obj);
            }
        };
    }

    protected URL getTemplateURL(String template) {
        return CSharpDeploymentModule.class.getResource(template);
    }

    protected boolean isUpToDate(File genDir) {
        return this.enunciate.isUpToDateWithSources(genDir);
    }

    public boolean isRequire() {
        return this.require;
    }

    public void setRequire(boolean require) {
        this.require = require;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getCompileExecutable() {
        return this.compileExecutable;
    }

    public void setCompileExecutable(String compileExecutable) {
        this.compileExecutable = compileExecutable;
    }

    public String getCompileCommand() {
        return this.compileCommand;
    }

    public void setCompileCommand(String compileCommand) {
        this.compileCommand = compileCommand;
    }

    public Map<String, String> getPackageToNamespaceConversions() {
        return this.packageToNamespaceConversions;
    }

    public boolean isDisableCompile() {
        return this.disableCompile;
    }

    public void setDisableCompile(boolean disableCompile) {
        this.disableCompile = disableCompile;
    }

    public boolean isSingleFilePerClass() {
        return this.singleFilePerClass;
    }

    public void setSingleFilePerClass(boolean singleFilePerClass) {
        this.singleFilePerClass = singleFilePerClass;
    }

    public Set<String> getFacetIncludes() {
        return this.facetIncludes;
    }

    public void addFacetInclude(String name) {
        if (name != null) {
            this.facetIncludes.add(name);
        }
    }

    public Set<String> getFacetExcludes() {
        return this.facetExcludes;
    }

    public void addFacetExclude(String name) {
        if (name != null) {
            this.facetExcludes.add(name);
        }
    }

    public void addClientPackageConversion(PackageNamespaceConversion conversion) {
        String from = conversion.getFrom();
        String to = conversion.getTo();
        if (from == null) {
            throw new IllegalArgumentException("A 'from' attribute must be specified on a package-conversion element.");
        }
        if (to == null) {
            throw new IllegalArgumentException("A 'to' attribute must be specified on a package-conversion element.");
        }
        this.packageToNamespaceConversions.put(from, to);
    }

    public RuleSet getConfigurationRules() {
        return new CSharpRuleSet();
    }

    public Validator getValidator() {
        return new CSharpValidator();
    }

    public boolean isDisabled() {
        if (super.isDisabled()) {
            return true;
        }
        if (this.getModelInternal() != null && this.getModelInternal().getNamespacesToWSDLs().isEmpty() && this.getModelInternal().getNamespacesToSchemas().isEmpty()) {
            this.debug("C# module is disabled because there are no endpoint interfaces, nor any XML types.", new Object[0]);
            return true;
        }
        return false;
    }
}

