/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.csharp;

import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebParam;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.ClientName;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.ComplexTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.EnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.SimpleTypeDefinition;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.jaxws.WebParam;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.util.MapType;

public class CSharpValidator
extends BaseValidator {
    public ValidationResult validateEndpointInterface(EndpointInterface ei) {
        ValidationResult result = super.validateEndpointInterface(ei);
        HashMap<String, Object> paramsByName = new HashMap<String, Object>();
        for (WebMethod webMethod : ei.getWebMethods()) {
            Declaration conflict;
            for (WebParam webParam : webMethod.getWebParameters()) {
                if (webParam.isHeader()) {
                    DecoratedTypeMirror paramType;
                    Declaration conflict2 = (Declaration)paramsByName.put(webParam.getElementName(), webParam);
                    if (conflict2 != null) {
                        result.addError((Declaration)webParam, "C# requires that all header parameters defined in the same endpoint interface have unique names. This parameter conflicts with the one at " + (conflict2.getPosition() == null ? "(unknown source position)" : conflict2.getPosition()));
                    }
                    if ((paramType = (DecoratedTypeMirror)webParam.getType()).isCollection()) {
                        result.addError((Declaration)webParam, "C# can't handle header parameters that are collections.");
                    }
                } else if (webParam.getMode() != WebParam.Mode.IN) {
                    result.addError((Declaration)webParam, "C# doesn't support non-header parameters of mode " + webParam.getMode());
                }
                if (!(webParam.getType() instanceof MapType)) continue;
                result.addError((Declaration)webParam, "C# can't handle types that are maps.");
            }
            if (webMethod.getWebResult().isHeader() && (conflict = (Declaration)paramsByName.put(webMethod.getWebResult().getElementName(), webMethod)) != null) {
                result.addError((Declaration)webMethod, "C# requires that all header parameters defined in the same endpoint interface have unique names. This parameter conflicts with the one at " + (conflict.getPosition() == null ? "(unknown source position)" : conflict.getPosition()));
            }
            if (webMethod.getWebResult().getType() instanceof MapType) {
                result.addError((Declaration)webMethod, "C# can't handle types that are maps.");
            }
            if (!CSharpValidator.capitalize(webMethod.getClientSimpleName()).equals(ei.getClientSimpleName())) continue;
            result.addError((Declaration)webMethod, "C# can't handle methods that are of the same name as their containing class. Either rename the method, or use the @org.codehaus.enunciate.ClientName annotation to rename the method (or type) on the client-side.");
        }
        return result;
    }

    public static String capitalize(String string) {
        return Character.toString(string.charAt(0)).toUpperCase() + string.substring(1);
    }

    public ValidationResult validateSimpleType(SimpleTypeDefinition simpleType) {
        ValidationResult result = super.validateSimpleType(simpleType);
        if (simpleType.getValue() != null && CSharpValidator.capitalize(simpleType.getValue().getClientSimpleName()).equals(simpleType.getClientSimpleName())) {
            result.addError((Declaration)simpleType.getValue(), "C# can't handle properties/fields that are of the same name as their containing class. Either rename the property/field, or use the @org.codehaus.enunciate.ClientName annotation to rename the property/field on the client-side.");
        }
        return result;
    }

    public ValidationResult validateEnumType(EnumTypeDefinition enumType) {
        ValidationResult result = super.validateEnumType(enumType);
        for (EnumConstantDeclaration enumItem : ((EnumDeclaration)enumType.getDelegate()).getEnumConstants()) {
            String simpleName = enumItem.getSimpleName();
            ClientName clientNameInfo = (ClientName)enumItem.getAnnotation(ClientName.class);
            if (clientNameInfo != null) {
                simpleName = clientNameInfo.value();
            }
            if ("event".equals(simpleName)) {
                result.addError((Declaration)enumItem, "C# can't handle an enum constant named 'Event'. Either rename the enum constant, or use the @org.codehaus.enunciate.ClientName annotation to rename it on the client-side.");
                continue;
            }
            if (!simpleName.equals(enumType.getClientSimpleName())) continue;
            result.addError((Declaration)enumItem, "C# can't handle properties/fields that are of the same name as their containing class. Either rename the property/field, or use the @org.codehaus.enunciate.ClientName annotation to rename the property/field on the client-side.");
        }
        return result;
    }

    public ValidationResult validateComplexType(ComplexTypeDefinition complexType) {
        ValidationResult result = super.validateComplexType(complexType);
        for (Attribute attribute : complexType.getAttributes()) {
            if (!CSharpValidator.capitalize(attribute.getClientSimpleName()).equals(complexType.getClientSimpleName())) continue;
            result.addError((Declaration)attribute, "C# can't handle properties/fields that are of the same name as their containing class.");
        }
        if (complexType.getValue() != null && CSharpValidator.capitalize(complexType.getValue().getClientSimpleName()).equals(complexType.getClientSimpleName())) {
            result.addError((Declaration)complexType.getValue(), "C# can't handle properties/fields that are of the same name as their containing class. Either rename the property/field, or use the @org.codehaus.enunciate.ClientName annotation to rename the property/field on the client-side.");
        }
        for (Element element : complexType.getElements()) {
            if (element.getAccessorType() instanceof MapType && !element.isAdapted()) {
                result.addError((Declaration)element, "C# doesn't have a built-in way of serializing a Map. So you're going to have to use @XmlJavaTypeAdapter to supply your own adapter for the Map, or disable the C# module.");
            }
            if (!CSharpValidator.capitalize(element.getClientSimpleName()).equals(complexType.getClientSimpleName())) continue;
            result.addError((Declaration)element, "C# can't handle properties/fields that are of the same name as their containing class. Either rename the property/field, or use the @org.codehaus.enunciate.ClientName annotation to rename the property/field on the client-side.");
        }
        if (((DecoratedTypeMirror)complexType.getSuperclass()).isInstanceOf(Map.class.getName())) {
            result.addError((Declaration)complexType, "Enunciate can't generate C# code that handles types that implement java.util.Map. I'm afraid you'll have to disable the C# module or use @XmlJavaTypeAdapter to adapt the type.");
        }
        return result;
    }
}

