/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.csharp;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.WildcardType;
import freemarker.template.TemplateModelException;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.jaxb.Accessor;

public class ClientClassnameForMethod
extends org.codehaus.enunciate.template.freemarker.ClientClassnameForMethod {
    private final Map<String, String> classConversions = new HashMap<String, String>();

    public ClientClassnameForMethod(Map<String, String> conversions) {
        super(conversions);
        this.setJdk15(false);
        this.classConversions.put(Boolean.class.getName(), "bool?");
        this.classConversions.put(String.class.getName(), "string");
        this.classConversions.put(Integer.class.getName(), "int?");
        this.classConversions.put(Short.class.getName(), "short?");
        this.classConversions.put(Byte.class.getName(), "sbyte?");
        this.classConversions.put(Double.class.getName(), "double?");
        this.classConversions.put(Long.class.getName(), "long?");
        this.classConversions.put(BigInteger.class.getName(), "long?");
        this.classConversions.put(BigDecimal.class.getName(), "decimal?");
        this.classConversions.put(Float.class.getName(), "float?");
        this.classConversions.put(Character.class.getName(), "ushort?");
        this.classConversions.put(Date.class.getName(), "DateTime?");
        this.classConversions.put(Timestamp.class.getName(), "DateTime?");
        this.classConversions.put(DataHandler.class.getName(), "byte[]");
        this.classConversions.put(Image.class.getName(), "byte[]");
        this.classConversions.put(Source.class.getName(), "byte[]");
        this.classConversions.put(QName.class.getName(), "global::System.Xml.XmlQualifiedName");
        this.classConversions.put(URI.class.getName(), "string");
        this.classConversions.put(UUID.class.getName(), "string");
        this.classConversions.put(XMLGregorianCalendar.class.getName(), "DateTime?");
        this.classConversions.put(GregorianCalendar.class.getName(), "DateTime?");
        this.classConversions.put(Calendar.class.getName(), "DateTime?");
        this.classConversions.put(Duration.class.getName(), "TimeSpan?");
        this.classConversions.put(JAXBElement.class.getName(), "object");
        this.classConversions.put(Object.class.getName(), "object");
    }

    public String convert(TypeDeclaration declaration) throws TemplateModelException {
        String fqn = declaration.getQualifiedName();
        if (this.classConversions.containsKey(fqn)) {
            return this.classConversions.get(fqn);
        }
        if (this.isCollection(declaration)) {
            return "global::System.Collections.ArrayList";
        }
        return super.convert(declaration);
    }

    public String convert(Accessor accessor) throws TemplateModelException {
        if (accessor.isXmlIDREF()) {
            return "string";
        }
        return super.convert(accessor);
    }

    protected boolean isCollection(TypeDeclaration declaration) {
        DecoratedTypeMirror decorated;
        String fqn = declaration.getQualifiedName();
        if (Collection.class.getName().equals(fqn)) {
            return true;
        }
        if (Object.class.getName().equals(fqn)) {
            return false;
        }
        if (declaration instanceof ClassDeclaration && (decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((ClassDeclaration)declaration).getSuperclass())).isCollection()) {
            return true;
        }
        for (InterfaceType interfaceType : declaration.getSuperinterfaces()) {
            DecoratedTypeMirror decorated2 = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)interfaceType);
            if (!decorated2.isCollection()) continue;
            return true;
        }
        return false;
    }

    public String convert(TypeMirror typeMirror) throws TemplateModelException {
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror);
        if (decorated.isPrimitive()) {
            PrimitiveType.Kind kind = ((PrimitiveType)decorated).getKind();
            switch (kind) {
                case BOOLEAN: {
                    return "bool";
                }
                case CHAR: {
                    return "ushort";
                }
            }
            return kind.toString().toLowerCase();
        }
        if (decorated.isCollection()) {
            return this.getCollectionTypeConversion((DeclaredType)typeMirror);
        }
        return super.convert(typeMirror);
    }

    protected String getCollectionTypeConversion(DeclaredType declaredType) throws TemplateModelException {
        Collection actualTypeArguments = declaredType.getActualTypeArguments();
        if (actualTypeArguments.size() == 1) {
            TypeMirror typeArg = (TypeMirror)actualTypeArguments.iterator().next();
            if (typeArg instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)typeArg;
                if (wildcardType.getUpperBounds() == null || wildcardType.getUpperBounds().isEmpty()) {
                    return "global::System.Collections.ArrayList";
                }
                return "global::System.Collections.Generic.List<" + this.convert((TypeMirror)wildcardType.getUpperBounds().iterator().next()) + ">";
            }
            if (typeArg instanceof TypeVariable) {
                Collection bounds = ((TypeVariable)typeArg).getDeclaration().getBounds();
                if (bounds == null || bounds.isEmpty()) {
                    return "global::System.Collections.ArrayList";
                }
                return "global::System.Collections.Generic.List<" + this.convert((TypeMirror)bounds.iterator().next()) + ">";
            }
            return "global::System.Collections.Generic.List<" + this.convert(typeArg) + ">";
        }
        return "global::System.Collections.ArrayList";
    }
}

