/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.csharp;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Collection;
import java.util.List;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.jaxws.WebParam;

public class RequestDocumentQNameMethod
implements TemplateMethodModelEx {
    public Object exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("The requestQName method method must have a web method as a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = BeansWrapper.getDefaultInstance().unwrap(from);
        if (!(unwrapped instanceof WebMethod)) {
            throw new TemplateModelException("A web method must be provided.");
        }
        WebMethod webMethod = (WebMethod)unwrapped;
        if (webMethod.getSoapBindingStyle() != SOAPBinding.Style.DOCUMENT || webMethod.getSoapUse() != SOAPBinding.Use.LITERAL) {
            throw new TemplateModelException("No request document qname available for a " + webMethod.getSoapBindingStyle() + "/" + webMethod.getSoapUse() + " web method.");
        }
        if (webMethod.getRequestWrapper() != null) {
            return new QName(webMethod.getRequestWrapper().getElementNamespace(), webMethod.getRequestWrapper().getElementName());
        }
        if (webMethod.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE) {
            Collection params = webMethod.getWebParameters();
            for (WebParam param : params) {
                if (param.isHeader()) continue;
                return new QName(webMethod.getDeclaringEndpointInterface().getTargetNamespace(), param.getElementName());
            }
        }
        return null;
    }
}

