/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.csharp;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.jaxws.WebResult;

public class ResponseDocumentQNameMethod
implements TemplateMethodModelEx {
    public Object exec(List list) throws TemplateModelException {
        WebResult wr;
        if (list.size() < 1) {
            throw new TemplateModelException("The responseDocumentQName method method must have a web method as a parameter.");
        }
        TemplateModel from = (TemplateModel)list.get(0);
        Object unwrapped = BeansWrapper.getDefaultInstance().unwrap(from);
        if (!(unwrapped instanceof WebMethod)) {
            throw new TemplateModelException("A web method must be provided.");
        }
        WebMethod webMethod = (WebMethod)unwrapped;
        if (webMethod.getSoapBindingStyle() != SOAPBinding.Style.DOCUMENT || webMethod.getSoapUse() != SOAPBinding.Use.LITERAL) {
            throw new TemplateModelException("No response document qname available for a " + webMethod.getSoapBindingStyle() + "/" + webMethod.getSoapUse() + " web method.");
        }
        if (webMethod.getResponseWrapper() != null) {
            return new QName(webMethod.getResponseWrapper().getElementNamespace(), webMethod.getResponseWrapper().getElementName());
        }
        if (webMethod.getSoapParameterStyle() == SOAPBinding.ParameterStyle.BARE && !(wr = webMethod.getWebResult()).isHeader()) {
            return new QName(wr.getTargetNamespace(), wr.getElementName());
        }
        return null;
    }
}

