/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.docs;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import org.codehaus.enunciate.main.Artifact;

public class ArtifactWrapper
extends StringModel {
    private Artifact artifact;

    public ArtifactWrapper(Artifact artifact, BeansWrapper wrapper) {
        super((Object)artifact, wrapper);
        this.artifact = artifact;
    }

    public TemplateModel get(String property) throws TemplateModelException {
        if ("size".equals(property)) {
            long sizeInBytes = this.artifact.getSize();
            String units = "bytes";
            float unitSize = 1.0f;
            if (sizeInBytes / 1024L > 0L) {
                units = "K";
                unitSize = 1024.0f;
            }
            if (sizeInBytes / 0x100000L > 0L) {
                units = "M";
                unitSize = 1048576.0f;
            }
            if (sizeInBytes / 0x40000000L > 0L) {
                units = "G";
                unitSize = 1.0737418E9f;
            }
            return this.wrap(String.format("%.2f%s", Float.valueOf((float)sizeInBytes / unitSize), units));
        }
        return super.get(property);
    }
}

