/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.docs;

import com.sun.mirror.declaration.PackageDeclaration;
import freemarker.ext.dom.NodeModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.declaration.DecoratedPackageDeclaration;
import net.sf.jelly.apt.util.JavaDocTagHandler;
import net.sf.jelly.apt.util.JavaDocTagHandlerFactory;
import org.apache.commons.digester.RuleSet;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateClasspathListener;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.EnunciateConfiguration;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.config.WsdlInfo;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.RootResource;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.main.NamedArtifact;
import org.codehaus.enunciate.main.webapp.BaseWebAppFragment;
import org.codehaus.enunciate.main.webapp.WebAppComponent;
import org.codehaus.enunciate.main.webapp.WebAppFragment;
import org.codehaus.enunciate.modules.DocumentationAwareModule;
import org.codehaus.enunciate.modules.FacetAware;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;
import org.codehaus.enunciate.modules.docs.DocumentationJavaDocTagHandler;
import org.codehaus.enunciate.modules.docs.DocumentationObjectWrapper;
import org.codehaus.enunciate.modules.docs.DownloadBundle;
import org.codehaus.enunciate.modules.docs.GenerateExampleJsonMethod;
import org.codehaus.enunciate.modules.docs.GenerateExampleXmlMethod;
import org.codehaus.enunciate.modules.docs.JsonSchemaForType;
import org.codehaus.enunciate.modules.docs.JsonTypeNameForQualifiedName;
import org.codehaus.enunciate.modules.docs.SchemaForNamespaceMethod;
import org.codehaus.enunciate.modules.docs.config.DocsRuleSet;
import org.codehaus.enunciate.modules.docs.config.DownloadConfig;
import org.codehaus.enunciate.template.freemarker.IsDefinedGloballyMethod;
import org.codehaus.enunciate.template.freemarker.UniqueContentTypesMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentationDeploymentModule
extends FreemarkerDeploymentModule
implements DocumentationAwareModule,
EnunciateClasspathListener,
FacetAware {
    private String splashPackage;
    private String copyright;
    private String title;
    private boolean includeDefaultDownloads = true;
    private boolean includeExampleXml = true;
    private boolean includeExampleJson = true;
    private boolean includeDeprecatedFieldsInExample = true;
    private boolean forceExampleJson = false;
    private String xslt;
    private URL xsltURL;
    private String freemarkerXMLProcessingTemplate;
    private URL freemarkerXMLProcessingTemplateURL;
    private String freemarkerDocsXMLTemplate;
    private URL freemarkerDocsXMLTemplateURL;
    private String css;
    private final List<String> additionalCss = new ArrayList<String>();
    private String base;
    private final ArrayList<DownloadConfig> downloads = new ArrayList();
    private String docsDir = null;
    private String javadocTagHandling;
    private boolean applyWsdlFilter = true;
    private boolean applyWadlFilter = true;
    private boolean jacksonXcAvailable = false;
    private String indexPageName = "index.html";
    private boolean disableRestMountpoint = false;
    private String defaultNamespace = null;
    private String groupRestResources = "org.codehaus.enunciate.contract.jaxrs.Resource";
    private Set<String> facetIncludes = new TreeSet<String>();
    private Set<String> facetExcludes = new TreeSet<String>(Arrays.asList("org.codehaus.enunciate.doc.ExcludeFromDocumentation"));

    public String getName() {
        return "docs";
    }

    public int getOrder() {
        return 100;
    }

    public void onClassesFound(Set<String> classes) {
        this.jacksonXcAvailable |= classes.contains("org.codehaus.jackson.xc.JaxbAnnotationIntrospector");
    }

    public String getSplashPackage() {
        return this.splashPackage;
    }

    public void setSplashPackage(String splashPackage) {
        this.splashPackage = splashPackage;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyRight) {
        this.copyright = copyRight;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleConditionally(String title) {
        if (this.title == null) {
            this.title = title;
        }
    }

    public String getJavadocTagHandling() {
        return this.javadocTagHandling;
    }

    public void setJavadocTagHandling(String javadocTagHandling) {
        this.javadocTagHandling = javadocTagHandling;
    }

    public void addDownload(DownloadConfig download) {
        this.downloads.add(download);
    }

    public Collection<DownloadConfig> getDownloads() {
        return this.downloads;
    }

    public void addAdditionalCss(String additionalCss) {
        this.additionalCss.add(additionalCss);
    }

    public List<String> getAdditionalCss() {
        return this.additionalCss;
    }

    public boolean isIncludeDefaultDownloads() {
        return this.includeDefaultDownloads;
    }

    public void setIncludeDefaultDownloads(boolean includeDefaultDownloads) {
        this.includeDefaultDownloads = includeDefaultDownloads;
    }

    public boolean isIncludeExampleXml() {
        return this.includeExampleXml;
    }

    public void setIncludeExampleXml(boolean includeExampleXml) {
        this.includeExampleXml = includeExampleXml;
    }

    public boolean isIncludeExampleJson() {
        return this.includeExampleJson;
    }

    public void setIncludeExampleJson(boolean includeExampleJson) {
        this.includeExampleJson = includeExampleJson;
    }

    public boolean isIncludeDeprecatedFieldsInExample() {
        return this.includeDeprecatedFieldsInExample;
    }

    public void setIncludeDeprecatedFieldsInExample(boolean includeDeprecatedFieldsInExample) {
        this.includeDeprecatedFieldsInExample = includeDeprecatedFieldsInExample;
    }

    public boolean isForceExampleJson() {
        return this.forceExampleJson;
    }

    public void setForceExampleJson(boolean forceExampleJson) {
        this.forceExampleJson = forceExampleJson;
    }

    public void setXslt(String xslt) throws MalformedURLException {
        this.xslt = xslt;
    }

    public void setXsltURL(URL xslt) {
        this.xsltURL = xslt;
    }

    public void setFreemarkerXMLProcessingTemplate(String freemarkerProcessingTemplate) throws MalformedURLException {
        this.freemarkerXMLProcessingTemplate = freemarkerProcessingTemplate;
    }

    public URL getFreemarkerXMLProcessingTemplateURL() {
        return this.freemarkerXMLProcessingTemplateURL;
    }

    public void setFreemarkerXMLProcessingTemplateURL(URL freemarkerXMLProcessingTemplateURL) {
        this.freemarkerXMLProcessingTemplateURL = freemarkerXMLProcessingTemplateURL;
    }

    public String getFreemarkerDocsXMLTemplate() {
        return this.freemarkerDocsXMLTemplate;
    }

    public void setFreemarkerDocsXMLTemplate(String freemarkerXmlTemplate) throws MalformedURLException {
        this.freemarkerDocsXMLTemplate = freemarkerXmlTemplate;
    }

    public URL getFreemarkerDocsXMLTemplateURL() {
        return this.freemarkerDocsXMLTemplateURL;
    }

    public void setFreemarkerDocsXMLTemplateURL(URL freemarkerDOCSXmlTemplateURL) {
        this.freemarkerDocsXMLTemplateURL = freemarkerDOCSXmlTemplateURL;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    protected URL getDocsTemplateURL() throws MalformedURLException {
        URL freemarkerProcessingTemplateURL = this.freemarkerDocsXMLTemplateURL;
        if (freemarkerProcessingTemplateURL == null) {
            freemarkerProcessingTemplateURL = this.freemarkerDocsXMLTemplate != null ? this.getEnunciate().resolvePath(this.freemarkerDocsXMLTemplate).toURI().toURL() : DocumentationDeploymentModule.class.getResource("docs.xml.fmt");
        }
        return freemarkerProcessingTemplateURL;
    }

    protected URL getDownloadsTemplateURL() {
        return DocumentationDeploymentModule.class.getResource("downloads.xml.fmt");
    }

    public String getDocsDir() {
        return this.docsDir;
    }

    public void setDocsDir(String docsDir) {
        this.docsDir = docsDir;
    }

    public boolean isApplyWsdlFilter() {
        return this.applyWsdlFilter;
    }

    public void setApplyWsdlFilter(boolean applyWsdlFilter) {
        this.applyWsdlFilter = applyWsdlFilter;
    }

    public boolean isApplyWadlFilter() {
        return this.applyWadlFilter;
    }

    public void setApplyWadlFilter(boolean applyWadlFilter) {
        this.applyWadlFilter = applyWadlFilter;
    }

    public String getIndexPageName() {
        return this.indexPageName;
    }

    public void setIndexPageName(String indexPageName) {
        this.indexPageName = indexPageName;
    }

    public boolean isDisableRestMountpoint() {
        return this.disableRestMountpoint;
    }

    public void setDisableRestMountpoint(boolean disableRestMountpoint) {
        this.disableRestMountpoint = disableRestMountpoint;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public String getGroupRestResources() {
        return this.groupRestResources;
    }

    public void setGroupRestResources(String groupRestResources) {
        if ("false".equalsIgnoreCase(groupRestResources) || "byPath".equalsIgnoreCase(groupRestResources)) {
            groupRestResources = null;
        } else if ("byDocumentationGroup".equalsIgnoreCase(groupRestResources)) {
            groupRestResources = "org.codehaus.enunciate.doc.DocumentationGroup";
        }
        this.groupRestResources = groupRestResources;
    }

    public File getDocsBuildDir() {
        File docsDir = this.getBuildDir();
        if (this.getDocsDir() != null) {
            docsDir = new File(docsDir, this.getDocsDir());
        }
        return docsDir;
    }

    public void init(Enunciate enunciate) throws EnunciateException {
        super.init(enunciate);
        enunciate.setProperty("docs.webapp.dir", (Object)this.getDocsDir());
        if (this.getJavadocTagHandling() == null) {
            JavaDocTagHandlerFactory.setTagHandler((JavaDocTagHandler)new DocumentationJavaDocTagHandler());
        } else if (!"OFF".equalsIgnoreCase(this.getJavadocTagHandling())) {
            try {
                JavaDocTagHandlerFactory.setTagHandler((JavaDocTagHandler)((JavaDocTagHandler)Class.forName(this.getJavadocTagHandling()).newInstance()));
            }
            catch (Throwable e) {
                throw new EnunciateException(e);
            }
        }
    }

    public void initModel(EnunciateFreemarkerModel model) {
        super.initModel(model);
        if (!this.getModelInternal().getNamespacesToWSDLs().isEmpty()) {
            String docsDir;
            String string = docsDir = this.getDocsDir() == null ? "" : this.getDocsDir();
            if (!docsDir.startsWith("/")) {
                docsDir = "/" + docsDir;
            }
            while (docsDir.endsWith("/")) {
                docsDir = docsDir.substring(0, docsDir.length() - 1);
            }
            for (WsdlInfo wsdlInfo : this.getModelInternal().getNamespacesToWSDLs().values()) {
                Object filename = wsdlInfo.getProperty("filename");
                if (filename == null) continue;
                wsdlInfo.setProperty("redirectLocation", (Object)(docsDir + "/" + filename));
            }
        }
        EnunciateConfiguration config = model.getEnunciateConfig();
        for (RootResource resource : model.getRootResources()) {
            for (ResourceMethod resourceMethod : resource.getResourceMethods(true)) {
                if (resourceMethod.getMetaData().containsKey("defaultSubcontext")) continue;
                resourceMethod.putMetaData("defaultSubcontext", (Object)(config == null ? "/rest" : config.getDefaultRestSubcontext()));
            }
        }
    }

    public void doFreemarkerGenerate() throws EnunciateException, IOException, TemplateException {
        if (!this.getEnunciate().isUpToDateWithSources(this.getGenerateDir())) {
            String title;
            EnunciateFreemarkerModel model = this.getModel();
            if (this.splashPackage != null) {
                PackageDeclaration packageDeclaration = Context.getCurrentEnvironment().getPackage(this.splashPackage);
                if (packageDeclaration != null) {
                    this.debug("Including documentation for package %s as the splash documentation.", new Object[]{this.splashPackage});
                    model.setVariable("apiDoc", (Object)new DecoratedPackageDeclaration(packageDeclaration).getJavaDoc());
                } else {
                    this.warn("Splash package %s not found.  No splash documentation included.", new Object[]{this.splashPackage});
                }
            }
            if (this.copyright != null) {
                this.debug("Documentation copyright: %s", new Object[]{this.copyright});
                model.setVariable("copyright", (Object)this.copyright);
            }
            if ((title = this.title) == null) {
                title = "Web API";
            }
            this.debug("Documentation title: %s", new Object[]{title});
            model.setVariable("title", (Object)title);
            model.setVariable("uniqueContentTypes", (Object)new UniqueContentTypesMethod());
            model.setVariable("schemaForNamespace", (Object)new SchemaForNamespaceMethod(model.getNamespacesToSchemas()));
            model.setVariable("jsonSchemaForType", (Object)new JsonSchemaForType(model));
            model.setVariable("jsonTypeNameForQualifiedName", (Object)new JsonTypeNameForQualifiedName(model));
            model.put("isDefinedGlobally", (Object)new IsDefinedGloballyMethod());
            model.put("includeExampleXml", this.isIncludeExampleXml());
            model.put("generateExampleXml", (Object)new GenerateExampleXmlMethod(this.getDefaultNamespace(), model, this.isIncludeDeprecatedFieldsInExample()));
            model.put("includeExampleJson", this.forceExampleJson || this.jacksonXcAvailable && this.isIncludeExampleJson());
            model.put("generateExampleJson", (Object)new GenerateExampleJsonMethod(model, this.isIncludeDeprecatedFieldsInExample()));
            this.processTemplate(this.getDocsTemplateURL(), model);
        } else {
            this.info("Skipping documentation source generation as everything appears up-to-date...", new Object[0]);
        }
    }

    protected void doBuild() throws EnunciateException, IOException {
        HashMap<String, String> initParams;
        if (!this.getEnunciate().isUpToDateWithSources(this.getBuildDir())) {
            this.buildBase();
            this.generateDownloadsXML();
            this.doXmlTransform();
        } else {
            this.info("Skipping build of documentation as everything appears up-to-date...", new Object[0]);
        }
        this.getEnunciate().addArtifact((Artifact)new FileArtifact(this.getName(), "docs", this.getDocsBuildDir()));
        BaseWebAppFragment webAppFragment = new BaseWebAppFragment(this.getName());
        webAppFragment.setBaseDir(this.getBuildDir());
        TreeMap<String, String> mimeMappings = new TreeMap<String, String>();
        mimeMappings.put("wsdl", "text/xml");
        mimeMappings.put("xsd", "text/xml");
        webAppFragment.setMimeMappings(mimeMappings);
        ArrayList<WebAppComponent> filters = new ArrayList<WebAppComponent>();
        if (this.isApplyWsdlFilter() && !this.getModelInternal().getNamespacesToWSDLs().isEmpty()) {
            WebAppComponent wsdlFilter = new WebAppComponent();
            wsdlFilter.setName("wsdl-filter");
            wsdlFilter.setClassname("org.codehaus.enunciate.webapp.IDLFilter");
            initParams = new HashMap<String, String>();
            initParams.put("assumed-base-address", this.getModel().getBaseDeploymentAddress());
            initParams.put("match-prefix", ":address location=\"");
            wsdlFilter.setInitParams(initParams);
            TreeSet<String> wsdls = new TreeSet<String>();
            for (WsdlInfo wsdlInfo : this.getModelInternal().getNamespacesToWSDLs().values()) {
                String wsdlLocation = (String)wsdlInfo.getProperty("redirectLocation");
                if (wsdlLocation == null) continue;
                wsdls.add(wsdlLocation);
            }
            wsdlFilter.setUrlMappings(wsdls);
            filters.add(wsdlFilter);
        }
        if (this.isApplyWadlFilter() && this.getModelInternal().getWadlFile() != null) {
            String docsDir;
            WebAppComponent wadlFilter = new WebAppComponent();
            wadlFilter.setName("wadl-filter");
            wadlFilter.setClassname("org.codehaus.enunciate.webapp.IDLFilter");
            initParams = new HashMap();
            initParams.put("assumed-base-address", this.getModel().getBaseDeploymentAddress());
            initParams.put("match-prefix", ":resources base=\"");
            wadlFilter.setInitParams(initParams);
            TreeSet<String> wadls = new TreeSet<String>();
            String string = docsDir = this.getDocsDir() == null ? "" : this.getDocsDir();
            if (!docsDir.startsWith("/")) {
                docsDir = "/" + docsDir;
            }
            while (docsDir.endsWith("/")) {
                docsDir = docsDir.substring(0, docsDir.length() - 1);
            }
            wadls.add(docsDir + "/" + this.getModelInternal().getWadlFile().getName());
            wadlFilter.setUrlMappings(wadls);
            filters.add(wadlFilter);
        }
        webAppFragment.setFilters(filters);
        this.getEnunciate().addWebAppFragment((WebAppFragment)webAppFragment);
    }

    protected void generateDownloadsXML() throws IOException, EnunciateException {
        EnunciateFreemarkerModel model = this.getModel();
        model.put("defaultDate", (Object)new Date());
        try {
            this.processTemplate(this.getDownloadsTemplateURL(), model);
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    protected void buildBase() throws IOException {
        String filename;
        File from;
        Enunciate enunciate = this.getEnunciate();
        File buildDir = this.getDocsBuildDir();
        buildDir.mkdirs();
        if (this.base == null) {
            InputStream discoveredBase = DocumentationDeploymentModule.class.getResourceAsStream("/META-INF/enunciate/docs-base.zip");
            if (discoveredBase == null) {
                this.debug("Default base to be used for documentation base.", new Object[0]);
                enunciate.extractBase(this.loadDefaultBase(), buildDir);
                URL discoveredCss = DocumentationDeploymentModule.class.getResource("/META-INF/enunciate/css/style.css");
                if (discoveredCss != null) {
                    enunciate.copyResource(discoveredCss, new File(new File(buildDir, "css"), "style.css"));
                } else if (this.css != null) {
                    enunciate.copyFile(enunciate.resolvePath(this.css), new File(new File(buildDir, "css"), "style.css"));
                }
            } else {
                this.debug("Discovered documentation base at /META-INF/enunciate/docs-base.zip", new Object[0]);
                enunciate.extractBase(discoveredBase, buildDir);
            }
        } else {
            File baseFile = enunciate.resolvePath(this.base);
            if (baseFile.isDirectory()) {
                this.debug("Directory %s to be used as the documentation base.", new Object[]{baseFile});
                enunciate.copyDir(baseFile, buildDir, new File[0]);
            } else {
                this.debug("Zip file %s to be extracted as the documentation base.", new Object[]{baseFile});
                enunciate.extractBase((InputStream)new FileInputStream(baseFile), buildDir);
            }
        }
        for (SchemaInfo schemaInfo : this.getModel().getNamespacesToSchemas().values()) {
            if (schemaInfo.getProperty("file") == null) continue;
            from = (File)schemaInfo.getProperty("file");
            filename = schemaInfo.getProperty("filename") != null ? (String)schemaInfo.getProperty("filename") : from.getName();
            File file = new File(this.getDocsBuildDir(), filename);
            enunciate.copyFile(from, file);
        }
        for (WsdlInfo wsdlInfo : this.getModel().getNamespacesToWSDLs().values()) {
            if (wsdlInfo.getProperty("file") == null) continue;
            from = (File)wsdlInfo.getProperty("file");
            filename = wsdlInfo.getProperty("filename") != null ? (String)wsdlInfo.getProperty("filename") : from.getName();
            File file = new File(this.getDocsBuildDir(), filename);
            enunciate.copyFile(from, file);
        }
        File wadlFile = this.getModelInternal().getWadlFile();
        if (wadlFile != null) {
            enunciate.copyFile(wadlFile, new File(this.getDocsBuildDir(), wadlFile.getName()));
        }
        HashSet<String> explicitArtifacts = new HashSet<String>();
        TreeSet<DownloadBundle> downloads = new TreeSet<DownloadBundle>();
        for (DownloadConfig downloadConfig : this.downloads) {
            if (downloadConfig.getArtifact() != null) {
                explicitArtifacts.add(downloadConfig.getArtifact());
                continue;
            }
            if (downloadConfig.getFile() == null) continue;
            File downloadFile = enunciate.resolvePath(downloadConfig.getFile());
            this.debug("File %s to be added as an extra download.", new Object[]{downloadFile.getAbsolutePath()});
            DownloadBundle downloadArtifact = new DownloadBundle(this.getName(), downloadFile.getName(), downloadFile);
            if (downloadConfig.getName() != null) {
                downloadArtifact.setName(downloadConfig.getName());
            }
            if (downloadConfig.getDescription() != null) {
                downloadArtifact.setDescription(downloadConfig.getDescription());
            }
            if (downloadConfig.getShowLink().equals("false")) {
                this.debug("Exporting %s to directory %s.", new Object[]{downloadArtifact.getId(), buildDir});
                downloadArtifact.exportTo(buildDir, enunciate);
                continue;
            }
            downloads.add(downloadArtifact);
        }
        for (Artifact artifact : enunciate.getArtifacts()) {
            if ((!(artifact instanceof NamedArtifact) || !this.includeDefaultDownloads) && !explicitArtifacts.contains(artifact.getId())) continue;
            if (artifact.isPublic()) {
                downloads.add((DownloadBundle)artifact);
            }
            this.debug("Artifact %s to be added as an extra download.", new Object[]{artifact.getId()});
            explicitArtifacts.remove(artifact.getId());
        }
        if (explicitArtifacts.size() > 0) {
            for (String string : explicitArtifacts) {
                this.warn("WARNING: Unknown artifact '%s'.  Will not be available for download.", new Object[]{string});
            }
        }
        for (Artifact artifact : downloads) {
            this.debug("Exporting %s to directory %s.", new Object[]{artifact.getId(), buildDir});
            artifact.exportTo(buildDir, enunciate);
        }
        HashSet<String> additionalCssFiles = new HashSet<String>();
        for (String additionalCss : this.getAdditionalCss()) {
            File additionalCssFile = enunciate.resolvePath(additionalCss);
            this.debug("File %s to be added as an additional css file.", new Object[]{additionalCss});
            enunciate.copyFile(additionalCssFile, new File(buildDir, additionalCssFile.getName()));
            additionalCssFiles.add(additionalCssFile.getName());
        }
        EnunciateFreemarkerModel enunciateFreemarkerModel = this.getModel();
        enunciateFreemarkerModel.put("downloads", downloads);
        enunciateFreemarkerModel.put("additionalCssFiles", additionalCssFiles);
    }

    protected void doXmlTransform() throws IOException, EnunciateException {
        URL freemarkerXMLProcessingTemplateURL;
        this.debug("Executing XML transformation.", new Object[0]);
        URL xsltURL = this.xsltURL;
        if (xsltURL == null) {
            xsltURL = this.xslt != null ? this.getEnunciate().resolvePath(this.xslt).toURI().toURL() : DocumentationDeploymentModule.class.getResource("/META-INF/enunciate/docs.xslt");
        }
        if ((freemarkerXMLProcessingTemplateURL = this.freemarkerXMLProcessingTemplateURL) == null) {
            freemarkerXMLProcessingTemplateURL = this.freemarkerXMLProcessingTemplate != null ? this.getEnunciate().resolvePath(this.freemarkerXMLProcessingTemplate).toURI().toURL() : DocumentationDeploymentModule.class.getResource("/META-INF/enunciate/docs.fmt");
        }
        if (xsltURL == null && freemarkerXMLProcessingTemplateURL == null) {
            freemarkerXMLProcessingTemplateURL = DocumentationDeploymentModule.class.getResource("docs.fmt");
        }
        if (xsltURL != null) {
            this.doXSLT(xsltURL);
        } else {
            this.doFreemarkerXMLProcessing(freemarkerXMLProcessingTemplateURL);
        }
    }

    protected void doFreemarkerXMLProcessing(URL freemarkerXMLProcessingTemplateURL) throws IOException, EnunciateException {
        this.debug("Using freemarker XML processing template %s", new Object[]{freemarkerXMLProcessingTemplateURL});
        EnunciateFreemarkerModel model = this.getModel();
        File docsXml = new File(this.getGenerateDir(), "docs.xml");
        model.put("docsxml", (Object)this.loadNodeModel(docsXml));
        File downloadsXml = new File(this.getGenerateDir(), "downloads.xml");
        if (downloadsXml.exists()) {
            model.put("downloadsxml", (Object)this.loadNodeModel(downloadsXml));
        }
        File buildDir = this.getDocsBuildDir();
        buildDir.mkdirs();
        model.setFileOutputDirectory(buildDir);
        model.put("apiRelativePath", (Object)this.getRelativePathToRootDir());
        model.put("indexPageName", (Object)this.getIndexPageName());
        model.put("disableRestMountpoint", this.isDisableRestMountpoint());
        model.put("groupRestResources", (Object)this.getGroupRestResources());
        model.put("additionalCss", this.getAdditionalCss());
        try {
            this.processTemplate(freemarkerXMLProcessingTemplateURL, model);
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    private NodeModel loadNodeModel(File xml) throws EnunciateException {
        Document doc;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(false);
            builderFactory.setValidating(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            doc = builder.parse(new FileInputStream(xml));
        }
        catch (Exception e) {
            throw new EnunciateException("Error parsing " + xml, (Throwable)e);
        }
        NodeModel.simplify((Node)doc);
        return NodeModel.wrap((Node)doc.getDocumentElement());
    }

    protected void doXSLT(URL xsltURL) throws IOException, EnunciateException {
        this.debug("Using stylesheet %s", new Object[]{xsltURL});
        StreamSource source = new StreamSource(xsltURL.openStream());
        try {
            Transformer transformer = SAXTransformerFactory.newInstance().newTransformer(source);
            transformer.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    return new StreamSource(new File(DocumentationDeploymentModule.this.getGenerateDir(), href));
                }
            });
            transformer.setParameter("downloads-exists", new File(this.getGenerateDir(), "downloads.xml").exists());
            this.debug("Extra downloads exist: %b", new Object[]{transformer.getParameter("downloads-exists")});
            File docsXml = new File(this.getGenerateDir(), "docs.xml");
            File buildDir = this.getDocsBuildDir();
            buildDir.mkdirs();
            transformer.setParameter("output-dir", buildDir.getAbsolutePath() + File.separator);
            transformer.setParameter("api-relative-path", this.getRelativePathToRootDir());
            transformer.setParameter("index-page-name", this.getIndexPageName());
            transformer.setParameter("disable-rest-mountpoint", this.isDisableRestMountpoint());
            transformer.setParameter("group-rest-resources", this.getGroupRestResources());
            File indexPage = new File(buildDir, this.getIndexPageName());
            this.debug("Transforming %s to %s.", new Object[]{docsXml, indexPage});
            transformer.transform(new StreamSource(docsXml), new StreamResult(indexPage));
        }
        catch (TransformerException e) {
            throw new EnunciateException("Error during transformation of the documentation (stylesheet " + xsltURL + ", document " + new File(this.getGenerateDir(), "docs.xml") + ")", (Throwable)e);
        }
    }

    protected String getRelativePathToRootDir() {
        String relativePath = ".";
        String docsDir = this.getDocsDir();
        if (docsDir != null) {
            StringBuilder builder = new StringBuilder();
            StringTokenizer pathTokens = new StringTokenizer(docsDir.replace(File.separatorChar, '/'), "/");
            if (pathTokens.hasMoreTokens()) {
                while (pathTokens.hasMoreTokens()) {
                    builder.append("..");
                    pathTokens.nextToken();
                    if (!pathTokens.hasMoreTokens()) continue;
                    builder.append('/');
                }
            } else {
                builder.append('.');
            }
            relativePath = builder.toString();
        }
        return relativePath;
    }

    public Set<String> getFacetIncludes() {
        return this.facetIncludes;
    }

    public void addFacetInclude(String name) {
        if (name != null) {
            this.facetIncludes.add(name);
        }
    }

    public Set<String> getFacetExcludes() {
        return this.facetExcludes;
    }

    public void addFacetExclude(String name) {
        if (name != null) {
            this.facetExcludes.add(name);
        }
    }

    protected InputStream loadDefaultBase() {
        return DocumentationDeploymentModule.class.getResourceAsStream("/docs.base.zip");
    }

    protected ObjectWrapper getObjectWrapper() {
        return new DocumentationObjectWrapper();
    }

    public RuleSet getConfigurationRules() {
        return new DocsRuleSet();
    }
}

