/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.docs;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.EnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.LocalElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.QNameEnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Value;
import org.codehaus.enunciate.contract.jaxb.types.KnownXmlType;
import org.codehaus.enunciate.contract.jaxb.types.MapXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlClassType;
import org.codehaus.enunciate.contract.jaxb.types.XmlPrimitiveType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.doc.DocumentationExample;
import org.codehaus.enunciate.modules.docs.RawValueNode;
import org.codehaus.enunciate.modules.docs.WhateverNode;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class GenerateExampleJsonMethod
implements TemplateMethodModelEx {
    private static final ThreadLocal<Stack<String>> TYPE_DEF_STACK = new ThreadLocal();
    private final EnunciateFreemarkerModel model;
    private final boolean includeDeprecatedFieldsInExample;

    public GenerateExampleJsonMethod(EnunciateFreemarkerModel model, boolean includeDeprecatedFieldsInExample) {
        this.model = model;
        this.includeDeprecatedFieldsInExample = includeDeprecatedFieldsInExample;
    }

    public Object exec(List list) throws TemplateModelException {
        Object type;
        RootElementDeclaration rootEl;
        if (list.size() < 1) {
            throw new TemplateModelException("The generateExampleJson method must have a root element as a parameter.");
        }
        Object object = BeansWrapper.getDefaultInstance().unwrap((TemplateModel)list.get(0));
        int maxDepth = Integer.MAX_VALUE;
        if (object instanceof RootElementDeclaration) {
            rootEl = (RootElementDeclaration)object;
            type = rootEl.getTypeDefinition();
        } else if (object instanceof LocalElementDeclaration) {
            rootEl = (LocalElementDeclaration)object;
            TypeDeclaration elementTypeDeclaration = rootEl.getElementTypeDeclaration();
            type = elementTypeDeclaration instanceof ClassDeclaration ? this.model.findTypeDefinition((ClassDeclaration)elementTypeDeclaration) : null;
        } else if (object instanceof TypeDefinition) {
            type = (TypeDefinition)object;
            maxDepth = 2;
        } else {
            throw new TemplateModelException("The generateExampleJson method must have a root element as a parameter.");
        }
        try {
            ObjectNode node = this.generateExampleJson((TypeDefinition)type, maxDepth);
            StringWriter sw = new StringWriter();
            JsonGenerator generator = new JsonFactory().createJsonGenerator((Writer)sw);
            this.configure(generator);
            node.serialize(generator, null);
            generator.flush();
            sw.flush();
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void configure(JsonGenerator generator) {
        generator.useDefaultPrettyPrinter();
    }

    public ObjectNode generateExampleJson(TypeDefinition type, int maxDepth) {
        if (TYPE_DEF_STACK.get() == null) {
            TYPE_DEF_STACK.set(new Stack());
        }
        ObjectNode jsonNode = JsonNodeFactory.instance.objectNode();
        this.generateExampleJson(type, jsonNode, maxDepth);
        return jsonNode;
    }

    public JsonNode generateExampleJson(EnumTypeDefinition type) {
        Map enumValues = type.getEnumValues();
        Object example = null;
        for (Object value : enumValues.values()) {
            if (value == null) continue;
            example = value;
            break;
        }
        String exampleValue = example == null ? "..." : (type instanceof QNameEnumTypeDefinition && ((QNameEnumTypeDefinition)type).isUriBaseType() ? ((QName)example).getNamespaceURI() + ((QName)example).getLocalPart() : String.valueOf(enumValues.values().iterator().next()));
        return JsonNodeFactory.instance.textNode(exampleValue);
    }

    protected void generateExampleJson(TypeDefinition type, ObjectNode jsonNode, int maxDepth) {
        if (type != null) {
            TypeDefinition typeDef;
            if (TYPE_DEF_STACK.get().contains(type.getQualifiedName())) {
                jsonNode.put("...", (JsonNode)WhateverNode.instance);
            } else {
                TYPE_DEF_STACK.get().push(type.getQualifiedName());
                for (Attribute attribute : type.getAttributes()) {
                    this.generateExampleJson(attribute, jsonNode, maxDepth);
                }
                if (type.getValue() != null) {
                    this.generateExampleJson(type.getValue(), jsonNode, maxDepth);
                } else {
                    for (Element element : type.getElements()) {
                        this.generateExampleJson(element, jsonNode, maxDepth);
                    }
                }
                TYPE_DEF_STACK.get().pop();
            }
            XmlType baseType = type.getBaseType();
            if (baseType instanceof XmlClassType && (typeDef = ((XmlClassType)baseType).getTypeDefinition()) != null) {
                this.generateExampleJson(typeDef, jsonNode, maxDepth);
            }
        }
    }

    protected void generateExampleJson(Attribute attribute, ObjectNode jsonNode, int maxDepth) {
        if (TYPE_DEF_STACK.get().size() > maxDepth) {
            return;
        }
        if (!this.includeDeprecatedFieldsInExample && attribute.getAnnotation(Deprecated.class) != null) {
            return;
        }
        DocumentationExample exampleInfo = (DocumentationExample)attribute.getAnnotation(DocumentationExample.class);
        if (exampleInfo == null || !exampleInfo.exclude()) {
            JsonNode valueNode = this.generateExampleJson(attribute.getBaseType(), exampleInfo == null || "##default".equals(exampleInfo.value()) ? null : exampleInfo.value(), maxDepth);
            jsonNode.put(attribute.getJsonMemberName(), valueNode);
        }
    }

    protected void generateExampleJson(Value value, ObjectNode jsonNode, int maxDepth) {
        if (TYPE_DEF_STACK.get().size() > maxDepth) {
            return;
        }
        DocumentationExample exampleInfo = (DocumentationExample)value.getAnnotation(DocumentationExample.class);
        if (exampleInfo == null || !exampleInfo.exclude()) {
            JsonNode valueNode = this.generateExampleJson(value.getBaseType(), exampleInfo == null || "##default".equals(exampleInfo.value()) ? null : exampleInfo.value(), maxDepth);
            jsonNode.put(value.getJsonMemberName(), valueNode);
        }
    }

    protected void generateExampleJson(Element element, ObjectNode jsonNode, int maxDepth) {
        if (TYPE_DEF_STACK.get().size() > maxDepth) {
            return;
        }
        if (!this.includeDeprecatedFieldsInExample && element.getAnnotation(Deprecated.class) != null) {
            return;
        }
        DocumentationExample exampleInfo = (DocumentationExample)element.getAnnotation(DocumentationExample.class);
        if (exampleInfo == null || !exampleInfo.exclude()) {
            Object elementNode;
            String name = element.getJsonMemberName();
            if (!element.isCollectionType()) {
                String exampleValue;
                String string = exampleValue = exampleInfo == null || "##default".equals(exampleInfo.value()) ? "..." : exampleInfo.value();
                elementNode = !element.isElementRefs() && element.getRef() == null ? this.generateExampleJson(element.getBaseType(), exampleValue, maxDepth) : JsonNodeFactory.instance.objectNode();
            } else {
                ArrayNode exampleChoices = JsonNodeFactory.instance.arrayNode();
                for (Element choice : element.getChoices()) {
                    QName ref = choice.isElementRefs() ? null : choice.getRef();
                    int iterations = "1".equals(choice.getMaxOccurs()) ? 1 : 2;
                    for (int i = 0; i < iterations; ++i) {
                        if (!choice.isElementRefs() && ref == null) {
                            String exampleValue = exampleInfo == null || "##default".equals(exampleInfo.value()) ? null : exampleInfo.value();
                            XmlType xmlType = choice.getBaseType();
                            if (i == 0) {
                                exampleChoices.add(this.generateExampleJson(xmlType, exampleValue, maxDepth));
                                continue;
                            }
                            exampleChoices.add((JsonNode)WhateverNode.instance);
                            continue;
                        }
                        exampleChoices.add((JsonNode)JsonNodeFactory.instance.objectNode());
                    }
                }
                elementNode = exampleChoices;
            }
            jsonNode.put(name, (JsonNode)elementNode);
        }
    }

    protected JsonNode generateExampleJson(XmlType type, String specifiedValue, int maxDepth) {
        if (type instanceof XmlClassType) {
            TypeDefinition typeDef = ((XmlClassType)type).getTypeDefinition();
            if (typeDef instanceof EnumTypeDefinition) {
                return this.generateExampleJson((EnumTypeDefinition)typeDef);
            }
            return this.generateExampleJson(typeDef, maxDepth);
        }
        if (type instanceof MapXmlType) {
            XmlType keyType = ((MapXmlType)type).getKeyType();
            XmlType valueType = ((MapXmlType)type).getValueType();
            ObjectNode mapNode = JsonNodeFactory.instance.objectNode();
            for (int i = 0; i < 2; ++i) {
                if (i != 0) continue;
                mapNode.put("...", this.generateExampleJson(valueType, null, maxDepth));
                mapNode.put("---", (JsonNode)WhateverNode.instance);
            }
            return mapNode;
        }
        if (type instanceof XmlPrimitiveType) {
            switch (((XmlPrimitiveType)type).getKind()) {
                case BOOLEAN: {
                    return JsonNodeFactory.instance.booleanNode("true".equalsIgnoreCase(specifiedValue));
                }
                case BYTE: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: {
                    return specifiedValue == null ? WhateverNode.instance : new RawValueNode(specifiedValue);
                }
            }
            return specifiedValue == null ? WhateverNode.instance : JsonNodeFactory.instance.textNode(specifiedValue);
        }
        if (type instanceof KnownXmlType) {
            switch ((KnownXmlType)type) {
                case BOOLEAN: {
                    return JsonNodeFactory.instance.booleanNode("true".equalsIgnoreCase(specifiedValue));
                }
                case BYTE: 
                case DECIMAL: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case INTEGER: 
                case LONG: 
                case POSITIVE_INTEGER: 
                case SHORT: 
                case UNSIGNED_BYTE: 
                case UNSIGNED_INT: 
                case UNSIGNED_LONG: 
                case UNSIGNED_SHORT: {
                    return specifiedValue == null ? WhateverNode.instance : new RawValueNode(specifiedValue);
                }
                case ANY_TYPE: {
                    return JsonNodeFactory.instance.objectNode();
                }
                case ANY_SIMPLE_TYPE: {
                    return WhateverNode.instance;
                }
            }
            return JsonNodeFactory.instance.textNode(specifiedValue == null ? "..." : specifiedValue);
        }
        return specifiedValue == null ? WhateverNode.instance : new RawValueNode(specifiedValue);
    }
}

