/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.docs;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Stack;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.namespace.QName;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxb.EnumTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.LocalElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Value;
import org.codehaus.enunciate.contract.jaxb.types.MapXmlType;
import org.codehaus.enunciate.contract.jaxb.types.XmlClassType;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.doc.DocumentationExample;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GenerateExampleXmlMethod
implements TemplateMethodModelEx {
    private static final ThreadLocal<Stack<String>> TYPE_DEF_STACK = new ThreadLocal();
    private final String defaultNamespace;
    private final EnunciateFreemarkerModel model;
    private final boolean includeDeprecatedFieldsInExample;

    public GenerateExampleXmlMethod(String defaultNamespace, EnunciateFreemarkerModel model, boolean includeDeprecatedFieldsInExample) {
        this.defaultNamespace = defaultNamespace;
        this.model = model;
        this.includeDeprecatedFieldsInExample = includeDeprecatedFieldsInExample;
    }

    public Object exec(List list) throws TemplateModelException {
        Object type;
        String name;
        String namespace;
        RootElementDeclaration rootEl;
        if (list.size() < 1) {
            throw new TemplateModelException("The generateExampleJson method must have a root element as a parameter.");
        }
        Object object = BeansWrapper.getDefaultInstance().unwrap((TemplateModel)list.get(0));
        String defaultNs = this.defaultNamespace;
        int maxDepth = Integer.MAX_VALUE;
        if (object instanceof RootElementDeclaration) {
            rootEl = (RootElementDeclaration)object;
            namespace = rootEl.getNamespace();
            name = rootEl.getName();
            type = rootEl.getTypeDefinition();
        } else if (object instanceof LocalElementDeclaration) {
            rootEl = (LocalElementDeclaration)object;
            namespace = rootEl.getNamespace();
            name = rootEl.getName();
            TypeDeclaration elementTypeDeclaration = rootEl.getElementTypeDeclaration();
            type = elementTypeDeclaration instanceof ClassDeclaration ? this.model.findTypeDefinition((ClassDeclaration)elementTypeDeclaration) : null;
        } else if (object instanceof TypeDefinition) {
            type = (TypeDefinition)object;
            namespace = type.getNamespace();
            name = type.getName();
            maxDepth = 2;
        } else {
            throw new TemplateModelException("The generateExampleJson method must have a root element as a parameter.");
        }
        try {
            String prefix;
            String string = namespace == null ? null : (prefix = defaultNs == null ? "" : (String)((EnunciateFreemarkerModel)FreemarkerModel.get()).getNamespacesToPrefixes().get(namespace));
            Namespace jdomNS = Namespace.XML_NAMESPACE.getURI().equals(namespace) ? Namespace.XML_NAMESPACE : (namespace == null || "".equals(namespace) ? Namespace.NO_NAMESPACE : Namespace.getNamespace((String)prefix, (String)namespace));
            Element rootElement = new Element(name, jdomNS);
            if (defaultNs != null) {
                rootElement.addNamespaceDeclaration(Namespace.getNamespace((String)"", (String)defaultNs));
            } else {
                defaultNs = namespace;
            }
            this.generateExampleXml((TypeDefinition)type, rootElement, defaultNs, maxDepth);
            Document document = new Document(rootElement);
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            StringWriter sw = new StringWriter();
            out.output(document, (Writer)sw);
            sw.flush();
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void generateExampleXml(TypeDefinition type, Element parent, String defaultNs, int maxDepth) {
        if (TYPE_DEF_STACK.get() == null) {
            TYPE_DEF_STACK.set(new Stack());
        }
        if (type != null) {
            if (TYPE_DEF_STACK.get().contains(type.getQualifiedName())) {
                parent.addContent((Content)new Comment("..."));
            } else if (type instanceof EnumTypeDefinition) {
                parent.addContent((Content)new Text("..."));
            } else {
                TypeDefinition typeDef;
                XmlType baseType = type.getBaseType();
                if (baseType instanceof XmlClassType && (typeDef = ((XmlClassType)baseType).getTypeDefinition()) != null) {
                    this.generateExampleXml(typeDef, parent, defaultNs, maxDepth);
                }
                TYPE_DEF_STACK.get().push(type.getQualifiedName());
                for (org.codehaus.enunciate.contract.jaxb.Attribute attribute : type.getAttributes()) {
                    this.generateExampleXml(attribute, parent, defaultNs);
                }
                if (type.getValue() != null) {
                    this.generateExampleXml(type.getValue(), parent);
                } else {
                    for (org.codehaus.enunciate.contract.jaxb.Element element : type.getElements()) {
                        this.generateExampleXml(element, parent, defaultNs, maxDepth);
                    }
                }
                TYPE_DEF_STACK.get().pop();
            }
        } else {
            parent.addContent((Content)new Comment("..."));
        }
    }

    protected void generateExampleXml(org.codehaus.enunciate.contract.jaxb.Attribute attribute, Element parent, String defaultNs) {
        if (!this.includeDeprecatedFieldsInExample && attribute.getAnnotation(Deprecated.class) != null) {
            return;
        }
        DocumentationExample exampleInfo = (DocumentationExample)attribute.getAnnotation(DocumentationExample.class);
        if (exampleInfo == null || !exampleInfo.exclude()) {
            String exampleValue;
            String namespace = attribute.getNamespace();
            String prefix = namespace == null ? null : (String)((EnunciateFreemarkerModel)FreemarkerModel.get()).getNamespacesToPrefixes().get(namespace);
            String string = exampleValue = exampleInfo == null || "##default".equals(exampleInfo.value()) ? "..." : exampleInfo.value();
            Namespace jdomNS = Namespace.XML_NAMESPACE.getURI().equals(namespace) ? Namespace.XML_NAMESPACE : (namespace == null || "".equals(namespace) || namespace.equals(defaultNs) ? Namespace.NO_NAMESPACE : Namespace.getNamespace((String)prefix, (String)namespace));
            Attribute attr = new Attribute(attribute.getName(), exampleValue, jdomNS);
            parent.setAttribute(attr);
        }
    }

    protected void generateExampleXml(Value value, Element parent) {
        DocumentationExample exampleInfo = (DocumentationExample)value.getAnnotation(DocumentationExample.class);
        if (exampleInfo == null || !exampleInfo.exclude()) {
            parent.setContent((Content)new Text(exampleInfo == null || "##default".equals(exampleInfo.value()) ? "..." : exampleInfo.value()));
        }
    }

    protected void generateExampleXml(org.codehaus.enunciate.contract.jaxb.Element element, Element parent, String defaultNs, int maxDepth) {
        if (TYPE_DEF_STACK.get().size() > maxDepth) {
            return;
        }
        if (!this.includeDeprecatedFieldsInExample && element.getAnnotation(Deprecated.class) != null) {
            return;
        }
        DocumentationExample exampleInfo = (DocumentationExample)element.getAnnotation(DocumentationExample.class);
        if (exampleInfo == null || !exampleInfo.exclude()) {
            if (element.isWrapped()) {
                String prefix;
                String namespace = element.getWrapperNamespace();
                String string = prefix = namespace == null ? null : (String)((EnunciateFreemarkerModel)FreemarkerModel.get()).getNamespacesToPrefixes().get(namespace);
                Namespace jdomNS = Namespace.XML_NAMESPACE.getURI().equals(namespace) ? Namespace.XML_NAMESPACE : (namespace == null || "".equals(namespace) ? Namespace.NO_NAMESPACE : (namespace.equals(defaultNs) ? Namespace.getNamespace((String)"", (String)namespace) : Namespace.getNamespace((String)prefix, (String)namespace)));
                Element el = new Element(element.getWrapperName(), jdomNS);
                parent.addContent((Content)el);
                parent = el;
            }
            for (org.codehaus.enunciate.contract.jaxb.Element choice : element.getChoices()) {
                QName ref = choice.getRef();
                int iterations = "1".equals(choice.getMaxOccurs()) ? 1 : 2;
                for (int i = 0; i < iterations; ++i) {
                    String prefix;
                    String namespace;
                    if (ref == null) {
                        String prefix2;
                        namespace = choice.getNamespace();
                        String string = prefix2 = namespace == null ? null : (String)((EnunciateFreemarkerModel)FreemarkerModel.get()).getNamespacesToPrefixes().get(namespace);
                        Namespace jdomNS = Namespace.XML_NAMESPACE.getURI().equals(namespace) ? Namespace.XML_NAMESPACE : (namespace == null || "".equals(namespace) ? (choice.getTypeDefinition().getSchema().getElementFormDefault() == XmlNsForm.QUALIFIED ? Namespace.NO_NAMESPACE : Namespace.getNamespace((String)"", (String)namespace)) : (namespace.equals(defaultNs) ? Namespace.getNamespace((String)"", (String)namespace) : Namespace.getNamespace((String)prefix2, (String)namespace)));
                        Element el = new Element(choice.getName(), jdomNS);
                        String exampleValue = exampleInfo == null || "##default".equals(exampleInfo.value()) ? "..." : exampleInfo.value();
                        XmlType xmlType = choice.getBaseType();
                        if (i == 0) {
                            this.generateExampleXml(xmlType, el, exampleValue, defaultNs, maxDepth);
                        } else if (xmlType instanceof XmlClassType) {
                            TypeDefinition typedef = ((XmlClassType)xmlType).getTypeDefinition();
                            for (org.codehaus.enunciate.contract.jaxb.Attribute attribute : typedef.getAttributes()) {
                                this.generateExampleXml(attribute, el, defaultNs);
                            }
                            if (typedef.getValue() != null) {
                                el.addContent((Content)new Text("..."));
                            } else {
                                el.addContent((Content)new Comment("..."));
                            }
                        } else {
                            el.addContent((Content)new Text("..."));
                        }
                        parent.addContent((Content)el);
                        continue;
                    }
                    namespace = ref.getNamespaceURI();
                    String name = ref.getLocalPart();
                    String string = prefix = namespace == null ? null : (String)((EnunciateFreemarkerModel)FreemarkerModel.get()).getNamespacesToPrefixes().get(namespace);
                    Namespace jdomNS = Namespace.XML_NAMESPACE.getURI().equals(namespace) ? Namespace.XML_NAMESPACE : (namespace == null || "".equals(namespace) ? Namespace.NO_NAMESPACE : (namespace.equals(defaultNs) ? Namespace.getNamespace((String)"", (String)namespace) : Namespace.getNamespace((String)prefix, (String)namespace)));
                    Element el = new Element(name, jdomNS);
                    el.addContent((Content)new Text("..."));
                    parent.addContent((Content)el);
                }
                if (iterations <= 1) continue;
                parent.addContent((Content)new Comment("...more \"" + (ref == null ? choice.getName() : ref.getLocalPart()) + "\" elements..."));
            }
        }
    }

    public void generateExampleXml(XmlType type, Element parent, String example, String defaultNs, int maxDepth) {
        if (type instanceof XmlClassType) {
            this.generateExampleXml(((XmlClassType)type).getTypeDefinition(), parent, defaultNs, maxDepth);
        } else if (type instanceof MapXmlType) {
            XmlType keyType = ((MapXmlType)type).getKeyType();
            XmlType valueType = ((MapXmlType)type).getValueType();
            for (int i = 0; i < 2; ++i) {
                Element entry = new Element("entry", parent.getNamespacePrefix(), parent.getNamespaceURI());
                Element key = new Element("key", parent.getNamespacePrefix(), parent.getNamespaceURI());
                Element value = new Element("value", parent.getNamespacePrefix(), parent.getNamespaceURI());
                if (i == 0) {
                    this.generateExampleXml(keyType, key, null, defaultNs, maxDepth);
                } else {
                    key.addContent((Content)new Comment("(another '" + keyType.getName() + "' type)"));
                }
                entry.addContent((Content)key);
                if (i == 0) {
                    this.generateExampleXml(valueType, value, null, defaultNs, maxDepth);
                } else {
                    value.addContent((Content)new Comment("(another '" + valueType.getName() + "' type)"));
                }
                entry.addContent((Content)value);
                parent.addContent((Content)entry);
            }
            parent.addContent((Content)new Comment("...more entries..."));
        } else {
            parent.addContent((Content)(type.isSimple() ? new Text(example == null ? "..." : example) : new Comment("custom xml")));
        }
    }
}

