/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.docs;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.type.TypeMirror;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.jaxrs.ResourceEntityParameter;
import org.codehaus.enunciate.contract.jaxrs.ResourceRepresentationMetadata;
import org.codehaus.enunciate.contract.json.JsonSchemaInfo;
import org.codehaus.enunciate.contract.json.JsonType;
import org.codehaus.enunciate.contract.json.JsonTypeDefinition;

public class JsonSchemaForType
implements TemplateMethodModelEx {
    public static final String NAME = "jsonSchemaForType";
    private final EnunciateFreemarkerModel model;

    public JsonSchemaForType(EnunciateFreemarkerModel model) {
        assert (model != null) : "model must not be null";
        this.model = model;
    }

    public JsonSchemaInfo exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("The jsonSchemaForType method expects exactly one argument");
        }
        Object object = BeansWrapper.getDefaultInstance().unwrap((TemplateModel)arguments.get(0));
        if (object instanceof String) {
            String typeName = (String)object;
            JsonType jsonType = this.model.findJsonTypeDefinition(typeName);
            return this.jsonSchemaForType(jsonType);
        }
        if (object instanceof ResourceRepresentationMetadata) {
            ResourceRepresentationMetadata metadata = (ResourceRepresentationMetadata)object;
            TypeMirror typeMirror = metadata.getDelegate();
            JsonType jsonType = this.model.findJsonTypeDefinition(typeMirror.toString());
            return this.jsonSchemaForType(jsonType);
        }
        if (object instanceof TypeMirror) {
            TypeMirror typeMirror = (TypeMirror)object;
            JsonType jsonType = this.model.findJsonTypeDefinition(typeMirror.toString());
            return this.jsonSchemaForType(jsonType);
        }
        if (object instanceof JsonType) {
            JsonType jsonType = (JsonType)object;
            return this.jsonSchemaForType(jsonType);
        }
        if (object instanceof ResourceEntityParameter) {
            ResourceEntityParameter restResourcePayload = (ResourceEntityParameter)object;
            JsonType jsonType = restResourcePayload.getJsonType();
            return this.jsonSchemaForType(jsonType);
        }
        return null;
    }

    private JsonSchemaInfo jsonSchemaForType(JsonType jsonType) {
        if (jsonType instanceof JsonTypeDefinition) {
            JsonTypeDefinition jsonTypeDefinition = (JsonTypeDefinition)jsonType;
            String schemaId = JsonSchemaInfo.schemaIdForType((ClassDeclaration)jsonTypeDefinition.classDeclaration());
            return (JsonSchemaInfo)this.model.getIdsToJsonSchemas().get(schemaId);
        }
        return null;
    }
}

