/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.docs;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.Map;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.contract.jaxb.Accessor;
import org.codehaus.enunciate.contract.jaxb.ElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.ElementRef;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxb.types.XmlType;
import org.codehaus.enunciate.contract.jaxrs.ResourceEntityParameter;
import org.codehaus.enunciate.contract.jaxrs.ResourceRepresentationMetadata;
import org.codehaus.enunciate.contract.jaxws.WebParam;

public class SchemaForNamespaceMethod
implements TemplateMethodModelEx {
    private final Map<String, SchemaInfo> namespaces2Schemas;

    public SchemaForNamespaceMethod(Map<String, SchemaInfo> namespaces2Schemas) {
        this.namespaces2Schemas = namespaces2Schemas;
    }

    public Object exec(List list) throws TemplateModelException {
        String namespace;
        if (list.size() < 1) {
            throw new TemplateModelException("The uniqueContentTypes method must have a list of methods as a parameter.");
        }
        Object object = BeansWrapper.getDefaultInstance().unwrap((TemplateModel)list.get(0));
        if (object instanceof ElementRef) {
            namespace = ((ElementRef)object).getRef().getNamespaceURI();
        } else if (object instanceof Accessor) {
            namespace = ((Accessor)object).getBaseType().getNamespace();
        } else if (object instanceof TypeDefinition) {
            namespace = ((TypeDefinition)object).getNamespace();
        } else if (object instanceof ElementDeclaration) {
            namespace = ((ElementDeclaration)object).getNamespace();
        } else if (object instanceof ResourceEntityParameter) {
            ElementDeclaration element = ((ResourceEntityParameter)object).getXmlElement();
            if (element == null) {
                return null;
            }
            namespace = element.getNamespace();
        } else if (object instanceof WebParam) {
            namespace = ((WebParam)object).getXmlType().getNamespace();
        } else if (object instanceof XmlType) {
            namespace = ((XmlType)object).getNamespace();
        } else if (object instanceof ResourceRepresentationMetadata) {
            ResourceRepresentationMetadata metadata = (ResourceRepresentationMetadata)object;
            ElementDeclaration element = metadata.getXmlElement();
            if (element == null) {
                return null;
            }
            namespace = element.getNamespace();
        } else {
            return null;
        }
        if ("".equals(namespace)) {
            namespace = null;
        }
        return this.namespaces2Schemas.get(namespace);
    }
}

