/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.jaxws;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.ReferenceType;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.WsdlInfo;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.RootResource;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.jaxws.RequestWrapper;
import org.codehaus.enunciate.contract.jaxws.ResponseWrapper;
import org.codehaus.enunciate.contract.jaxws.WebFault;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.validation.ValidationException;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;
import org.codehaus.enunciate.modules.jaxws.JAXWSSupportValidator;
import org.codehaus.enunciate.util.TypeDeclarationComparator;

public class JAXWSSupportDeploymentModule
extends FreemarkerDeploymentModule {
    public String getName() {
        return "jaxws-support";
    }

    public void doFreemarkerGenerate() throws IOException, TemplateException {
        File genDir = this.getGenerateDir();
        if (!this.isUpToDate(genDir)) {
            EnunciateFreemarkerModel model = this.getModel();
            model.put("Introspector", (Object)BeansWrapper.getDefaultInstance().getStaticModels().get("java.beans.Introspector"));
            Map ns2wsdl = model.getNamespacesToWSDLs();
            URL requestBeanTemplate = JAXWSSupportDeploymentModule.class.getResource("request-bean.fmt");
            URL responseBeanTemplate = JAXWSSupportDeploymentModule.class.getResource("response-bean.fmt");
            URL faultBeanTemplate = JAXWSSupportDeploymentModule.class.getResource("fault-bean.fmt");
            TreeSet<WebFault> visitedFaults = new TreeSet<WebFault>((Comparator<WebFault>)new TypeDeclarationComparator());
            for (WsdlInfo wsdlInfo : ns2wsdl.values()) {
                for (EndpointInterface ei : wsdlInfo.getEndpointInterfaces()) {
                    for (WebMethod webMethod : ei.getWebMethods()) {
                        for (WebMessage webMessage : webMethod.getMessages()) {
                            if (webMessage instanceof RequestWrapper) {
                                model.put("message", (Object)webMessage);
                                this.processTemplate(requestBeanTemplate, model);
                                continue;
                            }
                            if (webMessage instanceof ResponseWrapper) {
                                model.put("message", (Object)webMessage);
                                this.processTemplate(responseBeanTemplate, model);
                                continue;
                            }
                            if (!(webMessage instanceof WebFault) || !((WebFault)webMessage).isImplicitSchemaElement() || !visitedFaults.add((WebFault)webMessage)) continue;
                            model.put("message", (Object)webMessage);
                            this.processTemplate(faultBeanTemplate, model);
                        }
                    }
                }
            }
            for (RootResource rootResource : model.getRootResources()) {
                for (ResourceMethod resourceMethod : rootResource.getResourceMethods(true)) {
                    for (ReferenceType referenceType : resourceMethod.getThrownTypes()) {
                        WebFault fault;
                        if (!(referenceType instanceof DeclaredType)) {
                            throw new ValidationException(resourceMethod.getPosition(), "Method " + resourceMethod + " of " + resourceMethod.getParent().getQualifiedName() + ": thrown type must be a declared type.");
                        }
                        TypeDeclaration declaration = ((DeclaredType)referenceType).getDeclaration();
                        if (declaration == null) {
                            throw new ValidationException(resourceMethod.getPosition(), "Method " + resourceMethod + " of " + resourceMethod.getParent().getQualifiedName() + ": unknown declaration for " + referenceType);
                        }
                        if (declaration.getAnnotation(javax.xml.ws.WebFault.class) == null || !(fault = new WebFault((ClassDeclaration)declaration)).isImplicitSchemaElement() || !visitedFaults.add(fault)) continue;
                        model.put("message", (Object)fault);
                        this.processTemplate(faultBeanTemplate, model);
                    }
                }
            }
        } else {
            this.info("Skipping JAX-WS support generation as everything appears up-to-date...", new Object[0]);
        }
        this.getEnunciate().addArtifact((Artifact)new FileArtifact(this.getName(), "jaxws.support.src.dir", genDir));
        this.getEnunciate().addAdditionalSourceRoot(genDir);
    }

    protected boolean isUpToDate(File genDir) {
        return this.enunciate.isUpToDateWithSources(genDir);
    }

    public Validator getValidator() {
        return new JAXWSSupportValidator();
    }

    public boolean isDisabled() {
        if (super.isDisabled()) {
            return true;
        }
        if (this.getModelInternal() != null && this.getModelInternal().getNamespacesToWSDLs().isEmpty() && this.getModelInternal().getRootResources().isEmpty()) {
            this.debug("JAX-WS module is disabled because there are no endpoint interfaces.", new Object[0]);
            return true;
        }
        if (this.getModelInternal() != null && this.getModelInternal().getEnunciateConfig() != null && this.getModelInternal().getEnunciateConfig().getWebAppConfig() != null && this.getModelInternal().getEnunciateConfig().getWebAppConfig().isDisabled()) {
            this.debug("Module '%s' is disabled because the web application processing has been disabled.", new Object[]{this.getName()});
            return true;
        }
        return false;
    }
}

