/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.jaxws;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.Declaration;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jelly.apt.Context;
import org.codehaus.enunciate.contract.jaxws.EndpointInterface;
import org.codehaus.enunciate.contract.jaxws.RequestWrapper;
import org.codehaus.enunciate.contract.jaxws.ResponseWrapper;
import org.codehaus.enunciate.contract.jaxws.WebFault;
import org.codehaus.enunciate.contract.jaxws.WebMessage;
import org.codehaus.enunciate.contract.jaxws.WebMethod;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.util.TypeDeclarationComparator;

public class JAXWSSupportValidator
extends BaseValidator {
    private final HashSet<String> jaxwsBeans = new HashSet();
    private final TreeSet<WebFault> faultSet = new TreeSet(new TypeDeclarationComparator());

    public ValidationResult validateEndpointInterface(EndpointInterface ei) {
        ValidationResult result = super.validateEndpointInterface(ei);
        TreeSet<WebFault> unvisitedFaults = new TreeSet<WebFault>((Comparator<WebFault>)new TypeDeclarationComparator());
        for (WebMethod webMethod : ei.getWebMethods()) {
            for (WebMessage webMessage : webMethod.getMessages()) {
                WebFault webFault;
                if (webMessage instanceof RequestWrapper) {
                    result.aggregate(this.validateRequestWrapper((RequestWrapper)webMessage, this.jaxwsBeans));
                    continue;
                }
                if (webMessage instanceof ResponseWrapper) {
                    result.aggregate(this.validateResponseWrapper((ResponseWrapper)webMessage, this.jaxwsBeans));
                    continue;
                }
                if (!(webMessage instanceof WebFault) || !this.faultSet.add(webFault = (WebFault)webMessage)) continue;
                unvisitedFaults.add(webFault);
            }
        }
        for (WebFault webFault : unvisitedFaults) {
            result.aggregate(this.validateWebFault(webFault, this.jaxwsBeans));
        }
        return result;
    }

    public ValidationResult validateRequestWrapper(RequestWrapper wrapper, Set<String> alreadyVisited) {
        AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
        ValidationResult result = new ValidationResult();
        String requestBeanName = wrapper.getRequestBeanName();
        if (!alreadyVisited.add(requestBeanName)) {
            result.addError((Declaration)wrapper.getWebMethod(), requestBeanName + " conflicts with another generated bean name.  Please use the @RequestWrapper " + "annotation to customize the bean name.");
        }
        return result;
    }

    public ValidationResult validateResponseWrapper(ResponseWrapper wrapper, Set<String> alreadyVisited) {
        AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
        ValidationResult result = new ValidationResult();
        String responseBeanName = wrapper.getResponseBeanName();
        if (!alreadyVisited.add(responseBeanName)) {
            result.addError((Declaration)wrapper.getWebMethod(), responseBeanName + " conflicts with another generated bean name.  Please use the @ResponseWrapper " + "annotation to customize the bean name.");
        }
        return result;
    }

    public ValidationResult validateWebFault(WebFault webFault, Set<String> alreadyVisited) {
        String faultBeanFQN;
        AnnotationProcessorEnvironment ape = Context.getCurrentEnvironment();
        ValidationResult result = new ValidationResult();
        if (webFault.isImplicitSchemaElement() && !alreadyVisited.add(faultBeanFQN = webFault.getImplicitFaultBeanQualifiedName())) {
            result.addError((Declaration)webFault, faultBeanFQN + " conflicts with another generated bean name.  Please use the @WebFault annotation " + "to customize the fault bean name.");
        }
        return result;
    }
}

