/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.ruby;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import freemarker.template.TemplateModelException;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.jaxb.Accessor;

public class ClientClassnameForMethod
extends org.codehaus.enunciate.template.freemarker.ClientClassnameForMethod {
    private final Map<String, String> classConversions = new HashMap<String, String>();

    public ClientClassnameForMethod(Map<String, String> conversions) {
        super(conversions);
        this.setJdk15(false);
        this.classConversions.put(Boolean.class.getName(), "Boolean");
        this.classConversions.put(String.class.getName(), "String");
        this.classConversions.put(Integer.class.getName(), "Fixnum");
        this.classConversions.put(Short.class.getName(), "Fixnum");
        this.classConversions.put(Byte.class.getName(), "Fixnum");
        this.classConversions.put(Double.class.getName(), "Float");
        this.classConversions.put(Long.class.getName(), "Bignum");
        this.classConversions.put(BigInteger.class.getName(), "Bignum");
        this.classConversions.put(BigDecimal.class.getName(), "Float");
        this.classConversions.put(Float.class.getName(), "Float");
        this.classConversions.put(Character.class.getName(), "Fixnum");
        this.classConversions.put(Date.class.getName(), "Time");
        this.classConversions.put(Timestamp.class.getName(), "Time");
        this.classConversions.put(DataHandler.class.getName(), "String");
        this.classConversions.put(Image.class.getName(), "String");
        this.classConversions.put(Source.class.getName(), "String");
        this.classConversions.put(QName.class.getName(), "String");
        this.classConversions.put(URI.class.getName(), "String");
        this.classConversions.put(UUID.class.getName(), "String");
        this.classConversions.put(XMLGregorianCalendar.class.getName(), "String");
        this.classConversions.put(GregorianCalendar.class.getName(), "Time");
        this.classConversions.put(Calendar.class.getName(), "Time");
        this.classConversions.put(Duration.class.getName(), "String");
        this.classConversions.put(JAXBElement.class.getName(), "Object");
        this.classConversions.put(Object.class.getName(), "Object");
    }

    public String convert(TypeDeclaration declaration) throws TemplateModelException {
        String fqn = declaration.getQualifiedName();
        if (this.classConversions.containsKey(fqn)) {
            return this.classConversions.get(fqn);
        }
        if (declaration instanceof EnumDeclaration) {
            return "String";
        }
        if (this.isCollection(declaration)) {
            return "Array";
        }
        if (this.isMap(declaration)) {
            return "Hash";
        }
        return super.convert(declaration);
    }

    public String convert(Accessor accessor) throws TemplateModelException {
        if (accessor.isXmlIDREF()) {
            return "String";
        }
        return super.convert(accessor);
    }

    protected boolean isCollection(TypeDeclaration declaration) {
        DecoratedTypeMirror decorated;
        String fqn = declaration.getQualifiedName();
        if (Collection.class.getName().equals(fqn)) {
            return true;
        }
        if (Object.class.getName().equals(fqn)) {
            return false;
        }
        if (declaration instanceof ClassDeclaration && (decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((ClassDeclaration)declaration).getSuperclass())).isCollection()) {
            return true;
        }
        for (InterfaceType interfaceType : declaration.getSuperinterfaces()) {
            DecoratedTypeMirror decorated2 = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)interfaceType);
            if (!decorated2.isCollection()) continue;
            return true;
        }
        return false;
    }

    protected boolean isMap(TypeDeclaration declaration) {
        DecoratedTypeMirror decorated;
        String fqn = declaration.getQualifiedName();
        if (Map.class.getName().equals(fqn)) {
            return true;
        }
        if (declaration instanceof ClassDeclaration && (decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((ClassDeclaration)declaration).getSuperclass())).isInstanceOf(Map.class.getName())) {
            return true;
        }
        for (InterfaceType interfaceType : declaration.getSuperinterfaces()) {
            DecoratedTypeMirror decorated2 = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)interfaceType);
            if (!decorated2.isInstanceOf(Map.class.getName())) continue;
            return true;
        }
        return false;
    }

    public String convert(TypeMirror typeMirror) throws TemplateModelException {
        TypeMirror componentType;
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror);
        if (decorated.isPrimitive()) {
            PrimitiveType.Kind kind = ((PrimitiveType)decorated).getKind();
            switch (kind) {
                case BOOLEAN: {
                    return "Boolean";
                }
                case BYTE: 
                case INT: 
                case SHORT: 
                case CHAR: {
                    return "Fixnum";
                }
                case FLOAT: 
                case DOUBLE: {
                    return "Float";
                }
                case LONG: {
                    return "Bignum";
                }
            }
            return "String";
        }
        if (decorated.isEnum()) {
            return "String";
        }
        if (decorated.isCollection()) {
            return "Array";
        }
        if (decorated.isArray() && (componentType = ((ArrayType)decorated).getComponentType()) instanceof PrimitiveType && ((PrimitiveType)componentType).getKind() == PrimitiveType.Kind.BYTE) {
            return "String";
        }
        return super.convert(typeMirror);
    }

    protected String getPackageSeparator() {
        return "::";
    }
}

