/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.ruby;

import com.sun.mirror.type.ClassType;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.freemarker.FreemarkerJavaDoc;
import org.apache.commons.digester.RuleSet;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateClasspathListener;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.RootResource;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.ArtifactType;
import org.codehaus.enunciate.main.ClientLibraryArtifact;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.main.NamedFileArtifact;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;
import org.codehaus.enunciate.modules.ruby.ClientClassnameForMethod;
import org.codehaus.enunciate.modules.ruby.RubyValidator;
import org.codehaus.enunciate.modules.ruby.config.PackageModuleConversion;
import org.codehaus.enunciate.modules.ruby.config.RubyRuleSet;
import org.codehaus.enunciate.template.freemarker.ClassnameForMethod;
import org.codehaus.enunciate.template.freemarker.ClientPackageForMethod;
import org.codehaus.enunciate.template.freemarker.SimpleNameWithParamsMethod;

public class RubyDeploymentModule
extends FreemarkerDeploymentModule
implements EnunciateClasspathListener {
    private boolean forceEnable = false;
    private String label = null;
    private final Map<String, String> packageToModuleConversions = new HashMap<String, String>();
    private boolean jacksonXcAvailable = false;
    private Set<String> facetIncludes = new TreeSet<String>();
    private Set<String> facetExcludes = new TreeSet<String>();

    public String getName() {
        return "ruby";
    }

    public void onClassesFound(Set<String> classes) {
        this.jacksonXcAvailable |= classes.contains("org.codehaus.jackson.xc.JaxbAnnotationIntrospector");
    }

    public void initModel(EnunciateFreemarkerModel model) {
        super.initModel(model);
        if (!this.isDisabled()) {
            for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
                for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                    String pckg = typeDefinition.getPackage().getQualifiedName();
                    if (this.packageToModuleConversions.containsKey(pckg)) continue;
                    this.packageToModuleConversions.put(pckg, this.packageToModule(pckg));
                }
            }
        }
    }

    protected String packageToModule(String pckg) {
        if (pckg == null) {
            return null;
        }
        StringBuilder ns = new StringBuilder();
        StringTokenizer toks = new StringTokenizer(pckg, ".");
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            ns.append(Character.toString(tok.charAt(0)).toUpperCase());
            if (tok.length() > 1) {
                ns.append(tok.substring(1));
            }
            if (!toks.hasMoreTokens()) continue;
            ns.append("::");
        }
        return ns.toString();
    }

    public void doFreemarkerGenerate() throws IOException, TemplateException, EnunciateException {
        File genDir = this.getGenerateDir();
        if (!this.enunciate.isUpToDateWithSources(genDir)) {
            EnunciateFreemarkerModel model = this.getModel();
            ArrayList<TypeDefinition> schemaTypes = new ArrayList<TypeDefinition>();
            ExtensionDepthComparator comparator = new ExtensionDepthComparator();
            for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
                for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                    int position = Collections.binarySearch(schemaTypes, typeDefinition, comparator);
                    if (position < 0) {
                        position = -position - 1;
                    }
                    schemaTypes.add(position, typeDefinition);
                }
            }
            model.put("schemaTypes", schemaTypes);
            model.put("packages2modules", this.packageToModuleConversions);
            ClientPackageForMethod moduleFor = new ClientPackageForMethod(this.packageToModuleConversions);
            moduleFor.setUseClientNameConversions(true);
            model.put("moduleFor", (Object)moduleFor);
            ClientClassnameForMethod classnameFor = new ClientClassnameForMethod(this.packageToModuleConversions);
            classnameFor.setUseClientNameConversions(true);
            model.put("classnameFor", (Object)classnameFor);
            SimpleNameWithParamsMethod simpleNameFor = new SimpleNameWithParamsMethod((ClassnameForMethod)classnameFor);
            model.put("simpleNameFor", (Object)simpleNameFor);
            model.put("rubyFileName", (Object)this.getSourceFileName());
            this.debug("Generating the Ruby data classes...", new Object[0]);
            URL apiTemplate = this.getTemplateURL("api.fmt");
            this.processTemplate(apiTemplate, model);
        } else {
            this.info("Skipping Ruby code generation because everything appears up-to-date.", new Object[0]);
        }
        ClientLibraryArtifact artifactBundle = new ClientLibraryArtifact(this.getName(), "ruby.client.library", "Ruby Client Library");
        artifactBundle.setPlatform("Ruby");
        NamedFileArtifact sourceScript = new NamedFileArtifact(this.getName(), "ruby.client", new File(this.getGenerateDir(), this.getSourceFileName()));
        sourceScript.setArtifactType(ArtifactType.binaries);
        sourceScript.setPublic(false);
        String description = this.readResource("library_description.fmt");
        artifactBundle.setDescription(description);
        artifactBundle.addArtifact((FileArtifact)sourceScript);
        this.getEnunciate().addArtifact((Artifact)artifactBundle);
    }

    protected String readResource(String resource) throws IOException, EnunciateException {
        HashMap<String, ResourceMethod> model = new HashMap<String, ResourceMethod>();
        model.put("sample_resource", this.getModelInternal().findExampleResourceMethod());
        URL res = RubyDeploymentModule.class.getResource(resource);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        try {
            this.processTemplate(res, model, out);
            out.flush();
            bytes.flush();
            return bytes.toString("utf-8");
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    protected String getSourceFileName() {
        String label = this.getLabel();
        if (label == null) {
            label = this.getEnunciate().getConfig().getLabel();
        }
        return label + ".rb";
    }

    protected ObjectWrapper getObjectWrapper() {
        return new DefaultObjectWrapper(){

            public TemplateModel wrap(Object obj) throws TemplateModelException {
                if (obj instanceof JavaDoc) {
                    return new FreemarkerJavaDoc((JavaDoc)obj);
                }
                return super.wrap(obj);
            }
        };
    }

    protected URL getTemplateURL(String template) {
        return RubyDeploymentModule.class.getResource(template);
    }

    public boolean isForceEnable() {
        return this.forceEnable;
    }

    public void setForceEnable(boolean forceEnable) {
        this.forceEnable = forceEnable;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map<String, String> getPackageToModuleConversions() {
        return this.packageToModuleConversions;
    }

    public void addClientPackageConversion(PackageModuleConversion conversion) {
        String from = conversion.getFrom();
        String to = conversion.getTo();
        if (from == null) {
            throw new IllegalArgumentException("A 'from' attribute must be specified on a package-conversion element.");
        }
        if (to == null) {
            throw new IllegalArgumentException("A 'to' attribute must be specified on a package-conversion element.");
        }
        this.packageToModuleConversions.put(from, to);
    }

    public RuleSet getConfigurationRules() {
        return new RubyRuleSet();
    }

    public Validator getValidator() {
        return new RubyValidator();
    }

    public Set<String> getFacetIncludes() {
        return this.facetIncludes;
    }

    public void addFacetInclude(String name) {
        if (name != null) {
            this.facetIncludes.add(name);
        }
    }

    public Set<String> getFacetExcludes() {
        return this.facetExcludes;
    }

    public void addFacetExclude(String name) {
        if (name != null) {
            this.facetExcludes.add(name);
        }
    }

    public boolean isDisabled() {
        if (this.isForceEnable()) {
            this.debug("Ruby module is force-enabled via the 'forceEnable' attribute in the config.", new Object[0]);
            return false;
        }
        if (super.isDisabled()) {
            return true;
        }
        if (!this.jacksonXcAvailable) {
            this.debug("Ruby module is disabled because Jackson XC was not found on the Enunciate classpath.", new Object[0]);
            return true;
        }
        if (this.getModelInternal() != null && this.getModelInternal().getNamespacesToSchemas().isEmpty()) {
            this.debug("Ruby module is disabled because there are no schema types.", new Object[0]);
            return true;
        }
        if (this.getModelInternal() != null && this.getModelInternal().getRootResources().isEmpty()) {
            this.debug("Ruby module is disabled because there are no JAX-RS root resources.", new Object[0]);
            return true;
        }
        if (this.getModelInternal() != null && !this.existsAnyJsonResourceMethod(this.getModelInternal().getRootResources())) {
            this.debug("Ruby module is disabled because there are no JAX-RS root resource methods that produce or consume json.", new Object[0]);
            return true;
        }
        return false;
    }

    protected boolean existsAnyJsonResourceMethod(List<RootResource> rootResources) {
        for (RootResource rootResource : rootResources) {
            for (ResourceMethod resourceMethod : rootResource.getResourceMethods(true)) {
                for (String mime : resourceMethod.getProducesMime()) {
                    if ("*/*".equals(mime)) {
                        return true;
                    }
                    if (!mime.toLowerCase().contains("json")) continue;
                    return true;
                }
                for (String mime : resourceMethod.getConsumesMime()) {
                    if ("*/*".equals(mime)) {
                        return true;
                    }
                    if (!mime.toLowerCase().contains("json")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static final class ExtensionDepthComparator
    implements Comparator<TypeDefinition> {
        private ExtensionDepthComparator() {
        }

        @Override
        public int compare(TypeDefinition t1, TypeDefinition t2) {
            int depth1 = 0;
            int depth2 = 0;
            ClassType superClass = t1.getSuperclass();
            while (superClass != null && superClass.getDeclaration() != null && !Object.class.getName().equals(superClass.getDeclaration().getQualifiedName())) {
                ++depth1;
                superClass = superClass.getDeclaration().getSuperclass();
            }
            superClass = t2.getSuperclass();
            while (superClass != null && superClass.getDeclaration() != null && !Object.class.getName().equals(superClass.getDeclaration().getQualifiedName())) {
                ++depth2;
                superClass = superClass.getDeclaration().getSuperclass();
            }
            return depth1 - depth2;
        }
    }
}

