/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.ruby;

import com.sun.mirror.declaration.Declaration;
import javax.xml.bind.annotation.XmlElements;
import org.codehaus.enunciate.contract.jaxb.ComplexTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.ElementRef;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationResult;

public class RubyValidator
extends BaseValidator {
    public ValidationResult validateComplexType(ComplexTypeDefinition complexType) {
        ValidationResult result = super.validateComplexType(complexType);
        if (!Character.isUpperCase(complexType.getClientSimpleName().charAt(0))) {
            result.addError((Declaration)complexType, "Ruby requires your class name to be upper-case. Please rename the class or apply the @org.codehaus.enunciate.ClientName annotation to the class.");
        }
        for (Element element : complexType.getElements()) {
            if (element instanceof ElementRef && element.isElementRefs()) {
                result.addWarning((Declaration)complexType, "The Ruby client library doesn't fully support the @XmlElementRefs annotation. The items in the collection will be read-only and will only be available to Ruby clients in the form of a Hash. Consider redesigning using a collection of a single type. See http://jira.codehaus.org/browse/ENUNCIATE-542 for more information.");
                continue;
            }
            if (element.getAnnotation(XmlElements.class) == null) continue;
            result.addWarning((Declaration)complexType, "The Ruby client library doesn't fully support the @XmlElements annotation. The items in the collection will be read-only and will only be available to Ruby clients in the form of a Hash. Consider redesigning using a collection of a single type. See http://jira.codehaus.org/browse/ENUNCIATE-542 for more information.");
        }
        return result;
    }
}

