/*
 * Decompiled with CFR 0.152.
 */
package groovy.json;

import groovy.json.JsonException;
import groovy.json.JsonOutput;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;

class StreamingJsonDelegate
extends GroovyObjectSupport {
    private Writer writer;
    private boolean first;

    public StreamingJsonDelegate(Writer w, boolean first) {
        this.writer = w;
        this.first = first;
    }

    public Object invokeMethod(String name, Object args) {
        if (args != null && Object[].class.isAssignableFrom(args.getClass())) {
            try {
                if (!this.first) {
                    this.writer.write(",");
                } else {
                    this.first = false;
                }
                this.writer.write(JsonOutput.toJson(name));
                this.writer.write(":");
                Object[] arr = (Object[])args;
                if (arr.length == 1) {
                    this.writer.write(JsonOutput.toJson(arr[0]));
                } else if (StreamingJsonDelegate.isCollectionWithClosure(arr)) {
                    StreamingJsonDelegate.writeCollectionWithClosure(this.writer, (Collection)arr[0], (Closure)arr[1]);
                } else {
                    this.writer.write(JsonOutput.toJson(Arrays.asList(arr)));
                }
            }
            catch (IOException ioe) {
                throw new JsonException(ioe);
            }
        }
        return this;
    }

    public static boolean isCollectionWithClosure(Object[] args) {
        return args.length == 2 && args[0] instanceof Collection && args[1] instanceof Closure;
    }

    public static Object writeCollectionWithClosure(Writer writer, Collection coll, Closure closure) throws IOException {
        writer.write("[");
        boolean first = true;
        for (Object it : coll) {
            if (!first) {
                writer.write(",");
            } else {
                first = false;
            }
            writer.write("{");
            StreamingJsonDelegate.curryDelegateAndGetContent(writer, closure, it);
            writer.write("}");
        }
        writer.write("]");
        return writer;
    }

    public static void cloneDelegateAndGetContent(Writer w, Closure c) {
        StreamingJsonDelegate.cloneDelegateAndGetContent(w, c, true);
    }

    public static void cloneDelegateAndGetContent(Writer w, Closure c, boolean first) {
        StreamingJsonDelegate delegate = new StreamingJsonDelegate(w, first);
        Closure cloned = (Closure)c.clone();
        cloned.setDelegate((Object)delegate);
        cloned.setResolveStrategy(1);
        cloned.call();
    }

    public static void curryDelegateAndGetContent(Writer w, Closure c, Object o) {
        StreamingJsonDelegate.curryDelegateAndGetContent(w, c, o, true);
    }

    public static void curryDelegateAndGetContent(Writer w, Closure c, Object o, boolean first) {
        StreamingJsonDelegate delegate = new StreamingJsonDelegate(w, first);
        Closure curried = c.curry(o);
        curried.setDelegate((Object)delegate);
        curried.setResolveStrategy(1);
        curried.call();
    }
}

