/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.NopAnnotationIntrospector;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationIntrospector {
    public static AnnotationIntrospector nopInstance() {
        return NopAnnotationIntrospector.instance;
    }

    public static AnnotationIntrospector pair(AnnotationIntrospector a1, AnnotationIntrospector a2) {
        return new Pair(a1, a2);
    }

    public abstract boolean isHandled(Annotation var1);

    public abstract String findNamespace(Annotated var1);

    public abstract Boolean findCachability(AnnotatedClass var1);

    public abstract String findRootName(AnnotatedClass var1);

    public abstract String[] findPropertiesToIgnore(AnnotatedClass var1);

    public abstract Boolean findIgnoreUnknownProperties(AnnotatedClass var1);

    public abstract VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass var1, VisibilityChecker<?> var2);

    public abstract TypeResolverBuilder<?> findTypeResolver(AnnotatedClass var1, JavaType var2);

    public abstract TypeResolverBuilder<?> findPropertyTypeResolver(AnnotatedMember var1, JavaType var2);

    public abstract TypeResolverBuilder<?> findPropertyContentTypeResolver(AnnotatedMember var1, JavaType var2);

    public abstract List<NamedType> findSubtypes(Annotated var1);

    public abstract String findTypeName(AnnotatedClass var1);

    public abstract boolean isIgnorableMethod(AnnotatedMethod var1);

    public abstract boolean isIgnorableConstructor(AnnotatedConstructor var1);

    public abstract boolean isIgnorableField(AnnotatedField var1);

    public abstract Object findSerializer(Annotated var1);

    public abstract JsonSerialize.Inclusion findSerializationInclusion(Annotated var1, JsonSerialize.Inclusion var2);

    public abstract Class<?> findSerializationType(Annotated var1);

    public abstract JsonSerialize.Typing findSerializationTyping(Annotated var1);

    public abstract Class<?>[] findSerializationViews(Annotated var1);

    public abstract String[] findSerializationPropertyOrder(AnnotatedClass var1);

    public abstract Boolean findSerializationSortAlphabetically(AnnotatedClass var1);

    public abstract String findGettablePropertyName(AnnotatedMethod var1);

    public abstract boolean hasAsValueAnnotation(AnnotatedMethod var1);

    public abstract String findEnumValue(Enum<?> var1);

    public abstract String findSerializablePropertyName(AnnotatedField var1);

    public abstract Object findDeserializer(Annotated var1);

    public abstract Class<? extends KeyDeserializer> findKeyDeserializer(Annotated var1);

    public abstract Class<? extends JsonDeserializer<?>> findContentDeserializer(Annotated var1);

    public abstract Class<?> findDeserializationType(Annotated var1, JavaType var2, String var3);

    public abstract Class<?> findDeserializationKeyType(Annotated var1, JavaType var2, String var3);

    public abstract Class<?> findDeserializationContentType(Annotated var1, JavaType var2, String var3);

    public abstract String findSettablePropertyName(AnnotatedMethod var1);

    public abstract boolean hasAnySetterAnnotation(AnnotatedMethod var1);

    public abstract boolean hasCreatorAnnotation(Annotated var1);

    public abstract String findDeserializablePropertyName(AnnotatedField var1);

    public abstract String findPropertyNameForParam(AnnotatedParameter var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair
    extends AnnotationIntrospector {
        final AnnotationIntrospector _primary;
        final AnnotationIntrospector _secondary;

        public Pair(AnnotationIntrospector p, AnnotationIntrospector s) {
            this._primary = p;
            this._secondary = s;
        }

        @Override
        public boolean isHandled(Annotation ann) {
            return this._primary.isHandled(ann) || this._secondary.isHandled(ann);
        }

        @Override
        public String findNamespace(Annotated ann) {
            String ns1 = this._primary.findNamespace(ann);
            if (ns1 == null) {
                return this._secondary.findNamespace(ann);
            }
            if (ns1.length() > 0) {
                return ns1;
            }
            String ns2 = this._secondary.findNamespace(ann);
            return ns2 == null ? ns1 : ns2;
        }

        @Override
        public Boolean findCachability(AnnotatedClass ac) {
            Boolean result = this._primary.findCachability(ac);
            if (result == null) {
                result = this._secondary.findCachability(ac);
            }
            return result;
        }

        @Override
        public String findRootName(AnnotatedClass ac) {
            String name1 = this._primary.findRootName(ac);
            if (name1 == null) {
                return this._secondary.findRootName(ac);
            }
            if (name1.length() > 0) {
                return name1;
            }
            String name2 = this._secondary.findRootName(ac);
            return name2 == null ? name1 : name2;
        }

        @Override
        public String[] findPropertiesToIgnore(AnnotatedClass ac) {
            String[] result = this._primary.findPropertiesToIgnore(ac);
            if (result == null) {
                result = this._secondary.findPropertiesToIgnore(ac);
            }
            return result;
        }

        @Override
        public Boolean findIgnoreUnknownProperties(AnnotatedClass ac) {
            Boolean result = this._primary.findIgnoreUnknownProperties(ac);
            if (result == null) {
                result = this._secondary.findIgnoreUnknownProperties(ac);
            }
            return result;
        }

        @Override
        public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass ac, VisibilityChecker<?> checker) {
            checker = this._secondary.findAutoDetectVisibility(ac, checker);
            return this._primary.findAutoDetectVisibility(ac, checker);
        }

        @Override
        public TypeResolverBuilder<?> findTypeResolver(AnnotatedClass ac, JavaType baseType) {
            TypeResolverBuilder<?> b = this._primary.findTypeResolver(ac, baseType);
            if (b == null) {
                b = this._secondary.findTypeResolver(ac, baseType);
            }
            return b;
        }

        @Override
        public TypeResolverBuilder<?> findPropertyTypeResolver(AnnotatedMember am, JavaType baseType) {
            TypeResolverBuilder<?> b = this._primary.findPropertyTypeResolver(am, baseType);
            if (b == null) {
                b = this._secondary.findPropertyTypeResolver(am, baseType);
            }
            return b;
        }

        @Override
        public TypeResolverBuilder<?> findPropertyContentTypeResolver(AnnotatedMember am, JavaType baseType) {
            TypeResolverBuilder<?> b = this._primary.findPropertyContentTypeResolver(am, baseType);
            if (b == null) {
                b = this._secondary.findPropertyContentTypeResolver(am, baseType);
            }
            return b;
        }

        @Override
        public List<NamedType> findSubtypes(Annotated a) {
            List<NamedType> types1 = this._primary.findSubtypes(a);
            List<NamedType> types2 = this._secondary.findSubtypes(a);
            if (types1 == null || types1.isEmpty()) {
                return types2;
            }
            if (types2 == null || types2.isEmpty()) {
                return types1;
            }
            ArrayList<NamedType> result = new ArrayList<NamedType>(types1.size() + types2.size());
            result.addAll(types1);
            result.addAll(types2);
            return result;
        }

        @Override
        public String findTypeName(AnnotatedClass ac) {
            String name = this._primary.findTypeName(ac);
            if (name == null || name.length() == 0) {
                name = this._secondary.findTypeName(ac);
            }
            return name;
        }

        @Override
        public boolean isIgnorableMethod(AnnotatedMethod m) {
            return this._primary.isIgnorableMethod(m) || this._secondary.isIgnorableMethod(m);
        }

        @Override
        public boolean isIgnorableConstructor(AnnotatedConstructor c) {
            return this._primary.isIgnorableConstructor(c) || this._secondary.isIgnorableConstructor(c);
        }

        @Override
        public boolean isIgnorableField(AnnotatedField f) {
            return this._primary.isIgnorableField(f) || this._secondary.isIgnorableField(f);
        }

        @Override
        public Object findSerializer(Annotated am) {
            Object result = this._primary.findSerializer(am);
            if (result == null) {
                result = this._secondary.findSerializer(am);
            }
            return result;
        }

        @Override
        public JsonSerialize.Inclusion findSerializationInclusion(Annotated a, JsonSerialize.Inclusion defValue) {
            defValue = this._secondary.findSerializationInclusion(a, defValue);
            defValue = this._primary.findSerializationInclusion(a, defValue);
            return defValue;
        }

        @Override
        public Class<?> findSerializationType(Annotated a) {
            Class<?> result = this._primary.findSerializationType(a);
            if (result == null) {
                result = this._secondary.findSerializationType(a);
            }
            return result;
        }

        @Override
        public JsonSerialize.Typing findSerializationTyping(Annotated a) {
            JsonSerialize.Typing result = this._primary.findSerializationTyping(a);
            if (result == null) {
                result = this._secondary.findSerializationTyping(a);
            }
            return result;
        }

        @Override
        public Class<?>[] findSerializationViews(Annotated a) {
            Class<?>[] result = this._primary.findSerializationViews(a);
            if (result == null) {
                result = this._secondary.findSerializationViews(a);
            }
            return result;
        }

        @Override
        public String[] findSerializationPropertyOrder(AnnotatedClass ac) {
            String[] result = this._primary.findSerializationPropertyOrder(ac);
            if (result == null) {
                result = this._secondary.findSerializationPropertyOrder(ac);
            }
            return result;
        }

        @Override
        public Boolean findSerializationSortAlphabetically(AnnotatedClass ac) {
            Boolean result = this._primary.findSerializationSortAlphabetically(ac);
            if (result == null) {
                result = this._secondary.findSerializationSortAlphabetically(ac);
            }
            return result;
        }

        @Override
        public String findGettablePropertyName(AnnotatedMethod am) {
            String str2;
            String result = this._primary.findGettablePropertyName(am);
            if (result == null) {
                result = this._secondary.findGettablePropertyName(am);
            } else if (result.length() == 0 && (str2 = this._secondary.findGettablePropertyName(am)) != null) {
                result = str2;
            }
            return result;
        }

        @Override
        public boolean hasAsValueAnnotation(AnnotatedMethod am) {
            return this._primary.hasAsValueAnnotation(am) || this._secondary.hasAsValueAnnotation(am);
        }

        @Override
        public String findEnumValue(Enum<?> value) {
            String result = this._primary.findEnumValue(value);
            if (result == null) {
                result = this._secondary.findEnumValue(value);
            }
            return result;
        }

        @Override
        public String findSerializablePropertyName(AnnotatedField af) {
            String str2;
            String result = this._primary.findSerializablePropertyName(af);
            if (result == null) {
                result = this._secondary.findSerializablePropertyName(af);
            } else if (result.length() == 0 && (str2 = this._secondary.findSerializablePropertyName(af)) != null) {
                result = str2;
            }
            return result;
        }

        @Override
        public Object findDeserializer(Annotated am) {
            Object result = this._primary.findDeserializer(am);
            if (result == null) {
                result = this._secondary.findDeserializer(am);
            }
            return result;
        }

        @Override
        public Class<? extends KeyDeserializer> findKeyDeserializer(Annotated am) {
            Class<? extends KeyDeserializer> result = this._primary.findKeyDeserializer(am);
            if (result == null || result == KeyDeserializer.None.class) {
                result = this._secondary.findKeyDeserializer(am);
            }
            return result;
        }

        @Override
        public Class<? extends JsonDeserializer<?>> findContentDeserializer(Annotated am) {
            Class<? extends JsonDeserializer<?>> result = this._primary.findContentDeserializer(am);
            if (result == null || result == JsonDeserializer.None.class) {
                result = this._secondary.findContentDeserializer(am);
            }
            return result;
        }

        @Override
        public Class<?> findDeserializationType(Annotated am, JavaType baseType, String propName) {
            Class<?> result = this._primary.findDeserializationType(am, baseType, propName);
            if (result == null) {
                result = this._secondary.findDeserializationType(am, baseType, propName);
            }
            return result;
        }

        @Override
        public Class<?> findDeserializationKeyType(Annotated am, JavaType baseKeyType, String propName) {
            Class<?> result = this._primary.findDeserializationKeyType(am, baseKeyType, propName);
            if (result == null) {
                result = this._secondary.findDeserializationKeyType(am, baseKeyType, propName);
            }
            return result;
        }

        @Override
        public Class<?> findDeserializationContentType(Annotated am, JavaType baseContentType, String propName) {
            Class<?> result = this._primary.findDeserializationContentType(am, baseContentType, propName);
            if (result == null) {
                result = this._secondary.findDeserializationContentType(am, baseContentType, propName);
            }
            return result;
        }

        @Override
        public String findSettablePropertyName(AnnotatedMethod am) {
            String str2;
            String result = this._primary.findSettablePropertyName(am);
            if (result == null) {
                result = this._secondary.findSettablePropertyName(am);
            } else if (result.length() == 0 && (str2 = this._secondary.findSettablePropertyName(am)) != null) {
                result = str2;
            }
            return result;
        }

        @Override
        public boolean hasAnySetterAnnotation(AnnotatedMethod am) {
            return this._primary.hasAnySetterAnnotation(am) || this._secondary.hasAnySetterAnnotation(am);
        }

        @Override
        public boolean hasCreatorAnnotation(Annotated a) {
            return this._primary.hasCreatorAnnotation(a) || this._secondary.hasCreatorAnnotation(a);
        }

        @Override
        public String findDeserializablePropertyName(AnnotatedField af) {
            String str2;
            String result = this._primary.findDeserializablePropertyName(af);
            if (result == null) {
                result = this._secondary.findDeserializablePropertyName(af);
            } else if (result.length() == 0 && (str2 = this._secondary.findDeserializablePropertyName(af)) != null) {
                result = str2;
            }
            return result;
        }

        @Override
        public String findPropertyNameForParam(AnnotatedParameter param) {
            String result = this._primary.findPropertyNameForParam(param);
            if (result == null) {
                result = this._secondary.findPropertyNameForParam(param);
            }
            return result;
        }
    }
}

