/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.cassandraunit.DataLoader;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.FileDataSet;
import org.cassandraunit.dataset.ParseException;
import org.codehaus.mojo.cassandra.AbstractCqlLoadMojo;
import org.codehaus.mojo.cassandra.Utils;

public class StartCassandraClusterMojo
extends AbstractCqlLoadMojo {
    protected int startWaitSeconds;
    private boolean loadAfterFirstStart;
    protected File cuDataSet;
    private boolean cuLoadFailureIgnore;
    private boolean cuLoadAfterFirstStart;
    private int clusterSize;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        if (this.clusterSize < 1) {
            throw new MojoExecutionException("Invalid cluster size of " + this.clusterSize + " specified. Must be at least 1");
        }
        if (this.clusterSize > 254) {
            throw new MojoExecutionException("Invalid cluster size of " + this.clusterSize + " specified. Must be less than 254");
        }
        File[] cassandraDir = new File[this.clusterSize];
        BigInteger[] initialToken = new BigInteger[this.clusterSize];
        String[] listenAddress = new String[this.clusterSize];
        boolean isClean = true;
        for (int node = 0; node < this.clusterSize; ++node) {
            listenAddress[node] = "127.0.0." + (node + 1);
            initialToken[node] = BigInteger.valueOf(2L).pow(127).multiply(BigInteger.valueOf(node)).divide(BigInteger.valueOf(this.clusterSize));
            cassandraDir[node] = new File(this.cassandraDir.getParent(), this.cassandraDir.getName() + "-node" + (node + 1));
            if (!isClean || !cassandraDir[node].isDirectory()) continue;
            this.getLog().debug((CharSequence)("Re-using existing Cassandra cluster in " + cassandraDir[node].getAbsolutePath()));
            isClean = false;
        }
        long timeStamp = System.currentTimeMillis();
        if (isClean) {
            this.getLog().debug((CharSequence)("First start of Cassandra cluster in " + Arrays.asList(cassandraDir)));
        }
        try {
            int node;
            for (node = 0; node < this.clusterSize; ++node) {
                this.getLog().info((CharSequence)("Starting for Cassandra Node " + (node + 1) + "..."));
                Utils.startCassandraServer(cassandraDir[node], this.newServiceCommandLine(cassandraDir[node], listenAddress[node], listenAddress[node], initialToken[node], listenAddress, node == 0, node == 0 ? this.jmxPort : 0), this.createEnvironmentVars(), this.getLog());
            }
            if (this.startWaitSeconds >= 0) {
                for (node = 0; node < this.clusterSize; ++node) {
                    this.getLog().info((CharSequence)("Waiting for Cassandra Node " + (node + 1) + " to start..."));
                    boolean started = Utils.waitUntilStarted(listenAddress[node], this.rpcPort, this.startWaitSeconds, this.getLog());
                    if (started) continue;
                    Utils.stopCassandraServer(listenAddress[node], this.rpcPort, listenAddress[node], this.stopPort, this.stopKey, this.getLog());
                    throw new MojoFailureException("Cassandra failed to start within " + this.startWaitSeconds + "s");
                }
            }
            if (isClean && this.loadAfterFirstStart) {
                this.execCqlFile();
            }
            if (isClean && this.cuLoadAfterFirstStart && this.cuDataSet != null && this.cuDataSet.isFile()) {
                this.getLog().info((CharSequence)("Loading CassandraUnit dataSet " + this.cuDataSet + "..."));
                try {
                    DataLoader dataLoader = new DataLoader("cassandraUnitCluster", this.rpcAddress + ":" + this.rpcPort);
                    dataLoader.load((DataSet)new FileDataSet(this.cuDataSet.getAbsolutePath()));
                }
                catch (ParseException e) {
                    if (this.cuLoadFailureIgnore) {
                        this.getLog().error((CharSequence)(e.getMessage() + ". Ignoring as cuLoadFailureIgnore is true"));
                    }
                    throw new MojoExecutionException("Error while loading CassandraUnit dataSet", (Exception)((Object)e));
                }
                this.getLog().info((CharSequence)("Finished " + this.cuDataSet + "."));
            }
            this.getLog().info((CharSequence)("Cassandra started in " + (double)((System.currentTimeMillis() - timeStamp) / 100L) / 10.0 + "s"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
        }
    }
}

